/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoAggrMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoAggrPersistServiceImpl")
public class ExternalConfigInfoAggrPersistServiceImpl
implements ConfigInfoAggrPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalConfigInfoAggrPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public boolean addAggrConfigInfo(String dataId, String group, String tenant, String datumId, String appName, String content) {
        String appNameTmp = StringUtils.isBlank((CharSequence)appName) ? "" : appName;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String select = configInfoAggrMapper.select(Collections.singletonList("content"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        String insert = configInfoAggrMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id", "app_name", "content", "gmt_modified"));
        String update = configInfoAggrMapper.update(Arrays.asList("content", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        try {
            try {
                String dbContent = (String)this.jt.queryForObject(select, new Object[]{dataId, group, tenantTmp, datumId}, String.class);
                if (dbContent != null && dbContent.equals(content)) {
                    return true;
                }
                return this.jt.update(update, new Object[]{content, now, dataId, group, tenantTmp, datumId}) > 0;
            }
            catch (EmptyResultDataAccessException ex) {
                return this.jt.update(insert, new Object[]{dataId, group, tenantTmp, datumId, appNameTmp, content, now}) > 0;
            }
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean batchPublishAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        try {
            Boolean isPublishOk = (Boolean)this.tjt.execute(status -> {
                for (Map.Entry entry : datumMap.entrySet()) {
                    try {
                        if (this.addAggrConfigInfo(dataId, group, tenant, (String)entry.getKey(), appName, (String)entry.getValue())) continue;
                        throw new TransactionSystemException("error in batchPublishAggr");
                    }
                    catch (Throwable e) {
                        throw new TransactionSystemException("error in batchPublishAggr");
                    }
                }
                return Boolean.TRUE;
            });
            if (isPublishOk == null) {
                return false;
            }
            return isPublishOk;
        }
        catch (TransactionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean replaceAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        try {
            ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
            Boolean isReplaceOk = (Boolean)this.tjt.execute(status -> {
                try {
                    String appNameTmp = appName == null ? "" : appName;
                    this.removeAggrConfigInfo(dataId, group, tenant);
                    String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
                    String sql = configInfoAggrMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id", "app_name", "content", "gmt_modified"));
                    for (Map.Entry datumEntry : datumMap.entrySet()) {
                        this.jt.update(sql, new Object[]{dataId, group, tenantTmp, datumEntry.getKey(), appNameTmp, datumEntry.getValue(), new Timestamp(System.currentTimeMillis())});
                    }
                }
                catch (Throwable e) {
                    throw new TransactionSystemException("error in addAggrConfigInfo");
                }
                return Boolean.TRUE;
            });
            if (isReplaceOk == null) {
                return false;
            }
            return isReplaceOk;
        }
        catch (TransactionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            return false;
        }
    }

    @Override
    public void removeSingleAggrConfigInfo(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        try {
            this.jt.update(sql, ps -> {
                int index = 1;
                ps.setString(index++, dataId);
                ps.setString(index++, group);
                ps.setString(index++, tenantTmp);
                ps.setString(index, datumId);
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeAggrConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.delete(Arrays.asList("data_id", "group_id", "tenant_id"));
        try {
            this.jt.update(sql, ps -> {
                int index = 1;
                ps.setString(index++, dataId);
                ps.setString(index++, group);
                ps.setString(index, tenantTmp);
            });
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean batchRemoveAggr(String dataId, String group, String tenant, List<String> datumList) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        StringBuilder datumString = new StringBuilder();
        for (String datum : datumList) {
            datumString.append('\'').append(datum).append("',");
        }
        datumString.deleteCharAt(datumString.length() - 1);
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.batchRemoveAggr(datumList);
        try {
            this.jt.update(sql, new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, new Object[]{dataId, group, tenantTmp});
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant, List<String> datumIds, boolean isIn) {
        if (datumIds == null || datumIds.isEmpty()) {
            return 0;
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.aggrConfigInfoCount(datumIds.size(), isIn);
        List objectList = CollectionUtils.list((Object[])new Object[]{dataId, group, tenantTmp});
        objectList.addAll(datumIds);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, objectList.toArray());
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public ConfigInfoAggr findSingleConfigInfoAggr(String dataId, String group, String tenant, String datumId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.select(Arrays.asList("id", "data_id", "group_id", "tenant_id", "datum_id", "app_name", "content"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        try {
            return (ConfigInfoAggr)this.jt.queryForObject(sql, new Object[]{dataId, group, tenantTmp, datumId}, (RowMapper)RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ConfigInfoAggr> findConfigInfoAggr(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.findConfigInfoAggrIsOrdered();
        try {
            return this.jt.query(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrByPage(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        int startRow = (pageNo - 1) * pageSize;
        String sqlCountRows = configInfoAggrMapper.select(Arrays.asList("count(*)"), Arrays.asList("data_id", "group_id", "tenant_id"));
        String sqlFetchRows = configInfoAggrMapper.findConfigInfoAggrByPageFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, new Object[]{dataId, group, tenantTmp}, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "SELECT count(*) FROM config_info_aggr WHERE ";
        String sqlFetchRows = "SELECT data_id,group_id,tenant_id,datum_id,app_name,content FROM config_info_aggr WHERE ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfoAggr> page = new Page<ConfigInfoAggr>();
            page.setTotalCount(0);
            return page;
        }
        PaginationHelper<ConfigInfoAggr> helper = this.createPaginationHelper();
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfoAggr : configKeys) {
            boolean isFirstSub;
            String dataId = configInfoAggr.getDataId();
            String group = configInfoAggr.getGroup();
            String appName = configInfoAggr.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" AND ");
                } else {
                    where.append(" AND ");
                }
                where.append('(');
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" group_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" AND ");
            } else {
                where.append(" OR ");
            }
            where.append('(');
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        try {
            Page<ConfigInfoAggr> result = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_AGGR_ROW_MAPPER);
            return result;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoChanged> findAllAggrGroup() {
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.findAllAggrGroupByDistinct();
        try {
            return this.jt.query(sql, new Object[0], (RowMapper)RowMapperManager.CONFIG_INFO_CHANGED_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> findDatumIdByContent(String dataId, String groupId, String content) {
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.select(Collections.singletonList("datum_id"), Arrays.asList("data_id", "group_id", "content"));
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, groupId, content}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }
}

