/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigTagsRelationMapper;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalConfigInfoPersistServiceImpl")
public class ExternalConfigInfoPersistServiceImpl
implements ConfigInfoPersistService {
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant_id";
    public static final String SPOT = ".";
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;
    private HistoryConfigInfoPersistService historyConfigInfoPersistService;

    public ExternalConfigInfoPersistServiceImpl(@Qualifier(value="externalHistoryConfigInfoPersistServiceImpl") HistoryConfigInfoPersistService historyConfigInfoPersistService) {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public void addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        boolean result = (Boolean)this.tjt.execute(status -> {
            try {
                long configId = this.addConfigInfoAtomic(-1L, srcIp, srcUser, configInfo, time, configAdvanceInfo);
                String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                this.addConfigTagsRelation(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(0L, configInfo, srcIp, srcUser, time, "I");
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        this.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
        }
        catch (DataIntegrityViolationException ive) {
            this.updateConfigInfo(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        return this.insertOrUpdateCas(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
            return true;
        }
        catch (DataIntegrityViolationException ive) {
            return this.updateConfigInfoCas(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    @Override
    public long addConfigInfoAtomic(long configId, final String srcIp, final String srcUser, final ConfigInfo configInfo, final Timestamp time, Map<String, Object> configAdvanceInfo) {
        final String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        final String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        final String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        final String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        final String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        final String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        final String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        final String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        final String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        final String sql = configInfoMapper.insert(Arrays.asList("data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "src_ip", "src_user", "gmt_create", "gmt_modified", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"));
        final String[] returnGeneratedKeys = configInfoMapper.getPrimaryKeyGeneratedKeys();
        try {
            this.jt.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement(sql, returnGeneratedKeys);
                    ps.setString(1, configInfo.getDataId());
                    ps.setString(2, configInfo.getGroup());
                    ps.setString(3, tenantTmp);
                    ps.setString(4, appNameTmp);
                    ps.setString(5, configInfo.getContent());
                    ps.setString(6, md5Tmp);
                    ps.setString(7, srcIp);
                    ps.setString(8, srcUser);
                    ps.setTimestamp(9, time);
                    ps.setTimestamp(10, time);
                    ps.setString(11, desc);
                    ps.setString(12, use);
                    ps.setString(13, effect);
                    ps.setString(14, type);
                    ps.setString(15, schema);
                    ps.setString(16, encryptedDataKey);
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            Number nu = keyHolder.getKey();
            if (nu == null) {
                throw new IllegalArgumentException("insert config_info fail");
            }
            return nu.longValue();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addConfigTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        try {
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            this.jt.update(configTagsRelationMapper.insert(Arrays.asList("id", "tag_name", "tag_type", "data_id", "group_id", TENANT)), new Object[]{configId, tagName, "", dataId, group, tenant});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addConfigTagsRelation(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                this.addConfigTagRelationAtomic(configId, tagArr[i], dataId, group, tenant);
            }
        }
    }

    @Override
    public Map<String, Object> batchInsertOrUpdate(List<ConfigAllInfo> configInfoList, String srcUser, String srcIp, Map<String, Object> configAdvanceInfo, Timestamp time, boolean notify, SameConfigPolicy policy) throws NacosException {
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = null;
        ArrayList skipData = null;
        for (int i = 0; i < configInfoList.size(); ++i) {
            ConfigAllInfo configInfo = configInfoList.get(i);
            try {
                ParamUtils.checkParam(configInfo.getDataId(), configInfo.getGroup(), "datumId", configInfo.getContent());
            }
            catch (NacosException e) {
                LogUtil.DEFAULT_LOG.error("data verification failed", (Throwable)e);
                throw e;
            }
            ConfigInfo configInfo2Save = new ConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), configInfo.getAppName(), configInfo.getContent());
            configInfo2Save.setEncryptedDataKey(configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey());
            String type = configInfo.getType();
            if (StringUtils.isBlank((CharSequence)type)) {
                if (configInfo.getDataId().contains(SPOT)) {
                    String extName = configInfo.getDataId().substring(configInfo.getDataId().lastIndexOf(SPOT) + 1);
                    FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(extName);
                    type = fileTypeEnum.getFileType();
                } else {
                    type = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(null).getFileType();
                }
            }
            if (configAdvanceInfo == null) {
                configAdvanceInfo = new HashMap<String, Object>(16);
            }
            configAdvanceInfo.put("type", type);
            configAdvanceInfo.put("desc", configInfo.getDesc());
            try {
                this.addConfigInfo(srcIp, srcUser, configInfo2Save, time, configAdvanceInfo, notify);
                ++succCount;
                continue;
            }
            catch (DataIntegrityViolationException ive) {
                if (SameConfigPolicy.ABORT.equals((Object)policy)) {
                    failData = new ArrayList();
                    skipData = new ArrayList();
                    HashMap<String, String> faileditem = new HashMap<String, String>(2);
                    faileditem.put(DATA_ID, configInfo2Save.getDataId());
                    faileditem.put(GROUP, configInfo2Save.getGroup());
                    failData.add(faileditem);
                    for (int j = i + 1; j < configInfoList.size(); ++j) {
                        ConfigInfo skipConfigInfo = configInfoList.get(j);
                        HashMap<String, String> skipitem = new HashMap<String, String>(2);
                        skipitem.put(DATA_ID, skipConfigInfo.getDataId());
                        skipitem.put(GROUP, skipConfigInfo.getGroup());
                        skipData.add(skipitem);
                    }
                    break;
                }
                if (SameConfigPolicy.SKIP.equals((Object)policy)) {
                    ++skipCount;
                    if (skipData == null) {
                        skipData = new ArrayList();
                    }
                    HashMap<String, String> skipitem = new HashMap<String, String>(2);
                    skipitem.put(DATA_ID, configInfo2Save.getDataId());
                    skipitem.put(GROUP, configInfo2Save.getGroup());
                    skipData.add(skipitem);
                    continue;
                }
                if (!SameConfigPolicy.OVERWRITE.equals((Object)policy)) continue;
                ++succCount;
                this.updateConfigInfo(configInfo2Save, srcIp, srcUser, time, configAdvanceInfo, notify);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("succCount", succCount);
        result.put("skipCount", skipCount);
        if (failData != null && !failData.isEmpty()) {
            result.put("failData", failData);
        }
        if (skipData != null && !skipData.isEmpty()) {
            result.put("skipData", skipData);
        }
        return result;
    }

    @Override
    public void removeConfigInfo(final String dataId, final String group, final String tenant, final String srcIp, final String srcUser) {
        this.tjt.execute((TransactionCallback)new TransactionCallback<Boolean>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    ConfigInfoWrapper configInfo = ExternalConfigInfoPersistServiceImpl.this.findConfigInfo(dataId, group, tenant);
                    if (configInfo != null) {
                        ExternalConfigInfoPersistServiceImpl.this.removeConfigInfoAtomic(dataId, group, tenant, srcIp, srcUser);
                        ExternalConfigInfoPersistServiceImpl.this.removeTagByIdAtomic(configInfo.getId());
                        ExternalConfigInfoPersistServiceImpl.this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, this.time, "D");
                    }
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public List<ConfigInfo> removeConfigInfoByIds(final List<Long> ids, final String srcIp, final String srcUser) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.removeAll(Collections.singleton(null));
        return (List)this.tjt.execute((TransactionCallback)new TransactionCallback<List<ConfigInfo>>(){
            final Timestamp time = new Timestamp(System.currentTimeMillis());

            public List<ConfigInfo> doInTransaction(TransactionStatus status) {
                try {
                    String idsStr = StringUtils.join((Collection)ids, (String)",");
                    List<ConfigInfo> configInfoList = ExternalConfigInfoPersistServiceImpl.this.findConfigInfosByIds(idsStr);
                    if (!CollectionUtils.isEmpty(configInfoList)) {
                        ExternalConfigInfoPersistServiceImpl.this.removeConfigInfoByIdsAtomic(idsStr);
                        for (ConfigInfo configInfo : configInfoList) {
                            ExternalConfigInfoPersistServiceImpl.this.removeTagByIdAtomic(configInfo.getId());
                            ExternalConfigInfoPersistServiceImpl.this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, this.time, "D");
                        }
                    }
                    return configInfoList;
                }
                catch (CannotGetJdbcConnectionException e) {
                    LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    @Override
    public void removeTagByIdAtomic(long id) {
        try {
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            this.jt.update(configTagsRelationMapper.delete(Arrays.asList("id")), new Object[]{id});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            this.jt.update(configInfoMapper.delete(Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigInfoByIdsAtomic(String ids) {
        String[] tagArr;
        if (StringUtils.isBlank((CharSequence)ids)) {
            return;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        for (String s : tagArr = ids.split(",")) {
            paramList.add(Long.parseLong(s));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.removeConfigInfoByIdsAtomic(paramList.size());
        try {
            this.jt.update(sql, paramList.toArray());
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfo(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        boolean result = (Boolean)this.tjt.execute(status -> {
            try {
                String configTags;
                ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                String appNameTmp = oldConfigInfo.getAppName();
                if (configInfo.getAppName() == null) {
                    configInfo.setAppName(appNameTmp);
                }
                this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, time, configAdvanceInfo);
                String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                if (configTags != null) {
                    this.removeTagByIdAtomic(oldConfigInfo.getId());
                    this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                }
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public boolean updateConfigInfoCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        return (Boolean)this.tjt.execute(status -> {
            try {
                String configTags;
                int rows;
                ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                String appNameTmp = oldConfigInfo.getAppName();
                if (configInfo.getAppName() == null) {
                    configInfo.setAppName(appNameTmp);
                }
                if ((rows = this.updateConfigInfoAtomicCas(configInfo, srcIp, srcUser, time, configAdvanceInfo)) < 1) {
                    return Boolean.FALSE;
                }
                String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
                if (configTags != null) {
                    this.removeTagByIdAtomic(oldConfigInfo.getId());
                    this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
                }
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            }
            catch (CannotGetJdbcConnectionException e) {
                LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
                throw e;
            }
            return Boolean.TRUE;
        });
    }

    private int updateConfigInfoAtomicCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return this.jt.update(configInfoMapper.updateConfigInfoAtomicCas(), new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            this.jt.update(configInfoMapper.update(Arrays.asList(CONTENT, "md5", "src_ip", "src_user", "gmt_modified", "app_name", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void updateMd5(String dataId, String group, String tenant, String md5, Timestamp lastTime) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            this.jt.update(configInfoMapper.update(Collections.singletonList("md5"), Arrays.asList("data_id", "group_id", TENANT, "gmt_modified")), new Object[]{md5, dataId, group, tenantTmp, lastTime});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public long findConfigMaxId() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.findConfigMaxId();
        try {
            return (Long)this.jt.queryForObject(sql, Long.class);
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    @Override
    @Deprecated
    public List<ConfigInfo> findAllDataIdAndGroup() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.findAllDataIdAndGroup();
        try {
            return this.jt.query(sql, new Object[0], (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.emptyList();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("[db-other-error]" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ConfigInfoBase findConfigInfoBase(String dataId, String group) {
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfoBase)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", CONTENT), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, ""}, (RowMapper)RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfo findConfigInfo(long id) {
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfo)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT), Collections.singletonList("id")), new Object[]{id}, (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoWrapper findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfoWrapper)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "type", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(APP_NAME);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sql = null;
        String sqlCount = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((String)dataId)) {
            paramList.add(dataId);
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (StringUtils.isNotBlank((String)group)) {
            paramList.add(group);
            paramsMap.put(GROUP, GROUP);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            paramList.add(appName);
            paramsMap.put(APP_NAME, APP_NAME);
        }
        int startRow = (pageNo - 1) * pageSize;
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            paramList.addAll(Arrays.asList(tagArr));
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCount = configTagsRelationMapper.findConfigInfo4PageCountRows(paramsMap, tagArr.length);
            sql = configTagsRelationMapper.findConfigInfo4PageFetchRows(paramsMap, tagArr.length, startRow, pageSize);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCount = configInfoMapper.findConfigInfo4PageCountRows(paramsMap);
            sql = configInfoMapper.findConfigInfo4PageFetchRows(paramsMap, startRow, pageSize);
        }
        try {
            Page<ConfigInfo> page = helper.fetchPage(sqlCount, sql, paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
            for (ConfigInfo configInfo : page.getPageItems()) {
                Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
                configInfo.setContent((String)pair.getSecond());
            }
            return page;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByApp(int pageNo, int pageSize, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            int startRow = (pageNo - 1) * pageSize;
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return helper.fetchPage(configInfoMapper.findConfigInfoByAppCountRows(), configInfoMapper.findConfigInfoByAppFetchRows(startRow, pageSize), new Object[]{this.generateLikeArgument(tenantTmp), appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseByGroup(int pageNo, int pageSize, String group) {
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        try {
            int startRow = (pageNo - 1) * pageSize;
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return helper.fetchPage(configInfoMapper.count(Arrays.asList("group_id", TENANT)), configInfoMapper.findConfigInfoBaseByGroupFetchRows(startRow, pageSize), new Object[]{group, ""}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int configInfoCount() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.count(null);
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoCount(String tenant) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.configInfoLikeTenantCount();
        Integer result = (Integer)this.jt.queryForObject(sql, new Object[]{tenant}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public List<String> getTenantIdList(int page, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        String sql = configInfoMapper.getTenantIdList(from, pageSize);
        return this.jt.queryForList(sql, String.class);
    }

    @Override
    public List<String> getGroupIdList(int page, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        String sql = configInfoMapper.getGroupIdList(from, pageSize);
        return this.jt.queryForList(sql, String.class);
    }

    @Override
    public Page<ConfigInfo> findAllConfigInfo(int pageNo, int pageSize, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.count(null);
        String sqlFetchRows = configInfoMapper.findAllConfigInfoFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigKey> findAllConfigKey(int pageNo, int pageSize, String tenant) {
        int pageCount;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int startRow = (pageNo - 1) * pageSize;
        String select = configInfoMapper.findAllConfigKey(startRow, pageSize);
        int totalCount = this.configInfoCount(tenant);
        if (totalCount > pageSize * (pageCount = totalCount / pageSize)) {
            ++pageCount;
        }
        if (pageNo > pageCount) {
            return null;
        }
        Page<ConfigKey> page = new Page<ConfigKey>();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(totalCount);
        try {
            List result = this.jt.query(select, new Object[]{this.generateLikeArgument(tenantTmp)}, RowMapperManager.CONFIG_KEY_ROW_MAPPER);
            for (ConfigKey item : result) {
                page.getPageItems().add(item);
            }
            return page;
        }
        catch (EmptyResultDataAccessException e) {
            return page;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String select = configInfoMapper.findAllConfigInfoFragment(0, pageSize);
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(select, new Object[]{lastMaxId}, 1, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfo> page = new Page<ConfigInfo>();
            page.setTotalCount(0);
            return page;
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfo : configKeys) {
            boolean isFirstSub;
            String dataId = configInfo.getDataId();
            String group = configInfo.getGroup();
            String appName = configInfo.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" AND ");
                } else {
                    where.append(" AND ");
                }
                where.append('(');
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" group_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" AND ");
            } else {
                where.append(" OR ");
            }
            where.append('(');
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(APP_NAME);
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(CONTENT);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        String sqlCountRows = null;
        String sqlFetchRows = null;
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            params.add(this.generateLikeArgument(dataId));
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            params.add(this.generateLikeArgument(group));
            paramsMap.put(GROUP, GROUP);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            params.add(appName);
            paramsMap.put(APP_NAME, APP_NAME);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            params.add(this.generateLikeArgument(content));
            paramsMap.put(CONTENT, CONTENT);
        }
        int startRow = (pageNo - 1) * pageSize;
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            params.addAll(Arrays.asList(tagArr));
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCountRows = configTagsRelationMapper.findConfigInfoLike4PageCountRows(paramsMap, tagArr.length);
            sqlFetchRows = configTagsRelationMapper.findConfigInfoLike4PageFetchRows(paramsMap, tagArr.length, startRow, pageSize);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCountRows = configInfoMapper.findConfigInfoLike4PageCountRows(paramsMap);
            sqlFetchRows = configInfoMapper.findConfigInfoLike4PageFetchRows(paramsMap, startRow, pageSize);
        }
        try {
            Page<ConfigInfo> page = helper.fetchPage(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
            for (ConfigInfo configInfo : page.getPageItems()) {
                Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
                configInfo.setContent((String)pair.getSecond());
            }
            return page;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseLike(int pageNo, int pageSize, String dataId, String group, String content) throws IOException {
        if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group)) {
            throw new IOException("invalid param");
        }
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            params.add(this.generateLikeArgument(dataId));
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            params.add(this.generateLikeArgument(group));
            paramsMap.put(GROUP, GROUP);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            params.add(this.generateLikeArgument(content));
            paramsMap.put(CONTENT, CONTENT);
        }
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.findConfigInfoBaseLikeCountRows(paramsMap);
        String sqlFetchRows = configInfoMapper.findConfigInfoBaseLikeFetchRows(paramsMap, startRow, pageSize);
        try {
            return helper.fetchPage(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoWrapper> findChangeConfig(Timestamp startTime, Timestamp endTime) {
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            List list = this.jt.queryForList(configInfoMapper.findChangeConfig(), new Object[]{startTime, endTime});
            return this.convertChangeConfig(list);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigInfoWrapper> findChangeConfig(String dataId, String group, String tenant, String appName, Timestamp startTime, Timestamp endTime, int pageNo, int pageSize, long lastMaxId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        ArrayList<Object> params = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            params.add(this.generateLikeArgument(dataId));
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            params.add(this.generateLikeArgument(group));
            paramsMap.put(GROUP, GROUP);
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            params.add(tenantTmp);
            paramsMap.put(TENANT, TENANT);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            params.add(appName);
            paramsMap.put(APP_NAME, APP_NAME);
        }
        if (startTime != null) {
            params.add(startTime);
        }
        if (endTime != null) {
            params.add(endTime);
        }
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.findChangeConfigCountRows(paramsMap, startTime, endTime);
        String sqlFetchRows = configInfoMapper.findChangeConfigFetchRows(paramsMap, startTime, endTime, startRow, pageSize, lastMaxId);
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        try {
            return helper.fetchPage(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, lastMaxId, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.select(Arrays.asList("tag_name"), Arrays.asList("data_id", "group_id", TENANT));
        try {
            return this.jt.queryForList(sql, new Object[]{dataId, group, tenant}, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> findConfigInfosByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return null;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            paramList.add(Long.parseLong(tagArr[i]));
        }
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return this.jt.query(configInfoMapper.findConfigInfosByIds(tagArr.length), paramList.toArray(), (RowMapper)RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            ConfigAdvanceInfo configAdvance = (ConfigAdvanceInfo)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_ADVANCE_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(',').append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            ConfigAllInfo configAdvance = (ConfigAllInfo)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp}, (RowMapper)RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
            if (configTagList != null && !configTagList.isEmpty()) {
                StringBuilder configTagsTmp = new StringBuilder();
                for (String configTag : configTagList) {
                    if (configTagsTmp.length() == 0) {
                        configTagsTmp.append(configTag);
                        continue;
                    }
                    configTagsTmp.append(',').append(configTag);
                }
                configAdvance.setConfigTags(configTagsTmp.toString());
            }
            return configAdvance;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get(TENANT);
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> convertChangeConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfoWrapper> configs = new ArrayList<ConfigInfoWrapper>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get(TENANT);
            String content = (String)map.get(CONTENT);
            long mTime = ((Timestamp)map.get("gmt_modified")).getTime();
            ConfigInfoWrapper config = new ConfigInfoWrapper();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            config.setContent(content);
            config.setLastModified(mTime);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> listAllGroupKeyMd5() {
        int pageSize = 10000;
        int totalCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)totalCount * 1.0 / 10000.0);
        ArrayList<ConfigInfoWrapper> allConfigInfo = new ArrayList<ConfigInfoWrapper>();
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            List<ConfigInfoWrapper> configInfoList = this.listGroupKeyMd5ByPage(pageNo, 10000);
            allConfigInfo.addAll(configInfoList);
        }
        return allConfigInfo;
    }

    @Override
    public List<ConfigInfoWrapper> listGroupKeyMd5ByPage(int pageNo, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.count(null);
        String sqlFetchRows = configInfoMapper.listGroupKeyMd5ByPageFetchRows((pageNo - 1) * pageSize, pageSize);
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        try {
            Page<ConfigInfoWrapper> page = helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
            return page.getPageItems();
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public ConfigInfoWrapper queryConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return (ConfigInfoWrapper)this.jt.queryForObject(configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "type", "gmt_modified", "md5", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigAllInfo> findAllConfigInfo4Export(String dataId, String group, String tenant, String appName, List<Long> ids) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HashMap<String, String> params = new HashMap<String, String>(16);
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(ids)) {
            paramList.addAll(ids);
        } else {
            paramList.add(tenantTmp);
            params.put(TENANT, TENANT);
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                paramList.add(this.generateLikeArgument(dataId));
                params.put(DATA_ID, DATA_ID);
            }
            if (StringUtils.isNotBlank((String)group)) {
                paramList.add(group);
                params.put(GROUP, GROUP);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                paramList.add(appName);
                params.put(APP_NAME, APP_NAME);
            }
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.findAllConfigInfo4Export(ids, params);
        try {
            return this.jt.query(sql, paramList.toArray(), (RowMapper)RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<ConfigInfoWrapper> queryConfigInfoByNamespace(String tenant) {
        if (Objects.isNull(tenant)) {
            throw new IllegalArgumentException("tenantId can not be null");
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            return this.jt.query(configInfoMapper.select(Arrays.asList("data_id", "group_id", TENANT, "app_name", "type"), Collections.singletonList(TENANT)), new Object[]{tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        }
        catch (EmptyResultDataAccessException e) {
            return Collections.EMPTY_LIST;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public Page<ConfigInfoBase> findAllConfigInfoBase(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.count(null);
        String sqlFetchRows = configInfoMapper.findAllConfigInfoBaseFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        try {
            return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }
}

