/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.monitor;

import com.alibaba.nacos.common.utils.TopnCounterMetricsContainer;
import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricsMonitor {
    private static final String METER_REGISTRY = "CONFIG_STABLE_REGISTRY";
    private static AtomicInteger getConfig = new AtomicInteger();
    private static AtomicInteger publish = new AtomicInteger();
    private static AtomicInteger longPolling = new AtomicInteger();
    private static AtomicInteger configCount = new AtomicInteger();
    private static AtomicInteger notifyTask = new AtomicInteger();
    private static AtomicInteger notifyClientTask = new AtomicInteger();
    private static AtomicInteger dumpTask = new AtomicInteger();
    private static AtomicInteger fuzzySearch = new AtomicInteger();
    private static ConcurrentHashMap<String, AtomicInteger> configSubscriber = new ConcurrentHashMap();
    private static TopnCounterMetricsContainer configChangeCount = new TopnCounterMetricsContainer();

    public static AtomicInteger getConfigMonitor() {
        return getConfig;
    }

    public static AtomicInteger getPublishMonitor() {
        return publish;
    }

    public static AtomicInteger getLongPollingMonitor() {
        return longPolling;
    }

    public static AtomicInteger getConfigCountMonitor() {
        return configCount;
    }

    public static AtomicInteger getNotifyTaskMonitor() {
        return notifyTask;
    }

    public static AtomicInteger getNotifyClientTaskMonitor() {
        return notifyClientTask;
    }

    public static AtomicInteger getDumpTaskMonitor() {
        return dumpTask;
    }

    public static AtomicInteger getFuzzySearchMonitor() {
        return fuzzySearch;
    }

    public static AtomicInteger getConfigSubscriberMonitor(String version) {
        return configSubscriber.get(version);
    }

    public static TopnCounterMetricsContainer getConfigChangeCount() {
        return configChangeCount;
    }

    public static Timer getReadConfigRtTimer() {
        return NacosMeterRegistryCenter.timer((String)METER_REGISTRY, (String)"nacos_timer", (String[])new String[]{"module", "config", "name", "readConfigRt"});
    }

    public static Timer getReadConfigRpcRtTimer() {
        return NacosMeterRegistryCenter.timer((String)METER_REGISTRY, (String)"nacos_timer", (String[])new String[]{"module", "config", "name", "readConfigRpcRt"});
    }

    public static Timer getWriteConfigRtTimer() {
        return NacosMeterRegistryCenter.timer((String)METER_REGISTRY, (String)"nacos_timer", (String[])new String[]{"module", "config", "name", "writeConfigRt"});
    }

    public static Timer getWriteConfigRpcRtTimer() {
        return NacosMeterRegistryCenter.timer((String)METER_REGISTRY, (String)"nacos_timer", (String[])new String[]{"module", "config", "name", "writeConfigRpcRt"});
    }

    public static Timer getNotifyRtTimer() {
        return NacosMeterRegistryCenter.timer((String)METER_REGISTRY, (String)"nacos_timer", (String[])new String[]{"module", "config", "name", "notifyRt"});
    }

    public static Counter getIllegalArgumentException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "config", "name", "illegalArgument"});
    }

    public static Counter getNacosException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "config", "name", "nacos"});
    }

    public static Counter getDbException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "config", "name", "db"});
    }

    public static Counter getConfigNotifyException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "config", "name", "configNotify"});
    }

    public static Counter getUnhealthException() {
        return NacosMeterRegistryCenter.counter((String)METER_REGISTRY, (String)"nacos_exception", (String[])new String[]{"module", "config", "name", "unhealth"});
    }

    public static void incrementConfigChangeCount(String tenant, String group, String dataId) {
        configChangeCount.increment(tenant + "@" + group + "@" + dataId);
    }

    static {
        ImmutableTag immutableTag = new ImmutableTag("module", "config");
        ArrayList<ImmutableTag> tags = new ArrayList<ImmutableTag>();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "getConfig"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)getConfig);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "publish"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)publish);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "longPolling"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)longPolling);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "configCount"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)configCount);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "notifyTask"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)notifyTask);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "notifyClientTask"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)notifyClientTask);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "dumpTask"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)dumpTask);
        tags = new ArrayList();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "fuzzySearch"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_monitor", tags, (Number)fuzzySearch);
        configSubscriber.put("v1", new AtomicInteger(0));
        configSubscriber.put("v2", new AtomicInteger(0));
        tags = new ArrayList();
        tags.add(new ImmutableTag("version", "v1"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_config_subscriber", tags, (Number)configSubscriber.get("v1"));
        tags = new ArrayList();
        tags.add(new ImmutableTag("version", "v2"));
        NacosMeterRegistryCenter.gauge((String)METER_REGISTRY, (String)"nacos_config_subscriber", tags, (Number)configSubscriber.get("v2"));
    }
}

