/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.HistoryConfigInfoMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedHistoryConfigInfoPersistServiceImpl")
public class EmbeddedHistoryConfigInfoPersistServiceImpl
implements HistoryConfigInfoPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedHistoryConfigInfoPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public void insertConfigHistoryAtomic(long configHistoryId, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = StringUtils.isBlank((CharSequence)configInfo.getEncryptedDataKey()) ? "" : configInfo.getEncryptedDataKey();
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sql = historyConfigInfoMapper.insert(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_modified", "op_type", "encrypted_data_key"));
        Object[] args = new Object[]{configHistoryId, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops, encryptedDataKey};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
    }

    @Override
    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sql = historyConfigInfoMapper.removeConfigHistory();
        PaginationHelper helper = this.createPaginationHelper();
        helper.updateLimit(sql, new Object[]{startTime, limitSize});
    }

    @Override
    public List<ConfigInfo> findDeletedConfig(Timestamp startTime, Timestamp endTime) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        List<Map<String, Object>> list = this.databaseOperate.queryMany(historyConfigInfoMapper.findDeletedConfig(), new Object[]{startTime, endTime});
        return this.convertDeletedConfig(list);
    }

    @Override
    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlCountRows = historyConfigInfoMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        String sqlFetchRows = historyConfigInfoMapper.pageFindConfigHistoryFetchRows(pageNo, pageSize);
        PaginationHelper<ConfigHistoryInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, RowMapperManager.HISTORY_LIST_ROW_MAPPER);
    }

    @Override
    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlFetchRows = historyConfigInfoMapper.select(Arrays.asList("nid", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_user", "src_ip", "op_type", "gmt_create", "gmt_modified", "encrypted_data_key"), Collections.singletonList("nid"));
        return this.databaseOperate.queryOne(sqlFetchRows, new Object[]{nid}, RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
    }

    @Override
    public ConfigHistoryInfo detailPreviousConfigHistory(Long id) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlFetchRows = historyConfigInfoMapper.detailPreviousConfigHistory();
        return this.databaseOperate.queryOne(sqlFetchRows, new Object[]{id}, RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
    }

    @Override
    public int findConfigHistoryCountByTime(Timestamp startTime) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sql = historyConfigInfoMapper.findConfigHistoryCountByTime();
        Integer result = this.databaseOperate.queryOne(sql, new Object[]{startTime}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("findConfigHistoryCountByTime error");
        }
        return result;
    }
}

