// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: networking/v1alpha3/virtual_service.proto

package istio.networking.v1alpha3;

public final class VirtualServiceOuterClass {
  private VirtualServiceOuterClass() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface VirtualServiceOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.VirtualService)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @return A list containing the hosts.
     */
    java.util.List<java.lang.String>
        getHostsList();
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @return The count of hosts.
     */
    int getHostsCount();
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @param index The index of the element to return.
     * @return The hosts at the given index.
     */
    java.lang.String getHosts(int index);
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the hosts at the given index.
     */
    com.google.protobuf.ByteString
        getHostsBytes(int index);

    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @return A list containing the gateways.
     */
    java.util.List<java.lang.String>
        getGatewaysList();
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @return The count of gateways.
     */
    int getGatewaysCount();
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @param index The index of the element to return.
     * @return The gateways at the given index.
     */
    java.lang.String getGateways(int index);
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the gateways at the given index.
     */
    com.google.protobuf.ByteString
        getGatewaysBytes(int index);

    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute> 
        getHttpList();
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute getHttp(int index);
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    int getHttpCount();
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder> 
        getHttpOrBuilderList();
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder getHttpOrBuilder(
        int index);

    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute> 
        getTlsList();
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute getTls(int index);
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    int getTlsCount();
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder> 
        getTlsOrBuilderList();
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder getTlsOrBuilder(
        int index);

    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute> 
        getTcpList();
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute getTcp(int index);
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    int getTcpCount();
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder> 
        getTcpOrBuilderList();
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder getTcpOrBuilder(
        int index);

    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @return A list containing the exportTo.
     */
    java.util.List<java.lang.String>
        getExportToList();
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @return The count of exportTo.
     */
    int getExportToCount();
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @param index The index of the element to return.
     * @return The exportTo at the given index.
     */
    java.lang.String getExportTo(int index);
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @param index The index of the value to return.
     * @return The bytes of the exportTo at the given index.
     */
    com.google.protobuf.ByteString
        getExportToBytes(int index);
  }
  /**
   * <pre>
   * Configuration affecting traffic routing.
   * &lt;!-- crd generation tags
   * +cue-gen:VirtualService:groupName:networking.istio.io
   * +cue-gen:VirtualService:version:v1alpha3
   * +cue-gen:VirtualService:storageVersion
   * +cue-gen:VirtualService:annotations:helm.sh/resource-policy=keep
   * +cue-gen:VirtualService:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
   * +cue-gen:VirtualService:subresource:status
   * +cue-gen:VirtualService:scope:Namespaced
   * +cue-gen:VirtualService:resource:categories=istio-io,networking-istio-io,shortNames=vs
   * +cue-gen:VirtualService:printerColumn:name=Gateways,type=string,JSONPath=.spec.gateways,description="The names of gateways and sidecars 
   * that should apply these routes"
   * +cue-gen:VirtualService:printerColumn:name=Hosts,type=string,JSONPath=.spec.hosts,description="The destination hosts to which traffic is being sent"
   * +cue-gen:VirtualService:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp 
   * representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. 
   * Clients may not set this value. It is represented in RFC3339 form and is in UTC.
   * Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
   * +cue-gen:VirtualService:preserveUnknownFields:false
   * --&gt;
   * &lt;!-- go code generation tags
   * +kubetype-gen
   * +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
   * +genclient
   * +k8s:deepcopy-gen=true
   * --&gt;
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.VirtualService}
   */
  public static final class VirtualService extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.VirtualService)
      VirtualServiceOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use VirtualService.newBuilder() to construct.
    private VirtualService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private VirtualService() {
      hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      http_ = java.util.Collections.emptyList();
      tls_ = java.util.Collections.emptyList();
      tcp_ = java.util.Collections.emptyList();
      exportTo_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new VirtualService();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_VirtualService_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_VirtualService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.class, istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.Builder.class);
    }

    public static final int HOSTS_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList hosts_;
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @return A list containing the hosts.
     */
    public com.google.protobuf.ProtocolStringList
        getHostsList() {
      return hosts_;
    }
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @return The count of hosts.
     */
    public int getHostsCount() {
      return hosts_.size();
    }
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @param index The index of the element to return.
     * @return The hosts at the given index.
     */
    public java.lang.String getHosts(int index) {
      return hosts_.get(index);
    }
    /**
     * <pre>
     * The destination hosts to which traffic is being sent. Could
     * be a DNS name with wildcard prefix or an IP address.  Depending on the
     * platform, short-names can also be used instead of a FQDN (i.e. has no
     * dots in the name). In such a scenario, the FQDN of the host would be
     * derived based on the underlying platform.
     * A single VirtualService can be used to describe all the traffic
     * properties of the corresponding hosts, including those for multiple
     * HTTP and TCP ports. Alternatively, the traffic properties of a host
     * can be defined using more than one VirtualService, with certain
     * caveats. Refer to the
     * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
     * for details.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews" will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. _To avoid
     * potential misconfigurations, it is recommended to always use fully
     * qualified domain names over short names._
     * The hosts field applies to both HTTP and TCP services. Service inside
     * the mesh, i.e., those found in the service registry, must always be
     * referred to using their alphanumeric names. IP addresses are allowed
     * only for services defined via the Gateway.
     * *Note*: It must be empty for a delegate VirtualService.
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the hosts at the given index.
     */
    public com.google.protobuf.ByteString
        getHostsBytes(int index) {
      return hosts_.getByteString(index);
    }

    public static final int GATEWAYS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList gateways_;
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @return A list containing the gateways.
     */
    public com.google.protobuf.ProtocolStringList
        getGatewaysList() {
      return gateways_;
    }
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @return The count of gateways.
     */
    public int getGatewaysCount() {
      return gateways_.size();
    }
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @param index The index of the element to return.
     * @return The gateways at the given index.
     */
    public java.lang.String getGateways(int index) {
      return gateways_.get(index);
    }
    /**
     * <pre>
     * The names of gateways and sidecars that should apply these routes.
     * Gateways in other namespaces may be referred to by
     * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
     * namespace qualifier is the same as specifying the VirtualService's
     * namespace. A single VirtualService is used for sidecars inside the mesh as
     * well as for one or more gateways. The selection condition imposed by this
     * field can be overridden using the source field in the match conditions
     * of protocol-specific routes. The reserved word `mesh` is used to imply
     * all the sidecars in the mesh. When this field is omitted, the default
     * gateway (`mesh`) will be used, which would apply the rule to all
     * sidecars in the mesh. If a list of gateway names is provided, the
     * rules will apply only to the gateways. To apply the rules to both
     * gateways and sidecars, specify `mesh` as one of the gateway names.
     * </pre>
     *
     * <code>repeated string gateways = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the gateways at the given index.
     */
    public com.google.protobuf.ByteString
        getGatewaysBytes(int index) {
      return gateways_.getByteString(index);
    }

    public static final int HTTP_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute> http_;
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute> getHttpList() {
      return http_;
    }
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder> 
        getHttpOrBuilderList() {
      return http_;
    }
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    @java.lang.Override
    public int getHttpCount() {
      return http_.size();
    }
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute getHttp(int index) {
      return http_.get(index);
    }
    /**
     * <pre>
     * An ordered list of route rules for HTTP traffic. HTTP routes will be
     * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
     * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
     * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
     * an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder getHttpOrBuilder(
        int index) {
      return http_.get(index);
    }

    public static final int TLS_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute> tls_;
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute> getTlsList() {
      return tls_;
    }
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder> 
        getTlsOrBuilderList() {
      return tls_;
    }
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    @java.lang.Override
    public int getTlsCount() {
      return tls_.size();
    }
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute getTls(int index) {
      return tls_.get(index);
    }
    /**
     * <pre>
     * An ordered list of route rule for non-terminated TLS &amp; HTTPS
     * traffic. Routing is typically performed using the SNI value presented
     * by the ClientHello message. TLS routes will be applied to platform
     * service ports named 'https-*', 'tls-*', unterminated gateway ports using
     * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
     * entry ports using HTTPS/TLS protocols.  The first rule matching an
     * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
     * without associated virtual service will be treated as opaque TCP
     * traffic.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder getTlsOrBuilder(
        int index) {
      return tls_.get(index);
    }

    public static final int TCP_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute> tcp_;
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute> getTcpList() {
      return tcp_;
    }
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder> 
        getTcpOrBuilderList() {
      return tcp_;
    }
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    @java.lang.Override
    public int getTcpCount() {
      return tcp_.size();
    }
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute getTcp(int index) {
      return tcp_.get(index);
    }
    /**
     * <pre>
     * An ordered list of route rules for opaque TCP traffic. TCP routes will
     * be applied to any port that is not a HTTP or TLS port. The first rule
     * matching an incoming request is used.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder getTcpOrBuilder(
        int index) {
      return tcp_.get(index);
    }

    public static final int EXPORT_TO_FIELD_NUMBER = 6;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList exportTo_;
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @return A list containing the exportTo.
     */
    public com.google.protobuf.ProtocolStringList
        getExportToList() {
      return exportTo_;
    }
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @return The count of exportTo.
     */
    public int getExportToCount() {
      return exportTo_.size();
    }
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @param index The index of the element to return.
     * @return The exportTo at the given index.
     */
    public java.lang.String getExportTo(int index) {
      return exportTo_.get(index);
    }
    /**
     * <pre>
     * A list of namespaces to which this virtual service is exported. Exporting a
     * virtual service allows it to be used by sidecars and gateways defined in
     * other namespaces. This feature provides a mechanism for service owners
     * and mesh administrators to control the visibility of virtual services
     * across namespace boundaries.
     * If no namespaces are specified then the virtual service is exported to all
     * namespaces by default.
     * The value "." is reserved and defines an export to the same namespace that
     * the virtual service is declared in. Similarly the value "*" is reserved and
     * defines an export to all namespaces.
     * NOTE: in the current release, the `exportTo` value is restricted to
     * "." or "*" (i.e., the current namespace or all namespaces).
     * </pre>
     *
     * <code>repeated string export_to = 6;</code>
     * @param index The index of the value to return.
     * @return The bytes of the exportTo at the given index.
     */
    public com.google.protobuf.ByteString
        getExportToBytes(int index) {
      return exportTo_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < hosts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hosts_.getRaw(i));
      }
      for (int i = 0; i < gateways_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gateways_.getRaw(i));
      }
      for (int i = 0; i < http_.size(); i++) {
        output.writeMessage(3, http_.get(i));
      }
      for (int i = 0; i < tcp_.size(); i++) {
        output.writeMessage(4, tcp_.get(i));
      }
      for (int i = 0; i < tls_.size(); i++) {
        output.writeMessage(5, tls_.get(i));
      }
      for (int i = 0; i < exportTo_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, exportTo_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < hosts_.size(); i++) {
          dataSize += computeStringSizeNoTag(hosts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getHostsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < gateways_.size(); i++) {
          dataSize += computeStringSizeNoTag(gateways_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGatewaysList().size();
      }
      for (int i = 0; i < http_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, http_.get(i));
      }
      for (int i = 0; i < tcp_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, tcp_.get(i));
      }
      for (int i = 0; i < tls_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, tls_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exportTo_.size(); i++) {
          dataSize += computeStringSizeNoTag(exportTo_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExportToList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService other = (istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService) obj;

      if (!getHostsList()
          .equals(other.getHostsList())) return false;
      if (!getGatewaysList()
          .equals(other.getGatewaysList())) return false;
      if (!getHttpList()
          .equals(other.getHttpList())) return false;
      if (!getTlsList()
          .equals(other.getTlsList())) return false;
      if (!getTcpList()
          .equals(other.getTcpList())) return false;
      if (!getExportToList()
          .equals(other.getExportToList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getHostsCount() > 0) {
        hash = (37 * hash) + HOSTS_FIELD_NUMBER;
        hash = (53 * hash) + getHostsList().hashCode();
      }
      if (getGatewaysCount() > 0) {
        hash = (37 * hash) + GATEWAYS_FIELD_NUMBER;
        hash = (53 * hash) + getGatewaysList().hashCode();
      }
      if (getHttpCount() > 0) {
        hash = (37 * hash) + HTTP_FIELD_NUMBER;
        hash = (53 * hash) + getHttpList().hashCode();
      }
      if (getTlsCount() > 0) {
        hash = (37 * hash) + TLS_FIELD_NUMBER;
        hash = (53 * hash) + getTlsList().hashCode();
      }
      if (getTcpCount() > 0) {
        hash = (37 * hash) + TCP_FIELD_NUMBER;
        hash = (53 * hash) + getTcpList().hashCode();
      }
      if (getExportToCount() > 0) {
        hash = (37 * hash) + EXPORT_TO_FIELD_NUMBER;
        hash = (53 * hash) + getExportToList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Configuration affecting traffic routing.
     * &lt;!-- crd generation tags
     * +cue-gen:VirtualService:groupName:networking.istio.io
     * +cue-gen:VirtualService:version:v1alpha3
     * +cue-gen:VirtualService:storageVersion
     * +cue-gen:VirtualService:annotations:helm.sh/resource-policy=keep
     * +cue-gen:VirtualService:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
     * +cue-gen:VirtualService:subresource:status
     * +cue-gen:VirtualService:scope:Namespaced
     * +cue-gen:VirtualService:resource:categories=istio-io,networking-istio-io,shortNames=vs
     * +cue-gen:VirtualService:printerColumn:name=Gateways,type=string,JSONPath=.spec.gateways,description="The names of gateways and sidecars 
     * that should apply these routes"
     * +cue-gen:VirtualService:printerColumn:name=Hosts,type=string,JSONPath=.spec.hosts,description="The destination hosts to which traffic is being sent"
     * +cue-gen:VirtualService:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp 
     * representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. 
     * Clients may not set this value. It is represented in RFC3339 form and is in UTC.
     * Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
     * +cue-gen:VirtualService:preserveUnknownFields:false
     * --&gt;
     * &lt;!-- go code generation tags
     * +kubetype-gen
     * +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
     * +genclient
     * +k8s:deepcopy-gen=true
     * --&gt;
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.VirtualService}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.VirtualService)
        istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualServiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_VirtualService_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_VirtualService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.class, istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (httpBuilder_ == null) {
          http_ = java.util.Collections.emptyList();
        } else {
          http_ = null;
          httpBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (tlsBuilder_ == null) {
          tls_ = java.util.Collections.emptyList();
        } else {
          tls_ = null;
          tlsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (tcpBuilder_ == null) {
          tcp_ = java.util.Collections.emptyList();
        } else {
          tcp_ = null;
          tcpBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        exportTo_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_VirtualService_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService result = new istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          hosts_ = hosts_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.hosts_ = hosts_;
        if (((bitField0_ & 0x00000002) != 0)) {
          gateways_ = gateways_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.gateways_ = gateways_;
        if (httpBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            http_ = java.util.Collections.unmodifiableList(http_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.http_ = http_;
        } else {
          result.http_ = httpBuilder_.build();
        }
        if (tlsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            tls_ = java.util.Collections.unmodifiableList(tls_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.tls_ = tls_;
        } else {
          result.tls_ = tlsBuilder_.build();
        }
        if (tcpBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            tcp_ = java.util.Collections.unmodifiableList(tcp_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.tcp_ = tcp_;
        } else {
          result.tcp_ = tcpBuilder_.build();
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          exportTo_ = exportTo_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.exportTo_ = exportTo_;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService.getDefaultInstance()) return this;
        if (!other.hosts_.isEmpty()) {
          if (hosts_.isEmpty()) {
            hosts_ = other.hosts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureHostsIsMutable();
            hosts_.addAll(other.hosts_);
          }
          onChanged();
        }
        if (!other.gateways_.isEmpty()) {
          if (gateways_.isEmpty()) {
            gateways_ = other.gateways_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureGatewaysIsMutable();
            gateways_.addAll(other.gateways_);
          }
          onChanged();
        }
        if (httpBuilder_ == null) {
          if (!other.http_.isEmpty()) {
            if (http_.isEmpty()) {
              http_ = other.http_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureHttpIsMutable();
              http_.addAll(other.http_);
            }
            onChanged();
          }
        } else {
          if (!other.http_.isEmpty()) {
            if (httpBuilder_.isEmpty()) {
              httpBuilder_.dispose();
              httpBuilder_ = null;
              http_ = other.http_;
              bitField0_ = (bitField0_ & ~0x00000004);
              httpBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getHttpFieldBuilder() : null;
            } else {
              httpBuilder_.addAllMessages(other.http_);
            }
          }
        }
        if (tlsBuilder_ == null) {
          if (!other.tls_.isEmpty()) {
            if (tls_.isEmpty()) {
              tls_ = other.tls_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureTlsIsMutable();
              tls_.addAll(other.tls_);
            }
            onChanged();
          }
        } else {
          if (!other.tls_.isEmpty()) {
            if (tlsBuilder_.isEmpty()) {
              tlsBuilder_.dispose();
              tlsBuilder_ = null;
              tls_ = other.tls_;
              bitField0_ = (bitField0_ & ~0x00000008);
              tlsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTlsFieldBuilder() : null;
            } else {
              tlsBuilder_.addAllMessages(other.tls_);
            }
          }
        }
        if (tcpBuilder_ == null) {
          if (!other.tcp_.isEmpty()) {
            if (tcp_.isEmpty()) {
              tcp_ = other.tcp_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureTcpIsMutable();
              tcp_.addAll(other.tcp_);
            }
            onChanged();
          }
        } else {
          if (!other.tcp_.isEmpty()) {
            if (tcpBuilder_.isEmpty()) {
              tcpBuilder_.dispose();
              tcpBuilder_ = null;
              tcp_ = other.tcp_;
              bitField0_ = (bitField0_ & ~0x00000010);
              tcpBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTcpFieldBuilder() : null;
            } else {
              tcpBuilder_.addAllMessages(other.tcp_);
            }
          }
        }
        if (!other.exportTo_.isEmpty()) {
          if (exportTo_.isEmpty()) {
            exportTo_ = other.exportTo_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureExportToIsMutable();
            exportTo_.addAll(other.exportTo_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureHostsIsMutable();
                hosts_.add(s);
                break;
              } // case 10
              case 18: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureGatewaysIsMutable();
                gateways_.add(s);
                break;
              } // case 18
              case 26: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.parser(),
                        extensionRegistry);
                if (httpBuilder_ == null) {
                  ensureHttpIsMutable();
                  http_.add(m);
                } else {
                  httpBuilder_.addMessage(m);
                }
                break;
              } // case 26
              case 34: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.parser(),
                        extensionRegistry);
                if (tcpBuilder_ == null) {
                  ensureTcpIsMutable();
                  tcp_.add(m);
                } else {
                  tcpBuilder_.addMessage(m);
                }
                break;
              } // case 34
              case 42: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.parser(),
                        extensionRegistry);
                if (tlsBuilder_ == null) {
                  ensureTlsIsMutable();
                  tls_.add(m);
                } else {
                  tlsBuilder_.addMessage(m);
                }
                break;
              } // case 42
              case 50: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExportToIsMutable();
                exportTo_.add(s);
                break;
              } // case 50
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.LazyStringList hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureHostsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          hosts_ = new com.google.protobuf.LazyStringArrayList(hosts_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @return A list containing the hosts.
       */
      public com.google.protobuf.ProtocolStringList
          getHostsList() {
        return hosts_.getUnmodifiableView();
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @return The count of hosts.
       */
      public int getHostsCount() {
        return hosts_.size();
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @param index The index of the element to return.
       * @return The hosts at the given index.
       */
      public java.lang.String getHosts(int index) {
        return hosts_.get(index);
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @param index The index of the value to return.
       * @return The bytes of the hosts at the given index.
       */
      public com.google.protobuf.ByteString
          getHostsBytes(int index) {
        return hosts_.getByteString(index);
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @param index The index to set the value at.
       * @param value The hosts to set.
       * @return This builder for chaining.
       */
      public Builder setHosts(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureHostsIsMutable();
        hosts_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @param value The hosts to add.
       * @return This builder for chaining.
       */
      public Builder addHosts(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureHostsIsMutable();
        hosts_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @param values The hosts to add.
       * @return This builder for chaining.
       */
      public Builder addAllHosts(
          java.lang.Iterable<java.lang.String> values) {
        ensureHostsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, hosts_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearHosts() {
        hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The destination hosts to which traffic is being sent. Could
       * be a DNS name with wildcard prefix or an IP address.  Depending on the
       * platform, short-names can also be used instead of a FQDN (i.e. has no
       * dots in the name). In such a scenario, the FQDN of the host would be
       * derived based on the underlying platform.
       * A single VirtualService can be used to describe all the traffic
       * properties of the corresponding hosts, including those for multiple
       * HTTP and TCP ports. Alternatively, the traffic properties of a host
       * can be defined using more than one VirtualService, with certain
       * caveats. Refer to the
       * [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
       * for details.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews" will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. _To avoid
       * potential misconfigurations, it is recommended to always use fully
       * qualified domain names over short names._
       * The hosts field applies to both HTTP and TCP services. Service inside
       * the mesh, i.e., those found in the service registry, must always be
       * referred to using their alphanumeric names. IP addresses are allowed
       * only for services defined via the Gateway.
       * *Note*: It must be empty for a delegate VirtualService.
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       * @param value The bytes of the hosts to add.
       * @return This builder for chaining.
       */
      public Builder addHostsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureHostsIsMutable();
        hosts_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureGatewaysIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          gateways_ = new com.google.protobuf.LazyStringArrayList(gateways_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @return A list containing the gateways.
       */
      public com.google.protobuf.ProtocolStringList
          getGatewaysList() {
        return gateways_.getUnmodifiableView();
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @return The count of gateways.
       */
      public int getGatewaysCount() {
        return gateways_.size();
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @param index The index of the element to return.
       * @return The gateways at the given index.
       */
      public java.lang.String getGateways(int index) {
        return gateways_.get(index);
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @param index The index of the value to return.
       * @return The bytes of the gateways at the given index.
       */
      public com.google.protobuf.ByteString
          getGatewaysBytes(int index) {
        return gateways_.getByteString(index);
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @param index The index to set the value at.
       * @param value The gateways to set.
       * @return This builder for chaining.
       */
      public Builder setGateways(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureGatewaysIsMutable();
        gateways_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @param value The gateways to add.
       * @return This builder for chaining.
       */
      public Builder addGateways(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureGatewaysIsMutable();
        gateways_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @param values The gateways to add.
       * @return This builder for chaining.
       */
      public Builder addAllGateways(
          java.lang.Iterable<java.lang.String> values) {
        ensureGatewaysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, gateways_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearGateways() {
        gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The names of gateways and sidecars that should apply these routes.
       * Gateways in other namespaces may be referred to by
       * `&lt;gateway namespace&gt;/&lt;gateway name&gt;`; specifying a gateway with no
       * namespace qualifier is the same as specifying the VirtualService's
       * namespace. A single VirtualService is used for sidecars inside the mesh as
       * well as for one or more gateways. The selection condition imposed by this
       * field can be overridden using the source field in the match conditions
       * of protocol-specific routes. The reserved word `mesh` is used to imply
       * all the sidecars in the mesh. When this field is omitted, the default
       * gateway (`mesh`) will be used, which would apply the rule to all
       * sidecars in the mesh. If a list of gateway names is provided, the
       * rules will apply only to the gateways. To apply the rules to both
       * gateways and sidecars, specify `mesh` as one of the gateway names.
       * </pre>
       *
       * <code>repeated string gateways = 2;</code>
       * @param value The bytes of the gateways to add.
       * @return This builder for chaining.
       */
      public Builder addGatewaysBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureGatewaysIsMutable();
        gateways_.add(value);
        onChanged();
        return this;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute> http_ =
        java.util.Collections.emptyList();
      private void ensureHttpIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          http_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute>(http_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder> httpBuilder_;

      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute> getHttpList() {
        if (httpBuilder_ == null) {
          return java.util.Collections.unmodifiableList(http_);
        } else {
          return httpBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public int getHttpCount() {
        if (httpBuilder_ == null) {
          return http_.size();
        } else {
          return httpBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute getHttp(int index) {
        if (httpBuilder_ == null) {
          return http_.get(index);
        } else {
          return httpBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder setHttp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute value) {
        if (httpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHttpIsMutable();
          http_.set(index, value);
          onChanged();
        } else {
          httpBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder setHttp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder builderForValue) {
        if (httpBuilder_ == null) {
          ensureHttpIsMutable();
          http_.set(index, builderForValue.build());
          onChanged();
        } else {
          httpBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder addHttp(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute value) {
        if (httpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHttpIsMutable();
          http_.add(value);
          onChanged();
        } else {
          httpBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder addHttp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute value) {
        if (httpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHttpIsMutable();
          http_.add(index, value);
          onChanged();
        } else {
          httpBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder addHttp(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder builderForValue) {
        if (httpBuilder_ == null) {
          ensureHttpIsMutable();
          http_.add(builderForValue.build());
          onChanged();
        } else {
          httpBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder addHttp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder builderForValue) {
        if (httpBuilder_ == null) {
          ensureHttpIsMutable();
          http_.add(index, builderForValue.build());
          onChanged();
        } else {
          httpBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder addAllHttp(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute> values) {
        if (httpBuilder_ == null) {
          ensureHttpIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, http_);
          onChanged();
        } else {
          httpBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder clearHttp() {
        if (httpBuilder_ == null) {
          http_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          httpBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public Builder removeHttp(int index) {
        if (httpBuilder_ == null) {
          ensureHttpIsMutable();
          http_.remove(index);
          onChanged();
        } else {
          httpBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder getHttpBuilder(
          int index) {
        return getHttpFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder getHttpOrBuilder(
          int index) {
        if (httpBuilder_ == null) {
          return http_.get(index);  } else {
          return httpBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder> 
           getHttpOrBuilderList() {
        if (httpBuilder_ != null) {
          return httpBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(http_);
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder addHttpBuilder() {
        return getHttpFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.getDefaultInstance());
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder addHttpBuilder(
          int index) {
        return getHttpFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.getDefaultInstance());
      }
      /**
       * <pre>
       * An ordered list of route rules for HTTP traffic. HTTP routes will be
       * applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
       * ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
       * entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
       * an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRoute http = 3;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder> 
           getHttpBuilderList() {
        return getHttpFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder> 
          getHttpFieldBuilder() {
        if (httpBuilder_ == null) {
          httpBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder>(
                  http_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          http_ = null;
        }
        return httpBuilder_;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute> tls_ =
        java.util.Collections.emptyList();
      private void ensureTlsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          tls_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute>(tls_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder> tlsBuilder_;

      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute> getTlsList() {
        if (tlsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tls_);
        } else {
          return tlsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public int getTlsCount() {
        if (tlsBuilder_ == null) {
          return tls_.size();
        } else {
          return tlsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute getTls(int index) {
        if (tlsBuilder_ == null) {
          return tls_.get(index);
        } else {
          return tlsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder setTls(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute value) {
        if (tlsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTlsIsMutable();
          tls_.set(index, value);
          onChanged();
        } else {
          tlsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder setTls(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder builderForValue) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.set(index, builderForValue.build());
          onChanged();
        } else {
          tlsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder addTls(istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute value) {
        if (tlsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTlsIsMutable();
          tls_.add(value);
          onChanged();
        } else {
          tlsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder addTls(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute value) {
        if (tlsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTlsIsMutable();
          tls_.add(index, value);
          onChanged();
        } else {
          tlsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder addTls(
          istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder builderForValue) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.add(builderForValue.build());
          onChanged();
        } else {
          tlsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder addTls(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder builderForValue) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.add(index, builderForValue.build());
          onChanged();
        } else {
          tlsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder addAllTls(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute> values) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tls_);
          onChanged();
        } else {
          tlsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder clearTls() {
        if (tlsBuilder_ == null) {
          tls_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          tlsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public Builder removeTls(int index) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.remove(index);
          onChanged();
        } else {
          tlsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder getTlsBuilder(
          int index) {
        return getTlsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder getTlsOrBuilder(
          int index) {
        if (tlsBuilder_ == null) {
          return tls_.get(index);  } else {
          return tlsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder> 
           getTlsOrBuilderList() {
        if (tlsBuilder_ != null) {
          return tlsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tls_);
        }
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder addTlsBuilder() {
        return getTlsFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.getDefaultInstance());
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder addTlsBuilder(
          int index) {
        return getTlsFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.getDefaultInstance());
      }
      /**
       * <pre>
       * An ordered list of route rule for non-terminated TLS &amp; HTTPS
       * traffic. Routing is typically performed using the SNI value presented
       * by the ClientHello message. TLS routes will be applied to platform
       * service ports named 'https-*', 'tls-*', unterminated gateway ports using
       * HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
       * entry ports using HTTPS/TLS protocols.  The first rule matching an
       * incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
       * without associated virtual service will be treated as opaque TCP
       * traffic.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSRoute tls = 5;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder> 
           getTlsBuilderList() {
        return getTlsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder> 
          getTlsFieldBuilder() {
        if (tlsBuilder_ == null) {
          tlsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder>(
                  tls_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          tls_ = null;
        }
        return tlsBuilder_;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute> tcp_ =
        java.util.Collections.emptyList();
      private void ensureTcpIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          tcp_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute>(tcp_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder> tcpBuilder_;

      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute> getTcpList() {
        if (tcpBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tcp_);
        } else {
          return tcpBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public int getTcpCount() {
        if (tcpBuilder_ == null) {
          return tcp_.size();
        } else {
          return tcpBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute getTcp(int index) {
        if (tcpBuilder_ == null) {
          return tcp_.get(index);
        } else {
          return tcpBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder setTcp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute value) {
        if (tcpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTcpIsMutable();
          tcp_.set(index, value);
          onChanged();
        } else {
          tcpBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder setTcp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder builderForValue) {
        if (tcpBuilder_ == null) {
          ensureTcpIsMutable();
          tcp_.set(index, builderForValue.build());
          onChanged();
        } else {
          tcpBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder addTcp(istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute value) {
        if (tcpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTcpIsMutable();
          tcp_.add(value);
          onChanged();
        } else {
          tcpBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder addTcp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute value) {
        if (tcpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTcpIsMutable();
          tcp_.add(index, value);
          onChanged();
        } else {
          tcpBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder addTcp(
          istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder builderForValue) {
        if (tcpBuilder_ == null) {
          ensureTcpIsMutable();
          tcp_.add(builderForValue.build());
          onChanged();
        } else {
          tcpBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder addTcp(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder builderForValue) {
        if (tcpBuilder_ == null) {
          ensureTcpIsMutable();
          tcp_.add(index, builderForValue.build());
          onChanged();
        } else {
          tcpBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder addAllTcp(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute> values) {
        if (tcpBuilder_ == null) {
          ensureTcpIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tcp_);
          onChanged();
        } else {
          tcpBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder clearTcp() {
        if (tcpBuilder_ == null) {
          tcp_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          tcpBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public Builder removeTcp(int index) {
        if (tcpBuilder_ == null) {
          ensureTcpIsMutable();
          tcp_.remove(index);
          onChanged();
        } else {
          tcpBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder getTcpBuilder(
          int index) {
        return getTcpFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder getTcpOrBuilder(
          int index) {
        if (tcpBuilder_ == null) {
          return tcp_.get(index);  } else {
          return tcpBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder> 
           getTcpOrBuilderList() {
        if (tcpBuilder_ != null) {
          return tcpBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tcp_);
        }
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder addTcpBuilder() {
        return getTcpFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.getDefaultInstance());
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder addTcpBuilder(
          int index) {
        return getTcpFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.getDefaultInstance());
      }
      /**
       * <pre>
       * An ordered list of route rules for opaque TCP traffic. TCP routes will
       * be applied to any port that is not a HTTP or TLS port. The first rule
       * matching an incoming request is used.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TCPRoute tcp = 4;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder> 
           getTcpBuilderList() {
        return getTcpFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder> 
          getTcpFieldBuilder() {
        if (tcpBuilder_ == null) {
          tcpBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder>(
                  tcp_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          tcp_ = null;
        }
        return tcpBuilder_;
      }

      private com.google.protobuf.LazyStringList exportTo_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureExportToIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          exportTo_ = new com.google.protobuf.LazyStringArrayList(exportTo_);
          bitField0_ |= 0x00000020;
         }
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @return A list containing the exportTo.
       */
      public com.google.protobuf.ProtocolStringList
          getExportToList() {
        return exportTo_.getUnmodifiableView();
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @return The count of exportTo.
       */
      public int getExportToCount() {
        return exportTo_.size();
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @param index The index of the element to return.
       * @return The exportTo at the given index.
       */
      public java.lang.String getExportTo(int index) {
        return exportTo_.get(index);
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @param index The index of the value to return.
       * @return The bytes of the exportTo at the given index.
       */
      public com.google.protobuf.ByteString
          getExportToBytes(int index) {
        return exportTo_.getByteString(index);
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @param index The index to set the value at.
       * @param value The exportTo to set.
       * @return This builder for chaining.
       */
      public Builder setExportTo(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureExportToIsMutable();
        exportTo_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @param value The exportTo to add.
       * @return This builder for chaining.
       */
      public Builder addExportTo(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureExportToIsMutable();
        exportTo_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @param values The exportTo to add.
       * @return This builder for chaining.
       */
      public Builder addAllExportTo(
          java.lang.Iterable<java.lang.String> values) {
        ensureExportToIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, exportTo_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearExportTo() {
        exportTo_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A list of namespaces to which this virtual service is exported. Exporting a
       * virtual service allows it to be used by sidecars and gateways defined in
       * other namespaces. This feature provides a mechanism for service owners
       * and mesh administrators to control the visibility of virtual services
       * across namespace boundaries.
       * If no namespaces are specified then the virtual service is exported to all
       * namespaces by default.
       * The value "." is reserved and defines an export to the same namespace that
       * the virtual service is declared in. Similarly the value "*" is reserved and
       * defines an export to all namespaces.
       * NOTE: in the current release, the `exportTo` value is restricted to
       * "." or "*" (i.e., the current namespace or all namespaces).
       * </pre>
       *
       * <code>repeated string export_to = 6;</code>
       * @param value The bytes of the exportTo to add.
       * @return This builder for chaining.
       */
      public Builder addExportToBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureExportToIsMutable();
        exportTo_.add(value);
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.VirtualService)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.VirtualService)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VirtualService>
        PARSER = new com.google.protobuf.AbstractParser<VirtualService>() {
      @java.lang.Override
      public VirtualService parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<VirtualService> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VirtualService> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.VirtualService getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DestinationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.Destination)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The name of a service from the service registry. Service
     * names are looked up from the platform's service registry (e.g.,
     * Kubernetes services, Consul services, etc.) and from the hosts
     * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
     * destinations that are not found in either of the two, will be dropped.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. To avoid
     * potential misconfiguration, it is recommended to always use fully
     * qualified domain names over short names.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The host.
     */
    java.lang.String getHost();
    /**
     * <pre>
     * The name of a service from the service registry. Service
     * names are looked up from the platform's service registry (e.g.,
     * Kubernetes services, Consul services, etc.) and from the hosts
     * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
     * destinations that are not found in either of the two, will be dropped.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. To avoid
     * potential misconfiguration, it is recommended to always use fully
     * qualified domain names over short names.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for host.
     */
    com.google.protobuf.ByteString
        getHostBytes();

    /**
     * <pre>
     * The name of a subset within the service. Applicable only to services
     * within the mesh. The subset must be defined in a corresponding
     * DestinationRule.
     * </pre>
     *
     * <code>string subset = 2;</code>
     * @return The subset.
     */
    java.lang.String getSubset();
    /**
     * <pre>
     * The name of a subset within the service. Applicable only to services
     * within the mesh. The subset must be defined in a corresponding
     * DestinationRule.
     * </pre>
     *
     * <code>string subset = 2;</code>
     * @return The bytes for subset.
     */
    com.google.protobuf.ByteString
        getSubsetBytes();

    /**
     * <pre>
     * Specifies the port on the host that is being addressed. If a service
     * exposes only a single port it is not required to explicitly select the
     * port.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
     * @return Whether the port field is set.
     */
    boolean hasPort();
    /**
     * <pre>
     * Specifies the port on the host that is being addressed. If a service
     * exposes only a single port it is not required to explicitly select the
     * port.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
     * @return The port.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector getPort();
    /**
     * <pre>
     * Specifies the port on the host that is being addressed. If a service
     * exposes only a single port it is not required to explicitly select the
     * port.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelectorOrBuilder getPortOrBuilder();
  }
  /**
   * <pre>
   * Destination indicates the network addressable service to which the
   * request/connection will be sent after processing a routing rule. The
   * destination.host should unambiguously refer to a service in the service
   * registry. Istio's service registry is composed of all the services found
   * in the platform's service registry (e.g., Kubernetes services, Consul
   * services), as well as services declared through the
   * [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry) resource.
   * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
   * instead of "reviews.default.svc.cluster.local"), Istio will interpret
   * the short name based on the namespace of the rule, not the service. A
   * rule in the "default" namespace containing a host "reviews will be
   * interpreted as "reviews.default.svc.cluster.local", irrespective of the
   * actual namespace associated with the reviews service. _To avoid potential
   * misconfigurations, it is recommended to always use fully qualified
   * domain names over short names._
   * The following Kubernetes example routes all traffic by default to pods
   * of the reviews service with label "version: v1" (i.e., subset v1), and
   * some to subset v2, in a Kubernetes environment.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: reviews-route
   *   namespace: foo
   * spec:
   *   hosts:
   *   - reviews # interpreted as reviews.foo.svc.cluster.local
   *   http:
   *   - match:
   *     - uri:
   *         prefix: "/wpcatalog"
   *     - uri:
   *         prefix: "/consumercatalog"
   *     rewrite:
   *       uri: "/newcatalog"
   *     route:
   *     - destination:
   *         host: reviews # interpreted as reviews.foo.svc.cluster.local
   *         subset: v2
   *   - route:
   *     - destination:
   *         host: reviews # interpreted as reviews.foo.svc.cluster.local
   *         subset: v1
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: reviews-route
   *   namespace: foo
   * spec:
   *   hosts:
   *   - reviews # interpreted as reviews.foo.svc.cluster.local
   *   http:
   *   - match:
   *     - uri:
   *         prefix: "/wpcatalog"
   *     - uri:
   *         prefix: "/consumercatalog"
   *     rewrite:
   *       uri: "/newcatalog"
   *     route:
   *     - destination:
   *         host: reviews # interpreted as reviews.foo.svc.cluster.local
   *         subset: v2
   *   - route:
   *     - destination:
   *         host: reviews # interpreted as reviews.foo.svc.cluster.local
   *         subset: v1
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * And the associated DestinationRule
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: DestinationRule
   * metadata:
   *   name: reviews-destination
   *   namespace: foo
   * spec:
   *   host: reviews # interpreted as reviews.foo.svc.cluster.local
   *   subsets:
   *   - name: v1
   *     labels:
   *       version: v1
   *   - name: v2
   *     labels:
   *       version: v2
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: DestinationRule
   * metadata:
   *   name: reviews-destination
   *   namespace: foo
   * spec:
   *   host: reviews # interpreted as reviews.foo.svc.cluster.local
   *   subsets:
   *   - name: v1
   *     labels:
   *       version: v1
   *   - name: v2
   *     labels:
   *       version: v2
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * The following VirtualService sets a timeout of 5s for all calls to
   * productpage.prod.svc.cluster.local service in Kubernetes. Notice that
   * there are no subsets defined in this rule. Istio will fetch all
   * instances of productpage.prod.svc.cluster.local service from the service
   * registry and populate the sidecar's load balancing pool. Also, notice
   * that this rule is set in the istio-system namespace but uses the fully
   * qualified domain name of the productpage service,
   * productpage.prod.svc.cluster.local. Therefore the rule's namespace does
   * not have an impact in resolving the name of the productpage service.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: my-productpage-rule
   *   namespace: istio-system
   * spec:
   *   hosts:
   *   - productpage.prod.svc.cluster.local # ignores rule namespace
   *   http:
   *   - timeout: 5s
   *     route:
   *     - destination:
   *         host: productpage.prod.svc.cluster.local
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: my-productpage-rule
   *   namespace: istio-system
   * spec:
   *   hosts:
   *   - productpage.prod.svc.cluster.local # ignores rule namespace
   *   http:
   *   - timeout: 5s
   *     route:
   *     - destination:
   *         host: productpage.prod.svc.cluster.local
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * To control routing for traffic bound to services outside the mesh, external
   * services must first be added to Istio's internal service registry using the
   * ServiceEntry resource. VirtualServices can then be defined to control traffic
   * bound to these external services. For example, the following rules define a
   * Service for wikipedia.org and set a timeout of 5s for HTTP requests.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: ServiceEntry
   * metadata:
   *   name: external-svc-wikipedia
   * spec:
   *   hosts:
   *   - wikipedia.org
   *   location: MESH_EXTERNAL
   *   ports:
   *   - number: 80
   *     name: example-http
   *     protocol: HTTP
   *   resolution: DNS
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: my-wiki-rule
   * spec:
   *   hosts:
   *   - wikipedia.org
   *   http:
   *   - timeout: 5s
   *     route:
   *     - destination:
   *         host: wikipedia.org
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: ServiceEntry
   * metadata:
   *   name: external-svc-wikipedia
   * spec:
   *   hosts:
   *   - wikipedia.org
   *   location: MESH_EXTERNAL
   *   ports:
   *   - number: 80
   *     name: example-http
   *     protocol: HTTP
   *   resolution: DNS
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: my-wiki-rule
   * spec:
   *   hosts:
   *   - wikipedia.org
   *   http:
   *   - timeout: 5s
   *     route:
   *     - destination:
   *         host: wikipedia.org
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.Destination}
   */
  public static final class Destination extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.Destination)
      DestinationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Destination.newBuilder() to construct.
    private Destination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Destination() {
      host_ = "";
      subset_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Destination();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Destination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Destination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder.class);
    }

    public static final int HOST_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object host_ = "";
    /**
     * <pre>
     * The name of a service from the service registry. Service
     * names are looked up from the platform's service registry (e.g.,
     * Kubernetes services, Consul services, etc.) and from the hosts
     * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
     * destinations that are not found in either of the two, will be dropped.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. To avoid
     * potential misconfiguration, it is recommended to always use fully
     * qualified domain names over short names.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The host.
     */
    @java.lang.Override
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The name of a service from the service registry. Service
     * names are looked up from the platform's service registry (e.g.,
     * Kubernetes services, Consul services, etc.) and from the hosts
     * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
     * destinations that are not found in either of the two, will be dropped.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of
     * the actual namespace associated with the reviews service. To avoid
     * potential misconfiguration, it is recommended to always use fully
     * qualified domain names over short names.
     * </pre>
     *
     * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The bytes for host.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBSET_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object subset_ = "";
    /**
     * <pre>
     * The name of a subset within the service. Applicable only to services
     * within the mesh. The subset must be defined in a corresponding
     * DestinationRule.
     * </pre>
     *
     * <code>string subset = 2;</code>
     * @return The subset.
     */
    @java.lang.Override
    public java.lang.String getSubset() {
      java.lang.Object ref = subset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subset_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The name of a subset within the service. Applicable only to services
     * within the mesh. The subset must be defined in a corresponding
     * DestinationRule.
     * </pre>
     *
     * <code>string subset = 2;</code>
     * @return The bytes for subset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSubsetBytes() {
      java.lang.Object ref = subset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        subset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 3;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector port_;
    /**
     * <pre>
     * Specifies the port on the host that is being addressed. If a service
     * exposes only a single port it is not required to explicitly select the
     * port.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
     * @return Whether the port field is set.
     */
    @java.lang.Override
    public boolean hasPort() {
      return port_ != null;
    }
    /**
     * <pre>
     * Specifies the port on the host that is being addressed. If a service
     * exposes only a single port it is not required to explicitly select the
     * port.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
     * @return The port.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector getPort() {
      return port_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.getDefaultInstance() : port_;
    }
    /**
     * <pre>
     * Specifies the port on the host that is being addressed. If a service
     * exposes only a single port it is not required to explicitly select the
     * port.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelectorOrBuilder getPortOrBuilder() {
      return port_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.getDefaultInstance() : port_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, host_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subset_);
      }
      if (port_ != null) {
        output.writeMessage(3, getPort());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, host_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subset_);
      }
      if (port_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getPort());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Destination)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.Destination other = (istio.networking.v1alpha3.VirtualServiceOuterClass.Destination) obj;

      if (!getHost()
          .equals(other.getHost())) return false;
      if (!getSubset()
          .equals(other.getSubset())) return false;
      if (hasPort() != other.hasPort()) return false;
      if (hasPort()) {
        if (!getPort()
            .equals(other.getPort())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HOST_FIELD_NUMBER;
      hash = (53 * hash) + getHost().hashCode();
      hash = (37 * hash) + SUBSET_FIELD_NUMBER;
      hash = (53 * hash) + getSubset().hashCode();
      if (hasPort()) {
        hash = (37 * hash) + PORT_FIELD_NUMBER;
        hash = (53 * hash) + getPort().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Destination indicates the network addressable service to which the
     * request/connection will be sent after processing a routing rule. The
     * destination.host should unambiguously refer to a service in the service
     * registry. Istio's service registry is composed of all the services found
     * in the platform's service registry (e.g., Kubernetes services, Consul
     * services), as well as services declared through the
     * [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry) resource.
     * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
     * instead of "reviews.default.svc.cluster.local"), Istio will interpret
     * the short name based on the namespace of the rule, not the service. A
     * rule in the "default" namespace containing a host "reviews will be
     * interpreted as "reviews.default.svc.cluster.local", irrespective of the
     * actual namespace associated with the reviews service. _To avoid potential
     * misconfigurations, it is recommended to always use fully qualified
     * domain names over short names._
     * The following Kubernetes example routes all traffic by default to pods
     * of the reviews service with label "version: v1" (i.e., subset v1), and
     * some to subset v2, in a Kubernetes environment.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: reviews-route
     *   namespace: foo
     * spec:
     *   hosts:
     *   - reviews # interpreted as reviews.foo.svc.cluster.local
     *   http:
     *   - match:
     *     - uri:
     *         prefix: "/wpcatalog"
     *     - uri:
     *         prefix: "/consumercatalog"
     *     rewrite:
     *       uri: "/newcatalog"
     *     route:
     *     - destination:
     *         host: reviews # interpreted as reviews.foo.svc.cluster.local
     *         subset: v2
     *   - route:
     *     - destination:
     *         host: reviews # interpreted as reviews.foo.svc.cluster.local
     *         subset: v1
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: reviews-route
     *   namespace: foo
     * spec:
     *   hosts:
     *   - reviews # interpreted as reviews.foo.svc.cluster.local
     *   http:
     *   - match:
     *     - uri:
     *         prefix: "/wpcatalog"
     *     - uri:
     *         prefix: "/consumercatalog"
     *     rewrite:
     *       uri: "/newcatalog"
     *     route:
     *     - destination:
     *         host: reviews # interpreted as reviews.foo.svc.cluster.local
     *         subset: v2
     *   - route:
     *     - destination:
     *         host: reviews # interpreted as reviews.foo.svc.cluster.local
     *         subset: v1
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * And the associated DestinationRule
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: DestinationRule
     * metadata:
     *   name: reviews-destination
     *   namespace: foo
     * spec:
     *   host: reviews # interpreted as reviews.foo.svc.cluster.local
     *   subsets:
     *   - name: v1
     *     labels:
     *       version: v1
     *   - name: v2
     *     labels:
     *       version: v2
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: DestinationRule
     * metadata:
     *   name: reviews-destination
     *   namespace: foo
     * spec:
     *   host: reviews # interpreted as reviews.foo.svc.cluster.local
     *   subsets:
     *   - name: v1
     *     labels:
     *       version: v1
     *   - name: v2
     *     labels:
     *       version: v2
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * The following VirtualService sets a timeout of 5s for all calls to
     * productpage.prod.svc.cluster.local service in Kubernetes. Notice that
     * there are no subsets defined in this rule. Istio will fetch all
     * instances of productpage.prod.svc.cluster.local service from the service
     * registry and populate the sidecar's load balancing pool. Also, notice
     * that this rule is set in the istio-system namespace but uses the fully
     * qualified domain name of the productpage service,
     * productpage.prod.svc.cluster.local. Therefore the rule's namespace does
     * not have an impact in resolving the name of the productpage service.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: my-productpage-rule
     *   namespace: istio-system
     * spec:
     *   hosts:
     *   - productpage.prod.svc.cluster.local # ignores rule namespace
     *   http:
     *   - timeout: 5s
     *     route:
     *     - destination:
     *         host: productpage.prod.svc.cluster.local
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: my-productpage-rule
     *   namespace: istio-system
     * spec:
     *   hosts:
     *   - productpage.prod.svc.cluster.local # ignores rule namespace
     *   http:
     *   - timeout: 5s
     *     route:
     *     - destination:
     *         host: productpage.prod.svc.cluster.local
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * To control routing for traffic bound to services outside the mesh, external
     * services must first be added to Istio's internal service registry using the
     * ServiceEntry resource. VirtualServices can then be defined to control traffic
     * bound to these external services. For example, the following rules define a
     * Service for wikipedia.org and set a timeout of 5s for HTTP requests.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: ServiceEntry
     * metadata:
     *   name: external-svc-wikipedia
     * spec:
     *   hosts:
     *   - wikipedia.org
     *   location: MESH_EXTERNAL
     *   ports:
     *   - number: 80
     *     name: example-http
     *     protocol: HTTP
     *   resolution: DNS
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: my-wiki-rule
     * spec:
     *   hosts:
     *   - wikipedia.org
     *   http:
     *   - timeout: 5s
     *     route:
     *     - destination:
     *         host: wikipedia.org
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: ServiceEntry
     * metadata:
     *   name: external-svc-wikipedia
     * spec:
     *   hosts:
     *   - wikipedia.org
     *   location: MESH_EXTERNAL
     *   ports:
     *   - number: 80
     *     name: example-http
     *     protocol: HTTP
     *   resolution: DNS
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: my-wiki-rule
     * spec:
     *   hosts:
     *   - wikipedia.org
     *   http:
     *   - timeout: 5s
     *     route:
     *     - destination:
     *         host: wikipedia.org
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.Destination}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.Destination)
        istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Destination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Destination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        host_ = "";
        subset_ = "";
        port_ = null;
        if (portBuilder_ != null) {
          portBuilder_.dispose();
          portBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Destination_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.Destination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.Destination result = new istio.networking.v1alpha3.VirtualServiceOuterClass.Destination(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.host_ = host_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.subset_ = subset_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.port_ = portBuilder_ == null
              ? port_
              : portBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Destination) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.Destination)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance()) return this;
        if (!other.getHost().isEmpty()) {
          host_ = other.host_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSubset().isEmpty()) {
          subset_ = other.subset_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasPort()) {
          mergePort(other.getPort());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                subset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getPortFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object host_ = "";
      /**
       * <pre>
       * The name of a service from the service registry. Service
       * names are looked up from the platform's service registry (e.g.,
       * Kubernetes services, Consul services, etc.) and from the hosts
       * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
       * destinations that are not found in either of the two, will be dropped.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. To avoid
       * potential misconfiguration, it is recommended to always use fully
       * qualified domain names over short names.
       * </pre>
       *
       * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return The host.
       */
      public java.lang.String getHost() {
        java.lang.Object ref = host_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          host_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The name of a service from the service registry. Service
       * names are looked up from the platform's service registry (e.g.,
       * Kubernetes services, Consul services, etc.) and from the hosts
       * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
       * destinations that are not found in either of the two, will be dropped.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. To avoid
       * potential misconfiguration, it is recommended to always use fully
       * qualified domain names over short names.
       * </pre>
       *
       * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return The bytes for host.
       */
      public com.google.protobuf.ByteString
          getHostBytes() {
        java.lang.Object ref = host_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          host_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The name of a service from the service registry. Service
       * names are looked up from the platform's service registry (e.g.,
       * Kubernetes services, Consul services, etc.) and from the hosts
       * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
       * destinations that are not found in either of the two, will be dropped.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. To avoid
       * potential misconfiguration, it is recommended to always use fully
       * qualified domain names over short names.
       * </pre>
       *
       * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @param value The host to set.
       * @return This builder for chaining.
       */
      public Builder setHost(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        host_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of a service from the service registry. Service
       * names are looked up from the platform's service registry (e.g.,
       * Kubernetes services, Consul services, etc.) and from the hosts
       * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
       * destinations that are not found in either of the two, will be dropped.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. To avoid
       * potential misconfiguration, it is recommended to always use fully
       * qualified domain names over short names.
       * </pre>
       *
       * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return This builder for chaining.
       */
      public Builder clearHost() {
        host_ = getDefaultInstance().getHost();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of a service from the service registry. Service
       * names are looked up from the platform's service registry (e.g.,
       * Kubernetes services, Consul services, etc.) and from the hosts
       * declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
       * destinations that are not found in either of the two, will be dropped.
       * *Note for Kubernetes users*: When short names are used (e.g. "reviews"
       * instead of "reviews.default.svc.cluster.local"), Istio will interpret
       * the short name based on the namespace of the rule, not the service. A
       * rule in the "default" namespace containing a host "reviews will be
       * interpreted as "reviews.default.svc.cluster.local", irrespective of
       * the actual namespace associated with the reviews service. To avoid
       * potential misconfiguration, it is recommended to always use fully
       * qualified domain names over short names.
       * </pre>
       *
       * <code>string host = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @param value The bytes for host to set.
       * @return This builder for chaining.
       */
      public Builder setHostBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        host_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object subset_ = "";
      /**
       * <pre>
       * The name of a subset within the service. Applicable only to services
       * within the mesh. The subset must be defined in a corresponding
       * DestinationRule.
       * </pre>
       *
       * <code>string subset = 2;</code>
       * @return The subset.
       */
      public java.lang.String getSubset() {
        java.lang.Object ref = subset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The name of a subset within the service. Applicable only to services
       * within the mesh. The subset must be defined in a corresponding
       * DestinationRule.
       * </pre>
       *
       * <code>string subset = 2;</code>
       * @return The bytes for subset.
       */
      public com.google.protobuf.ByteString
          getSubsetBytes() {
        java.lang.Object ref = subset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          subset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The name of a subset within the service. Applicable only to services
       * within the mesh. The subset must be defined in a corresponding
       * DestinationRule.
       * </pre>
       *
       * <code>string subset = 2;</code>
       * @param value The subset to set.
       * @return This builder for chaining.
       */
      public Builder setSubset(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        subset_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of a subset within the service. Applicable only to services
       * within the mesh. The subset must be defined in a corresponding
       * DestinationRule.
       * </pre>
       *
       * <code>string subset = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSubset() {
        subset_ = getDefaultInstance().getSubset();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of a subset within the service. Applicable only to services
       * within the mesh. The subset must be defined in a corresponding
       * DestinationRule.
       * </pre>
       *
       * <code>string subset = 2;</code>
       * @param value The bytes for subset to set.
       * @return This builder for chaining.
       */
      public Builder setSubsetBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        subset_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector port_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector, istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelectorOrBuilder> portBuilder_;
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       * @return Whether the port field is set.
       */
      public boolean hasPort() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       * @return The port.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector getPort() {
        if (portBuilder_ == null) {
          return port_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.getDefaultInstance() : port_;
        } else {
          return portBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      public Builder setPort(istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector value) {
        if (portBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          port_ = value;
        } else {
          portBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      public Builder setPort(
          istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.Builder builderForValue) {
        if (portBuilder_ == null) {
          port_ = builderForValue.build();
        } else {
          portBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      public Builder mergePort(istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector value) {
        if (portBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            port_ != null &&
            port_ != istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.getDefaultInstance()) {
            getPortBuilder().mergeFrom(value);
          } else {
            port_ = value;
          }
        } else {
          portBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000004);
        port_ = null;
        if (portBuilder_ != null) {
          portBuilder_.dispose();
          portBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.Builder getPortBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getPortFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelectorOrBuilder getPortOrBuilder() {
        if (portBuilder_ != null) {
          return portBuilder_.getMessageOrBuilder();
        } else {
          return port_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.getDefaultInstance() : port_;
        }
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. If a service
       * exposes only a single port it is not required to explicitly select the
       * port.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.PortSelector port = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector, istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelectorOrBuilder> 
          getPortFieldBuilder() {
        if (portBuilder_ == null) {
          portBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector, istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelector.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.PortSelectorOrBuilder>(
                  getPort(),
                  getParentForChildren(),
                  isClean());
          port_ = null;
        }
        return portBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.Destination)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.Destination)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.Destination DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.Destination();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Destination>
        PARSER = new com.google.protobuf.AbstractParser<Destination>() {
      @java.lang.Override
      public Destination parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Destination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Destination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface HTTPRouteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.HTTPRoute)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The name assigned to the route for debugging purposes. The
     * route's name will be concatenated with the match's name and will
     * be logged in the access logs for requests matching this
     * route/match.
     * </pre>
     *
     * <code>string name = 17;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * The name assigned to the route for debugging purposes. The
     * route's name will be concatenated with the match's name and will
     * be logged in the access logs for requests matching this
     * route/match.
     * </pre>
     *
     * <code>string name = 17;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest> 
        getMatchList();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest getMatch(int index);
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    int getMatchCount();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder> 
        getMatchOrBuilderList();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder getMatchOrBuilder(
        int index);

    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination> 
        getRouteList();
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination getRoute(int index);
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    int getRouteCount();
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder> 
        getRouteOrBuilderList();
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder getRouteOrBuilder(
        int index);

    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. If
     * traffic passthrough option is specified in the rule,
     * route/redirect will be ignored. The redirect primitive can be used to
     * send a HTTP 301 redirect to a different URI or Authority.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
     * @return Whether the redirect field is set.
     */
    boolean hasRedirect();
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. If
     * traffic passthrough option is specified in the rule,
     * route/redirect will be ignored. The redirect primitive can be used to
     * send a HTTP 301 redirect to a different URI or Authority.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
     * @return The redirect.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect getRedirect();
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. If
     * traffic passthrough option is specified in the rule,
     * route/redirect will be ignored. The redirect primitive can be used to
     * send a HTTP 301 redirect to a different URI or Authority.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirectOrBuilder getRedirectOrBuilder();

    /**
     * <pre>
     * Delegate is used to specify the particular VirtualService which
     * can be used to define delegate HTTPRoute.
     * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
     * delegate VirtualService will be merged with that in the current one.
     * **NOTE**:
     *    1. Only one level delegation is supported.
     *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
     *       otherwise there is a conflict and the HTTPRoute will not take effect.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
     * @return Whether the delegate field is set.
     */
    boolean hasDelegate();
    /**
     * <pre>
     * Delegate is used to specify the particular VirtualService which
     * can be used to define delegate HTTPRoute.
     * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
     * delegate VirtualService will be merged with that in the current one.
     * **NOTE**:
     *    1. Only one level delegation is supported.
     *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
     *       otherwise there is a conflict and the HTTPRoute will not take effect.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
     * @return The delegate.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate getDelegate();
    /**
     * <pre>
     * Delegate is used to specify the particular VirtualService which
     * can be used to define delegate HTTPRoute.
     * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
     * delegate VirtualService will be merged with that in the current one.
     * **NOTE**:
     *    1. Only one level delegation is supported.
     *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
     *       otherwise there is a conflict and the HTTPRoute will not take effect.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder getDelegateOrBuilder();

    /**
     * <pre>
     * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
     * Redirect primitive. Rewrite will be performed before forwarding.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
     * @return Whether the rewrite field is set.
     */
    boolean hasRewrite();
    /**
     * <pre>
     * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
     * Redirect primitive. Rewrite will be performed before forwarding.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
     * @return The rewrite.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite getRewrite();
    /**
     * <pre>
     * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
     * Redirect primitive. Rewrite will be performed before forwarding.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewriteOrBuilder getRewriteOrBuilder();

    /**
     * <pre>
     * Timeout for HTTP requests, default is disabled.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return Whether the timeout field is set.
     */
    boolean hasTimeout();
    /**
     * <pre>
     * Timeout for HTTP requests, default is disabled.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return The timeout.
     */
    com.google.protobuf.Duration getTimeout();
    /**
     * <pre>
     * Timeout for HTTP requests, default is disabled.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder();

    /**
     * <pre>
     * Retry policy for HTTP requests.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
     * @return Whether the retries field is set.
     */
    boolean hasRetries();
    /**
     * <pre>
     * Retry policy for HTTP requests.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
     * @return The retries.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry getRetries();
    /**
     * <pre>
     * Retry policy for HTTP requests.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetryOrBuilder getRetriesOrBuilder();

    /**
     * <pre>
     * Fault injection policy to apply on HTTP traffic at the client side.
     * Note that timeouts or retries will not be enabled when faults are
     * enabled on the client side.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
     * @return Whether the fault field is set.
     */
    boolean hasFault();
    /**
     * <pre>
     * Fault injection policy to apply on HTTP traffic at the client side.
     * Note that timeouts or retries will not be enabled when faults are
     * enabled on the client side.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
     * @return The fault.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection getFault();
    /**
     * <pre>
     * Fault injection policy to apply on HTTP traffic at the client side.
     * Note that timeouts or retries will not be enabled when faults are
     * enabled on the client side.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjectionOrBuilder getFaultOrBuilder();

    /**
     * <pre>
     * Mirror HTTP traffic to a another destination in addition to forwarding
     * the requests to the intended destination. Mirrored traffic is on a
     * best effort basis where the sidecar/gateway will not wait for the
     * mirrored cluster to respond before returning the response from the
     * original destination.  Statistics will be generated for the mirrored
     * destination.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
     * @return Whether the mirror field is set.
     */
    boolean hasMirror();
    /**
     * <pre>
     * Mirror HTTP traffic to a another destination in addition to forwarding
     * the requests to the intended destination. Mirrored traffic is on a
     * best effort basis where the sidecar/gateway will not wait for the
     * mirrored cluster to respond before returning the response from the
     * original destination.  Statistics will be generated for the mirrored
     * destination.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
     * @return The mirror.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getMirror();
    /**
     * <pre>
     * Mirror HTTP traffic to a another destination in addition to forwarding
     * the requests to the intended destination. Mirrored traffic is on a
     * best effort basis where the sidecar/gateway will not wait for the
     * mirrored cluster to respond before returning the response from the
     * original destination.  Statistics will be generated for the mirrored
     * destination.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getMirrorOrBuilder();

    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * Use of integer `mirror_percent` value is deprecated. Use the
     * double `mirror_percentage` field instead
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
     * @deprecated istio.networking.v1alpha3.HTTPRoute.mirror_percent is deprecated.
     *     See networking/v1alpha3/virtual_service.proto;l=627
     * @return Whether the mirrorPercent field is set.
     */
    @java.lang.Deprecated boolean hasMirrorPercent();
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * Use of integer `mirror_percent` value is deprecated. Use the
     * double `mirror_percentage` field instead
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
     * @deprecated istio.networking.v1alpha3.HTTPRoute.mirror_percent is deprecated.
     *     See networking/v1alpha3/virtual_service.proto;l=627
     * @return The mirrorPercent.
     */
    @java.lang.Deprecated com.google.protobuf.UInt32Value getMirrorPercent();
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * Use of integer `mirror_percent` value is deprecated. Use the
     * double `mirror_percentage` field instead
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
     */
    @java.lang.Deprecated com.google.protobuf.UInt32ValueOrBuilder getMirrorPercentOrBuilder();

    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * If this field is absent, all the traffic (100%) will be mirrored.
     * Max value is 100.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
     * @return Whether the mirrorPercentage field is set.
     */
    boolean hasMirrorPercentage();
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * If this field is absent, all the traffic (100%) will be mirrored.
     * Max value is 100.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
     * @return The mirrorPercentage.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Percent getMirrorPercentage();
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * If this field is absent, all the traffic (100%) will be mirrored.
     * Max value is 100.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.PercentOrBuilder getMirrorPercentageOrBuilder();

    /**
     * <pre>
     * Cross-Origin Resource Sharing policy (CORS). Refer to
     * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
     * for further details about cross origin resource sharing.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
     * @return Whether the corsPolicy field is set.
     */
    boolean hasCorsPolicy();
    /**
     * <pre>
     * Cross-Origin Resource Sharing policy (CORS). Refer to
     * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
     * for further details about cross origin resource sharing.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
     * @return The corsPolicy.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy getCorsPolicy();
    /**
     * <pre>
     * Cross-Origin Resource Sharing policy (CORS). Refer to
     * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
     * for further details about cross origin resource sharing.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicyOrBuilder getCorsPolicyOrBuilder();

    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
     * @return Whether the headers field is set.
     */
    boolean hasHeaders();
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
     * @return The headers.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getHeaders();
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder getHeadersOrBuilder();
  }
  /**
   * <pre>
   * Describes match conditions and actions for routing HTTP/1.1, HTTP2, and
   * gRPC traffic. See VirtualService for usage examples.
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.HTTPRoute}
   */
  public static final class HTTPRoute extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.HTTPRoute)
      HTTPRouteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use HTTPRoute.newBuilder() to construct.
    private HTTPRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private HTTPRoute() {
      name_ = "";
      match_ = java.util.Collections.emptyList();
      route_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new HTTPRoute();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRoute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.class, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 17;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * The name assigned to the route for debugging purposes. The
     * route's name will be concatenated with the match's name and will
     * be logged in the access logs for requests matching this
     * route/match.
     * </pre>
     *
     * <code>string name = 17;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The name assigned to the route for debugging purposes. The
     * route's name will be concatenated with the match's name and will
     * be logged in the access logs for requests matching this
     * route/match.
     * </pre>
     *
     * <code>string name = 17;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MATCH_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest> match_;
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest> getMatchList() {
      return match_;
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder> 
        getMatchOrBuilderList() {
      return match_;
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    @java.lang.Override
    public int getMatchCount() {
      return match_.size();
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest getMatch(int index) {
      return match_.get(index);
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder getMatchOrBuilder(
        int index) {
      return match_.get(index);
    }

    public static final int ROUTE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination> route_;
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination> getRouteList() {
      return route_;
    }
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder> 
        getRouteOrBuilderList() {
      return route_;
    }
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    @java.lang.Override
    public int getRouteCount() {
      return route_.size();
    }
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination getRoute(int index) {
      return route_.get(index);
    }
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. The
     * forwarding target can be one of several versions of a service (see
     * glossary in beginning of document). Weights associated with the
     * service version determine the proportion of traffic it receives.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder getRouteOrBuilder(
        int index) {
      return route_.get(index);
    }

    public static final int REDIRECT_FIELD_NUMBER = 3;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect redirect_;
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. If
     * traffic passthrough option is specified in the rule,
     * route/redirect will be ignored. The redirect primitive can be used to
     * send a HTTP 301 redirect to a different URI or Authority.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
     * @return Whether the redirect field is set.
     */
    @java.lang.Override
    public boolean hasRedirect() {
      return redirect_ != null;
    }
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. If
     * traffic passthrough option is specified in the rule,
     * route/redirect will be ignored. The redirect primitive can be used to
     * send a HTTP 301 redirect to a different URI or Authority.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
     * @return The redirect.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect getRedirect() {
      return redirect_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.getDefaultInstance() : redirect_;
    }
    /**
     * <pre>
     * A HTTP rule can either redirect or forward (default) traffic. If
     * traffic passthrough option is specified in the rule,
     * route/redirect will be ignored. The redirect primitive can be used to
     * send a HTTP 301 redirect to a different URI or Authority.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirectOrBuilder getRedirectOrBuilder() {
      return redirect_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.getDefaultInstance() : redirect_;
    }

    public static final int DELEGATE_FIELD_NUMBER = 20;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate delegate_;
    /**
     * <pre>
     * Delegate is used to specify the particular VirtualService which
     * can be used to define delegate HTTPRoute.
     * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
     * delegate VirtualService will be merged with that in the current one.
     * **NOTE**:
     *    1. Only one level delegation is supported.
     *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
     *       otherwise there is a conflict and the HTTPRoute will not take effect.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
     * @return Whether the delegate field is set.
     */
    @java.lang.Override
    public boolean hasDelegate() {
      return delegate_ != null;
    }
    /**
     * <pre>
     * Delegate is used to specify the particular VirtualService which
     * can be used to define delegate HTTPRoute.
     * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
     * delegate VirtualService will be merged with that in the current one.
     * **NOTE**:
     *    1. Only one level delegation is supported.
     *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
     *       otherwise there is a conflict and the HTTPRoute will not take effect.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
     * @return The delegate.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate getDelegate() {
      return delegate_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance() : delegate_;
    }
    /**
     * <pre>
     * Delegate is used to specify the particular VirtualService which
     * can be used to define delegate HTTPRoute.
     * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
     * delegate VirtualService will be merged with that in the current one.
     * **NOTE**:
     *    1. Only one level delegation is supported.
     *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
     *       otherwise there is a conflict and the HTTPRoute will not take effect.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder getDelegateOrBuilder() {
      return delegate_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance() : delegate_;
    }

    public static final int REWRITE_FIELD_NUMBER = 4;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite rewrite_;
    /**
     * <pre>
     * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
     * Redirect primitive. Rewrite will be performed before forwarding.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
     * @return Whether the rewrite field is set.
     */
    @java.lang.Override
    public boolean hasRewrite() {
      return rewrite_ != null;
    }
    /**
     * <pre>
     * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
     * Redirect primitive. Rewrite will be performed before forwarding.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
     * @return The rewrite.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite getRewrite() {
      return rewrite_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.getDefaultInstance() : rewrite_;
    }
    /**
     * <pre>
     * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
     * Redirect primitive. Rewrite will be performed before forwarding.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewriteOrBuilder getRewriteOrBuilder() {
      return rewrite_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.getDefaultInstance() : rewrite_;
    }

    public static final int TIMEOUT_FIELD_NUMBER = 6;
    private com.google.protobuf.Duration timeout_;
    /**
     * <pre>
     * Timeout for HTTP requests, default is disabled.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return Whether the timeout field is set.
     */
    @java.lang.Override
    public boolean hasTimeout() {
      return timeout_ != null;
    }
    /**
     * <pre>
     * Timeout for HTTP requests, default is disabled.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     * @return The timeout.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTimeout() {
      return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
    }
    /**
     * <pre>
     * Timeout for HTTP requests, default is disabled.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
    }

    public static final int RETRIES_FIELD_NUMBER = 7;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry retries_;
    /**
     * <pre>
     * Retry policy for HTTP requests.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
     * @return Whether the retries field is set.
     */
    @java.lang.Override
    public boolean hasRetries() {
      return retries_ != null;
    }
    /**
     * <pre>
     * Retry policy for HTTP requests.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
     * @return The retries.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry getRetries() {
      return retries_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.getDefaultInstance() : retries_;
    }
    /**
     * <pre>
     * Retry policy for HTTP requests.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetryOrBuilder getRetriesOrBuilder() {
      return retries_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.getDefaultInstance() : retries_;
    }

    public static final int FAULT_FIELD_NUMBER = 8;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection fault_;
    /**
     * <pre>
     * Fault injection policy to apply on HTTP traffic at the client side.
     * Note that timeouts or retries will not be enabled when faults are
     * enabled on the client side.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
     * @return Whether the fault field is set.
     */
    @java.lang.Override
    public boolean hasFault() {
      return fault_ != null;
    }
    /**
     * <pre>
     * Fault injection policy to apply on HTTP traffic at the client side.
     * Note that timeouts or retries will not be enabled when faults are
     * enabled on the client side.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
     * @return The fault.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection getFault() {
      return fault_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.getDefaultInstance() : fault_;
    }
    /**
     * <pre>
     * Fault injection policy to apply on HTTP traffic at the client side.
     * Note that timeouts or retries will not be enabled when faults are
     * enabled on the client side.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjectionOrBuilder getFaultOrBuilder() {
      return fault_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.getDefaultInstance() : fault_;
    }

    public static final int MIRROR_FIELD_NUMBER = 9;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Destination mirror_;
    /**
     * <pre>
     * Mirror HTTP traffic to a another destination in addition to forwarding
     * the requests to the intended destination. Mirrored traffic is on a
     * best effort basis where the sidecar/gateway will not wait for the
     * mirrored cluster to respond before returning the response from the
     * original destination.  Statistics will be generated for the mirrored
     * destination.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
     * @return Whether the mirror field is set.
     */
    @java.lang.Override
    public boolean hasMirror() {
      return mirror_ != null;
    }
    /**
     * <pre>
     * Mirror HTTP traffic to a another destination in addition to forwarding
     * the requests to the intended destination. Mirrored traffic is on a
     * best effort basis where the sidecar/gateway will not wait for the
     * mirrored cluster to respond before returning the response from the
     * original destination.  Statistics will be generated for the mirrored
     * destination.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
     * @return The mirror.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getMirror() {
      return mirror_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : mirror_;
    }
    /**
     * <pre>
     * Mirror HTTP traffic to a another destination in addition to forwarding
     * the requests to the intended destination. Mirrored traffic is on a
     * best effort basis where the sidecar/gateway will not wait for the
     * mirrored cluster to respond before returning the response from the
     * original destination.  Statistics will be generated for the mirrored
     * destination.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getMirrorOrBuilder() {
      return mirror_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : mirror_;
    }

    public static final int MIRROR_PERCENT_FIELD_NUMBER = 18;
    private com.google.protobuf.UInt32Value mirrorPercent_;
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * Use of integer `mirror_percent` value is deprecated. Use the
     * double `mirror_percentage` field instead
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
     * @deprecated istio.networking.v1alpha3.HTTPRoute.mirror_percent is deprecated.
     *     See networking/v1alpha3/virtual_service.proto;l=627
     * @return Whether the mirrorPercent field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated public boolean hasMirrorPercent() {
      return mirrorPercent_ != null;
    }
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * Use of integer `mirror_percent` value is deprecated. Use the
     * double `mirror_percentage` field instead
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
     * @deprecated istio.networking.v1alpha3.HTTPRoute.mirror_percent is deprecated.
     *     See networking/v1alpha3/virtual_service.proto;l=627
     * @return The mirrorPercent.
     */
    @java.lang.Override
    @java.lang.Deprecated public com.google.protobuf.UInt32Value getMirrorPercent() {
      return mirrorPercent_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : mirrorPercent_;
    }
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * Use of integer `mirror_percent` value is deprecated. Use the
     * double `mirror_percentage` field instead
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated public com.google.protobuf.UInt32ValueOrBuilder getMirrorPercentOrBuilder() {
      return mirrorPercent_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : mirrorPercent_;
    }

    public static final int MIRROR_PERCENTAGE_FIELD_NUMBER = 19;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Percent mirrorPercentage_;
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * If this field is absent, all the traffic (100%) will be mirrored.
     * Max value is 100.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
     * @return Whether the mirrorPercentage field is set.
     */
    @java.lang.Override
    public boolean hasMirrorPercentage() {
      return mirrorPercentage_ != null;
    }
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * If this field is absent, all the traffic (100%) will be mirrored.
     * Max value is 100.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
     * @return The mirrorPercentage.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Percent getMirrorPercentage() {
      return mirrorPercentage_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.getDefaultInstance() : mirrorPercentage_;
    }
    /**
     * <pre>
     * Percentage of the traffic to be mirrored by the `mirror` field.
     * If this field is absent, all the traffic (100%) will be mirrored.
     * Max value is 100.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.PercentOrBuilder getMirrorPercentageOrBuilder() {
      return mirrorPercentage_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.getDefaultInstance() : mirrorPercentage_;
    }

    public static final int CORS_POLICY_FIELD_NUMBER = 10;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy corsPolicy_;
    /**
     * <pre>
     * Cross-Origin Resource Sharing policy (CORS). Refer to
     * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
     * for further details about cross origin resource sharing.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
     * @return Whether the corsPolicy field is set.
     */
    @java.lang.Override
    public boolean hasCorsPolicy() {
      return corsPolicy_ != null;
    }
    /**
     * <pre>
     * Cross-Origin Resource Sharing policy (CORS). Refer to
     * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
     * for further details about cross origin resource sharing.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
     * @return The corsPolicy.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy getCorsPolicy() {
      return corsPolicy_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.getDefaultInstance() : corsPolicy_;
    }
    /**
     * <pre>
     * Cross-Origin Resource Sharing policy (CORS). Refer to
     * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
     * for further details about cross origin resource sharing.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicyOrBuilder getCorsPolicyOrBuilder() {
      return corsPolicy_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.getDefaultInstance() : corsPolicy_;
    }

    public static final int HEADERS_FIELD_NUMBER = 16;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers headers_;
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
     * @return Whether the headers field is set.
     */
    @java.lang.Override
    public boolean hasHeaders() {
      return headers_ != null;
    }
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
     * @return The headers.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getHeaders() {
      return headers_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
    }
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder getHeadersOrBuilder() {
      return headers_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < match_.size(); i++) {
        output.writeMessage(1, match_.get(i));
      }
      for (int i = 0; i < route_.size(); i++) {
        output.writeMessage(2, route_.get(i));
      }
      if (redirect_ != null) {
        output.writeMessage(3, getRedirect());
      }
      if (rewrite_ != null) {
        output.writeMessage(4, getRewrite());
      }
      if (timeout_ != null) {
        output.writeMessage(6, getTimeout());
      }
      if (retries_ != null) {
        output.writeMessage(7, getRetries());
      }
      if (fault_ != null) {
        output.writeMessage(8, getFault());
      }
      if (mirror_ != null) {
        output.writeMessage(9, getMirror());
      }
      if (corsPolicy_ != null) {
        output.writeMessage(10, getCorsPolicy());
      }
      if (headers_ != null) {
        output.writeMessage(16, getHeaders());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 17, name_);
      }
      if (mirrorPercent_ != null) {
        output.writeMessage(18, getMirrorPercent());
      }
      if (mirrorPercentage_ != null) {
        output.writeMessage(19, getMirrorPercentage());
      }
      if (delegate_ != null) {
        output.writeMessage(20, getDelegate());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < match_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, match_.get(i));
      }
      for (int i = 0; i < route_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, route_.get(i));
      }
      if (redirect_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getRedirect());
      }
      if (rewrite_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getRewrite());
      }
      if (timeout_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getTimeout());
      }
      if (retries_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getRetries());
      }
      if (fault_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getFault());
      }
      if (mirror_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getMirror());
      }
      if (corsPolicy_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getCorsPolicy());
      }
      if (headers_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(16, getHeaders());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, name_);
      }
      if (mirrorPercent_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(18, getMirrorPercent());
      }
      if (mirrorPercentage_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(19, getMirrorPercentage());
      }
      if (delegate_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(20, getDelegate());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute other = (istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (!getMatchList()
          .equals(other.getMatchList())) return false;
      if (!getRouteList()
          .equals(other.getRouteList())) return false;
      if (hasRedirect() != other.hasRedirect()) return false;
      if (hasRedirect()) {
        if (!getRedirect()
            .equals(other.getRedirect())) return false;
      }
      if (hasDelegate() != other.hasDelegate()) return false;
      if (hasDelegate()) {
        if (!getDelegate()
            .equals(other.getDelegate())) return false;
      }
      if (hasRewrite() != other.hasRewrite()) return false;
      if (hasRewrite()) {
        if (!getRewrite()
            .equals(other.getRewrite())) return false;
      }
      if (hasTimeout() != other.hasTimeout()) return false;
      if (hasTimeout()) {
        if (!getTimeout()
            .equals(other.getTimeout())) return false;
      }
      if (hasRetries() != other.hasRetries()) return false;
      if (hasRetries()) {
        if (!getRetries()
            .equals(other.getRetries())) return false;
      }
      if (hasFault() != other.hasFault()) return false;
      if (hasFault()) {
        if (!getFault()
            .equals(other.getFault())) return false;
      }
      if (hasMirror() != other.hasMirror()) return false;
      if (hasMirror()) {
        if (!getMirror()
            .equals(other.getMirror())) return false;
      }
      if (hasMirrorPercent() != other.hasMirrorPercent()) return false;
      if (hasMirrorPercent()) {
        if (!getMirrorPercent()
            .equals(other.getMirrorPercent())) return false;
      }
      if (hasMirrorPercentage() != other.hasMirrorPercentage()) return false;
      if (hasMirrorPercentage()) {
        if (!getMirrorPercentage()
            .equals(other.getMirrorPercentage())) return false;
      }
      if (hasCorsPolicy() != other.hasCorsPolicy()) return false;
      if (hasCorsPolicy()) {
        if (!getCorsPolicy()
            .equals(other.getCorsPolicy())) return false;
      }
      if (hasHeaders() != other.hasHeaders()) return false;
      if (hasHeaders()) {
        if (!getHeaders()
            .equals(other.getHeaders())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getMatchCount() > 0) {
        hash = (37 * hash) + MATCH_FIELD_NUMBER;
        hash = (53 * hash) + getMatchList().hashCode();
      }
      if (getRouteCount() > 0) {
        hash = (37 * hash) + ROUTE_FIELD_NUMBER;
        hash = (53 * hash) + getRouteList().hashCode();
      }
      if (hasRedirect()) {
        hash = (37 * hash) + REDIRECT_FIELD_NUMBER;
        hash = (53 * hash) + getRedirect().hashCode();
      }
      if (hasDelegate()) {
        hash = (37 * hash) + DELEGATE_FIELD_NUMBER;
        hash = (53 * hash) + getDelegate().hashCode();
      }
      if (hasRewrite()) {
        hash = (37 * hash) + REWRITE_FIELD_NUMBER;
        hash = (53 * hash) + getRewrite().hashCode();
      }
      if (hasTimeout()) {
        hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
        hash = (53 * hash) + getTimeout().hashCode();
      }
      if (hasRetries()) {
        hash = (37 * hash) + RETRIES_FIELD_NUMBER;
        hash = (53 * hash) + getRetries().hashCode();
      }
      if (hasFault()) {
        hash = (37 * hash) + FAULT_FIELD_NUMBER;
        hash = (53 * hash) + getFault().hashCode();
      }
      if (hasMirror()) {
        hash = (37 * hash) + MIRROR_FIELD_NUMBER;
        hash = (53 * hash) + getMirror().hashCode();
      }
      if (hasMirrorPercent()) {
        hash = (37 * hash) + MIRROR_PERCENT_FIELD_NUMBER;
        hash = (53 * hash) + getMirrorPercent().hashCode();
      }
      if (hasMirrorPercentage()) {
        hash = (37 * hash) + MIRROR_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMirrorPercentage().hashCode();
      }
      if (hasCorsPolicy()) {
        hash = (37 * hash) + CORS_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getCorsPolicy().hashCode();
      }
      if (hasHeaders()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getHeaders().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describes match conditions and actions for routing HTTP/1.1, HTTP2, and
     * gRPC traffic. See VirtualService for usage examples.
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.HTTPRoute}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.HTTPRoute)
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRoute_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRoute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.class, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        if (matchBuilder_ == null) {
          match_ = java.util.Collections.emptyList();
        } else {
          match_ = null;
          matchBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (routeBuilder_ == null) {
          route_ = java.util.Collections.emptyList();
        } else {
          route_ = null;
          routeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        redirect_ = null;
        if (redirectBuilder_ != null) {
          redirectBuilder_.dispose();
          redirectBuilder_ = null;
        }
        delegate_ = null;
        if (delegateBuilder_ != null) {
          delegateBuilder_.dispose();
          delegateBuilder_ = null;
        }
        rewrite_ = null;
        if (rewriteBuilder_ != null) {
          rewriteBuilder_.dispose();
          rewriteBuilder_ = null;
        }
        timeout_ = null;
        if (timeoutBuilder_ != null) {
          timeoutBuilder_.dispose();
          timeoutBuilder_ = null;
        }
        retries_ = null;
        if (retriesBuilder_ != null) {
          retriesBuilder_.dispose();
          retriesBuilder_ = null;
        }
        fault_ = null;
        if (faultBuilder_ != null) {
          faultBuilder_.dispose();
          faultBuilder_ = null;
        }
        mirror_ = null;
        if (mirrorBuilder_ != null) {
          mirrorBuilder_.dispose();
          mirrorBuilder_ = null;
        }
        mirrorPercent_ = null;
        if (mirrorPercentBuilder_ != null) {
          mirrorPercentBuilder_.dispose();
          mirrorPercentBuilder_ = null;
        }
        mirrorPercentage_ = null;
        if (mirrorPercentageBuilder_ != null) {
          mirrorPercentageBuilder_.dispose();
          mirrorPercentageBuilder_ = null;
        }
        corsPolicy_ = null;
        if (corsPolicyBuilder_ != null) {
          corsPolicyBuilder_.dispose();
          corsPolicyBuilder_ = null;
        }
        headers_ = null;
        if (headersBuilder_ != null) {
          headersBuilder_.dispose();
          headersBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRoute_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute result = new istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute result) {
        if (matchBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            match_ = java.util.Collections.unmodifiableList(match_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.match_ = match_;
        } else {
          result.match_ = matchBuilder_.build();
        }
        if (routeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            route_ = java.util.Collections.unmodifiableList(route_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.route_ = route_;
        } else {
          result.route_ = routeBuilder_.build();
        }
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.redirect_ = redirectBuilder_ == null
              ? redirect_
              : redirectBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.delegate_ = delegateBuilder_ == null
              ? delegate_
              : delegateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.rewrite_ = rewriteBuilder_ == null
              ? rewrite_
              : rewriteBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.timeout_ = timeoutBuilder_ == null
              ? timeout_
              : timeoutBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.retries_ = retriesBuilder_ == null
              ? retries_
              : retriesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.fault_ = faultBuilder_ == null
              ? fault_
              : faultBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.mirror_ = mirrorBuilder_ == null
              ? mirror_
              : mirrorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.mirrorPercent_ = mirrorPercentBuilder_ == null
              ? mirrorPercent_
              : mirrorPercentBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.mirrorPercentage_ = mirrorPercentageBuilder_ == null
              ? mirrorPercentage_
              : mirrorPercentageBuilder_.build();
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.corsPolicy_ = corsPolicyBuilder_ == null
              ? corsPolicy_
              : corsPolicyBuilder_.build();
        }
        if (((from_bitField0_ & 0x00002000) != 0)) {
          result.headers_ = headersBuilder_ == null
              ? headers_
              : headersBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (matchBuilder_ == null) {
          if (!other.match_.isEmpty()) {
            if (match_.isEmpty()) {
              match_ = other.match_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureMatchIsMutable();
              match_.addAll(other.match_);
            }
            onChanged();
          }
        } else {
          if (!other.match_.isEmpty()) {
            if (matchBuilder_.isEmpty()) {
              matchBuilder_.dispose();
              matchBuilder_ = null;
              match_ = other.match_;
              bitField0_ = (bitField0_ & ~0x00000002);
              matchBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getMatchFieldBuilder() : null;
            } else {
              matchBuilder_.addAllMessages(other.match_);
            }
          }
        }
        if (routeBuilder_ == null) {
          if (!other.route_.isEmpty()) {
            if (route_.isEmpty()) {
              route_ = other.route_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureRouteIsMutable();
              route_.addAll(other.route_);
            }
            onChanged();
          }
        } else {
          if (!other.route_.isEmpty()) {
            if (routeBuilder_.isEmpty()) {
              routeBuilder_.dispose();
              routeBuilder_ = null;
              route_ = other.route_;
              bitField0_ = (bitField0_ & ~0x00000004);
              routeBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getRouteFieldBuilder() : null;
            } else {
              routeBuilder_.addAllMessages(other.route_);
            }
          }
        }
        if (other.hasRedirect()) {
          mergeRedirect(other.getRedirect());
        }
        if (other.hasDelegate()) {
          mergeDelegate(other.getDelegate());
        }
        if (other.hasRewrite()) {
          mergeRewrite(other.getRewrite());
        }
        if (other.hasTimeout()) {
          mergeTimeout(other.getTimeout());
        }
        if (other.hasRetries()) {
          mergeRetries(other.getRetries());
        }
        if (other.hasFault()) {
          mergeFault(other.getFault());
        }
        if (other.hasMirror()) {
          mergeMirror(other.getMirror());
        }
        if (other.hasMirrorPercent()) {
          mergeMirrorPercent(other.getMirrorPercent());
        }
        if (other.hasMirrorPercentage()) {
          mergeMirrorPercentage(other.getMirrorPercentage());
        }
        if (other.hasCorsPolicy()) {
          mergeCorsPolicy(other.getCorsPolicy());
        }
        if (other.hasHeaders()) {
          mergeHeaders(other.getHeaders());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.parser(),
                        extensionRegistry);
                if (matchBuilder_ == null) {
                  ensureMatchIsMutable();
                  match_.add(m);
                } else {
                  matchBuilder_.addMessage(m);
                }
                break;
              } // case 10
              case 18: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.parser(),
                        extensionRegistry);
                if (routeBuilder_ == null) {
                  ensureRouteIsMutable();
                  route_.add(m);
                } else {
                  routeBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getRedirectFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getRewriteFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
              case 50: {
                input.readMessage(
                    getTimeoutFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
              case 58: {
                input.readMessage(
                    getRetriesFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
              case 66: {
                input.readMessage(
                    getFaultFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
              case 74: {
                input.readMessage(
                    getMirrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
              case 82: {
                input.readMessage(
                    getCorsPolicyFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 82
              case 130: {
                input.readMessage(
                    getHeadersFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 130
              case 138: {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 138
              case 146: {
                input.readMessage(
                    getMirrorPercentFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 146
              case 154: {
                input.readMessage(
                    getMirrorPercentageFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 154
              case 162: {
                input.readMessage(
                    getDelegateFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 162
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * The name assigned to the route for debugging purposes. The
       * route's name will be concatenated with the match's name and will
       * be logged in the access logs for requests matching this
       * route/match.
       * </pre>
       *
       * <code>string name = 17;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The name assigned to the route for debugging purposes. The
       * route's name will be concatenated with the match's name and will
       * be logged in the access logs for requests matching this
       * route/match.
       * </pre>
       *
       * <code>string name = 17;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The name assigned to the route for debugging purposes. The
       * route's name will be concatenated with the match's name and will
       * be logged in the access logs for requests matching this
       * route/match.
       * </pre>
       *
       * <code>string name = 17;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name assigned to the route for debugging purposes. The
       * route's name will be concatenated with the match's name and will
       * be logged in the access logs for requests matching this
       * route/match.
       * </pre>
       *
       * <code>string name = 17;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name assigned to the route for debugging purposes. The
       * route's name will be concatenated with the match's name and will
       * be logged in the access logs for requests matching this
       * route/match.
       * </pre>
       *
       * <code>string name = 17;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest> match_ =
        java.util.Collections.emptyList();
      private void ensureMatchIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          match_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest>(match_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder> matchBuilder_;

      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest> getMatchList() {
        if (matchBuilder_ == null) {
          return java.util.Collections.unmodifiableList(match_);
        } else {
          return matchBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public int getMatchCount() {
        if (matchBuilder_ == null) {
          return match_.size();
        } else {
          return matchBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest getMatch(int index) {
        if (matchBuilder_ == null) {
          return match_.get(index);
        } else {
          return matchBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder setMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.set(index, value);
          onChanged();
        } else {
          matchBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder setMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.set(index, builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder addMatch(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.add(value);
          onChanged();
        } else {
          matchBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder addMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.add(index, value);
          onChanged();
        } else {
          matchBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder addMatch(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.add(builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder addMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.add(index, builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder addAllMatch(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest> values) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, match_);
          onChanged();
        } else {
          matchBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder clearMatch() {
        if (matchBuilder_ == null) {
          match_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          matchBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public Builder removeMatch(int index) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.remove(index);
          onChanged();
        } else {
          matchBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder getMatchBuilder(
          int index) {
        return getMatchFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder getMatchOrBuilder(
          int index) {
        if (matchBuilder_ == null) {
          return match_.get(index);  } else {
          return matchBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder> 
           getMatchOrBuilderList() {
        if (matchBuilder_ != null) {
          return matchBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(match_);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder addMatchBuilder() {
        return getMatchFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.getDefaultInstance());
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder addMatchBuilder(
          int index) {
        return getMatchFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.getDefaultInstance());
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPMatchRequest match = 1;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder> 
           getMatchBuilderList() {
        return getMatchFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder> 
          getMatchFieldBuilder() {
        if (matchBuilder_ == null) {
          matchBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder>(
                  match_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          match_ = null;
        }
        return matchBuilder_;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination> route_ =
        java.util.Collections.emptyList();
      private void ensureRouteIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          route_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination>(route_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder> routeBuilder_;

      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination> getRouteList() {
        if (routeBuilder_ == null) {
          return java.util.Collections.unmodifiableList(route_);
        } else {
          return routeBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public int getRouteCount() {
        if (routeBuilder_ == null) {
          return route_.size();
        } else {
          return routeBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination getRoute(int index) {
        if (routeBuilder_ == null) {
          return route_.get(index);
        } else {
          return routeBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder setRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.set(index, value);
          onChanged();
        } else {
          routeBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder setRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.set(index, builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder addRoute(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.add(value);
          onChanged();
        } else {
          routeBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder addRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.add(index, value);
          onChanged();
        } else {
          routeBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder addRoute(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.add(builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder addRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.add(index, builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder addAllRoute(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination> values) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, route_);
          onChanged();
        } else {
          routeBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder clearRoute() {
        if (routeBuilder_ == null) {
          route_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          routeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public Builder removeRoute(int index) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.remove(index);
          onChanged();
        } else {
          routeBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder getRouteBuilder(
          int index) {
        return getRouteFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder getRouteOrBuilder(
          int index) {
        if (routeBuilder_ == null) {
          return route_.get(index);  } else {
          return routeBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder> 
           getRouteOrBuilderList() {
        if (routeBuilder_ != null) {
          return routeBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(route_);
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder addRouteBuilder() {
        return getRouteFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.getDefaultInstance());
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder addRouteBuilder(
          int index) {
        return getRouteFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.getDefaultInstance());
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. The
       * forwarding target can be one of several versions of a service (see
       * glossary in beginning of document). Weights associated with the
       * service version determine the proportion of traffic it receives.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.HTTPRouteDestination route = 2;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder> 
           getRouteBuilderList() {
        return getRouteFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder> 
          getRouteFieldBuilder() {
        if (routeBuilder_ == null) {
          routeBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder>(
                  route_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          route_ = null;
        }
        return routeBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect redirect_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirectOrBuilder> redirectBuilder_;
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       * @return Whether the redirect field is set.
       */
      public boolean hasRedirect() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       * @return The redirect.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect getRedirect() {
        if (redirectBuilder_ == null) {
          return redirect_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.getDefaultInstance() : redirect_;
        } else {
          return redirectBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      public Builder setRedirect(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect value) {
        if (redirectBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          redirect_ = value;
        } else {
          redirectBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      public Builder setRedirect(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.Builder builderForValue) {
        if (redirectBuilder_ == null) {
          redirect_ = builderForValue.build();
        } else {
          redirectBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      public Builder mergeRedirect(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect value) {
        if (redirectBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            redirect_ != null &&
            redirect_ != istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.getDefaultInstance()) {
            getRedirectBuilder().mergeFrom(value);
          } else {
            redirect_ = value;
          }
        } else {
          redirectBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      public Builder clearRedirect() {
        bitField0_ = (bitField0_ & ~0x00000008);
        redirect_ = null;
        if (redirectBuilder_ != null) {
          redirectBuilder_.dispose();
          redirectBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.Builder getRedirectBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getRedirectFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirectOrBuilder getRedirectOrBuilder() {
        if (redirectBuilder_ != null) {
          return redirectBuilder_.getMessageOrBuilder();
        } else {
          return redirect_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.getDefaultInstance() : redirect_;
        }
      }
      /**
       * <pre>
       * A HTTP rule can either redirect or forward (default) traffic. If
       * traffic passthrough option is specified in the rule,
       * route/redirect will be ignored. The redirect primitive can be used to
       * send a HTTP 301 redirect to a different URI or Authority.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRedirect redirect = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirectOrBuilder> 
          getRedirectFieldBuilder() {
        if (redirectBuilder_ == null) {
          redirectBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirect.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRedirectOrBuilder>(
                  getRedirect(),
                  getParentForChildren(),
                  isClean());
          redirect_ = null;
        }
        return redirectBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate delegate_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate, istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder> delegateBuilder_;
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       * @return Whether the delegate field is set.
       */
      public boolean hasDelegate() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       * @return The delegate.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate getDelegate() {
        if (delegateBuilder_ == null) {
          return delegate_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance() : delegate_;
        } else {
          return delegateBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      public Builder setDelegate(istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate value) {
        if (delegateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          delegate_ = value;
        } else {
          delegateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      public Builder setDelegate(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder builderForValue) {
        if (delegateBuilder_ == null) {
          delegate_ = builderForValue.build();
        } else {
          delegateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      public Builder mergeDelegate(istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate value) {
        if (delegateBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
            delegate_ != null &&
            delegate_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance()) {
            getDelegateBuilder().mergeFrom(value);
          } else {
            delegate_ = value;
          }
        } else {
          delegateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      public Builder clearDelegate() {
        bitField0_ = (bitField0_ & ~0x00000010);
        delegate_ = null;
        if (delegateBuilder_ != null) {
          delegateBuilder_.dispose();
          delegateBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder getDelegateBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getDelegateFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder getDelegateOrBuilder() {
        if (delegateBuilder_ != null) {
          return delegateBuilder_.getMessageOrBuilder();
        } else {
          return delegate_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance() : delegate_;
        }
      }
      /**
       * <pre>
       * Delegate is used to specify the particular VirtualService which
       * can be used to define delegate HTTPRoute.
       * It can be set only when `Route` and `Redirect` are empty, and the route rules of the
       * delegate VirtualService will be merged with that in the current one.
       * **NOTE**:
       *    1. Only one level delegation is supported.
       *    2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
       *       otherwise there is a conflict and the HTTPRoute will not take effect.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Delegate delegate = 20;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate, istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder> 
          getDelegateFieldBuilder() {
        if (delegateBuilder_ == null) {
          delegateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate, istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder>(
                  getDelegate(),
                  getParentForChildren(),
                  isClean());
          delegate_ = null;
        }
        return delegateBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite rewrite_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewriteOrBuilder> rewriteBuilder_;
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       * @return Whether the rewrite field is set.
       */
      public boolean hasRewrite() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       * @return The rewrite.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite getRewrite() {
        if (rewriteBuilder_ == null) {
          return rewrite_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.getDefaultInstance() : rewrite_;
        } else {
          return rewriteBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      public Builder setRewrite(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite value) {
        if (rewriteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rewrite_ = value;
        } else {
          rewriteBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      public Builder setRewrite(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.Builder builderForValue) {
        if (rewriteBuilder_ == null) {
          rewrite_ = builderForValue.build();
        } else {
          rewriteBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      public Builder mergeRewrite(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite value) {
        if (rewriteBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0) &&
            rewrite_ != null &&
            rewrite_ != istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.getDefaultInstance()) {
            getRewriteBuilder().mergeFrom(value);
          } else {
            rewrite_ = value;
          }
        } else {
          rewriteBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      public Builder clearRewrite() {
        bitField0_ = (bitField0_ & ~0x00000020);
        rewrite_ = null;
        if (rewriteBuilder_ != null) {
          rewriteBuilder_.dispose();
          rewriteBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.Builder getRewriteBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getRewriteFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewriteOrBuilder getRewriteOrBuilder() {
        if (rewriteBuilder_ != null) {
          return rewriteBuilder_.getMessageOrBuilder();
        } else {
          return rewrite_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.getDefaultInstance() : rewrite_;
        }
      }
      /**
       * <pre>
       * Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
       * Redirect primitive. Rewrite will be performed before forwarding.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRewrite rewrite = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewriteOrBuilder> 
          getRewriteFieldBuilder() {
        if (rewriteBuilder_ == null) {
          rewriteBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewrite.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRewriteOrBuilder>(
                  getRewrite(),
                  getParentForChildren(),
                  isClean());
          rewrite_ = null;
        }
        return rewriteBuilder_;
      }

      private com.google.protobuf.Duration timeout_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> timeoutBuilder_;
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       * @return Whether the timeout field is set.
       */
      public boolean hasTimeout() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       * @return The timeout.
       */
      public com.google.protobuf.Duration getTimeout() {
        if (timeoutBuilder_ == null) {
          return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
        } else {
          return timeoutBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      public Builder setTimeout(com.google.protobuf.Duration value) {
        if (timeoutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeout_ = value;
        } else {
          timeoutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      public Builder setTimeout(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (timeoutBuilder_ == null) {
          timeout_ = builderForValue.build();
        } else {
          timeoutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      public Builder mergeTimeout(com.google.protobuf.Duration value) {
        if (timeoutBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0) &&
            timeout_ != null &&
            timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getTimeoutBuilder().mergeFrom(value);
          } else {
            timeout_ = value;
          }
        } else {
          timeoutBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      public Builder clearTimeout() {
        bitField0_ = (bitField0_ & ~0x00000040);
        timeout_ = null;
        if (timeoutBuilder_ != null) {
          timeoutBuilder_.dispose();
          timeoutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getTimeoutFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
        if (timeoutBuilder_ != null) {
          return timeoutBuilder_.getMessageOrBuilder();
        } else {
          return timeout_ == null ?
              com.google.protobuf.Duration.getDefaultInstance() : timeout_;
        }
      }
      /**
       * <pre>
       * Timeout for HTTP requests, default is disabled.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder> 
          getTimeoutFieldBuilder() {
        if (timeoutBuilder_ == null) {
          timeoutBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration, com.google.protobuf.Duration.Builder, com.google.protobuf.DurationOrBuilder>(
                  getTimeout(),
                  getParentForChildren(),
                  isClean());
          timeout_ = null;
        }
        return timeoutBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry retries_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetryOrBuilder> retriesBuilder_;
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       * @return Whether the retries field is set.
       */
      public boolean hasRetries() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       * @return The retries.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry getRetries() {
        if (retriesBuilder_ == null) {
          return retries_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.getDefaultInstance() : retries_;
        } else {
          return retriesBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      public Builder setRetries(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry value) {
        if (retriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retries_ = value;
        } else {
          retriesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      public Builder setRetries(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.Builder builderForValue) {
        if (retriesBuilder_ == null) {
          retries_ = builderForValue.build();
        } else {
          retriesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      public Builder mergeRetries(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry value) {
        if (retriesBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0) &&
            retries_ != null &&
            retries_ != istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.getDefaultInstance()) {
            getRetriesBuilder().mergeFrom(value);
          } else {
            retries_ = value;
          }
        } else {
          retriesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      public Builder clearRetries() {
        bitField0_ = (bitField0_ & ~0x00000080);
        retries_ = null;
        if (retriesBuilder_ != null) {
          retriesBuilder_.dispose();
          retriesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.Builder getRetriesBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getRetriesFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetryOrBuilder getRetriesOrBuilder() {
        if (retriesBuilder_ != null) {
          return retriesBuilder_.getMessageOrBuilder();
        } else {
          return retries_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.getDefaultInstance() : retries_;
        }
      }
      /**
       * <pre>
       * Retry policy for HTTP requests.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPRetry retries = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetryOrBuilder> 
          getRetriesFieldBuilder() {
        if (retriesBuilder_ == null) {
          retriesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetry.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRetryOrBuilder>(
                  getRetries(),
                  getParentForChildren(),
                  isClean());
          retries_ = null;
        }
        return retriesBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection fault_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjectionOrBuilder> faultBuilder_;
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       * @return Whether the fault field is set.
       */
      public boolean hasFault() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       * @return The fault.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection getFault() {
        if (faultBuilder_ == null) {
          return fault_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.getDefaultInstance() : fault_;
        } else {
          return faultBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      public Builder setFault(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection value) {
        if (faultBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fault_ = value;
        } else {
          faultBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      public Builder setFault(
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.Builder builderForValue) {
        if (faultBuilder_ == null) {
          fault_ = builderForValue.build();
        } else {
          faultBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      public Builder mergeFault(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection value) {
        if (faultBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0) &&
            fault_ != null &&
            fault_ != istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.getDefaultInstance()) {
            getFaultBuilder().mergeFrom(value);
          } else {
            fault_ = value;
          }
        } else {
          faultBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      public Builder clearFault() {
        bitField0_ = (bitField0_ & ~0x00000100);
        fault_ = null;
        if (faultBuilder_ != null) {
          faultBuilder_.dispose();
          faultBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.Builder getFaultBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getFaultFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjectionOrBuilder getFaultOrBuilder() {
        if (faultBuilder_ != null) {
          return faultBuilder_.getMessageOrBuilder();
        } else {
          return fault_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.getDefaultInstance() : fault_;
        }
      }
      /**
       * <pre>
       * Fault injection policy to apply on HTTP traffic at the client side.
       * Note that timeouts or retries will not be enabled when faults are
       * enabled on the client side.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.HTTPFaultInjection fault = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjectionOrBuilder> 
          getFaultFieldBuilder() {
        if (faultBuilder_ == null) {
          faultBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjection.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPFaultInjectionOrBuilder>(
                  getFault(),
                  getParentForChildren(),
                  isClean());
          fault_ = null;
        }
        return faultBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Destination mirror_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder> mirrorBuilder_;
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       * @return Whether the mirror field is set.
       */
      public boolean hasMirror() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       * @return The mirror.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getMirror() {
        if (mirrorBuilder_ == null) {
          return mirror_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : mirror_;
        } else {
          return mirrorBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      public Builder setMirror(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination value) {
        if (mirrorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mirror_ = value;
        } else {
          mirrorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      public Builder setMirror(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder builderForValue) {
        if (mirrorBuilder_ == null) {
          mirror_ = builderForValue.build();
        } else {
          mirrorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      public Builder mergeMirror(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination value) {
        if (mirrorBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0) &&
            mirror_ != null &&
            mirror_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance()) {
            getMirrorBuilder().mergeFrom(value);
          } else {
            mirror_ = value;
          }
        } else {
          mirrorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      public Builder clearMirror() {
        bitField0_ = (bitField0_ & ~0x00000200);
        mirror_ = null;
        if (mirrorBuilder_ != null) {
          mirrorBuilder_.dispose();
          mirrorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder getMirrorBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getMirrorFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getMirrorOrBuilder() {
        if (mirrorBuilder_ != null) {
          return mirrorBuilder_.getMessageOrBuilder();
        } else {
          return mirror_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : mirror_;
        }
      }
      /**
       * <pre>
       * Mirror HTTP traffic to a another destination in addition to forwarding
       * the requests to the intended destination. Mirrored traffic is on a
       * best effort basis where the sidecar/gateway will not wait for the
       * mirrored cluster to respond before returning the response from the
       * original destination.  Statistics will be generated for the mirrored
       * destination.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination mirror = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder> 
          getMirrorFieldBuilder() {
        if (mirrorBuilder_ == null) {
          mirrorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder>(
                  getMirror(),
                  getParentForChildren(),
                  isClean());
          mirror_ = null;
        }
        return mirrorBuilder_;
      }

      private com.google.protobuf.UInt32Value mirrorPercent_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> mirrorPercentBuilder_;
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       * @deprecated istio.networking.v1alpha3.HTTPRoute.mirror_percent is deprecated.
       *     See networking/v1alpha3/virtual_service.proto;l=627
       * @return Whether the mirrorPercent field is set.
       */
      @java.lang.Deprecated public boolean hasMirrorPercent() {
        return ((bitField0_ & 0x00000400) != 0);
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       * @deprecated istio.networking.v1alpha3.HTTPRoute.mirror_percent is deprecated.
       *     See networking/v1alpha3/virtual_service.proto;l=627
       * @return The mirrorPercent.
       */
      @java.lang.Deprecated public com.google.protobuf.UInt32Value getMirrorPercent() {
        if (mirrorPercentBuilder_ == null) {
          return mirrorPercent_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : mirrorPercent_;
        } else {
          return mirrorPercentBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setMirrorPercent(com.google.protobuf.UInt32Value value) {
        if (mirrorPercentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mirrorPercent_ = value;
        } else {
          mirrorPercentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setMirrorPercent(
          com.google.protobuf.UInt32Value.Builder builderForValue) {
        if (mirrorPercentBuilder_ == null) {
          mirrorPercent_ = builderForValue.build();
        } else {
          mirrorPercentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder mergeMirrorPercent(com.google.protobuf.UInt32Value value) {
        if (mirrorPercentBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0) &&
            mirrorPercent_ != null &&
            mirrorPercent_ != com.google.protobuf.UInt32Value.getDefaultInstance()) {
            getMirrorPercentBuilder().mergeFrom(value);
          } else {
            mirrorPercent_ = value;
          }
        } else {
          mirrorPercentBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder clearMirrorPercent() {
        bitField0_ = (bitField0_ & ~0x00000400);
        mirrorPercent_ = null;
        if (mirrorPercentBuilder_ != null) {
          mirrorPercentBuilder_.dispose();
          mirrorPercentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      @java.lang.Deprecated public com.google.protobuf.UInt32Value.Builder getMirrorPercentBuilder() {
        bitField0_ |= 0x00000400;
        onChanged();
        return getMirrorPercentFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      @java.lang.Deprecated public com.google.protobuf.UInt32ValueOrBuilder getMirrorPercentOrBuilder() {
        if (mirrorPercentBuilder_ != null) {
          return mirrorPercentBuilder_.getMessageOrBuilder();
        } else {
          return mirrorPercent_ == null ?
              com.google.protobuf.UInt32Value.getDefaultInstance() : mirrorPercent_;
        }
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * Use of integer `mirror_percent` value is deprecated. Use the
       * double `mirror_percentage` field instead
       * </pre>
       *
       * <code>.google.protobuf.UInt32Value mirror_percent = 18 [deprecated = true];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> 
          getMirrorPercentFieldBuilder() {
        if (mirrorPercentBuilder_ == null) {
          mirrorPercentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder>(
                  getMirrorPercent(),
                  getParentForChildren(),
                  isClean());
          mirrorPercent_ = null;
        }
        return mirrorPercentBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Percent mirrorPercentage_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Percent, istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.PercentOrBuilder> mirrorPercentageBuilder_;
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       * @return Whether the mirrorPercentage field is set.
       */
      public boolean hasMirrorPercentage() {
        return ((bitField0_ & 0x00000800) != 0);
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       * @return The mirrorPercentage.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Percent getMirrorPercentage() {
        if (mirrorPercentageBuilder_ == null) {
          return mirrorPercentage_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.getDefaultInstance() : mirrorPercentage_;
        } else {
          return mirrorPercentageBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      public Builder setMirrorPercentage(istio.networking.v1alpha3.VirtualServiceOuterClass.Percent value) {
        if (mirrorPercentageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mirrorPercentage_ = value;
        } else {
          mirrorPercentageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      public Builder setMirrorPercentage(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.Builder builderForValue) {
        if (mirrorPercentageBuilder_ == null) {
          mirrorPercentage_ = builderForValue.build();
        } else {
          mirrorPercentageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      public Builder mergeMirrorPercentage(istio.networking.v1alpha3.VirtualServiceOuterClass.Percent value) {
        if (mirrorPercentageBuilder_ == null) {
          if (((bitField0_ & 0x00000800) != 0) &&
            mirrorPercentage_ != null &&
            mirrorPercentage_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.getDefaultInstance()) {
            getMirrorPercentageBuilder().mergeFrom(value);
          } else {
            mirrorPercentage_ = value;
          }
        } else {
          mirrorPercentageBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      public Builder clearMirrorPercentage() {
        bitField0_ = (bitField0_ & ~0x00000800);
        mirrorPercentage_ = null;
        if (mirrorPercentageBuilder_ != null) {
          mirrorPercentageBuilder_.dispose();
          mirrorPercentageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.Builder getMirrorPercentageBuilder() {
        bitField0_ |= 0x00000800;
        onChanged();
        return getMirrorPercentageFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.PercentOrBuilder getMirrorPercentageOrBuilder() {
        if (mirrorPercentageBuilder_ != null) {
          return mirrorPercentageBuilder_.getMessageOrBuilder();
        } else {
          return mirrorPercentage_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.getDefaultInstance() : mirrorPercentage_;
        }
      }
      /**
       * <pre>
       * Percentage of the traffic to be mirrored by the `mirror` field.
       * If this field is absent, all the traffic (100%) will be mirrored.
       * Max value is 100.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Percent mirror_percentage = 19;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Percent, istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.PercentOrBuilder> 
          getMirrorPercentageFieldBuilder() {
        if (mirrorPercentageBuilder_ == null) {
          mirrorPercentageBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Percent, istio.networking.v1alpha3.VirtualServiceOuterClass.Percent.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.PercentOrBuilder>(
                  getMirrorPercentage(),
                  getParentForChildren(),
                  isClean());
          mirrorPercentage_ = null;
        }
        return mirrorPercentageBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy corsPolicy_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy, istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicyOrBuilder> corsPolicyBuilder_;
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       * @return Whether the corsPolicy field is set.
       */
      public boolean hasCorsPolicy() {
        return ((bitField0_ & 0x00001000) != 0);
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       * @return The corsPolicy.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy getCorsPolicy() {
        if (corsPolicyBuilder_ == null) {
          return corsPolicy_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.getDefaultInstance() : corsPolicy_;
        } else {
          return corsPolicyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      public Builder setCorsPolicy(istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy value) {
        if (corsPolicyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          corsPolicy_ = value;
        } else {
          corsPolicyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      public Builder setCorsPolicy(
          istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.Builder builderForValue) {
        if (corsPolicyBuilder_ == null) {
          corsPolicy_ = builderForValue.build();
        } else {
          corsPolicyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      public Builder mergeCorsPolicy(istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy value) {
        if (corsPolicyBuilder_ == null) {
          if (((bitField0_ & 0x00001000) != 0) &&
            corsPolicy_ != null &&
            corsPolicy_ != istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.getDefaultInstance()) {
            getCorsPolicyBuilder().mergeFrom(value);
          } else {
            corsPolicy_ = value;
          }
        } else {
          corsPolicyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      public Builder clearCorsPolicy() {
        bitField0_ = (bitField0_ & ~0x00001000);
        corsPolicy_ = null;
        if (corsPolicyBuilder_ != null) {
          corsPolicyBuilder_.dispose();
          corsPolicyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.Builder getCorsPolicyBuilder() {
        bitField0_ |= 0x00001000;
        onChanged();
        return getCorsPolicyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicyOrBuilder getCorsPolicyOrBuilder() {
        if (corsPolicyBuilder_ != null) {
          return corsPolicyBuilder_.getMessageOrBuilder();
        } else {
          return corsPolicy_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.getDefaultInstance() : corsPolicy_;
        }
      }
      /**
       * <pre>
       * Cross-Origin Resource Sharing policy (CORS). Refer to
       * [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
       * for further details about cross origin resource sharing.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.CorsPolicy cors_policy = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy, istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicyOrBuilder> 
          getCorsPolicyFieldBuilder() {
        if (corsPolicyBuilder_ == null) {
          corsPolicyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy, istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicy.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.CorsPolicyOrBuilder>(
                  getCorsPolicy(),
                  getParentForChildren(),
                  isClean());
          corsPolicy_ = null;
        }
        return corsPolicyBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers headers_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder> headersBuilder_;
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       * @return Whether the headers field is set.
       */
      public boolean hasHeaders() {
        return ((bitField0_ & 0x00002000) != 0);
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       * @return The headers.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getHeaders() {
        if (headersBuilder_ == null) {
          return headers_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
        } else {
          return headersBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      public Builder setHeaders(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          headers_ = value;
        } else {
          headersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      public Builder setHeaders(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder builderForValue) {
        if (headersBuilder_ == null) {
          headers_ = builderForValue.build();
        } else {
          headersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      public Builder mergeHeaders(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers value) {
        if (headersBuilder_ == null) {
          if (((bitField0_ & 0x00002000) != 0) &&
            headers_ != null &&
            headers_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance()) {
            getHeadersBuilder().mergeFrom(value);
          } else {
            headers_ = value;
          }
        } else {
          headersBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00002000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      public Builder clearHeaders() {
        bitField0_ = (bitField0_ & ~0x00002000);
        headers_ = null;
        if (headersBuilder_ != null) {
          headersBuilder_.dispose();
          headersBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder getHeadersBuilder() {
        bitField0_ |= 0x00002000;
        onChanged();
        return getHeadersFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder getHeadersOrBuilder() {
        if (headersBuilder_ != null) {
          return headersBuilder_.getMessageOrBuilder();
        } else {
          return headers_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
        }
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 16;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder> 
          getHeadersFieldBuilder() {
        if (headersBuilder_ == null) {
          headersBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder>(
                  getHeaders(),
                  getParentForChildren(),
                  isClean());
          headers_ = null;
        }
        return headersBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.HTTPRoute)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.HTTPRoute)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HTTPRoute>
        PARSER = new com.google.protobuf.AbstractParser<HTTPRoute>() {
      @java.lang.Override
      public HTTPRoute parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<HTTPRoute> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HTTPRoute> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRoute getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DelegateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.Delegate)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Name specifies the name of the delegate VirtualService.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * Name specifies the name of the delegate VirtualService.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * Namespace specifies the namespace where the delegate VirtualService resides.
     * By default, it is same to the root's.
     * </pre>
     *
     * <code>string namespace = 2;</code>
     * @return The namespace.
     */
    java.lang.String getNamespace();
    /**
     * <pre>
     * Namespace specifies the namespace where the delegate VirtualService resides.
     * By default, it is same to the root's.
     * </pre>
     *
     * <code>string namespace = 2;</code>
     * @return The bytes for namespace.
     */
    com.google.protobuf.ByteString
        getNamespaceBytes();
  }
  /**
   * <pre>
   * Describes the delegate VirtualService.
   * The following routing rules forward the traffic to `/productpage` by a delegate VirtualService named `productpage`,
   * forward the traffic to `/reviews` by a delegate VirtualService named `reviews`.
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: bookinfo
   * spec:
   *   hosts:
   *   - "bookinfo.com"
   *   gateways:
   *   - mygateway
   *   http:
   *   - match:
   *     - uri:
   *         prefix: "/productpage"
   *     delegate:
   *        name: productpage
   *        namespace: nsA
   *   - match:
   *     - uri:
   *         prefix: "/reviews"
   *     delegate:
   *         name: reviews
   *         namespace: nsB
   * ```
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: productpage
   *   namespace: nsA
   * spec:
   *   http:
   *   - match:
   *      - uri:
   *         prefix: "/productpage/v1/"
   *     route:
   *     - destination:
   *         host: productpage-v1.nsA.svc.cluster.local
   *   - route:
   *     - destination:
   *         host: productpage.nsA.svc.cluster.local
   * ```
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: reviews
   *   namespace: nsB
   * spec:
   *   http:
   *   - route:
   *     - destination:
   *         host: reviews.nsB.svc.cluster.local
   * ```
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.Delegate}
   */
  public static final class Delegate extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.Delegate)
      DelegateOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Delegate.newBuilder() to construct.
    private Delegate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Delegate() {
      name_ = "";
      namespace_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Delegate();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Delegate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Delegate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * Name specifies the name of the delegate VirtualService.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Name specifies the name of the delegate VirtualService.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAMESPACE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object namespace_ = "";
    /**
     * <pre>
     * Namespace specifies the namespace where the delegate VirtualService resides.
     * By default, it is same to the root's.
     * </pre>
     *
     * <code>string namespace = 2;</code>
     * @return The namespace.
     */
    @java.lang.Override
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespace_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Namespace specifies the namespace where the delegate VirtualService resides.
     * By default, it is same to the root's.
     * </pre>
     *
     * <code>string namespace = 2;</code>
     * @return The bytes for namespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, namespace_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, namespace_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate other = (istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (!getNamespace()
          .equals(other.getNamespace())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getNamespace().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describes the delegate VirtualService.
     * The following routing rules forward the traffic to `/productpage` by a delegate VirtualService named `productpage`,
     * forward the traffic to `/reviews` by a delegate VirtualService named `reviews`.
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: bookinfo
     * spec:
     *   hosts:
     *   - "bookinfo.com"
     *   gateways:
     *   - mygateway
     *   http:
     *   - match:
     *     - uri:
     *         prefix: "/productpage"
     *     delegate:
     *        name: productpage
     *        namespace: nsA
     *   - match:
     *     - uri:
     *         prefix: "/reviews"
     *     delegate:
     *         name: reviews
     *         namespace: nsB
     * ```
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: productpage
     *   namespace: nsA
     * spec:
     *   http:
     *   - match:
     *      - uri:
     *         prefix: "/productpage/v1/"
     *     route:
     *     - destination:
     *         host: productpage-v1.nsA.svc.cluster.local
     *   - route:
     *     - destination:
     *         host: productpage.nsA.svc.cluster.local
     * ```
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: reviews
     *   namespace: nsB
     * spec:
     *   http:
     *   - route:
     *     - destination:
     *         host: reviews.nsB.svc.cluster.local
     * ```
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.Delegate}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.Delegate)
        istio.networking.v1alpha3.VirtualServiceOuterClass.DelegateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Delegate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Delegate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        namespace_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Delegate_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate result = new istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.namespace_ = namespace_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getNamespace().isEmpty()) {
          namespace_ = other.namespace_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                namespace_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Name specifies the name of the delegate VirtualService.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Name specifies the name of the delegate VirtualService.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Name specifies the name of the delegate VirtualService.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name specifies the name of the delegate VirtualService.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name specifies the name of the delegate VirtualService.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object namespace_ = "";
      /**
       * <pre>
       * Namespace specifies the namespace where the delegate VirtualService resides.
       * By default, it is same to the root's.
       * </pre>
       *
       * <code>string namespace = 2;</code>
       * @return The namespace.
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          namespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Namespace specifies the namespace where the delegate VirtualService resides.
       * By default, it is same to the root's.
       * </pre>
       *
       * <code>string namespace = 2;</code>
       * @return The bytes for namespace.
       */
      public com.google.protobuf.ByteString
          getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Namespace specifies the namespace where the delegate VirtualService resides.
       * By default, it is same to the root's.
       * </pre>
       *
       * <code>string namespace = 2;</code>
       * @param value The namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespace(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        namespace_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Namespace specifies the namespace where the delegate VirtualService resides.
       * By default, it is same to the root's.
       * </pre>
       *
       * <code>string namespace = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearNamespace() {
        namespace_ = getDefaultInstance().getNamespace();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Namespace specifies the namespace where the delegate VirtualService resides.
       * By default, it is same to the root's.
       * </pre>
       *
       * <code>string namespace = 2;</code>
       * @param value The bytes for namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespaceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        namespace_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.Delegate)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.Delegate)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Delegate>
        PARSER = new com.google.protobuf.AbstractParser<Delegate>() {
      @java.lang.Override
      public Delegate parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Delegate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Delegate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Delegate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface HeadersOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.Headers)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Header manipulation rules to apply before forwarding a request
     * to the destination service
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
     * @return Whether the request field is set.
     */
    boolean hasRequest();
    /**
     * <pre>
     * Header manipulation rules to apply before forwarding a request
     * to the destination service
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
     * @return The request.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getRequest();
    /**
     * <pre>
     * Header manipulation rules to apply before forwarding a request
     * to the destination service
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder getRequestOrBuilder();

    /**
     * <pre>
     * Header manipulation rules to apply before returning a response
     * to the caller
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
     * @return Whether the response field is set.
     */
    boolean hasResponse();
    /**
     * <pre>
     * Header manipulation rules to apply before returning a response
     * to the caller
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
     * @return The response.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getResponse();
    /**
     * <pre>
     * Header manipulation rules to apply before returning a response
     * to the caller
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder getResponseOrBuilder();
  }
  /**
   * <pre>
   * Message headers can be manipulated when Envoy forwards requests to,
   * or responses from, a destination service. Header manipulation rules can
   * be specified for a specific route destination or for all destinations.
   * The following VirtualService adds a `test` header with the value `true`
   * to requests that are routed to any `reviews` service destination.
   * It also removes the `foo` response header, but only from responses
   * coming from the `v1` subset (version) of the `reviews` service.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: reviews-route
   * spec:
   *   hosts:
   *   - reviews.prod.svc.cluster.local
   *   http:
   *   - headers:
   *       request:
   *         set:
   *           test: true
   *     route:
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v2
   *       weight: 25
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v1
   *       headers:
   *         response:
   *           remove:
   *           - foo
   *       weight: 75
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: reviews-route
   * spec:
   *   hosts:
   *   - reviews.prod.svc.cluster.local
   *   http:
   *   - headers:
   *       request:
   *         set:
   *           test: true
   *     route:
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v2
   *       weight: 25
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v1
   *       headers:
   *         response:
   *           remove:
   *           - foo
   *       weight: 75
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.Headers}
   */
  public static final class Headers extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.Headers)
      HeadersOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Headers.newBuilder() to construct.
    private Headers(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Headers() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Headers();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder.class);
    }

    public interface HeaderOperationsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.Headers.HeaderOperations)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      int getSetCount();
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      boolean containsSet(
          java.lang.String key);
      /**
       * Use {@link #getSetMap()} instead.
       */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String>
      getSet();
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      java.util.Map<java.lang.String, java.lang.String>
      getSetMap();
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      /* nullable */
java.lang.String getSetOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue);
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      java.lang.String getSetOrThrow(
          java.lang.String key);

      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      int getAddCount();
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      boolean containsAdd(
          java.lang.String key);
      /**
       * Use {@link #getAddMap()} instead.
       */
      @java.lang.Deprecated
      java.util.Map<java.lang.String, java.lang.String>
      getAdd();
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      java.util.Map<java.lang.String, java.lang.String>
      getAddMap();
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      /* nullable */
java.lang.String getAddOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue);
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      java.lang.String getAddOrThrow(
          java.lang.String key);

      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @return A list containing the remove.
       */
      java.util.List<java.lang.String>
          getRemoveList();
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @return The count of remove.
       */
      int getRemoveCount();
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @param index The index of the element to return.
       * @return The remove at the given index.
       */
      java.lang.String getRemove(int index);
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @param index The index of the value to return.
       * @return The bytes of the remove at the given index.
       */
      com.google.protobuf.ByteString
          getRemoveBytes(int index);
    }
    /**
     * <pre>
     * HeaderOperations Describes the header manipulations to apply
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.Headers.HeaderOperations}
     */
    public static final class HeaderOperations extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.Headers.HeaderOperations)
        HeaderOperationsOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use HeaderOperations.newBuilder() to construct.
      private HeaderOperations(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private HeaderOperations() {
        remove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new HeaderOperations();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      @java.lang.Override
      protected com.google.protobuf.MapField internalGetMapField(
          int number) {
        switch (number) {
          case 1:
            return internalGetSet();
          case 2:
            return internalGetAdd();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder.class);
      }

      public static final int SET_FIELD_NUMBER = 1;
      private static final class SetDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<
            java.lang.String, java.lang.String> defaultEntry =
                com.google.protobuf.MapEntry
                .<java.lang.String, java.lang.String>newDefaultInstance(
                    istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_SetEntry_descriptor, 
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "");
      }
      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<
          java.lang.String, java.lang.String> set_;
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSet() {
        if (set_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              SetDefaultEntryHolder.defaultEntry);
        }
        return set_;
      }
      public int getSetCount() {
        return internalGetSet().getMap().size();
      }
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      @java.lang.Override
      public boolean containsSet(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetSet().getMap().containsKey(key);
      }
      /**
       * Use {@link #getSetMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getSet() {
        return getSetMap();
      }
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getSetMap() {
        return internalGetSet().getMap();
      }
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      @java.lang.Override
      public /* nullable */
java.lang.String getSetOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetSet().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * Overwrite the headers specified by key with the given values
       * </pre>
       *
       * <code>map&lt;string, string&gt; set = 1;</code>
       */
      @java.lang.Override
      public java.lang.String getSetOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetSet().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public static final int ADD_FIELD_NUMBER = 2;
      private static final class AddDefaultEntryHolder {
        static final com.google.protobuf.MapEntry<
            java.lang.String, java.lang.String> defaultEntry =
                com.google.protobuf.MapEntry
                .<java.lang.String, java.lang.String>newDefaultInstance(
                    istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_AddEntry_descriptor, 
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "");
      }
      @SuppressWarnings("serial")
      private com.google.protobuf.MapField<
          java.lang.String, java.lang.String> add_;
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAdd() {
        if (add_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              AddDefaultEntryHolder.defaultEntry);
        }
        return add_;
      }
      public int getAddCount() {
        return internalGetAdd().getMap().size();
      }
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      @java.lang.Override
      public boolean containsAdd(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetAdd().getMap().containsKey(key);
      }
      /**
       * Use {@link #getAddMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getAdd() {
        return getAddMap();
      }
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getAddMap() {
        return internalGetAdd().getMap();
      }
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      @java.lang.Override
      public /* nullable */
java.lang.String getAddOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetAdd().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * Append the given values to the headers specified by keys
       * (will create a comma-separated list of values)
       * </pre>
       *
       * <code>map&lt;string, string&gt; add = 2;</code>
       */
      @java.lang.Override
      public java.lang.String getAddOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetAdd().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public static final int REMOVE_FIELD_NUMBER = 3;
      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringList remove_;
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @return A list containing the remove.
       */
      public com.google.protobuf.ProtocolStringList
          getRemoveList() {
        return remove_;
      }
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @return The count of remove.
       */
      public int getRemoveCount() {
        return remove_.size();
      }
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @param index The index of the element to return.
       * @return The remove at the given index.
       */
      public java.lang.String getRemove(int index) {
        return remove_.get(index);
      }
      /**
       * <pre>
       * Remove a the specified headers
       * </pre>
       *
       * <code>repeated string remove = 3;</code>
       * @param index The index of the value to return.
       * @return The bytes of the remove at the given index.
       */
      public com.google.protobuf.ByteString
          getRemoveBytes(int index) {
        return remove_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3
          .serializeStringMapTo(
            output,
            internalGetSet(),
            SetDefaultEntryHolder.defaultEntry,
            1);
        com.google.protobuf.GeneratedMessageV3
          .serializeStringMapTo(
            output,
            internalGetAdd(),
            AddDefaultEntryHolder.defaultEntry,
            2);
        for (int i = 0; i < remove_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, remove_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
             : internalGetSet().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
          set__ = SetDefaultEntryHolder.defaultEntry.newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
          size += com.google.protobuf.CodedOutputStream
              .computeMessageSize(1, set__);
        }
        for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
             : internalGetAdd().getMap().entrySet()) {
          com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
          add__ = AddDefaultEntryHolder.defaultEntry.newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
          size += com.google.protobuf.CodedOutputStream
              .computeMessageSize(2, add__);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < remove_.size(); i++) {
            dataSize += computeStringSizeNoTag(remove_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getRemoveList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations)) {
          return super.equals(obj);
        }
        istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations other = (istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations) obj;

        if (!internalGetSet().equals(
            other.internalGetSet())) return false;
        if (!internalGetAdd().equals(
            other.internalGetAdd())) return false;
        if (!getRemoveList()
            .equals(other.getRemoveList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (!internalGetSet().getMap().isEmpty()) {
          hash = (37 * hash) + SET_FIELD_NUMBER;
          hash = (53 * hash) + internalGetSet().hashCode();
        }
        if (!internalGetAdd().getMap().isEmpty()) {
          hash = (37 * hash) + ADD_FIELD_NUMBER;
          hash = (53 * hash) + internalGetAdd().hashCode();
        }
        if (getRemoveCount() > 0) {
          hash = (37 * hash) + REMOVE_FIELD_NUMBER;
          hash = (53 * hash) + getRemoveList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * HeaderOperations Describes the header manipulations to apply
       * </pre>
       *
       * Protobuf type {@code istio.networking.v1alpha3.Headers.HeaderOperations}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.Headers.HeaderOperations)
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_descriptor;
        }

        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMapField(
            int number) {
          switch (number) {
            case 1:
              return internalGetSet();
            case 2:
              return internalGetAdd();
            default:
              throw new RuntimeException(
                  "Invalid map field number: " + number);
          }
        }
        @SuppressWarnings({"rawtypes"})
        protected com.google.protobuf.MapField internalGetMutableMapField(
            int number) {
          switch (number) {
            case 1:
              return internalGetMutableSet();
            case 2:
              return internalGetMutableAdd();
            default:
              throw new RuntimeException(
                  "Invalid map field number: " + number);
          }
        }
        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder.class);
        }

        // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.newBuilder()
        private Builder() {

        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);

        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          internalGetMutableSet().clear();
          internalGetMutableAdd().clear();
          remove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_HeaderOperations_descriptor;
        }

        @java.lang.Override
        public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getDefaultInstanceForType() {
          return istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance();
        }

        @java.lang.Override
        public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations build() {
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations buildPartial() {
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations result = new istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations result) {
          if (((bitField0_ & 0x00000004) != 0)) {
            remove_ = remove_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.remove_ = remove_;
        }

        private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.set_ = internalGetSet();
            result.set_.makeImmutable();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.add_ = internalGetAdd();
            result.add_.makeImmutable();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations) {
            return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations other) {
          if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance()) return this;
          internalGetMutableSet().mergeFrom(
              other.internalGetSet());
          bitField0_ |= 0x00000001;
          internalGetMutableAdd().mergeFrom(
              other.internalGetAdd());
          bitField0_ |= 0x00000002;
          if (!other.remove_.isEmpty()) {
            if (remove_.isEmpty()) {
              remove_ = other.remove_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureRemoveIsMutable();
              remove_.addAll(other.remove_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                  set__ = input.readMessage(
                      SetDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                  internalGetMutableSet().getMutableMap().put(
                      set__.getKey(), set__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                  add__ = input.readMessage(
                      AddDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                  internalGetMutableAdd().getMutableMap().put(
                      add__.getKey(), add__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 26: {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureRemoveIsMutable();
                  remove_.add(s);
                  break;
                } // case 26
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private com.google.protobuf.MapField<
            java.lang.String, java.lang.String> set_;
        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetSet() {
          if (set_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                SetDefaultEntryHolder.defaultEntry);
          }
          return set_;
        }
        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableSet() {
          if (set_ == null) {
            set_ = com.google.protobuf.MapField.newMapField(
                SetDefaultEntryHolder.defaultEntry);
          }
          if (!set_.isMutable()) {
            set_ = set_.copy();
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return set_;
        }
        public int getSetCount() {
          return internalGetSet().getMap().size();
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        @java.lang.Override
        public boolean containsSet(
            java.lang.String key) {
          if (key == null) { throw new NullPointerException("map key"); }
          return internalGetSet().getMap().containsKey(key);
        }
        /**
         * Use {@link #getSetMap()} instead.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getSet() {
          return getSetMap();
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getSetMap() {
          return internalGetSet().getMap();
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        @java.lang.Override
        public /* nullable */
java.lang.String getSetOrDefault(
            java.lang.String key,
            /* nullable */
java.lang.String defaultValue) {
          if (key == null) { throw new NullPointerException("map key"); }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetSet().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        @java.lang.Override
        public java.lang.String getSetOrThrow(
            java.lang.String key) {
          if (key == null) { throw new NullPointerException("map key"); }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetSet().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }
        public Builder clearSet() {
          bitField0_ = (bitField0_ & ~0x00000001);
          internalGetMutableSet().getMutableMap()
              .clear();
          return this;
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        public Builder removeSet(
            java.lang.String key) {
          if (key == null) { throw new NullPointerException("map key"); }
          internalGetMutableSet().getMutableMap()
              .remove(key);
          return this;
        }
        /**
         * Use alternate mutation accessors instead.
         */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String>
            getMutableSet() {
          bitField0_ |= 0x00000001;
          return internalGetMutableSet().getMutableMap();
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        public Builder putSet(
            java.lang.String key,
            java.lang.String value) {
          if (key == null) { throw new NullPointerException("map key"); }
          if (value == null) { throw new NullPointerException("map value"); }
          internalGetMutableSet().getMutableMap()
              .put(key, value);
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Overwrite the headers specified by key with the given values
         * </pre>
         *
         * <code>map&lt;string, string&gt; set = 1;</code>
         */
        public Builder putAllSet(
            java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableSet().getMutableMap()
              .putAll(values);
          bitField0_ |= 0x00000001;
          return this;
        }

        private com.google.protobuf.MapField<
            java.lang.String, java.lang.String> add_;
        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetAdd() {
          if (add_ == null) {
            return com.google.protobuf.MapField.emptyMapField(
                AddDefaultEntryHolder.defaultEntry);
          }
          return add_;
        }
        private com.google.protobuf.MapField<java.lang.String, java.lang.String>
            internalGetMutableAdd() {
          if (add_ == null) {
            add_ = com.google.protobuf.MapField.newMapField(
                AddDefaultEntryHolder.defaultEntry);
          }
          if (!add_.isMutable()) {
            add_ = add_.copy();
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return add_;
        }
        public int getAddCount() {
          return internalGetAdd().getMap().size();
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        @java.lang.Override
        public boolean containsAdd(
            java.lang.String key) {
          if (key == null) { throw new NullPointerException("map key"); }
          return internalGetAdd().getMap().containsKey(key);
        }
        /**
         * Use {@link #getAddMap()} instead.
         */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String> getAdd() {
          return getAddMap();
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        @java.lang.Override
        public java.util.Map<java.lang.String, java.lang.String> getAddMap() {
          return internalGetAdd().getMap();
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        @java.lang.Override
        public /* nullable */
java.lang.String getAddOrDefault(
            java.lang.String key,
            /* nullable */
java.lang.String defaultValue) {
          if (key == null) { throw new NullPointerException("map key"); }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetAdd().getMap();
          return map.containsKey(key) ? map.get(key) : defaultValue;
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        @java.lang.Override
        public java.lang.String getAddOrThrow(
            java.lang.String key) {
          if (key == null) { throw new NullPointerException("map key"); }
          java.util.Map<java.lang.String, java.lang.String> map =
              internalGetAdd().getMap();
          if (!map.containsKey(key)) {
            throw new java.lang.IllegalArgumentException();
          }
          return map.get(key);
        }
        public Builder clearAdd() {
          bitField0_ = (bitField0_ & ~0x00000002);
          internalGetMutableAdd().getMutableMap()
              .clear();
          return this;
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        public Builder removeAdd(
            java.lang.String key) {
          if (key == null) { throw new NullPointerException("map key"); }
          internalGetMutableAdd().getMutableMap()
              .remove(key);
          return this;
        }
        /**
         * Use alternate mutation accessors instead.
         */
        @java.lang.Deprecated
        public java.util.Map<java.lang.String, java.lang.String>
            getMutableAdd() {
          bitField0_ |= 0x00000002;
          return internalGetMutableAdd().getMutableMap();
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        public Builder putAdd(
            java.lang.String key,
            java.lang.String value) {
          if (key == null) { throw new NullPointerException("map key"); }
          if (value == null) { throw new NullPointerException("map value"); }
          internalGetMutableAdd().getMutableMap()
              .put(key, value);
          bitField0_ |= 0x00000002;
          return this;
        }
        /**
         * <pre>
         * Append the given values to the headers specified by keys
         * (will create a comma-separated list of values)
         * </pre>
         *
         * <code>map&lt;string, string&gt; add = 2;</code>
         */
        public Builder putAllAdd(
            java.util.Map<java.lang.String, java.lang.String> values) {
          internalGetMutableAdd().getMutableMap()
              .putAll(values);
          bitField0_ |= 0x00000002;
          return this;
        }

        private com.google.protobuf.LazyStringList remove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        private void ensureRemoveIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            remove_ = new com.google.protobuf.LazyStringArrayList(remove_);
            bitField0_ |= 0x00000004;
           }
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @return A list containing the remove.
         */
        public com.google.protobuf.ProtocolStringList
            getRemoveList() {
          return remove_.getUnmodifiableView();
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @return The count of remove.
         */
        public int getRemoveCount() {
          return remove_.size();
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @param index The index of the element to return.
         * @return The remove at the given index.
         */
        public java.lang.String getRemove(int index) {
          return remove_.get(index);
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @param index The index of the value to return.
         * @return The bytes of the remove at the given index.
         */
        public com.google.protobuf.ByteString
            getRemoveBytes(int index) {
          return remove_.getByteString(index);
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @param index The index to set the value at.
         * @param value The remove to set.
         * @return This builder for chaining.
         */
        public Builder setRemove(
            int index, java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          ensureRemoveIsMutable();
          remove_.set(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @param value The remove to add.
         * @return This builder for chaining.
         */
        public Builder addRemove(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          ensureRemoveIsMutable();
          remove_.add(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @param values The remove to add.
         * @return This builder for chaining.
         */
        public Builder addAllRemove(
            java.lang.Iterable<java.lang.String> values) {
          ensureRemoveIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, remove_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearRemove() {
          remove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Remove a the specified headers
         * </pre>
         *
         * <code>repeated string remove = 3;</code>
         * @param value The bytes of the remove to add.
         * @return This builder for chaining.
         */
        public Builder addRemoveBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          checkByteStringIsUtf8(value);
          ensureRemoveIsMutable();
          remove_.add(value);
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.Headers.HeaderOperations)
      }

      // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.Headers.HeaderOperations)
      private static final istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations();
      }

      public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<HeaderOperations>
          PARSER = new com.google.protobuf.AbstractParser<HeaderOperations>() {
        @java.lang.Override
        public HeaderOperations parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<HeaderOperations> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<HeaderOperations> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations request_;
    /**
     * <pre>
     * Header manipulation rules to apply before forwarding a request
     * to the destination service
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
     * @return Whether the request field is set.
     */
    @java.lang.Override
    public boolean hasRequest() {
      return request_ != null;
    }
    /**
     * <pre>
     * Header manipulation rules to apply before forwarding a request
     * to the destination service
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
     * @return The request.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getRequest() {
      return request_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : request_;
    }
    /**
     * <pre>
     * Header manipulation rules to apply before forwarding a request
     * to the destination service
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder getRequestOrBuilder() {
      return request_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : request_;
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations response_;
    /**
     * <pre>
     * Header manipulation rules to apply before returning a response
     * to the caller
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
     * @return Whether the response field is set.
     */
    @java.lang.Override
    public boolean hasResponse() {
      return response_ != null;
    }
    /**
     * <pre>
     * Header manipulation rules to apply before returning a response
     * to the caller
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
     * @return The response.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getResponse() {
      return response_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : response_;
    }
    /**
     * <pre>
     * Header manipulation rules to apply before returning a response
     * to the caller
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder getResponseOrBuilder() {
      return response_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : response_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (request_ != null) {
        output.writeMessage(1, getRequest());
      }
      if (response_ != null) {
        output.writeMessage(2, getResponse());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (request_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRequest());
      }
      if (response_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getResponse());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Headers)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.Headers other = (istio.networking.v1alpha3.VirtualServiceOuterClass.Headers) obj;

      if (hasRequest() != other.hasRequest()) return false;
      if (hasRequest()) {
        if (!getRequest()
            .equals(other.getRequest())) return false;
      }
      if (hasResponse() != other.hasResponse()) return false;
      if (hasResponse()) {
        if (!getResponse()
            .equals(other.getResponse())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Message headers can be manipulated when Envoy forwards requests to,
     * or responses from, a destination service. Header manipulation rules can
     * be specified for a specific route destination or for all destinations.
     * The following VirtualService adds a `test` header with the value `true`
     * to requests that are routed to any `reviews` service destination.
     * It also removes the `foo` response header, but only from responses
     * coming from the `v1` subset (version) of the `reviews` service.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: reviews-route
     * spec:
     *   hosts:
     *   - reviews.prod.svc.cluster.local
     *   http:
     *   - headers:
     *       request:
     *         set:
     *           test: true
     *     route:
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v2
     *       weight: 25
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v1
     *       headers:
     *         response:
     *           remove:
     *           - foo
     *       weight: 75
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: reviews-route
     * spec:
     *   hosts:
     *   - reviews.prod.svc.cluster.local
     *   http:
     *   - headers:
     *       request:
     *         set:
     *           test: true
     *     route:
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v2
     *       weight: 25
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v1
     *       headers:
     *         response:
     *           remove:
     *           - foo
     *       weight: 75
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.Headers}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.Headers)
        istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.class, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        request_ = null;
        if (requestBuilder_ != null) {
          requestBuilder_.dispose();
          requestBuilder_ = null;
        }
        response_ = null;
        if (responseBuilder_ != null) {
          responseBuilder_.dispose();
          responseBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_Headers_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.Headers result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.Headers result = new istio.networking.v1alpha3.VirtualServiceOuterClass.Headers(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.request_ = requestBuilder_ == null
              ? request_
              : requestBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.response_ = responseBuilder_ == null
              ? response_
              : responseBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.Headers) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.Headers)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getRequestFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getResponseFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations request_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder> requestBuilder_;
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       * @return Whether the request field is set.
       */
      public boolean hasRequest() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       * @return The request.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      public Builder setRequest(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
        } else {
          requestBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      public Builder setRequest(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      public Builder mergeRequest(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations value) {
        if (requestBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            request_ != null &&
            request_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance()) {
            getRequestBuilder().mergeFrom(value);
          } else {
            request_ = value;
          }
        } else {
          requestBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      public Builder clearRequest() {
        bitField0_ = (bitField0_ & ~0x00000001);
        request_ = null;
        if (requestBuilder_ != null) {
          requestBuilder_.dispose();
          requestBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder getRequestBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : request_;
        }
      }
      /**
       * <pre>
       * Header manipulation rules to apply before forwarding a request
       * to the destination service
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder> 
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder>(
                  getRequest(),
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations response_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder> responseBuilder_;
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       * @return Whether the response field is set.
       */
      public boolean hasResponse() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       * @return The response.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      public Builder setResponse(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
        } else {
          responseBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      public Builder setResponse(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      public Builder mergeResponse(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations value) {
        if (responseBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            response_ != null &&
            response_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance()) {
            getResponseBuilder().mergeFrom(value);
          } else {
            response_ = value;
          }
        } else {
          responseBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      public Builder clearResponse() {
        bitField0_ = (bitField0_ & ~0x00000002);
        response_ = null;
        if (responseBuilder_ != null) {
          responseBuilder_.dispose();
          responseBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder getResponseBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.getDefaultInstance() : response_;
        }
      }
      /**
       * <pre>
       * Header manipulation rules to apply before returning a response
       * to the caller
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers.HeaderOperations response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperations.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.HeaderOperationsOrBuilder>(
                  getResponse(),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.Headers)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.Headers)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.Headers DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.Headers();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Headers>
        PARSER = new com.google.protobuf.AbstractParser<Headers>() {
      @java.lang.Override
      public Headers parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Headers> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Headers> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TLSRouteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.TLSRoute)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes> 
        getMatchList();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes getMatch(int index);
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    int getMatchCount();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder> 
        getMatchOrBuilderList();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder getMatchOrBuilder(
        int index);

    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> 
        getRouteList();
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getRoute(int index);
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    int getRouteCount();
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
        getRouteOrBuilderList();
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder getRouteOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Describes match conditions and actions for routing unterminated TLS
   * traffic (TLS/HTTPS) The following routing rule forwards unterminated TLS
   * traffic arriving at port 443 of gateway called "mygateway" to internal
   * services in the mesh based on the SNI value.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: bookinfo-sni
   * spec:
   *   hosts:
   *   - "*.bookinfo.com"
   *   gateways:
   *   - mygateway
   *   tls:
   *   - match:
   *     - port: 443
   *       sniHosts:
   *       - login.bookinfo.com
   *     route:
   *     - destination:
   *         host: login.prod.svc.cluster.local
   *   - match:
   *     - port: 443
   *       sniHosts:
   *       - reviews.bookinfo.com
   *     route:
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: bookinfo-sni
   * spec:
   *   hosts:
   *   - "*.bookinfo.com"
   *   gateways:
   *   - mygateway
   *   tls:
   *   - match:
   *     - port: 443
   *       sniHosts:
   *       - login.bookinfo.com
   *     route:
   *     - destination:
   *         host: login.prod.svc.cluster.local
   *   - match:
   *     - port: 443
   *       sniHosts:
   *       - reviews.bookinfo.com
   *     route:
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.TLSRoute}
   */
  public static final class TLSRoute extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.TLSRoute)
      TLSRouteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TLSRoute.newBuilder() to construct.
    private TLSRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TLSRoute() {
      match_ = java.util.Collections.emptyList();
      route_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TLSRoute();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TLSRoute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TLSRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.class, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder.class);
    }

    public static final int MATCH_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes> match_;
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes> getMatchList() {
      return match_;
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder> 
        getMatchOrBuilderList() {
      return match_;
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public int getMatchCount() {
      return match_.size();
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes getMatch(int index) {
      return match_.get(index);
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder getMatchOrBuilder(
        int index) {
      return match_.get(index);
    }

    public static final int ROUTE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> route_;
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> getRouteList() {
      return route_;
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
        getRouteOrBuilderList() {
      return route_;
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public int getRouteCount() {
      return route_.size();
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getRoute(int index) {
      return route_.get(index);
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder getRouteOrBuilder(
        int index) {
      return route_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < match_.size(); i++) {
        output.writeMessage(1, match_.get(i));
      }
      for (int i = 0; i < route_.size(); i++) {
        output.writeMessage(2, route_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < match_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, match_.get(i));
      }
      for (int i = 0; i < route_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, route_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute other = (istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute) obj;

      if (!getMatchList()
          .equals(other.getMatchList())) return false;
      if (!getRouteList()
          .equals(other.getRouteList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getMatchCount() > 0) {
        hash = (37 * hash) + MATCH_FIELD_NUMBER;
        hash = (53 * hash) + getMatchList().hashCode();
      }
      if (getRouteCount() > 0) {
        hash = (37 * hash) + ROUTE_FIELD_NUMBER;
        hash = (53 * hash) + getRouteList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describes match conditions and actions for routing unterminated TLS
     * traffic (TLS/HTTPS) The following routing rule forwards unterminated TLS
     * traffic arriving at port 443 of gateway called "mygateway" to internal
     * services in the mesh based on the SNI value.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: bookinfo-sni
     * spec:
     *   hosts:
     *   - "*.bookinfo.com"
     *   gateways:
     *   - mygateway
     *   tls:
     *   - match:
     *     - port: 443
     *       sniHosts:
     *       - login.bookinfo.com
     *     route:
     *     - destination:
     *         host: login.prod.svc.cluster.local
     *   - match:
     *     - port: 443
     *       sniHosts:
     *       - reviews.bookinfo.com
     *     route:
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: bookinfo-sni
     * spec:
     *   hosts:
     *   - "*.bookinfo.com"
     *   gateways:
     *   - mygateway
     *   tls:
     *   - match:
     *     - port: 443
     *       sniHosts:
     *       - login.bookinfo.com
     *     route:
     *     - destination:
     *         host: login.prod.svc.cluster.local
     *   - match:
     *     - port: 443
     *       sniHosts:
     *       - reviews.bookinfo.com
     *     route:
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.TLSRoute}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.TLSRoute)
        istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRouteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TLSRoute_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TLSRoute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.class, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (matchBuilder_ == null) {
          match_ = java.util.Collections.emptyList();
        } else {
          match_ = null;
          matchBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (routeBuilder_ == null) {
          route_ = java.util.Collections.emptyList();
        } else {
          route_ = null;
          routeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TLSRoute_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute result = new istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute result) {
        if (matchBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            match_ = java.util.Collections.unmodifiableList(match_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.match_ = match_;
        } else {
          result.match_ = matchBuilder_.build();
        }
        if (routeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            route_ = java.util.Collections.unmodifiableList(route_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.route_ = route_;
        } else {
          result.route_ = routeBuilder_.build();
        }
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute.getDefaultInstance()) return this;
        if (matchBuilder_ == null) {
          if (!other.match_.isEmpty()) {
            if (match_.isEmpty()) {
              match_ = other.match_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMatchIsMutable();
              match_.addAll(other.match_);
            }
            onChanged();
          }
        } else {
          if (!other.match_.isEmpty()) {
            if (matchBuilder_.isEmpty()) {
              matchBuilder_.dispose();
              matchBuilder_ = null;
              match_ = other.match_;
              bitField0_ = (bitField0_ & ~0x00000001);
              matchBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getMatchFieldBuilder() : null;
            } else {
              matchBuilder_.addAllMessages(other.match_);
            }
          }
        }
        if (routeBuilder_ == null) {
          if (!other.route_.isEmpty()) {
            if (route_.isEmpty()) {
              route_ = other.route_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureRouteIsMutable();
              route_.addAll(other.route_);
            }
            onChanged();
          }
        } else {
          if (!other.route_.isEmpty()) {
            if (routeBuilder_.isEmpty()) {
              routeBuilder_.dispose();
              routeBuilder_ = null;
              route_ = other.route_;
              bitField0_ = (bitField0_ & ~0x00000002);
              routeBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getRouteFieldBuilder() : null;
            } else {
              routeBuilder_.addAllMessages(other.route_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.parser(),
                        extensionRegistry);
                if (matchBuilder_ == null) {
                  ensureMatchIsMutable();
                  match_.add(m);
                } else {
                  matchBuilder_.addMessage(m);
                }
                break;
              } // case 10
              case 18: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.parser(),
                        extensionRegistry);
                if (routeBuilder_ == null) {
                  ensureRouteIsMutable();
                  route_.add(m);
                } else {
                  routeBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes> match_ =
        java.util.Collections.emptyList();
      private void ensureMatchIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          match_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes>(match_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder> matchBuilder_;

      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes> getMatchList() {
        if (matchBuilder_ == null) {
          return java.util.Collections.unmodifiableList(match_);
        } else {
          return matchBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public int getMatchCount() {
        if (matchBuilder_ == null) {
          return match_.size();
        } else {
          return matchBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes getMatch(int index) {
        if (matchBuilder_ == null) {
          return match_.get(index);
        } else {
          return matchBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.set(index, value);
          onChanged();
        } else {
          matchBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.set(index, builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder addMatch(istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.add(value);
          onChanged();
        } else {
          matchBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder addMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.add(index, value);
          onChanged();
        } else {
          matchBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder addMatch(
          istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.add(builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder addMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.add(index, builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder addAllMatch(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes> values) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, match_);
          onChanged();
        } else {
          matchBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder clearMatch() {
        if (matchBuilder_ == null) {
          match_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          matchBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder removeMatch(int index) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.remove(index);
          onChanged();
        } else {
          matchBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder getMatchBuilder(
          int index) {
        return getMatchFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder getMatchOrBuilder(
          int index) {
        if (matchBuilder_ == null) {
          return match_.get(index);  } else {
          return matchBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder> 
           getMatchOrBuilderList() {
        if (matchBuilder_ != null) {
          return matchBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(match_);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder addMatchBuilder() {
        return getMatchFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.getDefaultInstance());
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder addMatchBuilder(
          int index) {
        return getMatchFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.getDefaultInstance());
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.TLSMatchAttributes match = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder> 
           getMatchBuilderList() {
        return getMatchFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder> 
          getMatchFieldBuilder() {
        if (matchBuilder_ == null) {
          matchBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributes.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.TLSMatchAttributesOrBuilder>(
                  match_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          match_ = null;
        }
        return matchBuilder_;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> route_ =
        java.util.Collections.emptyList();
      private void ensureRouteIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          route_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination>(route_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> routeBuilder_;

      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> getRouteList() {
        if (routeBuilder_ == null) {
          return java.util.Collections.unmodifiableList(route_);
        } else {
          return routeBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public int getRouteCount() {
        if (routeBuilder_ == null) {
          return route_.size();
        } else {
          return routeBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getRoute(int index) {
        if (routeBuilder_ == null) {
          return route_.get(index);
        } else {
          return routeBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder setRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.set(index, value);
          onChanged();
        } else {
          routeBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder setRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.set(index, builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.add(value);
          onChanged();
        } else {
          routeBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.add(index, value);
          onChanged();
        } else {
          routeBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(
          istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.add(builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.add(index, builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addAllRoute(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> values) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, route_);
          onChanged();
        } else {
          routeBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder clearRoute() {
        if (routeBuilder_ == null) {
          route_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          routeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder removeRoute(int index) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.remove(index);
          onChanged();
        } else {
          routeBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder getRouteBuilder(
          int index) {
        return getRouteFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder getRouteOrBuilder(
          int index) {
        if (routeBuilder_ == null) {
          return route_.get(index);  } else {
          return routeBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
           getRouteOrBuilderList() {
        if (routeBuilder_ != null) {
          return routeBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(route_);
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder addRouteBuilder() {
        return getRouteFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.getDefaultInstance());
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder addRouteBuilder(
          int index) {
        return getRouteFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.getDefaultInstance());
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder> 
           getRouteBuilderList() {
        return getRouteFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
          getRouteFieldBuilder() {
        if (routeBuilder_ == null) {
          routeBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder>(
                  route_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          route_ = null;
        }
        return routeBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.TLSRoute)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.TLSRoute)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TLSRoute>
        PARSER = new com.google.protobuf.AbstractParser<TLSRoute>() {
      @java.lang.Override
      public TLSRoute parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TLSRoute> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TLSRoute> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TLSRoute getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TCPRouteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.TCPRoute)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes> 
        getMatchList();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes getMatch(int index);
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    int getMatchCount();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder> 
        getMatchOrBuilderList();
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder getMatchOrBuilder(
        int index);

    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> 
        getRouteList();
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getRoute(int index);
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    int getRouteCount();
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
        getRouteOrBuilderList();
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder getRouteOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Describes match conditions and actions for routing TCP traffic. The
   * following routing rule forwards traffic arriving at port 27017 for
   * mongo.prod.svc.cluster.local to another Mongo server on port 5555.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: bookinfo-mongo
   * spec:
   *   hosts:
   *   - mongo.prod.svc.cluster.local
   *   tcp:
   *   - match:
   *     - port: 27017
   *     route:
   *     - destination:
   *         host: mongo.backup.svc.cluster.local
   *         port:
   *           number: 5555
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: bookinfo-mongo
   * spec:
   *   hosts:
   *   - mongo.prod.svc.cluster.local
   *   tcp:
   *   - match:
   *     - port: 27017
   *     route:
   *     - destination:
   *         host: mongo.backup.svc.cluster.local
   *         port:
   *           number: 5555
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.TCPRoute}
   */
  public static final class TCPRoute extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.TCPRoute)
      TCPRouteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TCPRoute.newBuilder() to construct.
    private TCPRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TCPRoute() {
      match_ = java.util.Collections.emptyList();
      route_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TCPRoute();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TCPRoute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TCPRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.class, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder.class);
    }

    public static final int MATCH_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes> match_;
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes> getMatchList() {
      return match_;
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder> 
        getMatchOrBuilderList() {
      return match_;
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    @java.lang.Override
    public int getMatchCount() {
      return match_.size();
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes getMatch(int index) {
      return match_.get(index);
    }
    /**
     * <pre>
     * Match conditions to be satisfied for the rule to be
     * activated. All conditions inside a single match block have AND
     * semantics, while the list of match blocks have OR semantics. The rule
     * is matched if any one of the match blocks succeed.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder getMatchOrBuilder(
        int index) {
      return match_.get(index);
    }

    public static final int ROUTE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> route_;
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> getRouteList() {
      return route_;
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
        getRouteOrBuilderList() {
      return route_;
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public int getRouteCount() {
      return route_.size();
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getRoute(int index) {
      return route_.get(index);
    }
    /**
     * <pre>
     * The destination to which the connection should be forwarded to.
     * </pre>
     *
     * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder getRouteOrBuilder(
        int index) {
      return route_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < match_.size(); i++) {
        output.writeMessage(1, match_.get(i));
      }
      for (int i = 0; i < route_.size(); i++) {
        output.writeMessage(2, route_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < match_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, match_.get(i));
      }
      for (int i = 0; i < route_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, route_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute other = (istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute) obj;

      if (!getMatchList()
          .equals(other.getMatchList())) return false;
      if (!getRouteList()
          .equals(other.getRouteList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getMatchCount() > 0) {
        hash = (37 * hash) + MATCH_FIELD_NUMBER;
        hash = (53 * hash) + getMatchList().hashCode();
      }
      if (getRouteCount() > 0) {
        hash = (37 * hash) + ROUTE_FIELD_NUMBER;
        hash = (53 * hash) + getRouteList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Describes match conditions and actions for routing TCP traffic. The
     * following routing rule forwards traffic arriving at port 27017 for
     * mongo.prod.svc.cluster.local to another Mongo server on port 5555.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: bookinfo-mongo
     * spec:
     *   hosts:
     *   - mongo.prod.svc.cluster.local
     *   tcp:
     *   - match:
     *     - port: 27017
     *     route:
     *     - destination:
     *         host: mongo.backup.svc.cluster.local
     *         port:
     *           number: 5555
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: bookinfo-mongo
     * spec:
     *   hosts:
     *   - mongo.prod.svc.cluster.local
     *   tcp:
     *   - match:
     *     - port: 27017
     *     route:
     *     - destination:
     *         host: mongo.backup.svc.cluster.local
     *         port:
     *           number: 5555
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.TCPRoute}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.TCPRoute)
        istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRouteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TCPRoute_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TCPRoute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.class, istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (matchBuilder_ == null) {
          match_ = java.util.Collections.emptyList();
        } else {
          match_ = null;
          matchBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (routeBuilder_ == null) {
          route_ = java.util.Collections.emptyList();
        } else {
          route_ = null;
          routeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_TCPRoute_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute result = new istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute result) {
        if (matchBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            match_ = java.util.Collections.unmodifiableList(match_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.match_ = match_;
        } else {
          result.match_ = matchBuilder_.build();
        }
        if (routeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            route_ = java.util.Collections.unmodifiableList(route_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.route_ = route_;
        } else {
          result.route_ = routeBuilder_.build();
        }
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute.getDefaultInstance()) return this;
        if (matchBuilder_ == null) {
          if (!other.match_.isEmpty()) {
            if (match_.isEmpty()) {
              match_ = other.match_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMatchIsMutable();
              match_.addAll(other.match_);
            }
            onChanged();
          }
        } else {
          if (!other.match_.isEmpty()) {
            if (matchBuilder_.isEmpty()) {
              matchBuilder_.dispose();
              matchBuilder_ = null;
              match_ = other.match_;
              bitField0_ = (bitField0_ & ~0x00000001);
              matchBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getMatchFieldBuilder() : null;
            } else {
              matchBuilder_.addAllMessages(other.match_);
            }
          }
        }
        if (routeBuilder_ == null) {
          if (!other.route_.isEmpty()) {
            if (route_.isEmpty()) {
              route_ = other.route_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureRouteIsMutable();
              route_.addAll(other.route_);
            }
            onChanged();
          }
        } else {
          if (!other.route_.isEmpty()) {
            if (routeBuilder_.isEmpty()) {
              routeBuilder_.dispose();
              routeBuilder_ = null;
              route_ = other.route_;
              bitField0_ = (bitField0_ & ~0x00000002);
              routeBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getRouteFieldBuilder() : null;
            } else {
              routeBuilder_.addAllMessages(other.route_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.parser(),
                        extensionRegistry);
                if (matchBuilder_ == null) {
                  ensureMatchIsMutable();
                  match_.add(m);
                } else {
                  matchBuilder_.addMessage(m);
                }
                break;
              } // case 10
              case 18: {
                istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination m =
                    input.readMessage(
                        istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.parser(),
                        extensionRegistry);
                if (routeBuilder_ == null) {
                  ensureRouteIsMutable();
                  route_.add(m);
                } else {
                  routeBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes> match_ =
        java.util.Collections.emptyList();
      private void ensureMatchIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          match_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes>(match_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder> matchBuilder_;

      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes> getMatchList() {
        if (matchBuilder_ == null) {
          return java.util.Collections.unmodifiableList(match_);
        } else {
          return matchBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public int getMatchCount() {
        if (matchBuilder_ == null) {
          return match_.size();
        } else {
          return matchBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes getMatch(int index) {
        if (matchBuilder_ == null) {
          return match_.get(index);
        } else {
          return matchBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder setMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.set(index, value);
          onChanged();
        } else {
          matchBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder setMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.set(index, builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder addMatch(istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.add(value);
          onChanged();
        } else {
          matchBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder addMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes value) {
        if (matchBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMatchIsMutable();
          match_.add(index, value);
          onChanged();
        } else {
          matchBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder addMatch(
          istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.add(builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder addMatch(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder builderForValue) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.add(index, builderForValue.build());
          onChanged();
        } else {
          matchBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder addAllMatch(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes> values) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, match_);
          onChanged();
        } else {
          matchBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder clearMatch() {
        if (matchBuilder_ == null) {
          match_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          matchBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public Builder removeMatch(int index) {
        if (matchBuilder_ == null) {
          ensureMatchIsMutable();
          match_.remove(index);
          onChanged();
        } else {
          matchBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder getMatchBuilder(
          int index) {
        return getMatchFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder getMatchOrBuilder(
          int index) {
        if (matchBuilder_ == null) {
          return match_.get(index);  } else {
          return matchBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder> 
           getMatchOrBuilderList() {
        if (matchBuilder_ != null) {
          return matchBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(match_);
        }
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder addMatchBuilder() {
        return getMatchFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.getDefaultInstance());
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder addMatchBuilder(
          int index) {
        return getMatchFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.getDefaultInstance());
      }
      /**
       * <pre>
       * Match conditions to be satisfied for the rule to be
       * activated. All conditions inside a single match block have AND
       * semantics, while the list of match blocks have OR semantics. The rule
       * is matched if any one of the match blocks succeed.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.L4MatchAttributes match = 1;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder> 
           getMatchBuilderList() {
        return getMatchFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder> 
          getMatchFieldBuilder() {
        if (matchBuilder_ == null) {
          matchBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder>(
                  match_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          match_ = null;
        }
        return matchBuilder_;
      }

      private java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> route_ =
        java.util.Collections.emptyList();
      private void ensureRouteIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          route_ = new java.util.ArrayList<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination>(route_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> routeBuilder_;

      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> getRouteList() {
        if (routeBuilder_ == null) {
          return java.util.Collections.unmodifiableList(route_);
        } else {
          return routeBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public int getRouteCount() {
        if (routeBuilder_ == null) {
          return route_.size();
        } else {
          return routeBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getRoute(int index) {
        if (routeBuilder_ == null) {
          return route_.get(index);
        } else {
          return routeBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder setRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.set(index, value);
          onChanged();
        } else {
          routeBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder setRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.set(index, builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.add(value);
          onChanged();
        } else {
          routeBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination value) {
        if (routeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRouteIsMutable();
          route_.add(index, value);
          onChanged();
        } else {
          routeBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(
          istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.add(builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addRoute(
          int index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder builderForValue) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.add(index, builderForValue.build());
          onChanged();
        } else {
          routeBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder addAllRoute(
          java.lang.Iterable<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination> values) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, route_);
          onChanged();
        } else {
          routeBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder clearRoute() {
        if (routeBuilder_ == null) {
          route_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          routeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public Builder removeRoute(int index) {
        if (routeBuilder_ == null) {
          ensureRouteIsMutable();
          route_.remove(index);
          onChanged();
        } else {
          routeBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder getRouteBuilder(
          int index) {
        return getRouteFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder getRouteOrBuilder(
          int index) {
        if (routeBuilder_ == null) {
          return route_.get(index);  } else {
          return routeBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public java.util.List<? extends istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
           getRouteOrBuilderList() {
        if (routeBuilder_ != null) {
          return routeBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(route_);
        }
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder addRouteBuilder() {
        return getRouteFieldBuilder().addBuilder(
            istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.getDefaultInstance());
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder addRouteBuilder(
          int index) {
        return getRouteFieldBuilder().addBuilder(
            index, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.getDefaultInstance());
      }
      /**
       * <pre>
       * The destination to which the connection should be forwarded to.
       * </pre>
       *
       * <code>repeated .istio.networking.v1alpha3.RouteDestination route = 2;</code>
       */
      public java.util.List<istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder> 
           getRouteBuilderList() {
        return getRouteFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder> 
          getRouteFieldBuilder() {
        if (routeBuilder_ == null) {
          routeBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder>(
                  route_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          route_ = null;
        }
        return routeBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.TCPRoute)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.TCPRoute)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TCPRoute>
        PARSER = new com.google.protobuf.AbstractParser<TCPRoute>() {
      @java.lang.Override
      public TCPRoute parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TCPRoute> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TCPRoute> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.TCPRoute getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface HTTPMatchRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.HTTPMatchRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The name assigned to a match. The match's name will be
     * concatenated with the parent route's name and will be logged in
     * the access logs for requests matching this route.
     * </pre>
     *
     * <code>string name = 11;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * The name assigned to a match. The match's name will be
     * concatenated with the parent route's name and will be logged in
     * the access logs for requests matching this route.
     * </pre>
     *
     * <code>string name = 11;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * URI to match
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * **Note:** Case-insensitive matching could be enabled via the
     * `ignore_uri_case` flag.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
     * @return Whether the uri field is set.
     */
    boolean hasUri();
    /**
     * <pre>
     * URI to match
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * **Note:** Case-insensitive matching could be enabled via the
     * `ignore_uri_case` flag.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
     * @return The uri.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getUri();
    /**
     * <pre>
     * URI to match
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * **Note:** Case-insensitive matching could be enabled via the
     * `ignore_uri_case` flag.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getUriOrBuilder();

    /**
     * <pre>
     * URI Scheme
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
     * @return Whether the scheme field is set.
     */
    boolean hasScheme();
    /**
     * <pre>
     * URI Scheme
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
     * @return The scheme.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getScheme();
    /**
     * <pre>
     * URI Scheme
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getSchemeOrBuilder();

    /**
     * <pre>
     * HTTP Method
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
     * @return Whether the method field is set.
     */
    boolean hasMethod();
    /**
     * <pre>
     * HTTP Method
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
     * @return The method.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getMethod();
    /**
     * <pre>
     * HTTP Method
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getMethodOrBuilder();

    /**
     * <pre>
     * HTTP Authority
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
     * @return Whether the authority field is set.
     */
    boolean hasAuthority();
    /**
     * <pre>
     * HTTP Authority
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
     * @return The authority.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getAuthority();
    /**
     * <pre>
     * HTTP Authority
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getAuthorityOrBuilder();

    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    int getHeadersCount();
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    boolean containsHeaders(
        java.lang.String key);
    /**
     * Use {@link #getHeadersMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    getHeaders();
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    getHeadersMap();
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue);
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getHeadersOrThrow(
        java.lang.String key);

    /**
     * <pre>
     * Specifies the ports on the host that is being addressed. Many services
     * only expose a single port or label ports with the protocols they support,
     * in these cases it is not required to explicitly select the port.
     * </pre>
     *
     * <code>uint32 port = 6;</code>
     * @return The port.
     */
    int getPort();

    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    int getSourceLabelsCount();
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    boolean containsSourceLabels(
        java.lang.String key);
    /**
     * Use {@link #getSourceLabelsMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String>
    getSourceLabels();
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    java.util.Map<java.lang.String, java.lang.String>
    getSourceLabelsMap();
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    /* nullable */
java.lang.String getSourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue);
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    java.lang.String getSourceLabelsOrThrow(
        java.lang.String key);

    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @return A list containing the gateways.
     */
    java.util.List<java.lang.String>
        getGatewaysList();
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @return The count of gateways.
     */
    int getGatewaysCount();
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @param index The index of the element to return.
     * @return The gateways at the given index.
     */
    java.lang.String getGateways(int index);
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @param index The index of the value to return.
     * @return The bytes of the gateways at the given index.
     */
    com.google.protobuf.ByteString
        getGatewaysBytes(int index);

    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    int getQueryParamsCount();
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    boolean containsQueryParams(
        java.lang.String key);
    /**
     * Use {@link #getQueryParamsMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    getQueryParams();
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    getQueryParamsMap();
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getQueryParamsOrDefault(
        java.lang.String key,
        /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue);
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getQueryParamsOrThrow(
        java.lang.String key);

    /**
     * <pre>
     * Flag to specify whether the URI matching should be case-insensitive.
     * **Note:** The case will be ignored only in the case of `exact` and `prefix`
     * URI matches.
     * </pre>
     *
     * <code>bool ignore_uri_case = 10;</code>
     * @return The ignoreUriCase.
     */
    boolean getIgnoreUriCase();

    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    int getWithoutHeadersCount();
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    boolean containsWithoutHeaders(
        java.lang.String key);
    /**
     * Use {@link #getWithoutHeadersMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    getWithoutHeaders();
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    getWithoutHeadersMap();
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getWithoutHeadersOrDefault(
        java.lang.String key,
        /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue);
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getWithoutHeadersOrThrow(
        java.lang.String key);

    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 13;</code>
     * @return The sourceNamespace.
     */
    java.lang.String getSourceNamespace();
    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 13;</code>
     * @return The bytes for sourceNamespace.
     */
    com.google.protobuf.ByteString
        getSourceNamespaceBytes();
  }
  /**
   * <pre>
   * HttpMatchRequest specifies a set of criterion to be met in order for the
   * rule to be applied to the HTTP request. For example, the following
   * restricts the rule to match only requests where the URL path
   * starts with /ratings/v2/ and the request contains a custom `end-user` header
   * with value `jason`.
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: ratings-route
   * spec:
   *   hosts:
   *   - ratings.prod.svc.cluster.local
   *   http:
   *   - match:
   *     - headers:
   *         end-user:
   *           exact: jason
   *       uri:
   *         prefix: "/ratings/v2/"
   *       ignoreUriCase: true
   *     route:
   *     - destination:
   *         host: ratings.prod.svc.cluster.local
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: ratings-route
   * spec:
   *   hosts:
   *   - ratings.prod.svc.cluster.local
   *   http:
   *   - match:
   *     - headers:
   *         end-user:
   *           exact: jason
   *       uri:
   *         prefix: "/ratings/v2/"
   *       ignoreUriCase: true
   *     route:
   *     - destination:
   *         host: ratings.prod.svc.cluster.local
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * HTTPMatchRequest CANNOT be empty.
   * **Note:** No regex string match can be set when delegate VirtualService is specified.
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.HTTPMatchRequest}
   */
  public static final class HTTPMatchRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.HTTPMatchRequest)
      HTTPMatchRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use HTTPMatchRequest.newBuilder() to construct.
    private HTTPMatchRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private HTTPMatchRequest() {
      name_ = "";
      gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      sourceNamespace_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new HTTPMatchRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 5:
          return internalGetHeaders();
        case 7:
          return internalGetSourceLabels();
        case 9:
          return internalGetQueryParams();
        case 12:
          return internalGetWithoutHeaders();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.class, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 11;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * The name assigned to a match. The match's name will be
     * concatenated with the parent route's name and will be logged in
     * the access logs for requests matching this route.
     * </pre>
     *
     * <code>string name = 11;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The name assigned to a match. The match's name will be
     * concatenated with the parent route's name and will be logged in
     * the access logs for requests matching this route.
     * </pre>
     *
     * <code>string name = 11;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int URI_FIELD_NUMBER = 1;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch uri_;
    /**
     * <pre>
     * URI to match
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * **Note:** Case-insensitive matching could be enabled via the
     * `ignore_uri_case` flag.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
     * @return Whether the uri field is set.
     */
    @java.lang.Override
    public boolean hasUri() {
      return uri_ != null;
    }
    /**
     * <pre>
     * URI to match
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * **Note:** Case-insensitive matching could be enabled via the
     * `ignore_uri_case` flag.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
     * @return The uri.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getUri() {
      return uri_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : uri_;
    }
    /**
     * <pre>
     * URI to match
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * **Note:** Case-insensitive matching could be enabled via the
     * `ignore_uri_case` flag.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getUriOrBuilder() {
      return uri_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : uri_;
    }

    public static final int SCHEME_FIELD_NUMBER = 2;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch scheme_;
    /**
     * <pre>
     * URI Scheme
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
     * @return Whether the scheme field is set.
     */
    @java.lang.Override
    public boolean hasScheme() {
      return scheme_ != null;
    }
    /**
     * <pre>
     * URI Scheme
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
     * @return The scheme.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getScheme() {
      return scheme_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : scheme_;
    }
    /**
     * <pre>
     * URI Scheme
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getSchemeOrBuilder() {
      return scheme_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : scheme_;
    }

    public static final int METHOD_FIELD_NUMBER = 3;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch method_;
    /**
     * <pre>
     * HTTP Method
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
     * @return Whether the method field is set.
     */
    @java.lang.Override
    public boolean hasMethod() {
      return method_ != null;
    }
    /**
     * <pre>
     * HTTP Method
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
     * @return The method.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getMethod() {
      return method_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : method_;
    }
    /**
     * <pre>
     * HTTP Method
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getMethodOrBuilder() {
      return method_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : method_;
    }

    public static final int AUTHORITY_FIELD_NUMBER = 4;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch authority_;
    /**
     * <pre>
     * HTTP Authority
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
     * @return Whether the authority field is set.
     */
    @java.lang.Override
    public boolean hasAuthority() {
      return authority_ != null;
    }
    /**
     * <pre>
     * HTTP Authority
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
     * @return The authority.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getAuthority() {
      return authority_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : authority_;
    }
    /**
     * <pre>
     * HTTP Authority
     * values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getAuthorityOrBuilder() {
      return authority_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : authority_;
    }

    public static final int HEADERS_FIELD_NUMBER = 5;
    private static final class HeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>newDefaultInstance(
                  istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_HeadersEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.MESSAGE,
                  istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance());
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> headers_;
    private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }
    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /**
     * Use {@link #getHeadersMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getHeaders() {
      return getHeadersMap();
    }
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    @java.lang.Override
    public /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
          internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * The header keys must be lowercase and use hyphen as the separator,
     * e.g. _x-request-id_.
     * Header values are case-sensitive and formatted as follows:
     * - `exact: "value"` for exact string match
     * - `prefix: "value"` for prefix-based match
     * - `regex: "value"` for ECMAscript style regex-based match
     * If the value is empty and only the name of header is specfied, presence of the header is checked.
     * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getHeadersOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
          internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PORT_FIELD_NUMBER = 6;
    private int port_ = 0;
    /**
     * <pre>
     * Specifies the ports on the host that is being addressed. Many services
     * only expose a single port or label ports with the protocols they support,
     * in these cases it is not required to explicitly select the port.
     * </pre>
     *
     * <code>uint32 port = 6;</code>
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int SOURCE_LABELS_FIELD_NUMBER = 7;
    private static final class SourceLabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, java.lang.String> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, java.lang.String>newDefaultInstance(
                  istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_SourceLabelsEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "");
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> sourceLabels_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetSourceLabels() {
      if (sourceLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SourceLabelsDefaultEntryHolder.defaultEntry);
      }
      return sourceLabels_;
    }
    public int getSourceLabelsCount() {
      return internalGetSourceLabels().getMap().size();
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsSourceLabels(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetSourceLabels().getMap().containsKey(key);
    }
    /**
     * Use {@link #getSourceLabelsMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSourceLabels() {
      return getSourceLabelsMap();
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSourceLabelsMap() {
      return internalGetSourceLabels().getMap();
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    @java.lang.Override
    public /* nullable */
java.lang.String getSourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetSourceLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it must include the reserved gateway
     * `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getSourceLabelsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetSourceLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int GATEWAYS_FIELD_NUMBER = 8;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList gateways_;
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @return A list containing the gateways.
     */
    public com.google.protobuf.ProtocolStringList
        getGatewaysList() {
      return gateways_;
    }
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @return The count of gateways.
     */
    public int getGatewaysCount() {
      return gateways_.size();
    }
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @param index The index of the element to return.
     * @return The gateways at the given index.
     */
    public java.lang.String getGateways(int index) {
      return gateways_.get(index);
    }
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 8;</code>
     * @param index The index of the value to return.
     * @return The bytes of the gateways at the given index.
     */
    public com.google.protobuf.ByteString
        getGatewaysBytes(int index) {
      return gateways_.getByteString(index);
    }

    public static final int QUERY_PARAMS_FIELD_NUMBER = 9;
    private static final class QueryParamsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>newDefaultInstance(
                  istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_QueryParamsEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.MESSAGE,
                  istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance());
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> queryParams_;
    private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    internalGetQueryParams() {
      if (queryParams_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            QueryParamsDefaultEntryHolder.defaultEntry);
      }
      return queryParams_;
    }
    public int getQueryParamsCount() {
      return internalGetQueryParams().getMap().size();
    }
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    @java.lang.Override
    public boolean containsQueryParams(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetQueryParams().getMap().containsKey(key);
    }
    /**
     * Use {@link #getQueryParamsMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getQueryParams() {
      return getQueryParamsMap();
    }
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getQueryParamsMap() {
      return internalGetQueryParams().getMap();
    }
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    @java.lang.Override
    public /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getQueryParamsOrDefault(
        java.lang.String key,
        /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
          internalGetQueryParams().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Query parameters for matching.
     * Ex:
     * - For a query parameter like "?key=true", the map key would be "key" and
     *   the string match could be defined as `exact: "true"`.
     * - For a query parameter like "?key", the map key would be "key" and the
     *   string match could be defined as `exact: ""`.
     * - For a query parameter like "?key=123", the map key would be "key" and the
     *   string match could be defined as `regex: "&#92;d+$"`. Note that this
     *   configuration will only match values like "123" but not "a123" or "123a".
     * **Note:** `prefix` matching is currently not supported.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getQueryParamsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
          internalGetQueryParams().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int IGNORE_URI_CASE_FIELD_NUMBER = 10;
    private boolean ignoreUriCase_ = false;
    /**
     * <pre>
     * Flag to specify whether the URI matching should be case-insensitive.
     * **Note:** The case will be ignored only in the case of `exact` and `prefix`
     * URI matches.
     * </pre>
     *
     * <code>bool ignore_uri_case = 10;</code>
     * @return The ignoreUriCase.
     */
    @java.lang.Override
    public boolean getIgnoreUriCase() {
      return ignoreUriCase_;
    }

    public static final int WITHOUT_HEADERS_FIELD_NUMBER = 12;
    private static final class WithoutHeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>newDefaultInstance(
                  istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_WithoutHeadersEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.MESSAGE,
                  istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance());
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> withoutHeaders_;
    private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
    internalGetWithoutHeaders() {
      if (withoutHeaders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            WithoutHeadersDefaultEntryHolder.defaultEntry);
      }
      return withoutHeaders_;
    }
    public int getWithoutHeadersCount() {
      return internalGetWithoutHeaders().getMap().size();
    }
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    @java.lang.Override
    public boolean containsWithoutHeaders(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetWithoutHeaders().getMap().containsKey(key);
    }
    /**
     * Use {@link #getWithoutHeadersMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getWithoutHeaders() {
      return getWithoutHeadersMap();
    }
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getWithoutHeadersMap() {
      return internalGetWithoutHeaders().getMap();
    }
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    @java.lang.Override
    public /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getWithoutHeadersOrDefault(
        java.lang.String key,
        /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
          internalGetWithoutHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * withoutHeader has the same syntax with the header, but has opposite meaning.
     * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
     * </pre>
     *
     * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getWithoutHeadersOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
          internalGetWithoutHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int SOURCE_NAMESPACE_FIELD_NUMBER = 13;
    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceNamespace_ = "";
    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 13;</code>
     * @return The sourceNamespace.
     */
    @java.lang.Override
    public java.lang.String getSourceNamespace() {
      java.lang.Object ref = sourceNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceNamespace_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 13;</code>
     * @return The bytes for sourceNamespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSourceNamespaceBytes() {
      java.lang.Object ref = sourceNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sourceNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (uri_ != null) {
        output.writeMessage(1, getUri());
      }
      if (scheme_ != null) {
        output.writeMessage(2, getScheme());
      }
      if (method_ != null) {
        output.writeMessage(3, getMethod());
      }
      if (authority_ != null) {
        output.writeMessage(4, getAuthority());
      }
      com.google.protobuf.GeneratedMessageV3
        .serializeStringMapTo(
          output,
          internalGetHeaders(),
          HeadersDefaultEntryHolder.defaultEntry,
          5);
      if (port_ != 0) {
        output.writeUInt32(6, port_);
      }
      com.google.protobuf.GeneratedMessageV3
        .serializeStringMapTo(
          output,
          internalGetSourceLabels(),
          SourceLabelsDefaultEntryHolder.defaultEntry,
          7);
      for (int i = 0; i < gateways_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, gateways_.getRaw(i));
      }
      com.google.protobuf.GeneratedMessageV3
        .serializeStringMapTo(
          output,
          internalGetQueryParams(),
          QueryParamsDefaultEntryHolder.defaultEntry,
          9);
      if (ignoreUriCase_ != false) {
        output.writeBool(10, ignoreUriCase_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, name_);
      }
      com.google.protobuf.GeneratedMessageV3
        .serializeStringMapTo(
          output,
          internalGetWithoutHeaders(),
          WithoutHeadersDefaultEntryHolder.defaultEntry,
          12);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNamespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 13, sourceNamespace_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (uri_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getUri());
      }
      if (scheme_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getScheme());
      }
      if (method_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getMethod());
      }
      if (authority_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getAuthority());
      }
      for (java.util.Map.Entry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> entry
           : internalGetHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
        headers__ = HeadersDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(5, headers__);
      }
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(6, port_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
           : internalGetSourceLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
        sourceLabels__ = SourceLabelsDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(7, sourceLabels__);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < gateways_.size(); i++) {
          dataSize += computeStringSizeNoTag(gateways_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGatewaysList().size();
      }
      for (java.util.Map.Entry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> entry
           : internalGetQueryParams().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
        queryParams__ = QueryParamsDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(9, queryParams__);
      }
      if (ignoreUriCase_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(10, ignoreUriCase_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, name_);
      }
      for (java.util.Map.Entry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> entry
           : internalGetWithoutHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
        withoutHeaders__ = WithoutHeadersDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(12, withoutHeaders__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNamespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, sourceNamespace_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest other = (istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (hasUri() != other.hasUri()) return false;
      if (hasUri()) {
        if (!getUri()
            .equals(other.getUri())) return false;
      }
      if (hasScheme() != other.hasScheme()) return false;
      if (hasScheme()) {
        if (!getScheme()
            .equals(other.getScheme())) return false;
      }
      if (hasMethod() != other.hasMethod()) return false;
      if (hasMethod()) {
        if (!getMethod()
            .equals(other.getMethod())) return false;
      }
      if (hasAuthority() != other.hasAuthority()) return false;
      if (hasAuthority()) {
        if (!getAuthority()
            .equals(other.getAuthority())) return false;
      }
      if (!internalGetHeaders().equals(
          other.internalGetHeaders())) return false;
      if (getPort()
          != other.getPort()) return false;
      if (!internalGetSourceLabels().equals(
          other.internalGetSourceLabels())) return false;
      if (!getGatewaysList()
          .equals(other.getGatewaysList())) return false;
      if (!internalGetQueryParams().equals(
          other.internalGetQueryParams())) return false;
      if (getIgnoreUriCase()
          != other.getIgnoreUriCase()) return false;
      if (!internalGetWithoutHeaders().equals(
          other.internalGetWithoutHeaders())) return false;
      if (!getSourceNamespace()
          .equals(other.getSourceNamespace())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasUri()) {
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
      }
      if (hasScheme()) {
        hash = (37 * hash) + SCHEME_FIELD_NUMBER;
        hash = (53 * hash) + getScheme().hashCode();
      }
      if (hasMethod()) {
        hash = (37 * hash) + METHOD_FIELD_NUMBER;
        hash = (53 * hash) + getMethod().hashCode();
      }
      if (hasAuthority()) {
        hash = (37 * hash) + AUTHORITY_FIELD_NUMBER;
        hash = (53 * hash) + getAuthority().hashCode();
      }
      if (!internalGetHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetHeaders().hashCode();
      }
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      if (!internalGetSourceLabels().getMap().isEmpty()) {
        hash = (37 * hash) + SOURCE_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetSourceLabels().hashCode();
      }
      if (getGatewaysCount() > 0) {
        hash = (37 * hash) + GATEWAYS_FIELD_NUMBER;
        hash = (53 * hash) + getGatewaysList().hashCode();
      }
      if (!internalGetQueryParams().getMap().isEmpty()) {
        hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetQueryParams().hashCode();
      }
      hash = (37 * hash) + IGNORE_URI_CASE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getIgnoreUriCase());
      if (!internalGetWithoutHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + WITHOUT_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetWithoutHeaders().hashCode();
      }
      hash = (37 * hash) + SOURCE_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNamespace().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * HttpMatchRequest specifies a set of criterion to be met in order for the
     * rule to be applied to the HTTP request. For example, the following
     * restricts the rule to match only requests where the URL path
     * starts with /ratings/v2/ and the request contains a custom `end-user` header
     * with value `jason`.
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: ratings-route
     * spec:
     *   hosts:
     *   - ratings.prod.svc.cluster.local
     *   http:
     *   - match:
     *     - headers:
     *         end-user:
     *           exact: jason
     *       uri:
     *         prefix: "/ratings/v2/"
     *       ignoreUriCase: true
     *     route:
     *     - destination:
     *         host: ratings.prod.svc.cluster.local
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: ratings-route
     * spec:
     *   hosts:
     *   - ratings.prod.svc.cluster.local
     *   http:
     *   - match:
     *     - headers:
     *         end-user:
     *           exact: jason
     *       uri:
     *         prefix: "/ratings/v2/"
     *       ignoreUriCase: true
     *     route:
     *     - destination:
     *         host: ratings.prod.svc.cluster.local
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * HTTPMatchRequest CANNOT be empty.
     * **Note:** No regex string match can be set when delegate VirtualService is specified.
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.HTTPMatchRequest}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.HTTPMatchRequest)
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(
          int number) {
        switch (number) {
          case 5:
            return internalGetHeaders();
          case 7:
            return internalGetSourceLabels();
          case 9:
            return internalGetQueryParams();
          case 12:
            return internalGetWithoutHeaders();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(
          int number) {
        switch (number) {
          case 5:
            return internalGetMutableHeaders();
          case 7:
            return internalGetMutableSourceLabels();
          case 9:
            return internalGetMutableQueryParams();
          case 12:
            return internalGetMutableWithoutHeaders();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.class, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        uri_ = null;
        if (uriBuilder_ != null) {
          uriBuilder_.dispose();
          uriBuilder_ = null;
        }
        scheme_ = null;
        if (schemeBuilder_ != null) {
          schemeBuilder_.dispose();
          schemeBuilder_ = null;
        }
        method_ = null;
        if (methodBuilder_ != null) {
          methodBuilder_.dispose();
          methodBuilder_ = null;
        }
        authority_ = null;
        if (authorityBuilder_ != null) {
          authorityBuilder_.dispose();
          authorityBuilder_ = null;
        }
        internalGetMutableHeaders().clear();
        port_ = 0;
        internalGetMutableSourceLabels().clear();
        gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000100);
        internalGetMutableQueryParams().clear();
        ignoreUriCase_ = false;
        internalGetMutableWithoutHeaders().clear();
        sourceNamespace_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPMatchRequest_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest result = new istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest result) {
        if (((bitField0_ & 0x00000100) != 0)) {
          gateways_ = gateways_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.gateways_ = gateways_;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.uri_ = uriBuilder_ == null
              ? uri_
              : uriBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.scheme_ = schemeBuilder_ == null
              ? scheme_
              : schemeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.method_ = methodBuilder_ == null
              ? method_
              : methodBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.authority_ = authorityBuilder_ == null
              ? authority_
              : authorityBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.headers_ = internalGetHeaders();
          result.headers_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.port_ = port_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.sourceLabels_ = internalGetSourceLabels();
          result.sourceLabels_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.queryParams_ = internalGetQueryParams();
          result.queryParams_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.ignoreUriCase_ = ignoreUriCase_;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.withoutHeaders_ = internalGetWithoutHeaders();
          result.withoutHeaders_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.sourceNamespace_ = sourceNamespace_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasUri()) {
          mergeUri(other.getUri());
        }
        if (other.hasScheme()) {
          mergeScheme(other.getScheme());
        }
        if (other.hasMethod()) {
          mergeMethod(other.getMethod());
        }
        if (other.hasAuthority()) {
          mergeAuthority(other.getAuthority());
        }
        internalGetMutableHeaders().mergeFrom(
            other.internalGetHeaders());
        bitField0_ |= 0x00000020;
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        internalGetMutableSourceLabels().mergeFrom(
            other.internalGetSourceLabels());
        bitField0_ |= 0x00000080;
        if (!other.gateways_.isEmpty()) {
          if (gateways_.isEmpty()) {
            gateways_ = other.gateways_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureGatewaysIsMutable();
            gateways_.addAll(other.gateways_);
          }
          onChanged();
        }
        internalGetMutableQueryParams().mergeFrom(
            other.internalGetQueryParams());
        bitField0_ |= 0x00000200;
        if (other.getIgnoreUriCase() != false) {
          setIgnoreUriCase(other.getIgnoreUriCase());
        }
        internalGetMutableWithoutHeaders().mergeFrom(
            other.internalGetWithoutHeaders());
        bitField0_ |= 0x00000800;
        if (!other.getSourceNamespace().isEmpty()) {
          sourceNamespace_ = other.sourceNamespace_;
          bitField0_ |= 0x00001000;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getUriFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getSchemeFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getMethodFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getAuthorityFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
              case 42: {
                com.google.protobuf.MapEntry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
                headers__ = input.readMessage(
                    HeadersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableHeaders().getMutableMap().put(
                    headers__.getKey(), headers__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 42
              case 48: {
                port_ = input.readUInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 48
              case 58: {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                sourceLabels__ = input.readMessage(
                    SourceLabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableSourceLabels().getMutableMap().put(
                    sourceLabels__.getKey(), sourceLabels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 58
              case 66: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureGatewaysIsMutable();
                gateways_.add(s);
                break;
              } // case 66
              case 74: {
                com.google.protobuf.MapEntry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
                queryParams__ = input.readMessage(
                    QueryParamsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableQueryParams().getMutableMap().put(
                    queryParams__.getKey(), queryParams__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 74
              case 80: {
                ignoreUriCase_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 80
              case 90: {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 90
              case 98: {
                com.google.protobuf.MapEntry<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
                withoutHeaders__ = input.readMessage(
                    WithoutHeadersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableWithoutHeaders().getMutableMap().put(
                    withoutHeaders__.getKey(), withoutHeaders__.getValue());
                bitField0_ |= 0x00000800;
                break;
              } // case 98
              case 106: {
                sourceNamespace_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * The name assigned to a match. The match's name will be
       * concatenated with the parent route's name and will be logged in
       * the access logs for requests matching this route.
       * </pre>
       *
       * <code>string name = 11;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The name assigned to a match. The match's name will be
       * concatenated with the parent route's name and will be logged in
       * the access logs for requests matching this route.
       * </pre>
       *
       * <code>string name = 11;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The name assigned to a match. The match's name will be
       * concatenated with the parent route's name and will be logged in
       * the access logs for requests matching this route.
       * </pre>
       *
       * <code>string name = 11;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name assigned to a match. The match's name will be
       * concatenated with the parent route's name and will be logged in
       * the access logs for requests matching this route.
       * </pre>
       *
       * <code>string name = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name assigned to a match. The match's name will be
       * concatenated with the parent route's name and will be logged in
       * the access logs for requests matching this route.
       * </pre>
       *
       * <code>string name = 11;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch uri_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> uriBuilder_;
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       * @return Whether the uri field is set.
       */
      public boolean hasUri() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       * @return The uri.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getUri() {
        if (uriBuilder_ == null) {
          return uri_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : uri_;
        } else {
          return uriBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      public Builder setUri(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (uriBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          uri_ = value;
        } else {
          uriBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      public Builder setUri(
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder builderForValue) {
        if (uriBuilder_ == null) {
          uri_ = builderForValue.build();
        } else {
          uriBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      public Builder mergeUri(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (uriBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            uri_ != null &&
            uri_ != istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance()) {
            getUriBuilder().mergeFrom(value);
          } else {
            uri_ = value;
          }
        } else {
          uriBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      public Builder clearUri() {
        bitField0_ = (bitField0_ & ~0x00000002);
        uri_ = null;
        if (uriBuilder_ != null) {
          uriBuilder_.dispose();
          uriBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder getUriBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getUriFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getUriOrBuilder() {
        if (uriBuilder_ != null) {
          return uriBuilder_.getMessageOrBuilder();
        } else {
          return uri_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : uri_;
        }
      }
      /**
       * <pre>
       * URI to match
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * **Note:** Case-insensitive matching could be enabled via the
       * `ignore_uri_case` flag.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch uri = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> 
          getUriFieldBuilder() {
        if (uriBuilder_ == null) {
          uriBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder>(
                  getUri(),
                  getParentForChildren(),
                  isClean());
          uri_ = null;
        }
        return uriBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch scheme_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> schemeBuilder_;
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       * @return Whether the scheme field is set.
       */
      public boolean hasScheme() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       * @return The scheme.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getScheme() {
        if (schemeBuilder_ == null) {
          return scheme_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : scheme_;
        } else {
          return schemeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      public Builder setScheme(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (schemeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scheme_ = value;
        } else {
          schemeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      public Builder setScheme(
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder builderForValue) {
        if (schemeBuilder_ == null) {
          scheme_ = builderForValue.build();
        } else {
          schemeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      public Builder mergeScheme(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (schemeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            scheme_ != null &&
            scheme_ != istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance()) {
            getSchemeBuilder().mergeFrom(value);
          } else {
            scheme_ = value;
          }
        } else {
          schemeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      public Builder clearScheme() {
        bitField0_ = (bitField0_ & ~0x00000004);
        scheme_ = null;
        if (schemeBuilder_ != null) {
          schemeBuilder_.dispose();
          schemeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder getSchemeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSchemeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getSchemeOrBuilder() {
        if (schemeBuilder_ != null) {
          return schemeBuilder_.getMessageOrBuilder();
        } else {
          return scheme_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : scheme_;
        }
      }
      /**
       * <pre>
       * URI Scheme
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch scheme = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> 
          getSchemeFieldBuilder() {
        if (schemeBuilder_ == null) {
          schemeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder>(
                  getScheme(),
                  getParentForChildren(),
                  isClean());
          scheme_ = null;
        }
        return schemeBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch method_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> methodBuilder_;
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       * @return Whether the method field is set.
       */
      public boolean hasMethod() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       * @return The method.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getMethod() {
        if (methodBuilder_ == null) {
          return method_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : method_;
        } else {
          return methodBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      public Builder setMethod(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (methodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          method_ = value;
        } else {
          methodBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      public Builder setMethod(
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder builderForValue) {
        if (methodBuilder_ == null) {
          method_ = builderForValue.build();
        } else {
          methodBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      public Builder mergeMethod(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (methodBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            method_ != null &&
            method_ != istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance()) {
            getMethodBuilder().mergeFrom(value);
          } else {
            method_ = value;
          }
        } else {
          methodBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      public Builder clearMethod() {
        bitField0_ = (bitField0_ & ~0x00000008);
        method_ = null;
        if (methodBuilder_ != null) {
          methodBuilder_.dispose();
          methodBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder getMethodBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getMethodFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getMethodOrBuilder() {
        if (methodBuilder_ != null) {
          return methodBuilder_.getMessageOrBuilder();
        } else {
          return method_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : method_;
        }
      }
      /**
       * <pre>
       * HTTP Method
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch method = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> 
          getMethodFieldBuilder() {
        if (methodBuilder_ == null) {
          methodBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder>(
                  getMethod(),
                  getParentForChildren(),
                  isClean());
          method_ = null;
        }
        return methodBuilder_;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch authority_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> authorityBuilder_;
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       * @return Whether the authority field is set.
       */
      public boolean hasAuthority() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       * @return The authority.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getAuthority() {
        if (authorityBuilder_ == null) {
          return authority_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : authority_;
        } else {
          return authorityBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      public Builder setAuthority(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (authorityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authority_ = value;
        } else {
          authorityBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      public Builder setAuthority(
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder builderForValue) {
        if (authorityBuilder_ == null) {
          authority_ = builderForValue.build();
        } else {
          authorityBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      public Builder mergeAuthority(istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (authorityBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
            authority_ != null &&
            authority_ != istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance()) {
            getAuthorityBuilder().mergeFrom(value);
          } else {
            authority_ = value;
          }
        } else {
          authorityBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      public Builder clearAuthority() {
        bitField0_ = (bitField0_ & ~0x00000010);
        authority_ = null;
        if (authorityBuilder_ != null) {
          authorityBuilder_.dispose();
          authorityBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder getAuthorityBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getAuthorityFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder getAuthorityOrBuilder() {
        if (authorityBuilder_ != null) {
          return authorityBuilder_.getMessageOrBuilder();
        } else {
          return authority_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.getDefaultInstance() : authority_;
        }
      }
      /**
       * <pre>
       * HTTP Authority
       * values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.StringMatch authority = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder> 
          getAuthorityFieldBuilder() {
        if (authorityBuilder_ == null) {
          authorityBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatchOrBuilder>(
                  getAuthority(),
                  getParentForChildren(),
                  isClean());
          authority_ = null;
        }
        return authorityBuilder_;
      }

      private com.google.protobuf.MapField<
          java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> headers_;
      private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          internalGetHeaders() {
        if (headers_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              HeadersDefaultEntryHolder.defaultEntry);
        }
        return headers_;
      }
      private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          internalGetMutableHeaders() {
        if (headers_ == null) {
          headers_ = com.google.protobuf.MapField.newMapField(
              HeadersDefaultEntryHolder.defaultEntry);
        }
        if (!headers_.isMutable()) {
          headers_ = headers_.copy();
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return headers_;
      }
      public int getHeadersCount() {
        return internalGetHeaders().getMap().size();
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      @java.lang.Override
      public boolean containsHeaders(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetHeaders().getMap().containsKey(key);
      }
      /**
       * Use {@link #getHeadersMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getHeaders() {
        return getHeadersMap();
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getHeadersMap() {
        return internalGetHeaders().getMap();
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      @java.lang.Override
      public /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getHeadersOrDefault(
          java.lang.String key,
          /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
            internalGetHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getHeadersOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
            internalGetHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }
      public Builder clearHeaders() {
        bitField0_ = (bitField0_ & ~0x00000020);
        internalGetMutableHeaders().getMutableMap()
            .clear();
        return this;
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      public Builder removeHeaders(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        internalGetMutableHeaders().getMutableMap()
            .remove(key);
        return this;
      }
      /**
       * Use alternate mutation accessors instead.
       */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          getMutableHeaders() {
        bitField0_ |= 0x00000020;
        return internalGetMutableHeaders().getMutableMap();
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      public Builder putHeaders(
          java.lang.String key,
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (key == null) { throw new NullPointerException("map key"); }
        if (value == null) { throw new NullPointerException("map value"); }
        internalGetMutableHeaders().getMutableMap()
            .put(key, value);
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * The header keys must be lowercase and use hyphen as the separator,
       * e.g. _x-request-id_.
       * Header values are case-sensitive and formatted as follows:
       * - `exact: "value"` for exact string match
       * - `prefix: "value"` for prefix-based match
       * - `regex: "value"` for ECMAscript style regex-based match
       * If the value is empty and only the name of header is specfied, presence of the header is checked.
       * **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; headers = 5;</code>
       */
      public Builder putAllHeaders(
          java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> values) {
        internalGetMutableHeaders().getMutableMap()
            .putAll(values);
        bitField0_ |= 0x00000020;
        return this;
      }

      private int port_ ;
      /**
       * <pre>
       * Specifies the ports on the host that is being addressed. Many services
       * only expose a single port or label ports with the protocols they support,
       * in these cases it is not required to explicitly select the port.
       * </pre>
       *
       * <code>uint32 port = 6;</code>
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }
      /**
       * <pre>
       * Specifies the ports on the host that is being addressed. Many services
       * only expose a single port or label ports with the protocols they support,
       * in these cases it is not required to explicitly select the port.
       * </pre>
       *
       * <code>uint32 port = 6;</code>
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {
        
        port_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the ports on the host that is being addressed. Many services
       * only expose a single port or label ports with the protocols they support,
       * in these cases it is not required to explicitly select the port.
       * </pre>
       *
       * <code>uint32 port = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000040);
        port_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
          java.lang.String, java.lang.String> sourceLabels_;
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetSourceLabels() {
        if (sourceLabels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              SourceLabelsDefaultEntryHolder.defaultEntry);
        }
        return sourceLabels_;
      }
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableSourceLabels() {
        if (sourceLabels_ == null) {
          sourceLabels_ = com.google.protobuf.MapField.newMapField(
              SourceLabelsDefaultEntryHolder.defaultEntry);
        }
        if (!sourceLabels_.isMutable()) {
          sourceLabels_ = sourceLabels_.copy();
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return sourceLabels_;
      }
      public int getSourceLabelsCount() {
        return internalGetSourceLabels().getMap().size();
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      @java.lang.Override
      public boolean containsSourceLabels(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetSourceLabels().getMap().containsKey(key);
      }
      /**
       * Use {@link #getSourceLabelsMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getSourceLabels() {
        return getSourceLabelsMap();
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getSourceLabelsMap() {
        return internalGetSourceLabels().getMap();
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      @java.lang.Override
      public /* nullable */
java.lang.String getSourceLabelsOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetSourceLabels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      @java.lang.Override
      public java.lang.String getSourceLabelsOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetSourceLabels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }
      public Builder clearSourceLabels() {
        bitField0_ = (bitField0_ & ~0x00000080);
        internalGetMutableSourceLabels().getMutableMap()
            .clear();
        return this;
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      public Builder removeSourceLabels(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        internalGetMutableSourceLabels().getMutableMap()
            .remove(key);
        return this;
      }
      /**
       * Use alternate mutation accessors instead.
       */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String>
          getMutableSourceLabels() {
        bitField0_ |= 0x00000080;
        return internalGetMutableSourceLabels().getMutableMap();
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      public Builder putSourceLabels(
          java.lang.String key,
          java.lang.String value) {
        if (key == null) { throw new NullPointerException("map key"); }
        if (value == null) { throw new NullPointerException("map value"); }
        internalGetMutableSourceLabels().getMutableMap()
            .put(key, value);
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it must include the reserved gateway
       * `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 7;</code>
       */
      public Builder putAllSourceLabels(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableSourceLabels().getMutableMap()
            .putAll(values);
        bitField0_ |= 0x00000080;
        return this;
      }

      private com.google.protobuf.LazyStringList gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureGatewaysIsMutable() {
        if (!((bitField0_ & 0x00000100) != 0)) {
          gateways_ = new com.google.protobuf.LazyStringArrayList(gateways_);
          bitField0_ |= 0x00000100;
         }
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @return A list containing the gateways.
       */
      public com.google.protobuf.ProtocolStringList
          getGatewaysList() {
        return gateways_.getUnmodifiableView();
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @return The count of gateways.
       */
      public int getGatewaysCount() {
        return gateways_.size();
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @param index The index of the element to return.
       * @return The gateways at the given index.
       */
      public java.lang.String getGateways(int index) {
        return gateways_.get(index);
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @param index The index of the value to return.
       * @return The bytes of the gateways at the given index.
       */
      public com.google.protobuf.ByteString
          getGatewaysBytes(int index) {
        return gateways_.getByteString(index);
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @param index The index to set the value at.
       * @param value The gateways to set.
       * @return This builder for chaining.
       */
      public Builder setGateways(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureGatewaysIsMutable();
        gateways_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @param value The gateways to add.
       * @return This builder for chaining.
       */
      public Builder addGateways(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureGatewaysIsMutable();
        gateways_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @param values The gateways to add.
       * @return This builder for chaining.
       */
      public Builder addAllGateways(
          java.lang.Iterable<java.lang.String> values) {
        ensureGatewaysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, gateways_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearGateways() {
        gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Names of gateways where the rule should be applied. Gateway names
       * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
       * match is independent of sourceLabels.
       * </pre>
       *
       * <code>repeated string gateways = 8;</code>
       * @param value The bytes of the gateways to add.
       * @return This builder for chaining.
       */
      public Builder addGatewaysBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureGatewaysIsMutable();
        gateways_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
          java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> queryParams_;
      private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          internalGetQueryParams() {
        if (queryParams_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              QueryParamsDefaultEntryHolder.defaultEntry);
        }
        return queryParams_;
      }
      private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          internalGetMutableQueryParams() {
        if (queryParams_ == null) {
          queryParams_ = com.google.protobuf.MapField.newMapField(
              QueryParamsDefaultEntryHolder.defaultEntry);
        }
        if (!queryParams_.isMutable()) {
          queryParams_ = queryParams_.copy();
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return queryParams_;
      }
      public int getQueryParamsCount() {
        return internalGetQueryParams().getMap().size();
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      @java.lang.Override
      public boolean containsQueryParams(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetQueryParams().getMap().containsKey(key);
      }
      /**
       * Use {@link #getQueryParamsMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getQueryParams() {
        return getQueryParamsMap();
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getQueryParamsMap() {
        return internalGetQueryParams().getMap();
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      @java.lang.Override
      public /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getQueryParamsOrDefault(
          java.lang.String key,
          /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
            internalGetQueryParams().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getQueryParamsOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
            internalGetQueryParams().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }
      public Builder clearQueryParams() {
        bitField0_ = (bitField0_ & ~0x00000200);
        internalGetMutableQueryParams().getMutableMap()
            .clear();
        return this;
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      public Builder removeQueryParams(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        internalGetMutableQueryParams().getMutableMap()
            .remove(key);
        return this;
      }
      /**
       * Use alternate mutation accessors instead.
       */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          getMutableQueryParams() {
        bitField0_ |= 0x00000200;
        return internalGetMutableQueryParams().getMutableMap();
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      public Builder putQueryParams(
          java.lang.String key,
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (key == null) { throw new NullPointerException("map key"); }
        if (value == null) { throw new NullPointerException("map value"); }
        internalGetMutableQueryParams().getMutableMap()
            .put(key, value);
        bitField0_ |= 0x00000200;
        return this;
      }
      /**
       * <pre>
       * Query parameters for matching.
       * Ex:
       * - For a query parameter like "?key=true", the map key would be "key" and
       *   the string match could be defined as `exact: "true"`.
       * - For a query parameter like "?key", the map key would be "key" and the
       *   string match could be defined as `exact: ""`.
       * - For a query parameter like "?key=123", the map key would be "key" and the
       *   string match could be defined as `regex: "&#92;d+$"`. Note that this
       *   configuration will only match values like "123" but not "a123" or "123a".
       * **Note:** `prefix` matching is currently not supported.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; query_params = 9;</code>
       */
      public Builder putAllQueryParams(
          java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> values) {
        internalGetMutableQueryParams().getMutableMap()
            .putAll(values);
        bitField0_ |= 0x00000200;
        return this;
      }

      private boolean ignoreUriCase_ ;
      /**
       * <pre>
       * Flag to specify whether the URI matching should be case-insensitive.
       * **Note:** The case will be ignored only in the case of `exact` and `prefix`
       * URI matches.
       * </pre>
       *
       * <code>bool ignore_uri_case = 10;</code>
       * @return The ignoreUriCase.
       */
      @java.lang.Override
      public boolean getIgnoreUriCase() {
        return ignoreUriCase_;
      }
      /**
       * <pre>
       * Flag to specify whether the URI matching should be case-insensitive.
       * **Note:** The case will be ignored only in the case of `exact` and `prefix`
       * URI matches.
       * </pre>
       *
       * <code>bool ignore_uri_case = 10;</code>
       * @param value The ignoreUriCase to set.
       * @return This builder for chaining.
       */
      public Builder setIgnoreUriCase(boolean value) {
        
        ignoreUriCase_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flag to specify whether the URI matching should be case-insensitive.
       * **Note:** The case will be ignored only in the case of `exact` and `prefix`
       * URI matches.
       * </pre>
       *
       * <code>bool ignore_uri_case = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearIgnoreUriCase() {
        bitField0_ = (bitField0_ & ~0x00000400);
        ignoreUriCase_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
          java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> withoutHeaders_;
      private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          internalGetWithoutHeaders() {
        if (withoutHeaders_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              WithoutHeadersDefaultEntryHolder.defaultEntry);
        }
        return withoutHeaders_;
      }
      private com.google.protobuf.MapField<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          internalGetMutableWithoutHeaders() {
        if (withoutHeaders_ == null) {
          withoutHeaders_ = com.google.protobuf.MapField.newMapField(
              WithoutHeadersDefaultEntryHolder.defaultEntry);
        }
        if (!withoutHeaders_.isMutable()) {
          withoutHeaders_ = withoutHeaders_.copy();
        }
        bitField0_ |= 0x00000800;
        onChanged();
        return withoutHeaders_;
      }
      public int getWithoutHeadersCount() {
        return internalGetWithoutHeaders().getMap().size();
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      @java.lang.Override
      public boolean containsWithoutHeaders(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetWithoutHeaders().getMap().containsKey(key);
      }
      /**
       * Use {@link #getWithoutHeadersMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getWithoutHeaders() {
        return getWithoutHeadersMap();
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> getWithoutHeadersMap() {
        return internalGetWithoutHeaders().getMap();
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      @java.lang.Override
      public /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getWithoutHeadersOrDefault(
          java.lang.String key,
          /* nullable */
istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
            internalGetWithoutHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch getWithoutHeadersOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> map =
            internalGetWithoutHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }
      public Builder clearWithoutHeaders() {
        bitField0_ = (bitField0_ & ~0x00000800);
        internalGetMutableWithoutHeaders().getMutableMap()
            .clear();
        return this;
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      public Builder removeWithoutHeaders(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        internalGetMutableWithoutHeaders().getMutableMap()
            .remove(key);
        return this;
      }
      /**
       * Use alternate mutation accessors instead.
       */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch>
          getMutableWithoutHeaders() {
        bitField0_ |= 0x00000800;
        return internalGetMutableWithoutHeaders().getMutableMap();
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      public Builder putWithoutHeaders(
          java.lang.String key,
          istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch value) {
        if (key == null) { throw new NullPointerException("map key"); }
        if (value == null) { throw new NullPointerException("map value"); }
        internalGetMutableWithoutHeaders().getMutableMap()
            .put(key, value);
        bitField0_ |= 0x00000800;
        return this;
      }
      /**
       * <pre>
       * withoutHeader has the same syntax with the header, but has opposite meaning.
       * If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
       * </pre>
       *
       * <code>map&lt;string, .istio.networking.v1alpha3.StringMatch&gt; without_headers = 12;</code>
       */
      public Builder putAllWithoutHeaders(
          java.util.Map<java.lang.String, istio.networking.v1alpha3.VirtualServiceOuterClass.StringMatch> values) {
        internalGetMutableWithoutHeaders().getMutableMap()
            .putAll(values);
        bitField0_ |= 0x00000800;
        return this;
      }

      private java.lang.Object sourceNamespace_ = "";
      /**
       * <pre>
       * Source namespace constraining the applicability of a rule to workloads in that namespace.
       * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
       * it must include the reserved gateway `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>string source_namespace = 13;</code>
       * @return The sourceNamespace.
       */
      public java.lang.String getSourceNamespace() {
        java.lang.Object ref = sourceNamespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceNamespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Source namespace constraining the applicability of a rule to workloads in that namespace.
       * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
       * it must include the reserved gateway `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>string source_namespace = 13;</code>
       * @return The bytes for sourceNamespace.
       */
      public com.google.protobuf.ByteString
          getSourceNamespaceBytes() {
        java.lang.Object ref = sourceNamespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sourceNamespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Source namespace constraining the applicability of a rule to workloads in that namespace.
       * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
       * it must include the reserved gateway `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>string source_namespace = 13;</code>
       * @param value The sourceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setSourceNamespace(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        sourceNamespace_ = value;
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Source namespace constraining the applicability of a rule to workloads in that namespace.
       * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
       * it must include the reserved gateway `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>string source_namespace = 13;</code>
       * @return This builder for chaining.
       */
      public Builder clearSourceNamespace() {
        sourceNamespace_ = getDefaultInstance().getSourceNamespace();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Source namespace constraining the applicability of a rule to workloads in that namespace.
       * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
       * it must include the reserved gateway `mesh` for this field to be applicable.
       * </pre>
       *
       * <code>string source_namespace = 13;</code>
       * @param value The bytes for sourceNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setSourceNamespaceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        sourceNamespace_ = value;
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.HTTPMatchRequest)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.HTTPMatchRequest)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HTTPMatchRequest>
        PARSER = new com.google.protobuf.AbstractParser<HTTPMatchRequest>() {
      @java.lang.Override
      public HTTPMatchRequest parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<HTTPMatchRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HTTPMatchRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPMatchRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface HTTPRouteDestinationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.HTTPRouteDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return Whether the destination field is set.
     */
    boolean hasDestination();
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The destination.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDestination();
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getDestinationOrBuilder();

    /**
     * <pre>
     * The proportion of traffic to be forwarded to the service
     * version. (0-100). Sum of weights across destinations SHOULD BE == 100.
     * If there is only one destination in a rule, the weight value is assumed to
     * be 100.
     * </pre>
     *
     * <code>int32 weight = 2;</code>
     * @return The weight.
     */
    int getWeight();

    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
     * @return Whether the headers field is set.
     */
    boolean hasHeaders();
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
     * @return The headers.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getHeaders();
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder getHeadersOrBuilder();
  }
  /**
   * <pre>
   * Each routing rule is associated with one or more service versions (see
   * glossary in beginning of document). Weights associated with the version
   * determine the proportion of traffic it receives. For example, the
   * following rule will route 25% of traffic for the "reviews" service to
   * instances with the "v2" tag and the remaining traffic (i.e., 75%) to
   * "v1".
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: reviews-route
   * spec:
   *   hosts:
   *   - reviews.prod.svc.cluster.local
   *   http:
   *   - route:
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v2
   *       weight: 25
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v1
   *       weight: 75
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: reviews-route
   * spec:
   *   hosts:
   *   - reviews.prod.svc.cluster.local
   *   http:
   *   - route:
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v2
   *       weight: 25
   *     - destination:
   *         host: reviews.prod.svc.cluster.local
   *         subset: v1
   *       weight: 75
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * And the associated DestinationRule
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: DestinationRule
   * metadata:
   *   name: reviews-destination
   * spec:
   *   host: reviews.prod.svc.cluster.local
   *   subsets:
   *   - name: v1
   *     labels:
   *       version: v1
   *   - name: v2
   *     labels:
   *       version: v2
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: DestinationRule
   * metadata:
   *   name: reviews-destination
   * spec:
   *   host: reviews.prod.svc.cluster.local
   *   subsets:
   *   - name: v1
   *     labels:
   *       version: v1
   *   - name: v2
   *     labels:
   *       version: v2
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * Traffic can also be split across two entirely different services without
   * having to define new subsets. For example, the following rule forwards 25% of
   * traffic to reviews.com to dev.reviews.com
   * {{&lt;tabset category-name="example"&gt;}}
   * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1alpha3
   * kind: VirtualService
   * metadata:
   *   name: reviews-route-two-domains
   * spec:
   *   hosts:
   *   - reviews.com
   *   http:
   *   - route:
   *     - destination:
   *         host: dev.reviews.com
   *       weight: 25
   *     - destination:
   *         host: reviews.com
   *       weight: 75
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
   * ```yaml
   * apiVersion: networking.istio.io/v1beta1
   * kind: VirtualService
   * metadata:
   *   name: reviews-route-two-domains
   * spec:
   *   hosts:
   *   - reviews.com
   *   http:
   *   - route:
   *     - destination:
   *         host: dev.reviews.com
   *       weight: 25
   *     - destination:
   *         host: reviews.com
   *       weight: 75
   * ```
   * {{&lt;/tab&gt;}}
   * {{&lt;/tabset&gt;}}
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.HTTPRouteDestination}
   */
  public static final class HTTPRouteDestination extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.HTTPRouteDestination)
      HTTPRouteDestinationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use HTTPRouteDestination.newBuilder() to construct.
    private HTTPRouteDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private HTTPRouteDestination() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new HTTPRouteDestination();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRouteDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRouteDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.class, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder.class);
    }

    public static final int DESTINATION_FIELD_NUMBER = 1;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Destination destination_;
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return Whether the destination field is set.
     */
    @java.lang.Override
    public boolean hasDestination() {
      return destination_ != null;
    }
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The destination.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDestination() {
      return destination_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
    }
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getDestinationOrBuilder() {
      return destination_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
    }

    public static final int WEIGHT_FIELD_NUMBER = 2;
    private int weight_ = 0;
    /**
     * <pre>
     * The proportion of traffic to be forwarded to the service
     * version. (0-100). Sum of weights across destinations SHOULD BE == 100.
     * If there is only one destination in a rule, the weight value is assumed to
     * be 100.
     * </pre>
     *
     * <code>int32 weight = 2;</code>
     * @return The weight.
     */
    @java.lang.Override
    public int getWeight() {
      return weight_;
    }

    public static final int HEADERS_FIELD_NUMBER = 7;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers headers_;
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
     * @return Whether the headers field is set.
     */
    @java.lang.Override
    public boolean hasHeaders() {
      return headers_ != null;
    }
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
     * @return The headers.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getHeaders() {
      return headers_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
    }
    /**
     * <pre>
     * Header manipulation rules
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder getHeadersOrBuilder() {
      return headers_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (destination_ != null) {
        output.writeMessage(1, getDestination());
      }
      if (weight_ != 0) {
        output.writeInt32(2, weight_);
      }
      if (headers_ != null) {
        output.writeMessage(7, getHeaders());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (destination_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getDestination());
      }
      if (weight_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, weight_);
      }
      if (headers_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getHeaders());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination other = (istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination) obj;

      if (hasDestination() != other.hasDestination()) return false;
      if (hasDestination()) {
        if (!getDestination()
            .equals(other.getDestination())) return false;
      }
      if (getWeight()
          != other.getWeight()) return false;
      if (hasHeaders() != other.hasHeaders()) return false;
      if (hasHeaders()) {
        if (!getHeaders()
            .equals(other.getHeaders())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDestination()) {
        hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getDestination().hashCode();
      }
      hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getWeight();
      if (hasHeaders()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getHeaders().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Each routing rule is associated with one or more service versions (see
     * glossary in beginning of document). Weights associated with the version
     * determine the proportion of traffic it receives. For example, the
     * following rule will route 25% of traffic for the "reviews" service to
     * instances with the "v2" tag and the remaining traffic (i.e., 75%) to
     * "v1".
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: reviews-route
     * spec:
     *   hosts:
     *   - reviews.prod.svc.cluster.local
     *   http:
     *   - route:
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v2
     *       weight: 25
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v1
     *       weight: 75
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: reviews-route
     * spec:
     *   hosts:
     *   - reviews.prod.svc.cluster.local
     *   http:
     *   - route:
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v2
     *       weight: 25
     *     - destination:
     *         host: reviews.prod.svc.cluster.local
     *         subset: v1
     *       weight: 75
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * And the associated DestinationRule
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: DestinationRule
     * metadata:
     *   name: reviews-destination
     * spec:
     *   host: reviews.prod.svc.cluster.local
     *   subsets:
     *   - name: v1
     *     labels:
     *       version: v1
     *   - name: v2
     *     labels:
     *       version: v2
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: DestinationRule
     * metadata:
     *   name: reviews-destination
     * spec:
     *   host: reviews.prod.svc.cluster.local
     *   subsets:
     *   - name: v1
     *     labels:
     *       version: v1
     *   - name: v2
     *     labels:
     *       version: v2
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * Traffic can also be split across two entirely different services without
     * having to define new subsets. For example, the following rule forwards 25% of
     * traffic to reviews.com to dev.reviews.com
     * {{&lt;tabset category-name="example"&gt;}}
     * {{&lt;tab name="v1alpha3" category-value="v1alpha3"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1alpha3
     * kind: VirtualService
     * metadata:
     *   name: reviews-route-two-domains
     * spec:
     *   hosts:
     *   - reviews.com
     *   http:
     *   - route:
     *     - destination:
     *         host: dev.reviews.com
     *       weight: 25
     *     - destination:
     *         host: reviews.com
     *       weight: 75
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;tab name="v1beta1" category-value="v1beta1"&gt;}}
     * ```yaml
     * apiVersion: networking.istio.io/v1beta1
     * kind: VirtualService
     * metadata:
     *   name: reviews-route-two-domains
     * spec:
     *   hosts:
     *   - reviews.com
     *   http:
     *   - route:
     *     - destination:
     *         host: dev.reviews.com
     *       weight: 25
     *     - destination:
     *         host: reviews.com
     *       weight: 75
     * ```
     * {{&lt;/tab&gt;}}
     * {{&lt;/tabset&gt;}}
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.HTTPRouteDestination}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.HTTPRouteDestination)
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRouteDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRouteDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.class, istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        destination_ = null;
        if (destinationBuilder_ != null) {
          destinationBuilder_.dispose();
          destinationBuilder_ = null;
        }
        weight_ = 0;
        headers_ = null;
        if (headersBuilder_ != null) {
          headersBuilder_.dispose();
          headersBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_HTTPRouteDestination_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination result = new istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.destination_ = destinationBuilder_ == null
              ? destination_
              : destinationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.weight_ = weight_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.headers_ = headersBuilder_ == null
              ? headers_
              : headersBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination.getDefaultInstance()) return this;
        if (other.hasDestination()) {
          mergeDestination(other.getDestination());
        }
        if (other.getWeight() != 0) {
          setWeight(other.getWeight());
        }
        if (other.hasHeaders()) {
          mergeHeaders(other.getHeaders());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getDestinationFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                weight_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 58: {
                input.readMessage(
                    getHeadersFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 58
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Destination destination_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder> destinationBuilder_;
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return Whether the destination field is set.
       */
      public boolean hasDestination() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return The destination.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDestination() {
        if (destinationBuilder_ == null) {
          return destination_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
        } else {
          return destinationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setDestination(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination value) {
        if (destinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          destination_ = value;
        } else {
          destinationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setDestination(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder builderForValue) {
        if (destinationBuilder_ == null) {
          destination_ = builderForValue.build();
        } else {
          destinationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder mergeDestination(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination value) {
        if (destinationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            destination_ != null &&
            destination_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance()) {
            getDestinationBuilder().mergeFrom(value);
          } else {
            destination_ = value;
          }
        } else {
          destinationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder clearDestination() {
        bitField0_ = (bitField0_ & ~0x00000001);
        destination_ = null;
        if (destinationBuilder_ != null) {
          destinationBuilder_.dispose();
          destinationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder getDestinationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDestinationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getDestinationOrBuilder() {
        if (destinationBuilder_ != null) {
          return destinationBuilder_.getMessageOrBuilder();
        } else {
          return destination_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
        }
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder> 
          getDestinationFieldBuilder() {
        if (destinationBuilder_ == null) {
          destinationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder>(
                  getDestination(),
                  getParentForChildren(),
                  isClean());
          destination_ = null;
        }
        return destinationBuilder_;
      }

      private int weight_ ;
      /**
       * <pre>
       * The proportion of traffic to be forwarded to the service
       * version. (0-100). Sum of weights across destinations SHOULD BE == 100.
       * If there is only one destination in a rule, the weight value is assumed to
       * be 100.
       * </pre>
       *
       * <code>int32 weight = 2;</code>
       * @return The weight.
       */
      @java.lang.Override
      public int getWeight() {
        return weight_;
      }
      /**
       * <pre>
       * The proportion of traffic to be forwarded to the service
       * version. (0-100). Sum of weights across destinations SHOULD BE == 100.
       * If there is only one destination in a rule, the weight value is assumed to
       * be 100.
       * </pre>
       *
       * <code>int32 weight = 2;</code>
       * @param value The weight to set.
       * @return This builder for chaining.
       */
      public Builder setWeight(int value) {
        
        weight_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The proportion of traffic to be forwarded to the service
       * version. (0-100). Sum of weights across destinations SHOULD BE == 100.
       * If there is only one destination in a rule, the weight value is assumed to
       * be 100.
       * </pre>
       *
       * <code>int32 weight = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearWeight() {
        bitField0_ = (bitField0_ & ~0x00000002);
        weight_ = 0;
        onChanged();
        return this;
      }

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Headers headers_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder> headersBuilder_;
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       * @return Whether the headers field is set.
       */
      public boolean hasHeaders() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       * @return The headers.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers getHeaders() {
        if (headersBuilder_ == null) {
          return headers_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
        } else {
          return headersBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      public Builder setHeaders(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          headers_ = value;
        } else {
          headersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      public Builder setHeaders(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder builderForValue) {
        if (headersBuilder_ == null) {
          headers_ = builderForValue.build();
        } else {
          headersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      public Builder mergeHeaders(istio.networking.v1alpha3.VirtualServiceOuterClass.Headers value) {
        if (headersBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            headers_ != null &&
            headers_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance()) {
            getHeadersBuilder().mergeFrom(value);
          } else {
            headers_ = value;
          }
        } else {
          headersBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      public Builder clearHeaders() {
        bitField0_ = (bitField0_ & ~0x00000004);
        headers_ = null;
        if (headersBuilder_ != null) {
          headersBuilder_.dispose();
          headersBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder getHeadersBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getHeadersFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder getHeadersOrBuilder() {
        if (headersBuilder_ != null) {
          return headersBuilder_.getMessageOrBuilder();
        } else {
          return headers_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.getDefaultInstance() : headers_;
        }
      }
      /**
       * <pre>
       * Header manipulation rules
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Headers headers = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Headers, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder> 
          getHeadersFieldBuilder() {
        if (headersBuilder_ == null) {
          headersBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Headers, istio.networking.v1alpha3.VirtualServiceOuterClass.Headers.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.HeadersOrBuilder>(
                  getHeaders(),
                  getParentForChildren(),
                  isClean());
          headers_ = null;
        }
        return headersBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.HTTPRouteDestination)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.HTTPRouteDestination)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HTTPRouteDestination>
        PARSER = new com.google.protobuf.AbstractParser<HTTPRouteDestination>() {
      @java.lang.Override
      public HTTPRouteDestination parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<HTTPRouteDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HTTPRouteDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.HTTPRouteDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RouteDestinationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.RouteDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return Whether the destination field is set.
     */
    boolean hasDestination();
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The destination.
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDestination();
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getDestinationOrBuilder();

    /**
     * <pre>
     * The proportion of traffic to be forwarded to the service
     * version. If there is only one destination in a rule, all traffic will be
     * routed to it irrespective of the weight.
     * </pre>
     *
     * <code>int32 weight = 2;</code>
     * @return The weight.
     */
    int getWeight();
  }
  /**
   * <pre>
   * L4 routing rule weighted destination.
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.RouteDestination}
   */
  public static final class RouteDestination extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.RouteDestination)
      RouteDestinationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use RouteDestination.newBuilder() to construct.
    private RouteDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private RouteDestination() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new RouteDestination();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_RouteDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_RouteDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.class, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder.class);
    }

    public static final int DESTINATION_FIELD_NUMBER = 1;
    private istio.networking.v1alpha3.VirtualServiceOuterClass.Destination destination_;
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return Whether the destination field is set.
     */
    @java.lang.Override
    public boolean hasDestination() {
      return destination_ != null;
    }
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return The destination.
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDestination() {
      return destination_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
    }
    /**
     * <pre>
     * Destination uniquely identifies the instances of a service
     * to which the request/connection should be forwarded to.
     * </pre>
     *
     * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getDestinationOrBuilder() {
      return destination_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
    }

    public static final int WEIGHT_FIELD_NUMBER = 2;
    private int weight_ = 0;
    /**
     * <pre>
     * The proportion of traffic to be forwarded to the service
     * version. If there is only one destination in a rule, all traffic will be
     * routed to it irrespective of the weight.
     * </pre>
     *
     * <code>int32 weight = 2;</code>
     * @return The weight.
     */
    @java.lang.Override
    public int getWeight() {
      return weight_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (destination_ != null) {
        output.writeMessage(1, getDestination());
      }
      if (weight_ != 0) {
        output.writeInt32(2, weight_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (destination_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getDestination());
      }
      if (weight_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, weight_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination other = (istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination) obj;

      if (hasDestination() != other.hasDestination()) return false;
      if (hasDestination()) {
        if (!getDestination()
            .equals(other.getDestination())) return false;
      }
      if (getWeight()
          != other.getWeight()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDestination()) {
        hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getDestination().hashCode();
      }
      hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getWeight();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * L4 routing rule weighted destination.
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.RouteDestination}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.RouteDestination)
        istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_RouteDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_RouteDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.class, istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        destination_ = null;
        if (destinationBuilder_ != null) {
          destinationBuilder_.dispose();
          destinationBuilder_ = null;
        }
        weight_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_RouteDestination_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination result = new istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.destination_ = destinationBuilder_ == null
              ? destination_
              : destinationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.weight_ = weight_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination.getDefaultInstance()) return this;
        if (other.hasDestination()) {
          mergeDestination(other.getDestination());
        }
        if (other.getWeight() != 0) {
          setWeight(other.getWeight());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getDestinationFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                weight_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private istio.networking.v1alpha3.VirtualServiceOuterClass.Destination destination_;
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder> destinationBuilder_;
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return Whether the destination field is set.
       */
      public boolean hasDestination() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       * @return The destination.
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination getDestination() {
        if (destinationBuilder_ == null) {
          return destination_ == null ? istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
        } else {
          return destinationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setDestination(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination value) {
        if (destinationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          destination_ = value;
        } else {
          destinationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder setDestination(
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder builderForValue) {
        if (destinationBuilder_ == null) {
          destination_ = builderForValue.build();
        } else {
          destinationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder mergeDestination(istio.networking.v1alpha3.VirtualServiceOuterClass.Destination value) {
        if (destinationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            destination_ != null &&
            destination_ != istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance()) {
            getDestinationBuilder().mergeFrom(value);
          } else {
            destination_ = value;
          }
        } else {
          destinationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public Builder clearDestination() {
        bitField0_ = (bitField0_ & ~0x00000001);
        destination_ = null;
        if (destinationBuilder_ != null) {
          destinationBuilder_.dispose();
          destinationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder getDestinationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDestinationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      public istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder getDestinationOrBuilder() {
        if (destinationBuilder_ != null) {
          return destinationBuilder_.getMessageOrBuilder();
        } else {
          return destination_ == null ?
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.getDefaultInstance() : destination_;
        }
      }
      /**
       * <pre>
       * Destination uniquely identifies the instances of a service
       * to which the request/connection should be forwarded to.
       * </pre>
       *
       * <code>.istio.networking.v1alpha3.Destination destination = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder> 
          getDestinationFieldBuilder() {
        if (destinationBuilder_ == null) {
          destinationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              istio.networking.v1alpha3.VirtualServiceOuterClass.Destination, istio.networking.v1alpha3.VirtualServiceOuterClass.Destination.Builder, istio.networking.v1alpha3.VirtualServiceOuterClass.DestinationOrBuilder>(
                  getDestination(),
                  getParentForChildren(),
                  isClean());
          destination_ = null;
        }
        return destinationBuilder_;
      }

      private int weight_ ;
      /**
       * <pre>
       * The proportion of traffic to be forwarded to the service
       * version. If there is only one destination in a rule, all traffic will be
       * routed to it irrespective of the weight.
       * </pre>
       *
       * <code>int32 weight = 2;</code>
       * @return The weight.
       */
      @java.lang.Override
      public int getWeight() {
        return weight_;
      }
      /**
       * <pre>
       * The proportion of traffic to be forwarded to the service
       * version. If there is only one destination in a rule, all traffic will be
       * routed to it irrespective of the weight.
       * </pre>
       *
       * <code>int32 weight = 2;</code>
       * @param value The weight to set.
       * @return This builder for chaining.
       */
      public Builder setWeight(int value) {
        
        weight_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The proportion of traffic to be forwarded to the service
       * version. If there is only one destination in a rule, all traffic will be
       * routed to it irrespective of the weight.
       * </pre>
       *
       * <code>int32 weight = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearWeight() {
        bitField0_ = (bitField0_ & ~0x00000002);
        weight_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:istio.networking.v1alpha3.RouteDestination)
    }

    // @@protoc_insertion_point(class_scope:istio.networking.v1alpha3.RouteDestination)
    private static final istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination();
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RouteDestination>
        PARSER = new com.google.protobuf.AbstractParser<RouteDestination>() {
      @java.lang.Override
      public RouteDestination parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<RouteDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RouteDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public istio.networking.v1alpha3.VirtualServiceOuterClass.RouteDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface L4MatchAttributesOrBuilder extends
      // @@protoc_insertion_point(interface_extends:istio.networking.v1alpha3.L4MatchAttributes)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @return A list containing the destinationSubnets.
     */
    java.util.List<java.lang.String>
        getDestinationSubnetsList();
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @return The count of destinationSubnets.
     */
    int getDestinationSubnetsCount();
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @param index The index of the element to return.
     * @return The destinationSubnets at the given index.
     */
    java.lang.String getDestinationSubnets(int index);
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the destinationSubnets at the given index.
     */
    com.google.protobuf.ByteString
        getDestinationSubnetsBytes(int index);

    /**
     * <pre>
     * Specifies the port on the host that is being addressed. Many services
     * only expose a single port or label ports with the protocols they support,
     * in these cases it is not required to explicitly select the port.
     * </pre>
     *
     * <code>uint32 port = 2;</code>
     * @return The port.
     */
    int getPort();

    /**
     * <pre>
     * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
     * form or just a.b.c.d
     * $hide_from_docs
     * </pre>
     *
     * <code>string source_subnet = 3;</code>
     * @return The sourceSubnet.
     */
    java.lang.String getSourceSubnet();
    /**
     * <pre>
     * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
     * form or just a.b.c.d
     * $hide_from_docs
     * </pre>
     *
     * <code>string source_subnet = 3;</code>
     * @return The bytes for sourceSubnet.
     */
    com.google.protobuf.ByteString
        getSourceSubnetBytes();

    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    int getSourceLabelsCount();
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    boolean containsSourceLabels(
        java.lang.String key);
    /**
     * Use {@link #getSourceLabelsMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String>
    getSourceLabels();
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    java.util.Map<java.lang.String, java.lang.String>
    getSourceLabelsMap();
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    /* nullable */
java.lang.String getSourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue);
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    java.lang.String getSourceLabelsOrThrow(
        java.lang.String key);

    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @return A list containing the gateways.
     */
    java.util.List<java.lang.String>
        getGatewaysList();
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @return The count of gateways.
     */
    int getGatewaysCount();
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @param index The index of the element to return.
     * @return The gateways at the given index.
     */
    java.lang.String getGateways(int index);
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the gateways at the given index.
     */
    com.google.protobuf.ByteString
        getGatewaysBytes(int index);

    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 6;</code>
     * @return The sourceNamespace.
     */
    java.lang.String getSourceNamespace();
    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 6;</code>
     * @return The bytes for sourceNamespace.
     */
    com.google.protobuf.ByteString
        getSourceNamespaceBytes();
  }
  /**
   * <pre>
   * L4 connection match attributes. Note that L4 connection matching support
   * is incomplete.
   * </pre>
   *
   * Protobuf type {@code istio.networking.v1alpha3.L4MatchAttributes}
   */
  public static final class L4MatchAttributes extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:istio.networking.v1alpha3.L4MatchAttributes)
      L4MatchAttributesOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use L4MatchAttributes.newBuilder() to construct.
    private L4MatchAttributes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private L4MatchAttributes() {
      destinationSubnets_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      sourceSubnet_ = "";
      gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      sourceNamespace_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new L4MatchAttributes();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_L4MatchAttributes_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 4:
          return internalGetSourceLabels();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_L4MatchAttributes_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.class, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder.class);
    }

    public static final int DESTINATION_SUBNETS_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList destinationSubnets_;
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @return A list containing the destinationSubnets.
     */
    public com.google.protobuf.ProtocolStringList
        getDestinationSubnetsList() {
      return destinationSubnets_;
    }
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @return The count of destinationSubnets.
     */
    public int getDestinationSubnetsCount() {
      return destinationSubnets_.size();
    }
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @param index The index of the element to return.
     * @return The destinationSubnets at the given index.
     */
    public java.lang.String getDestinationSubnets(int index) {
      return destinationSubnets_.get(index);
    }
    /**
     * <pre>
     * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
     * a.b.c.d/xx form or just a.b.c.d.
     * </pre>
     *
     * <code>repeated string destination_subnets = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the destinationSubnets at the given index.
     */
    public com.google.protobuf.ByteString
        getDestinationSubnetsBytes(int index) {
      return destinationSubnets_.getByteString(index);
    }

    public static final int PORT_FIELD_NUMBER = 2;
    private int port_ = 0;
    /**
     * <pre>
     * Specifies the port on the host that is being addressed. Many services
     * only expose a single port or label ports with the protocols they support,
     * in these cases it is not required to explicitly select the port.
     * </pre>
     *
     * <code>uint32 port = 2;</code>
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int SOURCE_SUBNET_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceSubnet_ = "";
    /**
     * <pre>
     * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
     * form or just a.b.c.d
     * $hide_from_docs
     * </pre>
     *
     * <code>string source_subnet = 3;</code>
     * @return The sourceSubnet.
     */
    @java.lang.Override
    public java.lang.String getSourceSubnet() {
      java.lang.Object ref = sourceSubnet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSubnet_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
     * form or just a.b.c.d
     * $hide_from_docs
     * </pre>
     *
     * <code>string source_subnet = 3;</code>
     * @return The bytes for sourceSubnet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSourceSubnetBytes() {
      java.lang.Object ref = sourceSubnet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sourceSubnet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_LABELS_FIELD_NUMBER = 4;
    private static final class SourceLabelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, java.lang.String> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, java.lang.String>newDefaultInstance(
                  istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_L4MatchAttributes_SourceLabelsEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "");
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> sourceLabels_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetSourceLabels() {
      if (sourceLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SourceLabelsDefaultEntryHolder.defaultEntry);
      }
      return sourceLabels_;
    }
    public int getSourceLabelsCount() {
      return internalGetSourceLabels().getMap().size();
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsSourceLabels(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetSourceLabels().getMap().containsKey(key);
    }
    /**
     * Use {@link #getSourceLabelsMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSourceLabels() {
      return getSourceLabelsMap();
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSourceLabelsMap() {
      return internalGetSourceLabels().getMap();
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */
java.lang.String getSourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetSourceLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * One or more labels that constrain the applicability of a rule to
     * workloads with the given labels. If the VirtualService has a list of
     * gateways specified in the top-level `gateways` field, it should include the reserved gateway
     * `mesh` in order for this field to be applicable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getSourceLabelsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetSourceLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int GATEWAYS_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList gateways_;
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @return A list containing the gateways.
     */
    public com.google.protobuf.ProtocolStringList
        getGatewaysList() {
      return gateways_;
    }
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @return The count of gateways.
     */
    public int getGatewaysCount() {
      return gateways_.size();
    }
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @param index The index of the element to return.
     * @return The gateways at the given index.
     */
    public java.lang.String getGateways(int index) {
      return gateways_.get(index);
    }
    /**
     * <pre>
     * Names of gateways where the rule should be applied. Gateway names
     * in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
     * match is independent of sourceLabels.
     * </pre>
     *
     * <code>repeated string gateways = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the gateways at the given index.
     */
    public com.google.protobuf.ByteString
        getGatewaysBytes(int index) {
      return gateways_.getByteString(index);
    }

    public static final int SOURCE_NAMESPACE_FIELD_NUMBER = 6;
    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceNamespace_ = "";
    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 6;</code>
     * @return The sourceNamespace.
     */
    @java.lang.Override
    public java.lang.String getSourceNamespace() {
      java.lang.Object ref = sourceNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceNamespace_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Source namespace constraining the applicability of a rule to workloads in that namespace.
     * If the VirtualService has a list of gateways specified in the top-level `gateways` field,
     * it must include the reserved gateway `mesh` for this field to be applicable.
     * </pre>
     *
     * <code>string source_namespace = 6;</code>
     * @return The bytes for sourceNamespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSourceNamespaceBytes() {
      java.lang.Object ref = sourceNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sourceNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < destinationSubnets_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, destinationSubnets_.getRaw(i));
      }
      if (port_ != 0) {
        output.writeUInt32(2, port_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceSubnet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceSubnet_);
      }
      com.google.protobuf.GeneratedMessageV3
        .serializeStringMapTo(
          output,
          internalGetSourceLabels(),
          SourceLabelsDefaultEntryHolder.defaultEntry,
          4);
      for (int i = 0; i < gateways_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, gateways_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNamespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sourceNamespace_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < destinationSubnets_.size(); i++) {
          dataSize += computeStringSizeNoTag(destinationSubnets_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDestinationSubnetsList().size();
      }
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, port_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceSubnet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceSubnet_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
           : internalGetSourceLabels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
        sourceLabels__ = SourceLabelsDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(4, sourceLabels__);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < gateways_.size(); i++) {
          dataSize += computeStringSizeNoTag(gateways_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGatewaysList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceNamespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sourceNamespace_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes)) {
        return super.equals(obj);
      }
      istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes other = (istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes) obj;

      if (!getDestinationSubnetsList()
          .equals(other.getDestinationSubnetsList())) return false;
      if (getPort()
          != other.getPort()) return false;
      if (!getSourceSubnet()
          .equals(other.getSourceSubnet())) return false;
      if (!internalGetSourceLabels().equals(
          other.internalGetSourceLabels())) return false;
      if (!getGatewaysList()
          .equals(other.getGatewaysList())) return false;
      if (!getSourceNamespace()
          .equals(other.getSourceNamespace())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDestinationSubnetsCount() > 0) {
        hash = (37 * hash) + DESTINATION_SUBNETS_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationSubnetsList().hashCode();
      }
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      hash = (37 * hash) + SOURCE_SUBNET_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSubnet().hashCode();
      if (!internalGetSourceLabels().getMap().isEmpty()) {
        hash = (37 * hash) + SOURCE_LABELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetSourceLabels().hashCode();
      }
      if (getGatewaysCount() > 0) {
        hash = (37 * hash) + GATEWAYS_FIELD_NUMBER;
        hash = (53 * hash) + getGatewaysList().hashCode();
      }
      hash = (37 * hash) + SOURCE_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceNamespace().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * L4 connection match attributes. Note that L4 connection matching support
     * is incomplete.
     * </pre>
     *
     * Protobuf type {@code istio.networking.v1alpha3.L4MatchAttributes}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:istio.networking.v1alpha3.L4MatchAttributes)
        istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_L4MatchAttributes_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(
          int number) {
        switch (number) {
          case 4:
            return internalGetSourceLabels();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(
          int number) {
        switch (number) {
          case 4:
            return internalGetMutableSourceLabels();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_L4MatchAttributes_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.class, istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.Builder.class);
      }

      // Construct using istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        destinationSubnets_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        port_ = 0;
        sourceSubnet_ = "";
        internalGetMutableSourceLabels().clear();
        gateways_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        sourceNamespace_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.internal_static_istio_networking_v1alpha3_L4MatchAttributes_descriptor;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes getDefaultInstanceForType() {
        return istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.getDefaultInstance();
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes build() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes buildPartial() {
        istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes result = new istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          destinationSubnets_ = destinationSubnets_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.destinationSubnets_ = destinationSubnets_;
        if (((bitField0_ & 0x00000010) != 0)) {
          gateways_ = gateways_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.gateways_ = gateways_;
      }

      private void buildPartial0(istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.port_ = port_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.sourceSubnet_ = sourceSubnet_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.sourceLabels_ = internalGetSourceLabels();
          result.sourceLabels_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.sourceNamespace_ = sourceNamespace_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes) {
          return mergeFrom((istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes other) {
        if (other == istio.networking.v1alpha3.VirtualServiceOuterClass.L4MatchAttributes.getDefaultInstance()) return this;
        if (!other.destinationSubnets_.isEmpty()) {
          if (destinationSubnets_.isEmpty()) {
            destinationSubnets_ = other.destinationSubnets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDestinationSubnetsIsMutable();
            destinationSubnets_.addAll(other.destinationSubnets_);
          }
          onChanged();
        }
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        if (!other.getSourceSubnet().isEmpty()) {
          sourceSubnet_ = other.sourceSubnet_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        internalGetMutableSourceLabels().mergeFrom(
            other.internalGetSourceLabels());
        bitField0_ |= 0x00000008;
        if (!other.gateways_.isEmpty()) {
          if (gateways_.isEmpty()) {
            gateways_ = other.gateways_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureGatewaysIsMutable();
            gateways_.addAll(other.gateways_);
          }
          onChanged();
        }
        if (!other.getSourceNamespace().isEmpty()) {
          sourceNamespace_ = other.sourceNamespace_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestinationSubnetsIsMutable();
                destinationSubnets_.add(s);
                break;
              } // case 10
              case 16: {
                port_ = input.readUInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 26: {
                sourceSubnet_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                sourceLabels__ = input.readMessage(
                    SourceLabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableSourceLabels().getMutableMap().put(
                    sourceLabels__.getKey(), sourceLabels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 42: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureGatewaysIsMutable();
                gateways_.add(s);
                break;
              } // case 42
              case 50: {
                sourceNamespace_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.LazyStringList destinationSubnets_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureDestinationSubnetsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          destinationSubnets_ = new com.google.protobuf.LazyStringArrayList(destinationSubnets_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @return A list containing the destinationSubnets.
       */
      public com.google.protobuf.ProtocolStringList
          getDestinationSubnetsList() {
        return destinationSubnets_.getUnmodifiableView();
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @return The count of destinationSubnets.
       */
      public int getDestinationSubnetsCount() {
        return destinationSubnets_.size();
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @param index The index of the element to return.
       * @return The destinationSubnets at the given index.
       */
      public java.lang.String getDestinationSubnets(int index) {
        return destinationSubnets_.get(index);
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @param index The index of the value to return.
       * @return The bytes of the destinationSubnets at the given index.
       */
      public com.google.protobuf.ByteString
          getDestinationSubnetsBytes(int index) {
        return destinationSubnets_.getByteString(index);
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @param index The index to set the value at.
       * @param value The destinationSubnets to set.
       * @return This builder for chaining.
       */
      public Builder setDestinationSubnets(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureDestinationSubnetsIsMutable();
        destinationSubnets_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @param value The destinationSubnets to add.
       * @return This builder for chaining.
       */
      public Builder addDestinationSubnets(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureDestinationSubnetsIsMutable();
        destinationSubnets_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @param values The destinationSubnets to add.
       * @return This builder for chaining.
       */
      public Builder addAllDestinationSubnets(
          java.lang.Iterable<java.lang.String> values) {
        ensureDestinationSubnetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, destinationSubnets_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearDestinationSubnets() {
        destinationSubnets_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
       * a.b.c.d/xx form or just a.b.c.d.
       * </pre>
       *
       * <code>repeated string destination_subnets = 1;</code>
       * @param value The bytes of the destinationSubnets to add.
       * @return This builder for chaining.
       */
      public Builder addDestinationSubnetsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureDestinationSubnetsIsMutable();
        destinationSubnets_.add(value);
        onChanged();
        return this;
      }

      private int port_ ;
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. Many services
       * only expose a single port or label ports with the protocols they support,
       * in these cases it is not required to explicitly select the port.
       * </pre>
       *
       * <code>uint32 port = 2;</code>
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. Many services
       * only expose a single port or label ports with the protocols they support,
       * in these cases it is not required to explicitly select the port.
       * </pre>
       *
       * <code>uint32 port = 2;</code>
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {
        
        port_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the port on the host that is being addressed. Many services
       * only expose a single port or label ports with the protocols they support,
       * in these cases it is not required to explicitly select the port.
       * </pre>
       *
       * <code>uint32 port = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000002);
        port_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object sourceSubnet_ = "";
      /**
       * <pre>
       * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
       * form or just a.b.c.d
       * $hide_from_docs
       * </pre>
       *
       * <code>string source_subnet = 3;</code>
       * @return The sourceSubnet.
       */
      public java.lang.String getSourceSubnet() {
        java.lang.Object ref = sourceSubnet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceSubnet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
       * form or just a.b.c.d
       * $hide_from_docs
       * </pre>
       *
       * <code>string source_subnet = 3;</code>
       * @return The bytes for sourceSubnet.
       */
      public com.google.protobuf.ByteString
          getSourceSubnetBytes() {
        java.lang.Object ref = sourceSubnet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sourceSubnet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
       * form or just a.b.c.d
       * $hide_from_docs
       * </pre>
       *
       * <code>string source_subnet = 3;</code>
       * @param value The sourceSubnet to set.
       * @return This builder for chaining.
       */
      public Builder setSourceSubnet(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        sourceSubnet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
       * form or just a.b.c.d
       * $hide_from_docs
       * </pre>
       *
       * <code>string source_subnet = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearSourceSubnet() {
        sourceSubnet_ = getDefaultInstance().getSourceSubnet();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
       * form or just a.b.c.d
       * $hide_from_docs
       * </pre>
       *
       * <code>string source_subnet = 3;</code>
       * @param value The bytes for sourceSubnet to set.
       * @return This builder for chaining.
       */
      public Builder setSourceSubnetBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        sourceSubnet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
          java.lang.String, java.lang.String> sourceLabels_;
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetSourceLabels() {
        if (sourceLabels_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              SourceLabelsDefaultEntryHolder.defaultEntry);
        }
        return sourceLabels_;
      }
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableSourceLabels() {
        if (sourceLabels_ == null) {
          sourceLabels_ = com.google.protobuf.MapField.newMapField(
              SourceLabelsDefaultEntryHolder.defaultEntry);
        }
        if (!sourceLabels_.isMutable()) {
          sourceLabels_ = sourceLabels_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return sourceLabels_;
      }
      public int getSourceLabelsCount() {
        return internalGetSourceLabels().getMap().size();
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it should include the reserved gateway
       * `mesh` in order for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 4;</code>
       */
      @java.lang.Override
      public boolean containsSourceLabels(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetSourceLabels().getMap().containsKey(key);
      }
      /**
       * Use {@link #getSourceLabelsMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getSourceLabels() {
        return getSourceLabelsMap();
      }
      /**
       * <pre>
       * One or more labels that constrain the applicability of a rule to
       * workloads with the given labels. If the VirtualService has a list of
       * gateways specified in the top-level `gateways` field, it should include the reserved gateway
       * `mesh` in order for this field to be applicable.
       * </pre>
       *
       * <code>map&lt;string, string&gt; source_labels = 4;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getSourceLabelsMap() {
        return internalGetSourceLabels().getMap();
      }
      /**
       * <pre>
       * One or more labels that c