package io.springboot.plugin.goview.common.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Entity
public class GoviewProject implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@TableId(type = IdType.ASSIGN_UUID)
	private String id;

	private String projectName;

	private Integer state;

	private LocalDateTime createTime;

	private String createUserId;

	private Integer isDelete;

	private String indexImage;

	private String remarks;

	@Transient
	@TableField(exist = false)
	private String content;

}
