package io.springboot.plugin.goview.common.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import org.hibernate.annotations.Type;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Entity
public class GoviewProjectData implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@TableId(type = IdType.ASSIGN_UUID)
	private String id;

	private String projectId;

	private LocalDateTime createTime;

	private String createUserId;

	@Lob
	@Basic(fetch = FetchType.LAZY)
	@Type(type = "org.hibernate.type.TextType")
	private String content;

}
