/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.plugin.goview.common.base;

import cn.hutool.core.util.StrUtil;
import io.springboot.plugin.goview.common.domain.AjaxResult;
import io.springboot.plugin.goview.common.domain.ResultTable;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
    }

    protected AjaxResult toAjax(int rows) {
        return rows > 0 ? this.success() : this.error();
    }

    public AjaxResult success() {
        return AjaxResult.success();
    }

    public AjaxResult error() {
        return AjaxResult.error();
    }

    public AjaxResult success(String message) {
        return AjaxResult.success(message);
    }

    public AjaxResult error(String message) {
        return AjaxResult.error(message);
    }

    public AjaxResult error(int code, String message) {
        return AjaxResult.error(code, message);
    }

    public AjaxResult retobject(int code, Object data) {
        return AjaxResult.successData(code, data);
    }

    public String redirect(String url) {
        return StrUtil.format((CharSequence)"redirect:{}", (Object[])new Object[]{url});
    }

    protected static ResultTable pageTable(Object data, long count) {
        return ResultTable.pageTable(count, data);
    }

    protected static ResultTable dataTable(Object data) {
        return ResultTable.dataTable(data);
    }

    protected static ResultTable treeTable(Object data) {
        return ResultTable.dataTable(data);
    }
}

