/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.sms.kit;

import com.aliyuncs.CommonResponse;
import com.google.gson.Gson;
import io.springboot.sms.core.SmsException;
import io.springboot.sms.core.SmsTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public final class Utils {
    private static final String SUCCESS_CODE = "OK";
    private static final String PHONE_NUMBER_REGEX = "\\d{5,}";

    public static int randomCode() {
        return 100000 + ThreadLocalRandom.current().nextInt(900000);
    }

    public static String toJsonStr(Map<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append('\"').append(entry.getKey().replace("\"", "\\\"")).append('\"').append(':').append('\"').append(entry.getValue().replace("\"", "\\\"")).append('\"').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }

    public static void checkSmsTemplate(SmsTemplate template) {
        Utils.checkNotEmpty(template.getSignName(), "SmsTemplate signName must be not empty");
        Utils.checkNotEmpty(template.getTemplateCode(), "SmsTemplate templateCode must be not empty");
        Utils.checkNotEmpty(template.getPhoneNumbers(), "SmsTemplate phoneNumbers must be not empty");
    }

    public static void checkSmsResponse(CommonResponse response) {
        if (null == response) {
            throw new SmsException("Response is null");
        }
        Gson gson = new Gson();
        Map json = (Map)gson.fromJson(response.getData(), Map.class);
        if (!SUCCESS_CODE.equalsIgnoreCase((String)json.get("Code"))) {
            throw new SmsException("Http status: " + response.getHttpStatus() + ", response: " + response.getData());
        }
    }

    public static void checkPhoneNumber(String ... phoneNumbers) {
        if (phoneNumbers.length == 0) {
            throw new IllegalArgumentException("Invalid phone size");
        }
        for (String phoneNumber : phoneNumbers) {
            if (phoneNumber.matches(PHONE_NUMBER_REGEX)) continue;
            throw new IllegalArgumentException("Invalid phone number " + phoneNumber);
        }
    }

    public static void checkNotEmpty(String str, String message) {
        if (null == str || str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotEmpty(Collection coll, String message) {
        if (null == coll || coll.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

