/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;

public class ParameterBuilder {
    private String name;
    private String description;
    private String defaultValue;
    private boolean required;
    private boolean allowMultiple;
    private AllowableValues allowableValues;
    private String paramType;
    private String paramAccess;
    private ResolvedType type;
    private ModelReference modelRef;

    ParameterBuilder from(Parameter other) {
        return this.name(other.getName()).allowableValues(other.getAllowableValues()).allowMultiple(other.isAllowMultiple()).defaultValue(other.getDefaultValue()).description(other.getDescription()).modelRef(other.getModelRef()).parameterAccess(other.getParamAccess()).parameterType(other.getParamType()).required(other.isRequired()).type((ResolvedType)other.getType().orNull());
    }

    public ParameterBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public ParameterBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ParameterBuilder defaultValue(String defaultValue) {
        this.defaultValue = BuilderDefaults.defaultIfAbsent(defaultValue, this.defaultValue);
        return this;
    }

    public ParameterBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public ParameterBuilder allowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
        return this;
    }

    public ParameterBuilder allowableValues(AllowableValues allowableValues) {
        this.allowableValues = BuilderDefaults.defaultIfAbsent(allowableValues, this.allowableValues);
        return this;
    }

    public ParameterBuilder parameterType(String paramType) {
        this.paramType = BuilderDefaults.defaultIfAbsent(paramType, this.paramType);
        return this;
    }

    public ParameterBuilder parameterAccess(String paramAccess) {
        this.paramAccess = BuilderDefaults.defaultIfAbsent(paramAccess, this.paramAccess);
        return this;
    }

    public ParameterBuilder type(ResolvedType type) {
        this.type = BuilderDefaults.defaultIfAbsent(type, this.type);
        return this;
    }

    public ParameterBuilder modelRef(ModelReference modelRef) {
        this.modelRef = BuilderDefaults.defaultIfAbsent(modelRef, this.modelRef);
        return this;
    }

    public Parameter build() {
        return new Parameter(this.name, this.description, this.defaultValue, this.required, this.allowMultiple, this.modelRef, (Optional<ResolvedType>)Optional.fromNullable((Object)this.type), this.allowableValues, this.paramType, this.paramAccess);
    }
}

