/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.collect.Maps;
import java.util.Map;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ResponseMessage;

public class ResponseMessageBuilder {
    private int code;
    private String message;
    private ModelReference responseModel;
    private Map<String, ModelReference> headers = Maps.newHashMap();

    public ResponseMessageBuilder code(int code) {
        this.code = code;
        return this;
    }

    public ResponseMessageBuilder message(String message) {
        this.message = BuilderDefaults.defaultIfAbsent(message, this.message);
        return this;
    }

    public ResponseMessageBuilder responseModel(ModelReference responseModel) {
        this.responseModel = BuilderDefaults.defaultIfAbsent(responseModel, this.responseModel);
        return this;
    }

    public ResponseMessageBuilder headers(Map<String, ModelReference> headers) {
        this.headers.putAll(BuilderDefaults.nullToEmptyMap(headers));
        return this;
    }

    public ResponseMessage build() {
        return new ResponseMessage(this.code, this.message, this.responseModel, this.headers);
    }
}

