/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tag;
import springfox.documentation.service.VendorExtension;

public class DocumentationBuilder {
    private String groupName;
    private Multimap<String, ApiListing> apiListings = TreeMultimap.create((Comparator)Ordering.natural(), DocumentationBuilder.byListingPosition());
    private ResourceListing resourceListing;
    private Set<Tag> tags = Sets.newLinkedHashSet();
    private String basePath;
    private Set<String> produces = Sets.newLinkedHashSet();
    private Set<String> consumes = Sets.newLinkedHashSet();
    private String host;
    private Set<String> schemes = Sets.newLinkedHashSet();
    private List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    public DocumentationBuilder name(String groupName) {
        this.groupName = BuilderDefaults.defaultIfAbsent(groupName, this.groupName);
        return this;
    }

    public DocumentationBuilder apiListingsByResourceGroupName(Multimap<String, ApiListing> apiListings) {
        this.apiListings.putAll(BuilderDefaults.nullToEmptyMultimap(apiListings));
        return this;
    }

    public DocumentationBuilder resourceListing(ResourceListing resourceListing) {
        this.resourceListing = BuilderDefaults.defaultIfAbsent(resourceListing, this.resourceListing);
        return this;
    }

    public DocumentationBuilder tags(Set<Tag> tags) {
        this.tags.addAll(BuilderDefaults.nullToEmptySet(tags));
        return this;
    }

    public DocumentationBuilder produces(Set<String> mediaTypes) {
        this.produces.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public DocumentationBuilder consumes(Set<String> mediaTypes) {
        this.consumes.addAll(BuilderDefaults.nullToEmptySet(mediaTypes));
        return this;
    }

    public DocumentationBuilder host(String host) {
        this.host = BuilderDefaults.defaultIfAbsent(host, this.host);
        return this;
    }

    public DocumentationBuilder schemes(Set<String> schemes) {
        this.schemes.addAll(BuilderDefaults.nullToEmptySet(schemes));
        return this;
    }

    public DocumentationBuilder basePath(String basePath) {
        this.basePath = BuilderDefaults.defaultIfAbsent(basePath, this.basePath);
        return this;
    }

    public DocumentationBuilder extensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public static Comparator<ApiListing> byListingPosition() {
        return new Comparator<ApiListing>(){

            @Override
            public int compare(ApiListing first, ApiListing second) {
                return first.getPosition() - second.getPosition();
            }
        };
    }

    public Documentation build() {
        return new Documentation(this.groupName, this.basePath, this.tags, this.apiListings, this.resourceListing, this.produces, this.consumes, this.host, this.schemes, this.vendorExtensions);
    }
}

