/*
 *
 *  Copyright 2016 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;

import java.util.Collection;
import java.util.List;

import static com.google.common.collect.Lists.*;

class EntitySchemaTemplate  {
  private final TypeResolver resolver;
  private final ResourceMappings mappings;
  private final RequestMappingInfo requestMapping;
  private final HandlerMethod handlerMethod;

  EntitySchemaTemplate(
      TypeResolver resolver,
      ResourceMappings mappings,
      RequestMappingInfo requestMapping,
      HandlerMethod handlerMethod) {
    this.resolver = resolver;
    this.mappings = mappings;
    this.requestMapping = requestMapping;
    this.handlerMethod = handlerMethod;
  }


  Collection<RequestHandler> operations() {
    List<RequestHandler> requestHandlers = newArrayList();
    for (ResourceMetadata resource : mappings) {

      requestHandlers.add(
          new EntitySchemaHandler(
              resolver,
              resource,
              requestMapping,
              handlerMethod));

    }
    return requestHandlers;
  }
}
