/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.EntitySchemaHandler;

class EntitySchemaTemplate {
    private final TypeResolver resolver;
    private final ResourceMappings mappings;
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    EntitySchemaTemplate(TypeResolver resolver, ResourceMappings mappings, RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.resolver = resolver;
        this.mappings = mappings;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    Collection<RequestHandler> operations() {
        ArrayList requestHandlers = Lists.newArrayList();
        for (ResourceMetadata resource : this.mappings) {
            requestHandlers.add(new EntitySchemaHandler(this.resolver, resource, this.requestMapping, this.handlerMethod));
        }
        return requestHandlers;
    }
}

