/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.hateoas.Resource;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.Java8OptionalToGuavaOptionalConverter;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

class EntityFindOneExtractor
implements EntityOperationsExtractor {
    EntityFindOneExtractor() {
    }

    @Override
    public List<RequestHandler> extract(EntityContext context) {
        ArrayList handlers = Lists.newArrayList();
        PersistentEntity<?, ?> entity = context.entity();
        CrudMethods crudMethods = context.crudMethods();
        TypeResolver resolver = context.getTypeResolver();
        RepositoryMetadata repository = context.getRepositoryMetadata();
        Method getFindOneMethod = crudMethods.getFindOneMethod();
        if (crudMethods.hasFindOneMethod()) {
            Java8OptionalToGuavaOptionalConverter converter = new Java8OptionalToGuavaOptionalConverter();
            Method actualFindOneMethod = (Method)converter.convert(getFindOneMethod).orNull();
            HandlerMethod handler = new HandlerMethod(context.getRepositoryInstance(), actualFindOneMethod);
            ActionSpecification spec = new ActionSpecification(RequestExtractionUtils.actionName(entity, actualFindOneMethod), String.format("%s%s/{id}", context.basePath(), context.resourcePath()), Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.GET}), new HashSet<MediaType>(), new HashSet<MediaType>(), handler, Lists.newArrayList((Object[])new ResolvedMethodParameter[]{new ResolvedMethodParameter(0, "id", RequestExtractionUtils.pathAnnotations("id", handler), resolver.resolve((Type)repository.getIdType(), new Type[0]))}), resolver.resolve(Resource.class, new Type[]{repository.getReturnedDomainClass(handler.getMethod())}));
            handlers.add(new SpringDataRestRequestHandler(context, spec));
        }
        return handlers;
    }
}

