/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.Resources;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.SyntheticModelProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spring.data.rest.schema.EmbeddedCollection;

class EmbeddedCollectionModelProvider
implements SyntheticModelProviderPlugin {
    private final TypeResolver resolver;
    private final RelProvider relProvider;
    private final TypeNameExtractor typeNameExtractor;

    EmbeddedCollectionModelProvider(TypeResolver resolver, RelProvider relProvider, TypeNameExtractor typeNameExtractor) {
        this.resolver = resolver;
        this.relProvider = relProvider;
        this.typeNameExtractor = typeNameExtractor;
    }

    public Model create(ModelContext context) {
        ResolvedType resourceType = this.resolver.resolve(context.getType(), new Type[0]);
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        String name = this.typeNameExtractor.typeName(context);
        return context.getBuilder().description(String.format("Embedded collection of %s", type.getSimpleName())).name(name).id(name).qualifiedType(type.getName()).type((ResolvedType)typeParameters.get(0)).properties((Map)Maps.uniqueIndex(this.properties(context), this.byName())).xml(new Xml().wrapped(Boolean.valueOf(true)).name("content")).build();
    }

    public List<ModelProperty> properties(ModelContext context) {
        ResolvedType resourceType = this.resolver.resolve(context.getType(), new Type[0]);
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        return Lists.newArrayList((Object[])new ModelProperty[]{new ModelPropertyBuilder().name(this.relProvider.getCollectionResourceRelFor(type)).type(this.resolver.resolve(List.class, new Type[]{type})).qualifiedType(Resources.class.getName()).position(0).required(Boolean.valueOf(true)).isHidden(Boolean.valueOf(false)).description("Resource collection").build().updateModelRef(ResolvedTypes.modelRefFactory((ModelContext)context, (TypeNameExtractor)this.typeNameExtractor))});
    }

    public Set<ResolvedType> dependencies(ModelContext context) {
        ResolvedType resourceType = this.resolver.resolve(context.getType(), new Type[0]);
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        return Sets.newHashSet((Object[])new ResolvedType[]{this.resolver.resolve((Type)type, new Type[0])});
    }

    public boolean supports(ModelContext delimiter) {
        return EmbeddedCollection.class.equals((Object)this.resolver.resolve(delimiter.getType(), new Type[0]).getErasedType()) && delimiter.getDocumentationType() == DocumentationType.SWAGGER_2;
    }

    private Function<ModelProperty, String> byName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }
}

