/*
 * Decompiled with CFR 0.152.
 */
package springfox.petstore.webflux.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import java.util.Objects;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import springfox.petstore.webflux.Responses;
import springfox.petstore.webflux.controller.NotFoundException;
import springfox.petstore.webflux.model.Pet;
import springfox.petstore.webflux.repository.MapBackedRepository;

@Controller
@RequestMapping(value={"/api/pet"}, produces={"application/json", "application/xml"})
@Api(value="/pet", description="Operations about pets")
public class PetController {
    private static final String WRITE_PETS = "write:pets";
    private static final String READ_PETS = "read:pets";
    private static final String PETSTORE_AUTH = "petstore_auth";
    private PetRepository petData = new PetRepository();

    @RequestMapping(value={"/{petId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Find pet by ID", notes="Returns a pet when ID < 10. ID > 10 or non-integers will simulate API error conditions", response=Pet.class, responseHeaders={@ResponseHeader(name="header4", response=String.class), @ResponseHeader(name="header3", response=String.class)}, authorizations={@Authorization(value="api_key"), @Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ID supplied", responseHeaders={@ResponseHeader(name="header2", response=String.class), @ResponseHeader(name="header1", response=String.class)}), @ApiResponse(code=404, message="Pet not found")})
    public Mono<ResponseEntity<Pet>> getPetById(@ApiParam(value="ID of pet that needs to be fetched", allowableValues="range[1,5]", required=true) @PathVariable(value="petId") String petId) throws NotFoundException {
        Pet pet = (Pet)this.petData.get(Long.valueOf(petId));
        if (null != pet) {
            return Mono.just(Responses.ok(pet));
        }
        throw new NotFoundException(404, "Pet not found");
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="Add a new pet to the store", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=405, message="Invalid input")})
    public Mono<ResponseEntity<String>> addPet(@ApiParam(value="Pet object that needs to be added to the store", required=true) @RequestBody Pet pet) {
        this.petData.add(pet);
        return Mono.just(Responses.ok("SUCCESS"));
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="Update an existing pet", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ID supplied"), @ApiResponse(code=404, message="Pet not found"), @ApiResponse(code=405, message="Validation exception")})
    public Mono<ResponseEntity<String>> updatePet(@ApiParam(value="Pet object that needs to be added to the store", required=true) @RequestBody Pet pet) {
        this.petData.add(pet);
        return Mono.just(Responses.ok("SUCCESS"));
    }

    @RequestMapping(value={"/findByStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="Finds Pets by status", notes="Multiple status values can be provided with comma-separated strings", response=Pet.class, responseContainer="List", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid status value")})
    public Mono<ResponseEntity<List<Pet>>> findPetsByStatus(@ApiParam(value="Status values that need to be considered for filter", required=true, defaultValue="available", allowableValues="available,pending,sold", allowMultiple=true) @RequestParam(value="status") String status) {
        return Mono.just(Responses.ok(this.petData.findPetByStatus(status)));
    }

    @RequestMapping(value={"/findByTags"}, method={RequestMethod.GET})
    @ApiOperation(value="Finds Pets by tags", notes="Multiple tags can be provided with comma-separated strings. Use tag1, tag2, tag3 for testing.", response=Pet.class, responseContainer="List", authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tag value")})
    @Deprecated
    public Flux<Pet> findPetsByTags(@ApiParam(value="Tags to filter by", required=true, allowMultiple=true) @RequestParam(value="tags") String tags) {
        return Flux.fromIterable(this.petData.findPetByTags(tags));
    }

    @RequestMapping(value={"/findPetsHidden"}, method={RequestMethod.GET})
    @ApiOperation(value="Finds Pets (hidden)", notes="Hidden method", response=Pet.class, responseContainer="List", hidden=true, authorizations={@Authorization(value="petstore_auth", scopes={@AuthorizationScope(scope="write:pets", description=""), @AuthorizationScope(scope="read:pets", description="")})})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid tag value")})
    public Mono<ResponseEntity<List<Pet>>> findPetsHidden(@ApiParam(value="Tags to filter by", required=true, allowMultiple=true) @RequestParam(value="tags") String tags) {
        return Mono.just(Responses.ok(this.petData.findPetByTags(tags)));
    }

    static class PetRepository
    extends MapBackedRepository<Long, Pet> {
        PetRepository() {
        }

        List<Pet> findPetByStatus(String status) {
            return this.where(input -> Objects.equals(input.getStatus(), status));
        }

        List<Pet> findPetByTags(String tags) {
            return this.where(input -> input.getTags().stream().anyMatch(input1 -> Objects.equals(input1.getName(), tags)));
        }
    }
}

