/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="default")
public class DefaultModelDependencyProvider
implements ModelDependencyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModelDependencyProvider.class);
    private final TypeResolver typeResolver;
    private final ModelPropertiesProvider propertiesProvider;
    private final TypeNameExtractor nameExtractor;

    @Autowired
    public DefaultModelDependencyProvider(TypeResolver typeResolver, @Qualifier(value="cachedModelProperties") ModelPropertiesProvider propertiesProvider, TypeNameExtractor nameExtractor) {
        this.typeResolver = typeResolver;
        this.propertiesProvider = propertiesProvider;
        this.nameExtractor = nameExtractor;
    }

    @Override
    public Set<ResolvedType> dependentModels(ModelContext modelContext) {
        return FluentIterable.from(this.resolvedDependencies(modelContext)).filter(this.ignorableTypes(modelContext)).filter(Predicates.not(this.baseTypes(modelContext))).toSet();
    }

    private Predicate<ResolvedType> baseTypes(final ModelContext modelContext) {
        return new Predicate<ResolvedType>(){

            public boolean apply(ResolvedType resolvedType) {
                return DefaultModelDependencyProvider.this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType));
            }
        };
    }

    private boolean isBaseType(ModelContext modelContext) {
        String typeName = this.nameExtractor.typeName(modelContext);
        return Types.isBaseType(typeName);
    }

    private Predicate<ResolvedType> ignorableTypes(final ModelContext modelContext) {
        return new Predicate<ResolvedType>(){

            public boolean apply(ResolvedType input) {
                return !modelContext.hasSeenBefore(input);
            }
        };
    }

    private List<ResolvedType> resolvedDependencies(ModelContext modelContext) {
        ResolvedType resolvedType = modelContext.alternateFor(modelContext.resolvedType(this.typeResolver));
        if (this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType))) {
            LOG.debug("Marking base type {} as seen", (Object)resolvedType.getSignature());
            modelContext.seen(resolvedType);
            return Lists.newArrayList();
        }
        ArrayList dependencies = Lists.newArrayList(this.resolvedTypeParameters(modelContext, resolvedType));
        dependencies.addAll(this.resolvedPropertiesAndFields(modelContext, resolvedType));
        return dependencies;
    }

    private List<? extends ResolvedType> resolvedTypeParameters(ModelContext modelContext, ResolvedType resolvedType) {
        ArrayList parameters = Lists.newArrayList();
        for (ResolvedType parameter : resolvedType.getTypeParameters()) {
            LOG.debug("Adding type for parameter {}", (Object)parameter.getSignature());
            parameters.add(modelContext.alternateFor(parameter));
            LOG.debug("Recursively resolving dependencies for parameter {}", (Object)parameter.getSignature());
            parameters.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)parameter)));
        }
        return parameters;
    }

    private List<ResolvedType> resolvedPropertiesAndFields(ModelContext modelContext, ResolvedType resolvedType) {
        if (modelContext.hasSeenBefore(resolvedType) || resolvedType.getErasedType().isEnum()) {
            return Lists.newArrayList();
        }
        modelContext.seen(resolvedType);
        ArrayList properties = Lists.newArrayList();
        for (ModelProperty property : this.nonTrivialProperties(modelContext, resolvedType)) {
            LOG.debug("Adding type {} for parameter {}", (Object)property.getType().getSignature(), (Object)property.getName());
            properties.add(property.getType());
            properties.addAll(this.maybeFromCollectionElementType(modelContext, property));
            properties.addAll(this.maybeFromMapValueType(modelContext, property));
            properties.addAll(this.maybeFromRegularType(modelContext, property));
        }
        return properties;
    }

    private FluentIterable<ModelProperty> nonTrivialProperties(ModelContext modelContext, ResolvedType resolvedType) {
        return FluentIterable.from(this.propertiesFor(modelContext, resolvedType)).filter(Predicates.not(this.baseProperty(modelContext)));
    }

    private Predicate<? super ModelProperty> baseProperty(final ModelContext modelContext) {
        return new Predicate<ModelProperty>(){

            public boolean apply(ModelProperty input) {
                return DefaultModelDependencyProvider.this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)input.getType()));
            }
        };
    }

    private List<ResolvedType> maybeFromRegularType(ModelContext modelContext, ModelProperty property) {
        if (Collections.isContainerType(property.getType()) || Maps.isMapType(property.getType())) {
            return Lists.newArrayList();
        }
        LOG.debug("Recursively resolving dependencies for type {}", ResolvedTypes.resolvedTypeSignature(property.getType()).or((Object)"<null>"));
        return Lists.newArrayList(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)property.getType())));
    }

    private List<ResolvedType> maybeFromCollectionElementType(ModelContext modelContext, ModelProperty property) {
        ArrayList dependencies = Lists.newArrayList();
        if (Collections.isContainerType(property.getType())) {
            ResolvedType collectionElementType = Collections.collectionElementType(property.getType());
            String resolvedTypeSignature = (String)ResolvedTypes.resolvedTypeSignature(collectionElementType).or((Object)"<null>");
            if (!this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType))) {
                LOG.debug("Adding collectionElement type {}", (Object)resolvedTypeSignature);
                dependencies.add(collectionElementType);
            }
            LOG.debug("Recursively resolving dependencies for collectionElement type {}", (Object)resolvedTypeSignature);
            dependencies.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType)));
        }
        return dependencies;
    }

    private List<ResolvedType> maybeFromMapValueType(ModelContext modelContext, ModelProperty property) {
        ArrayList dependencies = Lists.newArrayList();
        if (Maps.isMapType(property.getType())) {
            ResolvedType valueType = Maps.mapValueType(property.getType());
            String resolvedTypeSignature = (String)ResolvedTypes.resolvedTypeSignature(valueType).or((Object)"<null>");
            if (!this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)valueType))) {
                LOG.debug("Adding value type {}", (Object)resolvedTypeSignature);
                dependencies.add(valueType);
            }
            LOG.debug("Recursively resolving dependencies for value type {}", (Object)resolvedTypeSignature);
            dependencies.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)valueType)));
        }
        return dependencies;
    }

    private List<ModelProperty> propertiesFor(ModelContext modelContext, ResolvedType resolvedType) {
        return this.propertiesProvider.propertiesFor(resolvedType, modelContext);
    }
}

