/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.fasterxml.classmate.ResolvedType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class OperationModelContextsBuilder {
    private final String group;
    private final DocumentationType documentationType;
    private final String requestMappingId;
    private final AlternateTypeProvider alternateTypeProvider;
    private final GenericTypeNamingStrategy genericsNamingStrategy;
    private final Set<Class> ignorableTypes;
    private final Set<ModelContext> contexts = new HashSet<ModelContext>();
    private int parameterIndex = 0;

    public OperationModelContextsBuilder(String group, DocumentationType documentationType, String requestMappingId, AlternateTypeProvider alternateTypeProvider, GenericTypeNamingStrategy genericsNamingStrategy, Set<Class> ignorableParameterTypes) {
        this.group = group;
        this.documentationType = documentationType;
        this.requestMappingId = requestMappingId;
        this.alternateTypeProvider = alternateTypeProvider;
        this.genericsNamingStrategy = genericsNamingStrategy;
        this.ignorableTypes = ignorableParameterTypes;
    }

    public ModelContext addReturn(ResolvedType type) {
        return this.addReturn(type, Optional.empty());
    }

    public ModelContext addReturn(ResolvedType type, Optional<ResolvedType> view) {
        ModelContext returnValue = ModelContext.returnValue(String.format("%s_%s", this.requestMappingId, this.parameterIndex), this.group, type, view, this.documentationType, this.alternateTypeProvider, this.genericsNamingStrategy, this.ignorableTypes);
        if (this.contexts.add(returnValue)) {
            ++this.parameterIndex;
            return returnValue;
        }
        return this.contexts.stream().filter(context -> context.equals(returnValue)).findFirst().get();
    }

    public ModelContext addInputParam(ResolvedType type) {
        return this.addInputParam(type, Optional.empty(), new HashSet<ResolvedType>());
    }

    public ModelContext addInputParam(ResolvedType type, Optional<ResolvedType> view, Set<ResolvedType> validationGroups) {
        validationGroups = new HashSet<ResolvedType>(validationGroups);
        ModelContext inputParam = ModelContext.inputParam(String.format("%s_%s", this.requestMappingId, this.parameterIndex), this.group, type, view, validationGroups, this.documentationType, this.alternateTypeProvider, this.genericsNamingStrategy, this.ignorableTypes);
        if (this.contexts.add(inputParam)) {
            ++this.parameterIndex;
            return inputParam;
        }
        return this.contexts.stream().filter(context -> context.equals(inputParam)).findFirst().get();
    }

    public Set<ModelContext> build() {
        Comparator<ModelContext> byParameterId = Comparator.comparing(ModelContext::getParameterId);
        Supplier<TreeSet> supplier = () -> new TreeSet(byParameterId);
        return this.contexts.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(supplier), Collections::unmodifiableSet));
    }
}

