/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.WebFluxRequestHandler;
import springfox.documentation.spring.web.plugins.SpringIntegrationParametersProvider;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class SpringIntegrationWebFluxRequestHandler
extends WebFluxRequestHandler {
    private final HandlerMethodResolver methodResolver;
    private final HandlerMethod handlerMethod;
    private final SpringIntegrationParametersProvider parametersProvider;

    public SpringIntegrationWebFluxRequestHandler(HandlerMethodResolver methodResolver, RequestMappingInfo requestMapping, HandlerMethod handlerMethod, SpringIntegrationParametersProvider parametersProvider) {
        super(methodResolver, requestMapping, handlerMethod);
        this.methodResolver = methodResolver;
        this.handlerMethod = handlerMethod;
        this.parametersProvider = parametersProvider;
    }

    public String groupName() {
        return ControllerNamingUtils.controllerNameAsGroup((HandlerMethod)this.handlerMethod);
    }

    public String getName() {
        return ((BaseHttpInboundEndpoint)this.handlerMethod.getBean()).getComponentName();
    }

    public ResolvedType getReturnType() {
        return this.methodResolver.methodReturnType(this.handlerMethod);
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.parametersProvider.getParameters((BaseHttpInboundEndpoint)this.handlerMethod.getBean());
    }
}

