/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.integration.http.inbound.IntegrationRequestMappingHandlerMapping;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.SpringIntegrationWebMvcRequestHandler;
import springfox.documentation.spring.web.plugins.SpringIntegrationParametersProvider;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

@Component
@Order
public class SpringIntegrationWebMvcRequestHandlerProvider
implements RequestHandlerProvider {
    private final List<IntegrationRequestMappingHandlerMapping> handlerMappings;
    private final HandlerMethodResolver methodResolver;
    private final String contextPath;
    private SpringIntegrationParametersProvider parametersProvider;

    @Autowired
    public SpringIntegrationWebMvcRequestHandlerProvider(Optional<ServletContext> servletContext, HandlerMethodResolver methodResolver, List<IntegrationRequestMappingHandlerMapping> handlerMappings, SpringIntegrationParametersProvider parametersProvider) {
        this.handlerMappings = handlerMappings;
        this.methodResolver = methodResolver;
        this.parametersProvider = parametersProvider;
        this.contextPath = servletContext.map(ServletContext::getContextPath).orElse("/");
    }

    public List<RequestHandler> requestHandlers() {
        return BuilderDefaults.nullToEmptyList(this.handlerMappings).stream().map(this.toMappingEntries()).flatMap(Collection::stream).map(this.toRequestHandler()).sorted(Orderings.byPatternsCondition()).collect(Collectors.toList());
    }

    private Function<IntegrationRequestMappingHandlerMapping, Set<Map.Entry<RequestMappingInfo, HandlerMethod>>> toMappingEntries() {
        return input -> {
            Map handlerMethods = input.getHandlerMethods();
            return handlerMethods.entrySet();
        };
    }

    private Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler> toRequestHandler() {
        return input -> new SpringIntegrationWebMvcRequestHandler(this.contextPath, this.methodResolver, (RequestMappingInfo)input.getKey(), (HandlerMethod)input.getValue(), this.parametersProvider);
    }
}

