/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.github.classgraph.utils.ReflectionUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriTemplate;
import springfox.documentation.service.ResolvedMethodParameter;

@Component
public class SpringIntegrationParametersProvider {
    private static final String REQUEST_PARAMS_EXPRESSION_CONTEXT_VARIABLE = "#requestParams";
    private static final String FIELD_PAYLOAD_EXPRESSION = "payloadExpression";
    private static final String FIELD_HEADER_EXPRESSIONS = "headerExpressions";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final TypeResolver typeResolver = new TypeResolver();

    public List<ResolvedMethodParameter> getParameters(BaseHttpInboundEndpoint inboundEndpoint) {
        ArrayList<ResolvedMethodParameter> parameters = new ArrayList<ResolvedMethodParameter>();
        parameters.addAll(this.addRequestBodyParam(inboundEndpoint));
        parameters.addAll(this.addPathVariableParams(inboundEndpoint));
        parameters.addAll(this.addRequestParamParams(inboundEndpoint));
        return parameters;
    }

    private List<ResolvedMethodParameter> addRequestBodyParam(BaseHttpInboundEndpoint inboundEndpoint) {
        ArrayList<ResolvedMethodParameter> parameters = new ArrayList<ResolvedMethodParameter>();
        ResolvableType requestPayloadType = (ResolvableType)ReflectionUtils.getFieldVal((Object)inboundEndpoint, (String)"requestPayloadType", (boolean)true);
        if (requestPayloadType != null) {
            ResolvedType parameterType = this.typeResolver.resolve(requestPayloadType.getType(), new Type[0]);
            HashMap requestBodyAttributes = new HashMap();
            RequestBody requestBodyAnnotation = (RequestBody)AnnotationUtils.synthesizeAnnotation(requestBodyAttributes, RequestBody.class, null);
            ResolvedMethodParameter body = new ResolvedMethodParameter(0, "body", Collections.singletonList(requestBodyAnnotation), parameterType);
            parameters.add(body);
        }
        return parameters;
    }

    private List<ResolvedMethodParameter> addPathVariableParams(BaseHttpInboundEndpoint inboundEndpoint) {
        return Stream.of(inboundEndpoint.getRequestMapping().getPathPatterns()).map(pattern -> new UriTemplate(pattern).getVariableNames()).flatMap(Collection::stream).map(variableName -> new ResolvedMethodParameter(0, variableName, Collections.singletonList(AnnotationUtils.synthesizeAnnotation(Collections.emptyMap(), PathVariable.class, null)), this.typeResolver.resolve(String.class, new Type[0]))).collect(Collectors.toList());
    }

    private List<ResolvedMethodParameter> addRequestParamParams(BaseHttpInboundEndpoint inboundEndpoint) {
        Map headerExpressions;
        ArrayList<ResolvedMethodParameter> parameters = new ArrayList<ResolvedMethodParameter>();
        Expression payloadExpression = (Expression)ReflectionUtils.getFieldVal((Object)inboundEndpoint, (String)FIELD_PAYLOAD_EXPRESSION, (boolean)true);
        if (payloadExpression != null) {
            this.extractRequestParam(payloadExpression, this.typeResolver).ifPresent(parameters::add);
        }
        if ((headerExpressions = (Map)ReflectionUtils.getFieldVal((Object)inboundEndpoint, (String)FIELD_HEADER_EXPRESSIONS, (boolean)true)) != null) {
            for (Expression headerExpression : headerExpressions.values()) {
                this.extractRequestParam(headerExpression, this.typeResolver).ifPresent(parameters::add);
            }
        }
        return parameters;
    }

    private Optional<ResolvedMethodParameter> extractRequestParam(Expression expression, TypeResolver typeResolver) {
        ResolvedMethodParameter ret = null;
        String expressionString = expression.getExpressionString();
        SpelExpression spelExpression = this.parser.parseRaw(expressionString);
        SpelNode ast = spelExpression.getAST();
        SpelNode firstChild = ast.getChild(0);
        if (firstChild != null && REQUEST_PARAMS_EXPRESSION_CONTEXT_VARIABLE.equals(firstChild.toStringAST())) {
            String firstIndexer = ast.getChild(1).toStringAST();
            String requestParamName = firstIndexer.replaceAll("^\\['|']", "");
            boolean required = requestParamName.equals(firstIndexer);
            HashMap<String, Boolean> requestParamAttributes = new HashMap<String, Boolean>();
            requestParamAttributes.put("required", required);
            RequestParam requestParamAnnotation = (RequestParam)AnnotationUtils.synthesizeAnnotation(requestParamAttributes, RequestParam.class, null);
            ret = new ResolvedMethodParameter(0, requestParamName, Collections.singletonList(requestParamAnnotation), typeResolver.resolve(String.class, new Type[0]));
        }
        return Optional.ofNullable(ret);
    }
}

