/*
 *
 *  Copyright 2015 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */

package springfox.documentation.spring.web.scanners;

import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

import java.util.List;
import java.util.Map;

public class ApiListingReferenceScanResult {
  private final List<ApiListingReference> apiListingReferences;
  private final Map<ResourceGroup, List<RequestMappingContext>> resourceGroupRequestMappings;

  public ApiListingReferenceScanResult(List<ApiListingReference> apiListingReferences,
      Map<ResourceGroup, List<RequestMappingContext>> resourceGroupRequestMappings) {
    this.apiListingReferences = apiListingReferences;
    this.resourceGroupRequestMappings = resourceGroupRequestMappings;
  }

  public List<ApiListingReference> getApiListingReferences() {
    return apiListingReferences;
  }

  public Map<ResourceGroup, List<RequestMappingContext>> getResourceGroupRequestMappings() {
    return resourceGroupRequestMappings;
  }
}
