/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.HandlerMethodReturnTypes;

@Component
@Order(value=-2147483648)
public class ResponseMessagesReader
implements OperationBuilderPlugin {
    private final TypeResolver typeResolver;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public ResponseMessagesReader(TypeResolver typeResolver, TypeNameExtractor typeNameExtractor) {
        this.typeResolver = typeResolver;
        this.typeNameExtractor = typeNameExtractor;
    }

    public void apply(OperationContext context) {
        List responseMessages = context.getGlobalResponseMessages(context.httpMethod().toString());
        context.operationBuilder().responseMessages((Set)Sets.newHashSet((Iterable)responseMessages));
        this.applyReturnTypeOverride(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void applyReturnTypeOverride(OperationContext context) {
        ResolvedType returnType = HandlerMethodReturnTypes.handlerReturnType(this.typeResolver, context.getHandlerMethod());
        returnType = context.alternateFor(returnType);
        int httpStatusCode = this.httpStatusCode(context.getHandlerMethod());
        String message = this.message(context.getHandlerMethod());
        ModelRef modelRef = null;
        if (!Types.isVoid((ResolvedType)returnType)) {
            ModelContext modelContext = ModelContext.returnValue((Type)returnType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getDocumentationContext().getGenericsNamingStrategy());
            modelRef = this.modelRef(returnType, modelContext);
        }
        ResponseMessage built = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(modelRef).build();
        context.operationBuilder().responseMessages((Set)Sets.newHashSet((Object[])new ResponseMessage[]{built}));
    }

    private ModelRef modelRef(ResolvedType type, ModelContext modelContext) {
        if (Collections.isContainerType((ResolvedType)type)) {
            ResolvedType collectionElementType = Collections.collectionElementType((ResolvedType)type);
            String elementTypeName = this.typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType));
            return new ModelRef(Collections.containerType((ResolvedType)type), elementTypeName);
        }
        if (Maps.isMapType((ResolvedType)type)) {
            String elementTypeName = this.typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)Maps.mapValueType((ResolvedType)type)));
            return new ModelRef("Map", elementTypeName, true);
        }
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)type));
        return new ModelRef(typeName);
    }

    private int httpStatusCode(HandlerMethod handlerMethod) {
        Optional responseStatus = Optional.fromNullable((Object)AnnotationUtils.getAnnotation((Method)handlerMethod.getMethod(), ResponseStatus.class));
        int httpStatusCode = HttpStatus.OK.value();
        if (responseStatus.isPresent()) {
            httpStatusCode = ((ResponseStatus)responseStatus.get()).value().value();
        }
        return httpStatusCode;
    }

    private String message(HandlerMethod handlerMethod) {
        Optional responseStatus = Optional.fromNullable((Object)AnnotationUtils.getAnnotation((Method)handlerMethod.getMethod(), ResponseStatus.class));
        String reasonPhrase = HttpStatus.OK.getReasonPhrase();
        if (responseStatus.isPresent()) {
            reasonPhrase = ((ResponseStatus)responseStatus.get()).reason();
        }
        return reasonPhrase;
    }
}

