/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        String name = this.findParameterNameFromAnnotations(methodParameter);
        String parameterName = methodParameter.getParameterName();
        if (Strings.isNullOrEmpty((String)name)) {
            name = Strings.isNullOrEmpty((String)parameterName) ? String.format("param%s", methodParameter.getParameterIndex()) : parameterName;
        }
        context.parameterBuilder().name(name);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findParameterNameFromAnnotations(MethodParameter methodParameter) {
        ArrayList methodAnnotations = Lists.newArrayList((Object[])methodParameter.getParameterAnnotations());
        return (String)FluentIterable.from((Iterable)methodAnnotations).filter(PathVariable.class).first().transform(this.pathVariableValue()).or(this.first(methodAnnotations, ModelAttribute.class).transform(this.modelAttributeValue())).or(this.first(methodAnnotations, RequestParam.class).transform(this.requestParamValue())).or(this.first(methodAnnotations, RequestHeader.class).transform(this.requestHeaderValue())).orNull();
    }

    private <T> Optional<T> first(List<Annotation> methodAnnotations, Class<T> ofType) {
        return FluentIterable.from(methodAnnotations).filter(ofType).first();
    }

    private Function<RequestHeader, String> requestHeaderValue() {
        return new Function<RequestHeader, String>(){

            public String apply(RequestHeader input) {
                return input.value();
            }
        };
    }

    private Function<RequestParam, String> requestParamValue() {
        return new Function<RequestParam, String>(){

            public String apply(RequestParam input) {
                return input.value();
            }
        };
    }

    private Function<ModelAttribute, String> modelAttributeValue() {
        return new Function<ModelAttribute, String>(){

            public String apply(ModelAttribute input) {
                return input.value();
            }
        };
    }

    private Function<PathVariable, String> pathVariableValue() {
        return new Function<PathVariable, String>(){

            public String apply(PathVariable input) {
                return input.value();
            }
        };
    }
}

