/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanResult;

@Component
public class ApiListingReferenceScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ApiListingReferenceScanner.class);

    public ApiListingReferenceScanResult scan(DocumentationContext context) {
        LOG.info("Scanning for api listing references");
        ArrayListMultimap resourceGroupRequestMappings = ArrayListMultimap.create();
        ApiSelector selector = context.getApiSelector();
        FluentIterable matchingHandlers = FluentIterable.from((Iterable)context.getRequestHandlers()).filter(selector.getRequestHandlerSelector());
        for (RequestHandler handler : matchingHandlers) {
            RequestMappingInfo requestMappingInfo = handler.getRequestMapping();
            HandlerMethod handlerMethod = handler.getHandlerMethod();
            ResourceGroup resourceGroup = new ResourceGroup(ControllerNamingUtils.controllerNameAsGroup(handlerMethod), handlerMethod.getBeanType(), Integer.valueOf(0));
            RequestMappingContext requestMappingContext = new RequestMappingContext(context, requestMappingInfo, handlerMethod);
            resourceGroupRequestMappings.put((Object)resourceGroup, (Object)requestMappingContext);
        }
        return new ApiListingReferenceScanResult(Multimaps.asMap((ListMultimap)resourceGroupRequestMappings));
    }
}

