/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.wordnik.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationPositionReader
implements OperationBuilderPlugin {
    private static final Logger log = LoggerFactory.getLogger(OperationPositionReader.class);

    public void apply(OperationContext context) {
        ApiOperation apiOperation = (ApiOperation)context.getHandlerMethod().getMethodAnnotation(ApiOperation.class);
        if (null != apiOperation && apiOperation.position() > 0) {
            context.operationBuilder().position(apiOperation.position());
            log.debug("Added operation at position: {}", (Object)apiOperation.position());
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

