/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.HandlerMethodReturnTypes;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerOperationModelsProvider
implements OperationModelsProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerOperationModelsProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerOperationModelsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(RequestMappingContext context) {
        this.collectFromApiOperation(context);
        this.collectApiResponses(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private void collectFromApiOperation(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        ResolvedType returnType = HandlerMethodReturnTypes.handlerReturnType((TypeResolver)this.typeResolver, (HandlerMethod)handlerMethod);
        returnType = context.alternateFor(returnType);
        Optional returnParameter = Annotations.findApiOperationAnnotation(handlerMethod.getMethod()).transform(Annotations.resolvedTypeFromOperation(this.typeResolver, returnType));
        if (returnParameter.isPresent() && returnParameter.get() != returnType) {
            LOG.debug("Adding return parameter of type {}", ResolvedTypes.resolvedTypeSignature((ResolvedType)((ResolvedType)returnParameter.get())).or((Object)"<null>"));
            context.operationModelsBuilder().addReturn((Type)returnParameter.get());
        }
    }

    private void collectApiResponses(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        Optional<ApiResponses> apiResponses = Annotations.findApiResponsesAnnotations(handlerMethod.getMethod());
        LOG.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        List modelTypes = (List)apiResponses.transform(this.toResolvedTypes(context)).or(new ArrayList());
        for (ResolvedType modelType : modelTypes) {
            context.operationModelsBuilder().addReturn((Type)modelType);
        }
    }

    private Function<ApiResponses, List<ResolvedType>> toResolvedTypes(final RequestMappingContext context) {
        return new Function<ApiResponses, List<ResolvedType>>(){

            public List<ResolvedType> apply(ApiResponses input) {
                ArrayList resolvedTypes = Lists.newArrayList();
                for (ApiResponse response : input.value()) {
                    ResolvedType modelType = context.alternateFor(SwaggerOperationModelsProvider.this.typeResolver.resolve((Type)response.response(), new Type[0]));
                    LOG.debug("Adding input parameter of type {}", ResolvedTypes.resolvedTypeSignature((ResolvedType)modelType).or((Object)"<null>"));
                    resolvedTypes.add(modelType);
                }
                return resolvedTypes;
            }
        };
    }
}

