/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.schema;

import io.swagger.annotations.ApiModel;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.DefaultTypeNameProvider;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class ApiModelTypeNameProvider
extends DefaultTypeNameProvider {
    public String nameFor(Class<?> type) {
        ApiModel annotation = (ApiModel)AnnotationUtils.findAnnotation(type, ApiModel.class);
        String defaultTypeName = super.nameFor(type);
        if (annotation != null) {
            return Optional.ofNullable(annotation.value()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(defaultTypeName);
        }
        return defaultTypeName;
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

