/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.readers.parameter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.ApiParam;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.readers.parameter.ParameterTypeReader;
import springfox.documentation.swagger.readers.parameter.ParameterAnnotationReader;

@Component(value="swagger1ParameterNameReader")
@Order(value=-2147482648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    private ParameterAnnotationReader annotations = new ParameterAnnotationReader();

    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        Optional<ApiParam> apiParam = this.apiParam(methodParameter);
        String paramType = ParameterTypeReader.findParameterType((ParameterContext)context);
        String name = null;
        if (apiParam.isPresent()) {
            name = Strings.emptyToNull((String)((ApiParam)apiParam.get()).name());
        }
        context.parameterBuilder().name(this.maybeOverrideName(name, paramType));
    }

    @VisibleForTesting
    Optional<ApiParam> apiParam(MethodParameter methodParameter) {
        return Optional.fromNullable((Object)methodParameter.getParameterAnnotation(ApiParam.class)).or(this.annotations.fromHierarchy(methodParameter, ApiParam.class));
    }

    private String maybeOverrideName(String parameterName, String paramType) {
        if ("body".equals(paramType)) {
            return paramType;
        }
        return parameterName;
    }

    public boolean supports(DocumentationType delimiter) {
        return DocumentationType.SWAGGER_12.equals((Object)delimiter);
    }
}

