/*
 *
 *  Copyright 2015 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *
 */

package springfox.documentation.swagger1.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Preconditions;

@JsonPropertyOrder({"type", "items"})
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ContainerDataType implements SwaggerDataType {
  private String type = "array";
  private final Boolean uniqueItems;
  @JsonProperty
  private final SwaggerDataType items;

  public ContainerDataType(String innerType, boolean uniqueItems) {
    Preconditions.checkNotNull(innerType);
    Preconditions.checkArgument(!innerType.equals("array"), "Nested arrays not supported");
    items = new DataType(innerType);
    this.uniqueItems = uniqueItems ? true : null;
  }

  public String getType() {
    return type;
  }

  public Boolean isUniqueItems() {
    return uniqueItems;
  }

  public SwaggerDataType getItems() {
    return items;
  }

  @Override
  public String getAbsoluteType() {
    return type;
  }
}
