package springfox.documentation.swagger1.mappers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationCodeGrant;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.BasicAuth;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ImplicitGrant;
import springfox.documentation.service.LoginEndpoint;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.TokenEndpoint;
import springfox.documentation.service.TokenRequestEndpoint;
import springfox.documentation.swagger1.dto.Authorization;
import springfox.documentation.swagger1.dto.AuthorizationType;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2015-06-24T10:14:21-0500",
    comments = "version: 1.0.0.Beta4, compiler: javac, environment: Java 1.7.0_60 (Oracle Corporation)"
)
@Component
public class AuthorizationTypesMapperImpl extends AuthorizationTypesMapper {

    @Override
    public springfox.documentation.swagger1.dto.OAuth toSwaggerOAuth(OAuth from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.OAuth oAuth = new springfox.documentation.swagger1.dto.OAuth();

        oAuth.setScopes( toSwaggerAuthorizationScopes( from.getScopes() ) );
        oAuth.setGrantTypes( toSwaggerGrantTypes( from.getGrantTypes() ) );
        oAuth.setName( from.getName() );

        return oAuth;
    }

    @Override
    public springfox.documentation.swagger1.dto.BasicAuth toSwaggerBasicAuth(BasicAuth from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.BasicAuth basicAuth = new springfox.documentation.swagger1.dto.BasicAuth();

        basicAuth.setName( from.getName() );

        return basicAuth;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiKey toSwaggerApiKey(ApiKey from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiKey apiKey = new springfox.documentation.swagger1.dto.ApiKey();

        apiKey.setName( from.getName() );
        apiKey.setPassAs( from.getPassAs() );
        apiKey.setKeyname( from.getKeyname() );

        return apiKey;
    }

    @Override
    public springfox.documentation.swagger1.dto.ImplicitGrant toSwaggerImplicitGrant(ImplicitGrant from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ImplicitGrant implicitGrant = new springfox.documentation.swagger1.dto.ImplicitGrant();

        implicitGrant.setTokenName( from.getTokenName() );
        implicitGrant.setLoginEndpoint( toSwaggerLoginEndpoint( from.getLoginEndpoint() ) );
        implicitGrant.setType( from.getType() );

        return implicitGrant;
    }

    @Override
    public springfox.documentation.swagger1.dto.AuthorizationCodeGrant toSwaggerAuthorizationCodeGrant(AuthorizationCodeGrant from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.AuthorizationCodeGrant authorizationCodeGrant = new springfox.documentation.swagger1.dto.AuthorizationCodeGrant();

        authorizationCodeGrant.setTokenRequestEndpoint( toSwaggerTokenRequestEndpoint( from.getTokenRequestEndpoint() ) );
        authorizationCodeGrant.setType( from.getType() );
        authorizationCodeGrant.setTokenEndpoint( toSwaggerTokenEndpoint( from.getTokenEndpoint() ) );

        return authorizationCodeGrant;
    }

    @Override
    public springfox.documentation.swagger1.dto.TokenEndpoint toSwaggerTokenEndpoint(TokenEndpoint from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.TokenEndpoint tokenEndpoint_ = new springfox.documentation.swagger1.dto.TokenEndpoint();

        tokenEndpoint_.setTokenName( from.getTokenName() );
        tokenEndpoint_.setUrl( from.getUrl() );

        return tokenEndpoint_;
    }

    @Override
    public springfox.documentation.swagger1.dto.TokenRequestEndpoint toSwaggerTokenRequestEndpoint(TokenRequestEndpoint from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.TokenRequestEndpoint tokenRequestEndpoint_ = new springfox.documentation.swagger1.dto.TokenRequestEndpoint();

        tokenRequestEndpoint_.setClientSecretName( from.getClientSecretName() );
        tokenRequestEndpoint_.setClientIdName( from.getClientIdName() );
        tokenRequestEndpoint_.setUrl( from.getUrl() );

        return tokenRequestEndpoint_;
    }

    @Override
    public springfox.documentation.swagger1.dto.AuthorizationScope toSwaggerAuthorizationScope(AuthorizationScope from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.AuthorizationScope authorizationScope = new springfox.documentation.swagger1.dto.AuthorizationScope();

        authorizationScope.setScope( from.getScope() );
        authorizationScope.setDescription( from.getDescription() );

        return authorizationScope;
    }

    @Override
    public Authorization toSwaggerSecurityReference(SecurityReference from) {
        if ( from == null ) {
            return null;
        }

        Authorization authorization = new Authorization();

        authorization.setType( from.getReference() );
        authorization.setScopes( toSwaggerAuthorizationScopes( from.getScopes() ) );

        return authorization;
    }

    @Override
    public springfox.documentation.swagger1.dto.LoginEndpoint toSwaggerLoginEndpoint(LoginEndpoint from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.LoginEndpoint loginEndpoint_ = new springfox.documentation.swagger1.dto.LoginEndpoint();

        loginEndpoint_.setUrl( from.getUrl() );

        return loginEndpoint_;
    }

    @Override
    public List<springfox.documentation.swagger1.dto.AuthorizationScope> toSwaggerAuthorizationScopes(List<AuthorizationScope> from) {
        if ( from == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.AuthorizationScope> list__ = new ArrayList<springfox.documentation.swagger1.dto.AuthorizationScope>();

        for ( AuthorizationScope authorizationScope : from ) {
            list__.add( toSwaggerAuthorizationScope( authorizationScope ) );
        }

        return list__;
    }

    @Override
    public List<springfox.documentation.swagger1.dto.GrantType> toSwaggerGrantTypes(List<GrantType> from) {
        if ( from == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.GrantType> list_ = new ArrayList<springfox.documentation.swagger1.dto.GrantType>();

        for ( GrantType grantType : from ) {
            list_.add( toSwaggerGrantType( grantType ) );
        }

        return list_;
    }

    @Override
    public List<AuthorizationType> toSwaggerAuthorizationTypes(List<SecurityScheme> from) {
        if ( from == null ) {
            return null;
        }

        List<AuthorizationType> list = new ArrayList<AuthorizationType>();

        for ( SecurityScheme securityScheme : from ) {
            list.add( toSwaggerAuthorizationType( securityScheme ) );
        }

        return list;
    }

}
