/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import springfox.documentation.swagger1.dto.ContainerDataType;
import springfox.documentation.swagger1.dto.PrimitiveDataType;
import springfox.documentation.swagger1.dto.PrimitiveFormatDataType;
import springfox.documentation.swagger1.dto.ReferenceDataType;
import springfox.documentation.swagger1.dto.SwaggerDataType;

public class DataType
implements SwaggerDataType {
    private static final Pattern containerPattern = Pattern.compile("([a-zA-Z]+)\\[([a-zA-Z\\.\\-]+)\\]");
    @JsonUnwrapped
    @JsonProperty
    private SwaggerDataType dataType;

    public DataType(String initialType) {
        this.dataType = this.typeFromDataType(initialType);
    }

    public SwaggerDataType typeFromDataType(String initialType) {
        if (this.isOfType(initialType.toLowerCase(), "void")) {
            return new PrimitiveDataType("void");
        }
        if (this.isOfType(initialType, "int")) {
            return new PrimitiveFormatDataType("integer", "int32");
        }
        if (this.isOfType(initialType, "long")) {
            return new PrimitiveFormatDataType("integer", "int64");
        }
        if (this.isOfType(initialType, "float")) {
            return new PrimitiveFormatDataType("number", "float");
        }
        if (this.isOfType(initialType, "double")) {
            return new PrimitiveFormatDataType("number", "double");
        }
        if (this.isOfType(initialType, "string")) {
            return new PrimitiveDataType("string");
        }
        if (this.isOfType(initialType, "byte")) {
            return new PrimitiveFormatDataType("string", "byte");
        }
        if (this.isOfType(initialType, "boolean")) {
            return new PrimitiveDataType("boolean");
        }
        if (this.isOfType(initialType, "Date") || this.isOfType(initialType, "DateTime")) {
            return new PrimitiveFormatDataType("string", "date-time");
        }
        if (this.isOfType(initialType, "BigDecimal") || this.isOfType(initialType, "BigInteger")) {
            return new PrimitiveDataType("number");
        }
        if (this.isOfType(initialType, "UUID")) {
            return new PrimitiveFormatDataType("string", "uuid");
        }
        if (this.isOfType(initialType, "date")) {
            return new PrimitiveFormatDataType("string", "date");
        }
        if (this.isOfType(initialType, "date-time")) {
            return new PrimitiveFormatDataType("string", "date-time");
        }
        Matcher matcher = containerPattern.matcher(initialType);
        if (matcher.matches()) {
            String containerInnerType = matcher.group(2);
            if (this.isUniqueContainerType(matcher.group(1))) {
                return new ContainerDataType(containerInnerType, true);
            }
            return new ContainerDataType(containerInnerType, false);
        }
        return new ReferenceDataType(initialType);
    }

    private boolean isUniqueContainerType(String containerInnerType) {
        return null != containerInnerType && containerInnerType.equalsIgnoreCase("Set");
    }

    private boolean isOfType(String initialType, String ofType) {
        return initialType.equals(ofType);
    }

    @Override
    public String getAbsoluteType() {
        return this.dataType.getAbsoluteType();
    }
}

