/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.mappers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.mapstruct.Mapper;
import org.mapstruct.Qualifier;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.swagger1.dto.DataType;

@Mapper
public class DataTypeMapper {
    public String responseTypeName(ModelRef modelRef) {
        if (modelRef == null) {
            return null;
        }
        if (modelRef.isCollection()) {
            return "array";
        }
        return modelRef.getType();
    }

    public DataType operationTypeFromModelRef(ModelRef modelRef) {
        if (modelRef != null) {
            return new DataType(this.operationTypeName(modelRef));
        }
        return null;
    }

    public DataType typeFromModelRef(ModelRef modelRef) {
        if (modelRef != null) {
            if (modelRef.isCollection()) {
                return new DataType(String.format("%s[%s]", modelRef.getType(), modelRef.getItemType()));
            }
            return new DataType(modelRef.getType());
        }
        return null;
    }

    private String operationTypeName(ModelRef modelRef) {
        if (modelRef == null) {
            return null;
        }
        if (modelRef.isCollection()) {
            return String.format("%s[%s]", modelRef.getType(), modelRef.getItemType());
        }
        return modelRef.getType();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface ItemType {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface ResponseTypeName {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface Type {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    @Qualifier
    public static @interface OperationType {
    }
}

