/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.web;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.Collection;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.swagger1.dto.ApiListing;

public class ApiListingMerger {
    public static Optional<ApiListing> mergedApiListing(Collection<ApiListing> apiListings) {
        if (BuilderDefaults.nullToEmptyList(apiListings).size() > 1) {
            ApiListing merged = new ApiListing();
            merged.setSwaggerVersion("1.2");
            merged.setPosition(0);
            for (ApiListing each : apiListings) {
                merged.setApiVersion(each.getApiVersion());
                merged.setBasePath(each.getBasePath());
                merged.setResourcePath(each.getResourcePath());
                merged.setDescription(each.getDescription());
                merged.appendAuthorizations(each.getAuthorizations());
                merged.appendApis(each.getApis());
                merged.appendProtocols(Sets.newHashSet(each.getProtocols()));
                merged.appendConsumes(Sets.newHashSet(each.getConsumes()));
                merged.appendModels(each.getModels());
                merged.appendProduces(Sets.newHashSet(each.getProduces()));
            }
            return Optional.of((Object)merged);
        }
        return FluentIterable.from((Iterable)BuilderDefaults.nullToEmptyList(apiListings)).first();
    }
}

