/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.web;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger1.dto.ApiListing;
import springfox.documentation.swagger1.dto.ResourceListing;
import springfox.documentation.swagger1.mappers.Mappers;
import springfox.documentation.swagger1.mappers.ServiceModelToSwaggerMapper;
import springfox.documentation.swagger1.web.ApiListingMerger;

@Controller
@ApiIgnore
@RequestMapping(value={"${springfox.documentation.swagger.v1.path:/api-docs}"})
public class Swagger1Controller {
    @Autowired
    private DocumentationCache documentationCache;
    @Autowired
    private ServiceModelToSwaggerMapper mapper;
    @Autowired
    private JsonSerializer jsonSerializer;

    @ApiIgnore
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Json> getResourceListing(@RequestParam(value="group", required=false) String swaggerGroup) {
        return this.getSwaggerResourceListing(swaggerGroup);
    }

    @ApiIgnore
    @RequestMapping(value={"/{swaggerGroup}/{apiDeclaration}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Json> getApiListing(@PathVariable String swaggerGroup, @PathVariable String apiDeclaration) {
        return this.getSwaggerApiListing(swaggerGroup, apiDeclaration);
    }

    private ResponseEntity<Json> getSwaggerApiListing(String swaggerGroup, String apiDeclaration) {
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Multimap apiListingMap = documentation.getApiListings();
        Map dtoApiListings = Multimaps.transformEntries((Multimap)apiListingMap, Mappers.toApiListingDto(this.mapper)).asMap();
        Collection apiListings = (Collection)dtoApiListings.get(apiDeclaration);
        return (ResponseEntity)ApiListingMerger.mergedApiListing(apiListings).transform(this.toJson()).transform(this.toResponseEntity(Json.class)).or((Object)new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private Function<ApiListing, Json> toJson() {
        return new Function<ApiListing, Json>(){

            public Json apply(ApiListing input) {
                return Swagger1Controller.this.jsonSerializer.toJson((Object)input);
            }
        };
    }

    private ResponseEntity<Json> getSwaggerResourceListing(String swaggerGroup) {
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        springfox.documentation.service.ResourceListing listing = documentation.getResourceListing();
        ResourceListing resourceListing = this.mapper.toSwaggerResourceListing(listing);
        return (ResponseEntity)Optional.fromNullable((Object)this.jsonSerializer.toJson((Object)resourceListing)).transform(this.toResponseEntity(Json.class)).or((Object)new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private <T> Function<T, ResponseEntity<T>> toResponseEntity(Class<T> clazz) {
        return new Function<T, ResponseEntity<T>>(){

            public ResponseEntity<T> apply(T input) {
                return new ResponseEntity(input, HttpStatus.OK);
            }
        };
    }
}

