/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.dto;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import springfox.documentation.swagger1.dto.AuthorizationScope;
import springfox.documentation.swagger1.dto.AuthorizationType;
import springfox.documentation.swagger1.dto.GrantType;

public class OAuth
extends AuthorizationType {
    private List<AuthorizationScope> scopes;
    private LinkedHashMap<String, GrantType> grantTypes;

    public OAuth() {
        super("oauth2");
    }

    public OAuth(List<AuthorizationScope> scopes, List<GrantType> gTypes) {
        super("oauth2");
        this.scopes = scopes;
        this.grantTypes = this.initializeGrantTypes(gTypes);
    }

    private LinkedHashMap<String, GrantType> initializeGrantTypes(List<GrantType> gTypes) {
        if (null != gTypes) {
            LinkedHashMap<String, GrantType> map = new LinkedHashMap<String, GrantType>();
            for (GrantType grantType : gTypes) {
                map.put(grantType.getType(), grantType);
            }
            return map;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getType();
    }

    public List<AuthorizationScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<AuthorizationScope> scopes) {
        this.scopes = scopes;
    }

    public List<GrantType> getGrantTypes() {
        return new ArrayList<GrantType>(this.grantTypes.values());
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = this.initializeGrantTypes(grantTypes);
    }
}

