/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.mappers;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger1.mappers.ServiceModelToSwaggerMapper;

public class Mappers {
    private Mappers() {
        throw new UnsupportedOperationException();
    }

    public static Function<Map.Entry<String, List<ApiListing>>, Map.Entry<String, List<springfox.documentation.swagger1.dto.ApiListing>>> toApiListingDto(HttpServletRequest servletRequest, String host, ServiceModelToSwaggerMapper mapper) {
        return entry -> {
            List newApiListings = ((List)entry.getValue()).stream().map(value -> {
                springfox.documentation.swagger1.dto.ApiListing apiListing = mapper.toSwaggerApiListing((ApiListing)value);
                UriComponents uriComponents = HostNameProvider.componentsFrom((HttpServletRequest)servletRequest, (String)apiListing.getBasePath());
                apiListing.setBasePath(Mappers.adjustedBasePath(uriComponents, host, apiListing.getBasePath()));
                return apiListing;
            }).collect(Collectors.toList());
            return new AbstractMap.SimpleEntry(entry.getKey(), newApiListings);
        };
    }

    private static String adjustedBasePath(UriComponents uriComponents, String hostNameOverride, String basePath) {
        if (!StringUtils.isEmpty((Object)hostNameOverride)) {
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s://%s:%d%s", uriComponents.getScheme(), hostNameOverride, port, basePath);
            }
            return String.format("%s://%s%s", uriComponents.getScheme(), hostNameOverride, basePath);
        }
        return basePath;
    }
}

