/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.web;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.PropertySourcedMapping;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger1.dto.ResourceListing;
import springfox.documentation.swagger1.mappers.Mappers;
import springfox.documentation.swagger1.mappers.ServiceModelToSwaggerMapper;
import springfox.documentation.swagger1.web.ApiListingMerger;

@Controller
@ApiIgnore
public class Swagger1Controller {
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwaggerMapper mapper;
    private final JsonSerializer jsonSerializer;

    @Autowired
    public Swagger1Controller(DocumentationCache documentationCache, ServiceModelToSwaggerMapper mapper, JsonSerializer jsonSerializer) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
    }

    @RequestMapping(value={"/api-docs"}, method={RequestMethod.GET})
    @PropertySourcedMapping(value="${springfox.documentation.swagger.v1.path}", propertyKey="springfox.documentation.swagger.v1.path")
    @ResponseBody
    public ResponseEntity<Json> getResourceListing(@RequestParam(value="group", required=false) String swaggerGroup) {
        return this.getSwaggerResourceListing(swaggerGroup);
    }

    @RequestMapping(value={"/api-docs/{swaggerGroup}/{apiDeclaration}"}, method={RequestMethod.GET})
    @PropertySourcedMapping(value="${springfox.documentation.swagger.v1.path}/{swaggerGroup}/{apiDeclaration}", propertyKey="springfox.documentation.swagger.v1.path")
    @ResponseBody
    public ResponseEntity<Json> getApiListing(@PathVariable String swaggerGroup, @PathVariable String apiDeclaration, HttpServletRequest servletRequest) {
        return this.getSwaggerApiListing(swaggerGroup, apiDeclaration, servletRequest);
    }

    private ResponseEntity<Json> getSwaggerApiListing(String swaggerGroup, String apiDeclaration, HttpServletRequest servletRequest) {
        String groupName = Optional.ofNullable(swaggerGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Map apiListingMap = documentation.getApiListings();
        Map<String, Collection> dtoApiListings = apiListingMap.entrySet().stream().map(Mappers.toApiListingDto(servletRequest, documentation.getHost(), this.mapper)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Collection apiListings = dtoApiListings.get(apiDeclaration);
        return ApiListingMerger.mergedApiListing(apiListings).map(arg_0 -> ((JsonSerializer)this.jsonSerializer).toJson(arg_0)).map(this.toResponseEntity()).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private ResponseEntity<Json> getSwaggerResourceListing(String swaggerGroup) {
        String groupName = Optional.ofNullable(swaggerGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        springfox.documentation.service.ResourceListing listing = documentation.getResourceListing();
        ResourceListing resourceListing = this.mapper.toSwaggerResourceListing(listing);
        return Optional.ofNullable(this.jsonSerializer.toJson((Object)resourceListing)).map(this.toResponseEntity()).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    private <T> Function<T, ResponseEntity<T>> toResponseEntity() {
        return input -> new ResponseEntity(input, HttpStatus.OK);
    }
}

