/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.mappers;

import io.swagger.models.Contact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.swagger1.dto.ApiDescription;
import springfox.documentation.swagger1.dto.ApiInfo;
import springfox.documentation.swagger1.dto.Authorization;
import springfox.documentation.swagger1.dto.AuthorizationScope;
import springfox.documentation.swagger1.dto.ModelDto;
import springfox.documentation.swagger1.dto.ModelPropertyDto;
import springfox.documentation.swagger1.dto.Parameter;
import springfox.documentation.swagger1.dto.ResourceListing;
import springfox.documentation.swagger1.dto.ResponseMessage;
import springfox.documentation.swagger1.mappers.AllowableValuesMapper;
import springfox.documentation.swagger1.mappers.AuthorizationTypesMapper;
import springfox.documentation.swagger1.mappers.DataTypeMapper;
import springfox.documentation.swagger1.mappers.ServiceModelToSwaggerMapper;

@Component
public class ServiceModelToSwaggerMapperImpl
implements ServiceModelToSwaggerMapper {
    @Autowired
    private AllowableValuesMapper allowableValuesMapper;
    @Autowired
    private DataTypeMapper dataTypeMapper;
    @Autowired
    private AuthorizationTypesMapper authorizationTypesMapper;

    @Override
    public ApiDescription toSwaggerApiDescription(springfox.documentation.service.ApiDescription from) {
        if (from == null) {
            return null;
        }
        ApiDescription apiDescription = new ApiDescription();
        apiDescription.setPath(from.getPath());
        apiDescription.setDescription(from.getDescription());
        apiDescription.setOperations(this.operationListToOperationList(from.getOperations()));
        apiDescription.setHidden(from.isHidden());
        return apiDescription;
    }

    @Override
    public ApiInfo toSwaggerApiInfo(springfox.documentation.service.ApiInfo from) {
        if (from == null) {
            return null;
        }
        ApiInfo apiInfo = new ApiInfo();
        apiInfo.setContact(this.fromContactName(from));
        apiInfo.setTitle(from.getTitle());
        apiInfo.setDescription(from.getDescription());
        apiInfo.setTermsOfServiceUrl(from.getTermsOfServiceUrl());
        apiInfo.setLicense(from.getLicense());
        apiInfo.setLicenseUrl(from.getLicenseUrl());
        return apiInfo;
    }

    @Override
    public Contact map(springfox.documentation.service.Contact from) {
        if (from == null) {
            return null;
        }
        Contact contact = new Contact();
        contact.setName(from.getName());
        contact.setUrl(from.getUrl());
        contact.setEmail(from.getEmail());
        return contact;
    }

    @Override
    public ResponseMessage toSwaggerResponseMessage(springfox.documentation.service.ResponseMessage from) {
        if (from == null) {
            return null;
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setResponseModel(this.dataTypeMapper.responseTypeName(from.getResponseModel()));
        responseMessage.setCode(from.getCode());
        responseMessage.setMessage(from.getMessage());
        return responseMessage;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListingReference toSwaggerApiListingReference(ApiListingReference from) {
        if (from == null) {
            return null;
        }
        springfox.documentation.swagger1.dto.ApiListingReference apiListingReference = new springfox.documentation.swagger1.dto.ApiListingReference();
        apiListingReference.setPath(from.getPath());
        apiListingReference.setDescription(from.getDescription());
        apiListingReference.setPosition(from.getPosition());
        return apiListingReference;
    }

    @Override
    public ModelDto toSwaggerModelDto(Model from) {
        if (from == null) {
            return null;
        }
        ModelDto modelDto = new ModelDto();
        modelDto.setSubTypes(this.modelReferenceListToStringList(from.getSubTypes()));
        modelDto.setId(from.getId());
        modelDto.setName(from.getName());
        modelDto.setQualifiedType(from.getQualifiedType());
        modelDto.setProperties(this.stringModelPropertyMapToStringModelPropertyDtoMap(from.getProperties()));
        modelDto.setDescription(from.getDescription());
        modelDto.setBaseModel(from.getBaseModel());
        modelDto.setDiscriminator(from.getDiscriminator());
        return modelDto;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListing toSwaggerApiListing(ApiListing from) {
        Set set2;
        Set set1;
        if (from == null) {
            return null;
        }
        springfox.documentation.swagger1.dto.ApiListing apiListing = new springfox.documentation.swagger1.dto.ApiListing();
        apiListing.setAuthorizations(this.securityReferenceListToAuthorizationList(from.getSecurityReferences()));
        apiListing.setApiVersion(from.getApiVersion());
        apiListing.setBasePath(from.getBasePath());
        apiListing.setResourcePath(from.getResourcePath());
        Set set = from.getProduces();
        if (set != null) {
            apiListing.setProduces(new HashSet<String>(set));
        }
        if ((set1 = from.getConsumes()) != null) {
            apiListing.setConsumes(new HashSet<String>(set1));
        }
        if ((set2 = from.getProtocols()) != null) {
            apiListing.setProtocols(new HashSet<String>(set2));
        }
        apiListing.setApis(this.apiDescriptionListToApiDescriptionList(from.getApis()));
        apiListing.setModels(this.stringModelMapToStringModelDtoMap(from.getModels()));
        apiListing.setDescription(from.getDescription());
        apiListing.setPosition(from.getPosition());
        apiListing.setSwaggerVersion("1.2");
        return apiListing;
    }

    @Override
    public ModelPropertyDto toSwaggerModelPropertyDto(ModelProperty from) {
        if (from == null) {
            return null;
        }
        ModelPropertyDto modelPropertyDto = new ModelPropertyDto();
        modelPropertyDto.setType(this.dataTypeMapper.typeFromModelRef(from.getModelRef()));
        modelPropertyDto.setQualifiedType(from.getQualifiedType());
        modelPropertyDto.setPosition(from.getPosition());
        modelPropertyDto.setDescription(from.getDescription());
        modelPropertyDto.setAllowableValues(this.allowableValuesMapper.toSwaggerAllowableValues(from.getAllowableValues()));
        modelPropertyDto.setName(from.getName());
        modelPropertyDto.setRequired(from.isRequired());
        return modelPropertyDto;
    }

    @Override
    public springfox.documentation.swagger1.dto.Operation toSwaggerOperation(Operation from) {
        Set set2;
        Set set1;
        if (from == null) {
            return null;
        }
        springfox.documentation.swagger1.dto.Operation operation = new springfox.documentation.swagger1.dto.Operation();
        operation.setNickname(from.getUniqueId());
        operation.setAuthorizations(this.stringListMapToStringListMap(from.getSecurityReferences()));
        operation.setDataType(this.dataTypeMapper.operationTypeFromModelRef(from.getResponseModel()));
        if (from.getMethod() != null) {
            operation.setMethod(from.getMethod().name());
        }
        operation.setSummary(from.getSummary());
        operation.setNotes(from.getNotes());
        operation.setPosition(from.getPosition());
        Set set = from.getProduces();
        if (set != null) {
            operation.setProduces(new ArrayList<String>(set));
        }
        if ((set1 = from.getConsumes()) != null) {
            operation.setConsumes(new ArrayList<String>(set1));
        }
        if ((set2 = from.getProtocol()) != null) {
            operation.setProtocol(new ArrayList<String>(set2));
        }
        operation.setParameters(this.parameterListToParameterList(from.getParameters()));
        operation.setResponseMessages(this.responseMessageSetToResponseMessageSet(from.getResponseMessages()));
        operation.setDeprecated(from.getDeprecated());
        return operation;
    }

    @Override
    public Parameter toSwaggerParameter(springfox.documentation.service.Parameter from) {
        if (from == null) {
            return null;
        }
        Parameter parameter = new Parameter();
        parameter.setParameterType(this.dataTypeMapper.operationTypeFromModelRef(from.getModelRef()));
        parameter.setName(from.getName());
        parameter.setDescription(from.getDescription());
        parameter.setDefaultValue(from.getDefaultValue());
        parameter.setAllowableValues(this.allowableValuesMapper.toSwaggerAllowableValues(from.getAllowableValues()));
        parameter.setParamType(from.getParamType());
        parameter.setParamAccess(from.getParamAccess());
        parameter.setRequired(from.isRequired());
        parameter.setAllowMultiple(from.isAllowMultiple());
        return parameter;
    }

    @Override
    public ResourceListing toSwaggerResourceListing(springfox.documentation.service.ResourceListing from) {
        if (from == null) {
            return null;
        }
        ResourceListing resourceListing = new ResourceListing();
        resourceListing.setAuthorizations(this.authorizationTypesMapper.toSwaggerAuthorizationTypes(from.getSecuritySchemes()));
        resourceListing.setApiVersion(from.getApiVersion());
        resourceListing.setApis(this.apiListingReferenceListToApiListingReferenceList(from.getApis()));
        resourceListing.setInfo(this.toSwaggerApiInfo(from.getInfo()));
        resourceListing.setSwaggerVersion("1.2");
        return resourceListing;
    }

    protected List<springfox.documentation.swagger1.dto.Operation> operationListToOperationList(List<Operation> list) {
        if (list == null) {
            return null;
        }
        ArrayList<springfox.documentation.swagger1.dto.Operation> list1 = new ArrayList<springfox.documentation.swagger1.dto.Operation>(list.size());
        for (Operation operation : list) {
            list1.add(this.toSwaggerOperation(operation));
        }
        return list1;
    }

    private String fromContactName(springfox.documentation.service.ApiInfo apiInfo) {
        if (apiInfo == null) {
            return null;
        }
        springfox.documentation.service.Contact contact = apiInfo.getContact();
        if (contact == null) {
            return null;
        }
        String name = contact.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    protected List<String> modelReferenceListToStringList(List<ModelReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> list1 = new ArrayList<String>(list.size());
        for (ModelReference modelReference : list) {
            list1.add(this.dataTypeMapper.responseTypeName(modelReference));
        }
        return list1;
    }

    protected Map<String, ModelPropertyDto> stringModelPropertyMapToStringModelPropertyDtoMap(Map<String, ModelProperty> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, ModelPropertyDto> map1 = new HashMap<String, ModelPropertyDto>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, ModelProperty> entry : map.entrySet()) {
            String key = entry.getKey();
            ModelPropertyDto value = this.toSwaggerModelPropertyDto(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected List<Authorization> securityReferenceListToAuthorizationList(List<SecurityReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Authorization> list1 = new ArrayList<Authorization>(list.size());
        for (SecurityReference securityReference : list) {
            list1.add(this.authorizationTypesMapper.toSwaggerSecurityReference(securityReference));
        }
        return list1;
    }

    protected List<ApiDescription> apiDescriptionListToApiDescriptionList(List<springfox.documentation.service.ApiDescription> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ApiDescription> list1 = new ArrayList<ApiDescription>(list.size());
        for (springfox.documentation.service.ApiDescription apiDescription : list) {
            list1.add(this.toSwaggerApiDescription(apiDescription));
        }
        return list1;
    }

    protected Map<String, ModelDto> stringModelMapToStringModelDtoMap(Map<String, Model> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, ModelDto> map1 = new HashMap<String, ModelDto>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, Model> entry : map.entrySet()) {
            String key = entry.getKey();
            ModelDto value = this.toSwaggerModelDto(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected Map<String, List<AuthorizationScope>> stringListMapToStringListMap(Map<String, List<springfox.documentation.service.AuthorizationScope>> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, List<AuthorizationScope>> map1 = new HashMap<String, List<AuthorizationScope>>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, List<springfox.documentation.service.AuthorizationScope>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<AuthorizationScope> value = this.authorizationTypesMapper.toSwaggerAuthorizationScopes(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Parameter> list1 = new ArrayList<Parameter>(list.size());
        for (springfox.documentation.service.Parameter parameter : list) {
            list1.add(this.toSwaggerParameter(parameter));
        }
        return list1;
    }

    protected Set<ResponseMessage> responseMessageSetToResponseMessageSet(Set<springfox.documentation.service.ResponseMessage> set) {
        if (set == null) {
            return null;
        }
        HashSet<ResponseMessage> set1 = new HashSet<ResponseMessage>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (springfox.documentation.service.ResponseMessage responseMessage : set) {
            set1.add(this.toSwaggerResponseMessage(responseMessage));
        }
        return set1;
    }

    protected List<springfox.documentation.swagger1.dto.ApiListingReference> apiListingReferenceListToApiListingReferenceList(List<ApiListingReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<springfox.documentation.swagger1.dto.ApiListingReference> list1 = new ArrayList<springfox.documentation.swagger1.dto.ApiListingReference>(list.size());
        for (ApiListingReference apiListingReference : list) {
            list1.add(this.toSwaggerApiListingReference(apiListingReference));
        }
        return list1;
    }
}

