package springfox.documentation.swagger1.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.swagger1.dto.Authorization;
import springfox.documentation.swagger1.dto.ModelDto;
import springfox.documentation.swagger1.dto.ModelPropertyDto;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2015-08-15T09:45:46-0500",
    comments = "version: 1.0.0.CR1, compiler: javac, environment: Java 1.8.0_45 (Oracle Corporation)"
)
@Component
public class ServiceModelToSwaggerMapperImpl implements ServiceModelToSwaggerMapper {

    @Autowired
    private AllowableValuesMapper allowableValuesMapper;
    @Autowired
    private DataTypeMapper dataTypeMapper;
    @Autowired
    private AuthorizationTypesMapper authorizationTypesMapper;

    @Override
    public springfox.documentation.swagger1.dto.ApiDescription toSwaggerApiDescription(ApiDescription from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiDescription apiDescription = new springfox.documentation.swagger1.dto.ApiDescription();

        apiDescription.setPath( from.getPath() );
        apiDescription.setDescription( from.getDescription() );
        apiDescription.setOperations( operationListToOperationList( from.getOperations() ) );
        apiDescription.setHidden( from.isHidden() );

        return apiDescription;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiInfo toSwaggerApiInfo(ApiInfo from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiInfo apiInfo = new springfox.documentation.swagger1.dto.ApiInfo();

        apiInfo.setTitle( from.getTitle() );
        apiInfo.setDescription( from.getDescription() );
        apiInfo.setTermsOfServiceUrl( from.getTermsOfServiceUrl() );
        apiInfo.setContact( from.getContact() );
        apiInfo.setLicense( from.getLicense() );
        apiInfo.setLicenseUrl( from.getLicenseUrl() );

        return apiInfo;
    }

    @Override
    public springfox.documentation.swagger1.dto.ResponseMessage toSwaggerResponseMessage(ResponseMessage from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ResponseMessage responseMessage = new springfox.documentation.swagger1.dto.ResponseMessage();

        responseMessage.setResponseModel( dataTypeMapper.responseTypeName( from.getResponseModel() ) );
        responseMessage.setCode( from.getCode() );
        responseMessage.setMessage( from.getMessage() );

        return responseMessage;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListingReference toSwaggerApiListingReference(ApiListingReference from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiListingReference apiListingReference = new springfox.documentation.swagger1.dto.ApiListingReference();

        apiListingReference.setPath( from.getPath() );
        apiListingReference.setDescription( from.getDescription() );
        apiListingReference.setPosition( from.getPosition() );

        return apiListingReference;
    }

    @Override
    public ModelDto toSwaggerModelDto(Model from) {
        if ( from == null ) {
            return null;
        }

        ModelDto modelDto = new ModelDto();

        modelDto.setId( from.getId() );
        modelDto.setName( from.getName() );
        modelDto.setQualifiedType( from.getQualifiedType() );
        modelDto.setProperties( stringModelPropertyMapToStringModelPropertyDtoMap( from.getProperties() ) );
        modelDto.setDescription( from.getDescription() );
        modelDto.setBaseModel( from.getBaseModel() );
        modelDto.setDiscriminator( from.getDiscriminator() );
        if ( from.getSubTypes() != null ) {
            modelDto.setSubTypes( new ArrayList<String>( from.getSubTypes() ) );
        }

        return modelDto;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListing toSwaggerApiListing(ApiListing from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiListing apiListing = new springfox.documentation.swagger1.dto.ApiListing();

        apiListing.setAuthorizations( securityReferenceListToAuthorizationList( from.getSecurityReferences() ) );
        apiListing.setApiVersion( from.getApiVersion() );
        apiListing.setBasePath( from.getBasePath() );
        apiListing.setResourcePath( from.getResourcePath() );
        if ( from.getProduces() != null ) {
            apiListing.setProduces( new HashSet<String>( from.getProduces() ) );
        }
        if ( from.getConsumes() != null ) {
            apiListing.setConsumes( new HashSet<String>( from.getConsumes() ) );
        }
        if ( from.getProtocols() != null ) {
            apiListing.setProtocols( new HashSet<String>( from.getProtocols() ) );
        }
        apiListing.setApis( apiDescriptionListToApiDescriptionList( from.getApis() ) );
        apiListing.setModels( stringModelMapToStringModelDtoMap( from.getModels() ) );
        apiListing.setDescription( from.getDescription() );
        apiListing.setPosition( from.getPosition() );

        apiListing.setSwaggerVersion( "1.2" );

        return apiListing;
    }

    @Override
    public ModelPropertyDto toSwaggerModelPropertyDto(ModelProperty from) {
        if ( from == null ) {
            return null;
        }

        ModelPropertyDto modelPropertyDto_ = new ModelPropertyDto();

        modelPropertyDto_.setType( dataTypeMapper.typeFromModelRef( from.getModelRef() ) );
        modelPropertyDto_.setQualifiedType( from.getQualifiedType() );
        modelPropertyDto_.setPosition( from.getPosition() );
        modelPropertyDto_.setDescription( from.getDescription() );
        modelPropertyDto_.setAllowableValues( allowableValuesMapper.toSwaggerAllowableValues( from.getAllowableValues() ) );
        modelPropertyDto_.setName( from.getName() );
        modelPropertyDto_.setRequired( from.isRequired() );

        return modelPropertyDto_;
    }

    @Override
    public springfox.documentation.swagger1.dto.Operation toSwaggerOperation(Operation from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.Operation operation_ = new springfox.documentation.swagger1.dto.Operation();

        operation_.setNickname( from.getUniqueId() );
        operation_.setAuthorizations( stringListMapToStringListMap( from.getSecurityReferences() ) );
        operation_.setDataType( dataTypeMapper.operationTypeFromModelRef( from.getResponseModel() ) );
        if ( from.getMethod() != null ) {
            operation_.setMethod( from.getMethod().name() );
        }
        operation_.setSummary( from.getSummary() );
        operation_.setNotes( from.getNotes() );
        operation_.setPosition( from.getPosition() );
        if ( from.getProduces() != null ) {
            operation_.setProduces( new ArrayList<String>( from.getProduces() ) );
        }
        if ( from.getConsumes() != null ) {
            operation_.setConsumes( new ArrayList<String>( from.getConsumes() ) );
        }
        if ( from.getProtocol() != null ) {
            operation_.setProtocol( new ArrayList<String>( from.getProtocol() ) );
        }
        operation_.setParameters( parameterListToParameterList( from.getParameters() ) );
        operation_.setResponseMessages( responseMessageSetToResponseMessageSet( from.getResponseMessages() ) );
        operation_.setDeprecated( from.getDeprecated() );

        return operation_;
    }

    @Override
    public springfox.documentation.swagger1.dto.Parameter toSwaggerParameter(Parameter from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.Parameter parameter_ = new springfox.documentation.swagger1.dto.Parameter();

        parameter_.setParameterType( dataTypeMapper.operationTypeFromModelRef( from.getModelRef() ) );
        parameter_.setName( from.getName() );
        parameter_.setDescription( from.getDescription() );
        parameter_.setDefaultValue( from.getDefaultValue() );
        parameter_.setAllowableValues( allowableValuesMapper.toSwaggerAllowableValues( from.getAllowableValues() ) );
        parameter_.setParamType( from.getParamType() );
        parameter_.setParamAccess( from.getParamAccess() );
        parameter_.setRequired( from.isRequired() );
        parameter_.setAllowMultiple( from.isAllowMultiple() );

        return parameter_;
    }

    @Override
    public springfox.documentation.swagger1.dto.ResourceListing toSwaggerResourceListing(ResourceListing from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ResourceListing resourceListing = new springfox.documentation.swagger1.dto.ResourceListing();

        resourceListing.setAuthorizations( authorizationTypesMapper.toSwaggerAuthorizationTypes( from.getSecuritySchemes() ) );
        resourceListing.setApiVersion( from.getApiVersion() );
        resourceListing.setApis( apiListingReferenceListToApiListingReferenceList( from.getApis() ) );
        resourceListing.setInfo( toSwaggerApiInfo( from.getInfo() ) );

        resourceListing.setSwaggerVersion( "1.2" );

        return resourceListing;
    }

    protected List<springfox.documentation.swagger1.dto.Operation> operationListToOperationList(List<Operation> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.Operation> list_ = new ArrayList<springfox.documentation.swagger1.dto.Operation>();
        for ( Operation operation : list ) {
            list_.add( toSwaggerOperation( operation ) );
        }

        return list_;
    }

    protected Map<String, ModelPropertyDto> stringModelPropertyMapToStringModelPropertyDtoMap(Map<String, ModelProperty> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, ModelPropertyDto> map_ = new HashMap<String, ModelPropertyDto>();

        for ( java.util.Map.Entry<String, ModelProperty> entry : map.entrySet() ) {
            String key = entry.getKey();
            ModelPropertyDto value = toSwaggerModelPropertyDto( entry.getValue() );
            map_.put( key, value );
        }

        return map_;
    }

    protected List<Authorization> securityReferenceListToAuthorizationList(List<SecurityReference> list) {
        if ( list == null ) {
            return null;
        }

        List<Authorization> list_ = new ArrayList<Authorization>();
        for ( SecurityReference securityReference : list ) {
            list_.add( authorizationTypesMapper.toSwaggerSecurityReference( securityReference ) );
        }

        return list_;
    }

    protected List<springfox.documentation.swagger1.dto.ApiDescription> apiDescriptionListToApiDescriptionList(List<ApiDescription> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.ApiDescription> list_ = new ArrayList<springfox.documentation.swagger1.dto.ApiDescription>();
        for ( ApiDescription apiDescription : list ) {
            list_.add( toSwaggerApiDescription( apiDescription ) );
        }

        return list_;
    }

    protected Map<String, ModelDto> stringModelMapToStringModelDtoMap(Map<String, Model> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, ModelDto> map_ = new HashMap<String, ModelDto>();

        for ( java.util.Map.Entry<String, Model> entry : map.entrySet() ) {
            String key = entry.getKey();
            ModelDto value = toSwaggerModelDto( entry.getValue() );
            map_.put( key, value );
        }

        return map_;
    }

    protected Map<String, List<springfox.documentation.swagger1.dto.AuthorizationScope>> stringListMapToStringListMap(Map<String, List<AuthorizationScope>> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, List<springfox.documentation.swagger1.dto.AuthorizationScope>> map_ = new HashMap<String, List<springfox.documentation.swagger1.dto.AuthorizationScope>>();

        for ( java.util.Map.Entry<String, List<AuthorizationScope>> entry : map.entrySet() ) {
            String key = entry.getKey();
            List<springfox.documentation.swagger1.dto.AuthorizationScope> value = authorizationTypesMapper.toSwaggerAuthorizationScopes( entry.getValue() );
            map_.put( key, value );
        }

        return map_;
    }

    protected List<springfox.documentation.swagger1.dto.Parameter> parameterListToParameterList(List<Parameter> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.Parameter> list_ = new ArrayList<springfox.documentation.swagger1.dto.Parameter>();
        for ( Parameter parameter : list ) {
            list_.add( toSwaggerParameter( parameter ) );
        }

        return list_;
    }

    protected Set<springfox.documentation.swagger1.dto.ResponseMessage> responseMessageSetToResponseMessageSet(Set<ResponseMessage> set) {
        if ( set == null ) {
            return null;
        }

        Set<springfox.documentation.swagger1.dto.ResponseMessage> set_ = new HashSet<springfox.documentation.swagger1.dto.ResponseMessage>();
        for ( ResponseMessage responseMessage : set ) {
            set_.add( toSwaggerResponseMessage( responseMessage ) );
        }

        return set_;
    }

    protected List<springfox.documentation.swagger1.dto.ApiListingReference> apiListingReferenceListToApiListingReferenceList(List<ApiListingReference> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.ApiListingReference> list_ = new ArrayList<springfox.documentation.swagger1.dto.ApiListingReference>();
        for ( ApiListingReference apiListingReference : list ) {
            list_.add( toSwaggerApiListingReference( apiListingReference ) );
        }

        return list_;
    }

}
