/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.readers.parameter;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.readers.parameter.ParameterTypeReader;

@Component(value="swagger1ParameterNameReader")
@Order(value=-2147482648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        Optional apiParam = context.resolvedMethodParameter().findAnnotation(ApiParam.class);
        String paramType = ParameterTypeReader.findParameterType((ParameterContext)context);
        String name = null;
        if (apiParam.isPresent()) {
            name = Strings.emptyToNull((String)((ApiParam)apiParam.get()).name());
        }
        context.parameterBuilder().name(this.maybeOverrideName(name, paramType));
    }

    private String maybeOverrideName(String parameterName, String paramType) {
        if ("body".equals(paramType)) {
            return paramType;
        }
        return parameterName;
    }

    public boolean supports(DocumentationType delimiter) {
        return DocumentationType.SWAGGER_12.equals((Object)delimiter);
    }
}

