package springfox.documentation.swagger1.mappers;

import java.util.ArrayList;

import java.util.HashMap;

import java.util.HashSet;

import java.util.List;

import java.util.Map;

import java.util.Set;

import javax.annotation.Generated;

import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Component;

import springfox.documentation.schema.Model;

import springfox.documentation.schema.ModelProperty;

import springfox.documentation.service.ApiDescription;

import springfox.documentation.service.ApiInfo;

import springfox.documentation.service.ApiListing;

import springfox.documentation.service.ApiListingReference;

import springfox.documentation.service.Contact;

import springfox.documentation.service.Operation;

import springfox.documentation.service.ResourceListing;

import springfox.documentation.service.ResponseMessage;

import springfox.documentation.service.SecurityReference;

import springfox.documentation.swagger1.dto.Authorization;

import springfox.documentation.swagger1.dto.AuthorizationScope;

import springfox.documentation.swagger1.dto.AuthorizationType;

import springfox.documentation.swagger1.dto.ModelDto;

import springfox.documentation.swagger1.dto.ModelPropertyDto;

import springfox.documentation.swagger1.dto.Parameter;

@Generated(

    value = "org.mapstruct.ap.MappingProcessor",

    date = "2017-05-20T20:46:17-0500",

    comments = "version: 1.1.0.Final, compiler: javac, environment: Java 1.7.0_79 (Oracle Corporation)"

)

@Component

public class ServiceModelToSwaggerMapperImpl implements ServiceModelToSwaggerMapper {

    @Autowired

    private AllowableValuesMapper allowableValuesMapper;

    @Autowired

    private DataTypeMapper dataTypeMapper;

    @Autowired

    private AuthorizationTypesMapper authorizationTypesMapper;

    @Override

    public springfox.documentation.swagger1.dto.ApiDescription toSwaggerApiDescription(ApiDescription from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.ApiDescription apiDescription = new springfox.documentation.swagger1.dto.ApiDescription();

        apiDescription.setPath( from.getPath() );

        apiDescription.setDescription( from.getDescription() );

        List<springfox.documentation.swagger1.dto.Operation> list = operationListToOperationList( from.getOperations() );

        if ( list != null ) {

            apiDescription.setOperations( list );
        }

        apiDescription.setHidden( from.isHidden() );

        return apiDescription;
    }

    @Override

    public springfox.documentation.swagger1.dto.ApiInfo toSwaggerApiInfo(ApiInfo from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.ApiInfo apiInfo = new springfox.documentation.swagger1.dto.ApiInfo();

        apiInfo.setContact( fromContactName( from ) );

        apiInfo.setTitle( from.getTitle() );

        apiInfo.setDescription( from.getDescription() );

        apiInfo.setTermsOfServiceUrl( from.getTermsOfServiceUrl() );

        apiInfo.setLicense( from.getLicense() );

        apiInfo.setLicenseUrl( from.getLicenseUrl() );

        return apiInfo;
    }

    @Override

    public io.swagger.models.Contact map(Contact from) {

        if ( from == null ) {

            return null;
        }

        io.swagger.models.Contact contact = new io.swagger.models.Contact();

        contact.setName( from.getName() );

        contact.setUrl( from.getUrl() );

        contact.setEmail( from.getEmail() );

        return contact;
    }

    @Override

    public springfox.documentation.swagger1.dto.ResponseMessage toSwaggerResponseMessage(ResponseMessage from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.ResponseMessage responseMessage = new springfox.documentation.swagger1.dto.ResponseMessage();

        responseMessage.setResponseModel( dataTypeMapper.responseTypeName( from.getResponseModel() ) );

        responseMessage.setCode( from.getCode() );

        responseMessage.setMessage( from.getMessage() );

        return responseMessage;
    }

    @Override

    public springfox.documentation.swagger1.dto.ApiListingReference toSwaggerApiListingReference(ApiListingReference from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.ApiListingReference apiListingReference = new springfox.documentation.swagger1.dto.ApiListingReference();

        apiListingReference.setPath( from.getPath() );

        apiListingReference.setDescription( from.getDescription() );

        apiListingReference.setPosition( from.getPosition() );

        return apiListingReference;
    }

    @Override

    public ModelDto toSwaggerModelDto(Model from) {

        if ( from == null ) {

            return null;
        }

        ModelDto modelDto = new ModelDto();

        modelDto.setId( from.getId() );

        modelDto.setName( from.getName() );

        modelDto.setQualifiedType( from.getQualifiedType() );

        Map<String, ModelPropertyDto> map = stringModelPropertyMapToStringModelPropertyDtoMap( from.getProperties() );

        if ( map != null ) {

            modelDto.setProperties( map );
        }

        modelDto.setDescription( from.getDescription() );

        modelDto.setBaseModel( from.getBaseModel() );

        modelDto.setDiscriminator( from.getDiscriminator() );

        List<String> list = from.getSubTypes();

        if ( list != null ) {

            modelDto.setSubTypes(       new ArrayList<String>( list )

            );
        }

        return modelDto;
    }

    @Override

    public springfox.documentation.swagger1.dto.ApiListing toSwaggerApiListing(ApiListing from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.ApiListing apiListing = new springfox.documentation.swagger1.dto.ApiListing();

        List<Authorization> list = securityReferenceListToAuthorizationList( from.getSecurityReferences() );

        if ( list != null ) {

            apiListing.setAuthorizations( list );
        }

        apiListing.setApiVersion( from.getApiVersion() );

        apiListing.setBasePath( from.getBasePath() );

        apiListing.setResourcePath( from.getResourcePath() );

        Set<String> set = from.getProduces();

        if ( set != null ) {

            apiListing.setProduces(       new HashSet<String>( set )

            );
        }

        Set<String> set_ = from.getConsumes();

        if ( set_ != null ) {

            apiListing.setConsumes(       new HashSet<String>( set_ )

            );
        }

        Set<String> set__ = from.getProtocols();

        if ( set__ != null ) {

            apiListing.setProtocols(       new HashSet<String>( set__ )

            );
        }

        List<springfox.documentation.swagger1.dto.ApiDescription> list_ = apiDescriptionListToApiDescriptionList( from.getApis() );

        if ( list_ != null ) {

            apiListing.setApis( list_ );
        }

        Map<String, ModelDto> map = stringModelMapToStringModelDtoMap( from.getModels() );

        if ( map != null ) {

            apiListing.setModels( map );
        }

        apiListing.setDescription( from.getDescription() );

        apiListing.setPosition( from.getPosition() );

        apiListing.setSwaggerVersion( "1.2" );

        return apiListing;
    }

    @Override

    public ModelPropertyDto toSwaggerModelPropertyDto(ModelProperty from) {

        if ( from == null ) {

            return null;
        }

        ModelPropertyDto modelPropertyDto_ = new ModelPropertyDto();

        modelPropertyDto_.setType( dataTypeMapper.typeFromModelRef( from.getModelRef() ) );

        modelPropertyDto_.setQualifiedType( from.getQualifiedType() );

        modelPropertyDto_.setPosition( from.getPosition() );

        modelPropertyDto_.setDescription( from.getDescription() );

        modelPropertyDto_.setAllowableValues( allowableValuesMapper.toSwaggerAllowableValues( from.getAllowableValues() ) );

        modelPropertyDto_.setName( from.getName() );

        modelPropertyDto_.setRequired( from.isRequired() );

        return modelPropertyDto_;
    }

    @Override

    public springfox.documentation.swagger1.dto.Operation toSwaggerOperation(Operation from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.Operation operation_ = new springfox.documentation.swagger1.dto.Operation();

        operation_.setDataType( dataTypeMapper.operationTypeFromModelRef( from.getResponseModel() ) );

        Map<String, List<AuthorizationScope>> map = stringListMapToStringListMap( from.getSecurityReferences() );

        if ( map != null ) {

            operation_.setAuthorizations( map );
        }

        operation_.setNickname( from.getUniqueId() );

        if ( from.getMethod() != null ) {

            operation_.setMethod( from.getMethod().name() );
        }

        operation_.setSummary( from.getSummary() );

        operation_.setNotes( from.getNotes() );

        operation_.setPosition( from.getPosition() );

        Set<String> set = from.getProduces();

        if ( set != null ) {

            operation_.setProduces(       new ArrayList<String>( set )

            );
        }

        Set<String> set_ = from.getConsumes();

        if ( set_ != null ) {

            operation_.setConsumes(       new ArrayList<String>( set_ )

            );
        }

        Set<String> set__ = from.getProtocol();

        if ( set__ != null ) {

            operation_.setProtocol(       new ArrayList<String>( set__ )

            );
        }

        List<Parameter> list = parameterListToParameterList( from.getParameters() );

        if ( list != null ) {

            operation_.setParameters( list );
        }

        Set<springfox.documentation.swagger1.dto.ResponseMessage> set___ = responseMessageSetToResponseMessageSet( from.getResponseMessages() );

        if ( set___ != null ) {

            operation_.setResponseMessages( set___ );
        }

        operation_.setDeprecated( from.getDeprecated() );

        return operation_;
    }

    @Override

    public Parameter toSwaggerParameter(springfox.documentation.service.Parameter from) {

        if ( from == null ) {

            return null;
        }

        Parameter parameter_ = new Parameter();

        parameter_.setParameterType( dataTypeMapper.operationTypeFromModelRef( from.getModelRef() ) );

        parameter_.setName( from.getName() );

        parameter_.setDescription( from.getDescription() );

        parameter_.setDefaultValue( from.getDefaultValue() );

        parameter_.setAllowableValues( allowableValuesMapper.toSwaggerAllowableValues( from.getAllowableValues() ) );

        parameter_.setParamType( from.getParamType() );

        parameter_.setParamAccess( from.getParamAccess() );

        parameter_.setRequired( from.isRequired() );

        parameter_.setAllowMultiple( from.isAllowMultiple() );

        return parameter_;
    }

    @Override

    public springfox.documentation.swagger1.dto.ResourceListing toSwaggerResourceListing(ResourceListing from) {

        if ( from == null ) {

            return null;
        }

        springfox.documentation.swagger1.dto.ResourceListing resourceListing = new springfox.documentation.swagger1.dto.ResourceListing();

        List<AuthorizationType> list = authorizationTypesMapper.toSwaggerAuthorizationTypes( from.getSecuritySchemes() );

        if ( list != null ) {

            resourceListing.setAuthorizations( list );
        }

        resourceListing.setApiVersion( from.getApiVersion() );

        List<springfox.documentation.swagger1.dto.ApiListingReference> list_ = apiListingReferenceListToApiListingReferenceList( from.getApis() );

        if ( list_ != null ) {

            resourceListing.setApis( list_ );
        }

        resourceListing.setInfo( toSwaggerApiInfo( from.getInfo() ) );

        resourceListing.setSwaggerVersion( "1.2" );

        return resourceListing;
    }

    protected List<springfox.documentation.swagger1.dto.Operation> operationListToOperationList(List<Operation> list) {

        if ( list == null ) {

            return null;
        }

        List<springfox.documentation.swagger1.dto.Operation> list_ = new ArrayList<springfox.documentation.swagger1.dto.Operation>();

        for ( Operation operation : list ) {

            list_.add( toSwaggerOperation( operation ) );
        }

        return list_;
    }

    private String fromContactName(ApiInfo apiInfo) {

        if ( apiInfo == null ) {

            return null;
        }

        Contact contact = apiInfo.getContact();

        if ( contact == null ) {

            return null;
        }

        String name = contact.getName();

        if ( name == null ) {

            return null;
        }

        return name;
    }

    protected Map<String, ModelPropertyDto> stringModelPropertyMapToStringModelPropertyDtoMap(Map<String, ModelProperty> map) {

        if ( map == null ) {

            return null;
        }

        Map<String, ModelPropertyDto> map_ = new HashMap<String, ModelPropertyDto>();

        for ( java.util.Map.Entry<String, ModelProperty> entry : map.entrySet() ) {

            String key = entry.getKey();

            ModelPropertyDto value = toSwaggerModelPropertyDto( entry.getValue() );

            map_.put( key, value );
        }

        return map_;
    }

    protected List<Authorization> securityReferenceListToAuthorizationList(List<SecurityReference> list) {

        if ( list == null ) {

            return null;
        }

        List<Authorization> list_ = new ArrayList<Authorization>();

        for ( SecurityReference securityReference : list ) {

            list_.add( authorizationTypesMapper.toSwaggerSecurityReference( securityReference ) );
        }

        return list_;
    }

    protected List<springfox.documentation.swagger1.dto.ApiDescription> apiDescriptionListToApiDescriptionList(List<ApiDescription> list) {

        if ( list == null ) {

            return null;
        }

        List<springfox.documentation.swagger1.dto.ApiDescription> list_ = new ArrayList<springfox.documentation.swagger1.dto.ApiDescription>();

        for ( ApiDescription apiDescription : list ) {

            list_.add( toSwaggerApiDescription( apiDescription ) );
        }

        return list_;
    }

    protected Map<String, ModelDto> stringModelMapToStringModelDtoMap(Map<String, Model> map) {

        if ( map == null ) {

            return null;
        }

        Map<String, ModelDto> map_ = new HashMap<String, ModelDto>();

        for ( java.util.Map.Entry<String, Model> entry : map.entrySet() ) {

            String key = entry.getKey();

            ModelDto value = toSwaggerModelDto( entry.getValue() );

            map_.put( key, value );
        }

        return map_;
    }

    protected Map<String, List<AuthorizationScope>> stringListMapToStringListMap(Map<String, List<springfox.documentation.service.AuthorizationScope>> map) {

        if ( map == null ) {

            return null;
        }

        Map<String, List<AuthorizationScope>> map_ = new HashMap<String, List<AuthorizationScope>>();

        for ( java.util.Map.Entry<String, List<springfox.documentation.service.AuthorizationScope>> entry : map.entrySet() ) {

            String key = entry.getKey();

            List<AuthorizationScope> value = authorizationTypesMapper.toSwaggerAuthorizationScopes( entry.getValue() );

            map_.put( key, value );
        }

        return map_;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {

        if ( list == null ) {

            return null;
        }

        List<Parameter> list_ = new ArrayList<Parameter>();

        for ( springfox.documentation.service.Parameter parameter : list ) {

            list_.add( toSwaggerParameter( parameter ) );
        }

        return list_;
    }

    protected Set<springfox.documentation.swagger1.dto.ResponseMessage> responseMessageSetToResponseMessageSet(Set<ResponseMessage> set) {

        if ( set == null ) {

            return null;
        }

        Set<springfox.documentation.swagger1.dto.ResponseMessage> set_ = new HashSet<springfox.documentation.swagger1.dto.ResponseMessage>();

        for ( ResponseMessage responseMessage : set ) {

            set_.add( toSwaggerResponseMessage( responseMessage ) );
        }

        return set_;
    }

    protected List<springfox.documentation.swagger1.dto.ApiListingReference> apiListingReferenceListToApiListingReferenceList(List<ApiListingReference> list) {

        if ( list == null ) {

            return null;
        }

        List<springfox.documentation.swagger1.dto.ApiListingReference> list_ = new ArrayList<springfox.documentation.swagger1.dto.ApiListingReference>();

        for ( ApiListingReference apiListingReference : list ) {

            list_.add( toSwaggerApiListingReference( apiListingReference ) );
        }

        return list_;
    }
}

