package springfox.documentation.swagger1.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.swagger1.dto.Authorization;
import springfox.documentation.swagger1.dto.AuthorizationScope;
import springfox.documentation.swagger1.dto.ModelDto;
import springfox.documentation.swagger1.dto.ModelPropertyDto;
import springfox.documentation.swagger1.dto.Parameter;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2018-01-14T16:11:26-0600",
    comments = "version: 1.2.0.Final, compiler: javac, environment: Java 1.7.0_79 (Oracle Corporation)"
)
@Component
public class ServiceModelToSwaggerMapperImpl implements ServiceModelToSwaggerMapper {

    @Autowired
    private AllowableValuesMapper allowableValuesMapper;
    @Autowired
    private DataTypeMapper dataTypeMapper;
    @Autowired
    private AuthorizationTypesMapper authorizationTypesMapper;

    @Override
    public springfox.documentation.swagger1.dto.ApiDescription toSwaggerApiDescription(ApiDescription from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiDescription apiDescription = new springfox.documentation.swagger1.dto.ApiDescription();

        apiDescription.setPath( from.getPath() );
        apiDescription.setDescription( from.getDescription() );
        apiDescription.setOperations( operationListToOperationList( from.getOperations() ) );
        apiDescription.setHidden( from.isHidden() );

        return apiDescription;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiInfo toSwaggerApiInfo(ApiInfo from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiInfo apiInfo = new springfox.documentation.swagger1.dto.ApiInfo();

        String name = fromContactName( from );
        if ( name != null ) {
            apiInfo.setContact( name );
        }
        apiInfo.setTitle( from.getTitle() );
        apiInfo.setDescription( from.getDescription() );
        apiInfo.setTermsOfServiceUrl( from.getTermsOfServiceUrl() );
        apiInfo.setLicense( from.getLicense() );
        apiInfo.setLicenseUrl( from.getLicenseUrl() );

        return apiInfo;
    }

    @Override
    public io.swagger.models.Contact map(Contact from) {
        if ( from == null ) {
            return null;
        }

        io.swagger.models.Contact contact = new io.swagger.models.Contact();

        contact.setName( from.getName() );
        contact.setUrl( from.getUrl() );
        contact.setEmail( from.getEmail() );

        return contact;
    }

    @Override
    public springfox.documentation.swagger1.dto.ResponseMessage toSwaggerResponseMessage(ResponseMessage from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ResponseMessage responseMessage = new springfox.documentation.swagger1.dto.ResponseMessage();

        responseMessage.setResponseModel( dataTypeMapper.responseTypeName( from.getResponseModel() ) );
        responseMessage.setCode( from.getCode() );
        responseMessage.setMessage( from.getMessage() );

        return responseMessage;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListingReference toSwaggerApiListingReference(ApiListingReference from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiListingReference apiListingReference = new springfox.documentation.swagger1.dto.ApiListingReference();

        apiListingReference.setPath( from.getPath() );
        apiListingReference.setDescription( from.getDescription() );
        apiListingReference.setPosition( from.getPosition() );

        return apiListingReference;
    }

    @Override
    public ModelDto toSwaggerModelDto(Model from) {
        if ( from == null ) {
            return null;
        }

        ModelDto modelDto = new ModelDto();

        modelDto.setId( from.getId() );
        modelDto.setName( from.getName() );
        modelDto.setQualifiedType( from.getQualifiedType() );
        modelDto.setProperties( stringModelPropertyMapToStringModelPropertyDtoMap( from.getProperties() ) );
        modelDto.setDescription( from.getDescription() );
        modelDto.setBaseModel( from.getBaseModel() );
        modelDto.setDiscriminator( from.getDiscriminator() );
        List<String> list = from.getSubTypes();
        if ( list != null ) {
            modelDto.setSubTypes( new ArrayList<String>( list ) );
        }
        else {
            modelDto.setSubTypes( null );
        }

        return modelDto;
    }

    @Override
    public springfox.documentation.swagger1.dto.ApiListing toSwaggerApiListing(ApiListing from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ApiListing apiListing = new springfox.documentation.swagger1.dto.ApiListing();

        apiListing.setAuthorizations( securityReferenceListToAuthorizationList( from.getSecurityReferences() ) );
        apiListing.setApiVersion( from.getApiVersion() );
        apiListing.setBasePath( from.getBasePath() );
        apiListing.setResourcePath( from.getResourcePath() );
        Set<String> set = from.getProduces();
        if ( set != null ) {
            apiListing.setProduces( new HashSet<String>( set ) );
        }
        else {
            apiListing.setProduces( null );
        }
        Set<String> set1 = from.getConsumes();
        if ( set1 != null ) {
            apiListing.setConsumes( new HashSet<String>( set1 ) );
        }
        else {
            apiListing.setConsumes( null );
        }
        Set<String> set2 = from.getProtocols();
        if ( set2 != null ) {
            apiListing.setProtocols( new HashSet<String>( set2 ) );
        }
        else {
            apiListing.setProtocols( null );
        }
        apiListing.setApis( apiDescriptionListToApiDescriptionList( from.getApis() ) );
        apiListing.setModels( stringModelMapToStringModelDtoMap( from.getModels() ) );
        apiListing.setDescription( from.getDescription() );
        apiListing.setPosition( from.getPosition() );

        apiListing.setSwaggerVersion( "1.2" );

        return apiListing;
    }

    @Override
    public ModelPropertyDto toSwaggerModelPropertyDto(ModelProperty from) {
        if ( from == null ) {
            return null;
        }

        ModelPropertyDto modelPropertyDto = new ModelPropertyDto();

        modelPropertyDto.setType( dataTypeMapper.typeFromModelRef( from.getModelRef() ) );
        modelPropertyDto.setQualifiedType( from.getQualifiedType() );
        modelPropertyDto.setPosition( from.getPosition() );
        modelPropertyDto.setDescription( from.getDescription() );
        modelPropertyDto.setAllowableValues( allowableValuesMapper.toSwaggerAllowableValues( from.getAllowableValues() ) );
        modelPropertyDto.setName( from.getName() );
        modelPropertyDto.setRequired( from.isRequired() );

        return modelPropertyDto;
    }

    @Override
    public springfox.documentation.swagger1.dto.Operation toSwaggerOperation(Operation from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.Operation operation = new springfox.documentation.swagger1.dto.Operation();

        operation.setDataType( dataTypeMapper.operationTypeFromModelRef( from.getResponseModel() ) );
        operation.setAuthorizations( stringListMapToStringListMap( from.getSecurityReferences() ) );
        operation.setNickname( from.getUniqueId() );
        if ( from.getMethod() != null ) {
            operation.setMethod( from.getMethod().name() );
        }
        operation.setSummary( from.getSummary() );
        operation.setNotes( from.getNotes() );
        operation.setPosition( from.getPosition() );
        Set<String> set = from.getProduces();
        if ( set != null ) {
            operation.setProduces( new ArrayList<String>( set ) );
        }
        else {
            operation.setProduces( null );
        }
        Set<String> set1 = from.getConsumes();
        if ( set1 != null ) {
            operation.setConsumes( new ArrayList<String>( set1 ) );
        }
        else {
            operation.setConsumes( null );
        }
        Set<String> set2 = from.getProtocol();
        if ( set2 != null ) {
            operation.setProtocol( new ArrayList<String>( set2 ) );
        }
        else {
            operation.setProtocol( null );
        }
        operation.setParameters( parameterListToParameterList( from.getParameters() ) );
        operation.setResponseMessages( responseMessageSetToResponseMessageSet( from.getResponseMessages() ) );
        operation.setDeprecated( from.getDeprecated() );

        return operation;
    }

    @Override
    public Parameter toSwaggerParameter(springfox.documentation.service.Parameter from) {
        if ( from == null ) {
            return null;
        }

        Parameter parameter = new Parameter();

        parameter.setParameterType( dataTypeMapper.operationTypeFromModelRef( from.getModelRef() ) );
        parameter.setName( from.getName() );
        parameter.setDescription( from.getDescription() );
        parameter.setDefaultValue( from.getDefaultValue() );
        parameter.setAllowableValues( allowableValuesMapper.toSwaggerAllowableValues( from.getAllowableValues() ) );
        parameter.setParamType( from.getParamType() );
        parameter.setParamAccess( from.getParamAccess() );
        parameter.setRequired( from.isRequired() );
        parameter.setAllowMultiple( from.isAllowMultiple() );

        return parameter;
    }

    @Override
    public springfox.documentation.swagger1.dto.ResourceListing toSwaggerResourceListing(ResourceListing from) {
        if ( from == null ) {
            return null;
        }

        springfox.documentation.swagger1.dto.ResourceListing resourceListing = new springfox.documentation.swagger1.dto.ResourceListing();

        resourceListing.setAuthorizations( authorizationTypesMapper.toSwaggerAuthorizationTypes( from.getSecuritySchemes() ) );
        resourceListing.setApiVersion( from.getApiVersion() );
        resourceListing.setApis( apiListingReferenceListToApiListingReferenceList( from.getApis() ) );
        resourceListing.setInfo( toSwaggerApiInfo( from.getInfo() ) );

        resourceListing.setSwaggerVersion( "1.2" );

        return resourceListing;
    }

    protected List<springfox.documentation.swagger1.dto.Operation> operationListToOperationList(List<Operation> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.Operation> list1 = new ArrayList<springfox.documentation.swagger1.dto.Operation>( list.size() );
        for ( Operation operation : list ) {
            list1.add( toSwaggerOperation( operation ) );
        }

        return list1;
    }

    private String fromContactName(ApiInfo apiInfo) {
        if ( apiInfo == null ) {
            return null;
        }
        Contact contact = apiInfo.getContact();
        if ( contact == null ) {
            return null;
        }
        String name = contact.getName();
        if ( name == null ) {
            return null;
        }
        return name;
    }

    protected Map<String, ModelPropertyDto> stringModelPropertyMapToStringModelPropertyDtoMap(Map<String, ModelProperty> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, ModelPropertyDto> map1 = new HashMap<String, ModelPropertyDto>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, ModelProperty> entry : map.entrySet() ) {
            String key = entry.getKey();
            ModelPropertyDto value = toSwaggerModelPropertyDto( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    protected List<Authorization> securityReferenceListToAuthorizationList(List<SecurityReference> list) {
        if ( list == null ) {
            return null;
        }

        List<Authorization> list1 = new ArrayList<Authorization>( list.size() );
        for ( SecurityReference securityReference : list ) {
            list1.add( authorizationTypesMapper.toSwaggerSecurityReference( securityReference ) );
        }

        return list1;
    }

    protected List<springfox.documentation.swagger1.dto.ApiDescription> apiDescriptionListToApiDescriptionList(List<ApiDescription> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.ApiDescription> list1 = new ArrayList<springfox.documentation.swagger1.dto.ApiDescription>( list.size() );
        for ( ApiDescription apiDescription : list ) {
            list1.add( toSwaggerApiDescription( apiDescription ) );
        }

        return list1;
    }

    protected Map<String, ModelDto> stringModelMapToStringModelDtoMap(Map<String, Model> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, ModelDto> map1 = new HashMap<String, ModelDto>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, Model> entry : map.entrySet() ) {
            String key = entry.getKey();
            ModelDto value = toSwaggerModelDto( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    protected Map<String, List<AuthorizationScope>> stringListMapToStringListMap(Map<String, List<springfox.documentation.service.AuthorizationScope>> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, List<AuthorizationScope>> map1 = new HashMap<String, List<AuthorizationScope>>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, List<springfox.documentation.service.AuthorizationScope>> entry : map.entrySet() ) {
            String key = entry.getKey();
            List<AuthorizationScope> value = authorizationTypesMapper.toSwaggerAuthorizationScopes( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    protected List<Parameter> parameterListToParameterList(List<springfox.documentation.service.Parameter> list) {
        if ( list == null ) {
            return null;
        }

        List<Parameter> list1 = new ArrayList<Parameter>( list.size() );
        for ( springfox.documentation.service.Parameter parameter : list ) {
            list1.add( toSwaggerParameter( parameter ) );
        }

        return list1;
    }

    protected Set<springfox.documentation.swagger1.dto.ResponseMessage> responseMessageSetToResponseMessageSet(Set<ResponseMessage> set) {
        if ( set == null ) {
            return null;
        }

        Set<springfox.documentation.swagger1.dto.ResponseMessage> set1 = new HashSet<springfox.documentation.swagger1.dto.ResponseMessage>( Math.max( (int) ( set.size() / .75f ) + 1, 16 ) );
        for ( ResponseMessage responseMessage : set ) {
            set1.add( toSwaggerResponseMessage( responseMessage ) );
        }

        return set1;
    }

    protected List<springfox.documentation.swagger1.dto.ApiListingReference> apiListingReferenceListToApiListingReferenceList(List<ApiListingReference> list) {
        if ( list == null ) {
            return null;
        }

        List<springfox.documentation.swagger1.dto.ApiListingReference> list1 = new ArrayList<springfox.documentation.swagger1.dto.ApiListingReference>( list.size() );
        for ( ApiListingReference apiListingReference : list ) {
            list1.add( toSwaggerApiListingReference( apiListingReference ) );
        }

        return list1;
    }
}
