/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import springfox.documentation.swagger1.dto.Authorization;
import springfox.documentation.swagger1.dto.AuthorizationScope;
import springfox.documentation.swagger1.dto.DataType;
import springfox.documentation.swagger1.dto.Parameter;
import springfox.documentation.swagger1.dto.ResponseMessage;
import springfox.documentation.swagger1.dto.SwaggerDataType;

@JsonPropertyOrder(value={"method", "summary", "notes", "type", "nickname", "produces", "consumes", "parameters", "responseMessages", "deprecated"})
public class Operation {
    private String method;
    private String summary;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String notes;
    @JsonProperty
    @JsonUnwrapped
    private SwaggerDataType dataType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String nickname;
    @JsonIgnore
    private int position;
    private List<String> produces;
    private List<String> consumes;
    @JsonIgnore
    private List<String> protocol;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, List<AuthorizationScope>> authorizations;
    private List<Parameter> parameters;
    private SortedSet<ResponseMessage> responseMessages;
    private String deprecated;

    public Operation() {
    }

    public Operation(String method, String summary, String notes, String responseClass, String nickname, int position, List<String> produces, List<String> consumes, List<String> protocol, List<Authorization> authorizations, List<Parameter> parameters, Set<ResponseMessage> responseMessages, String deprecated) {
        this.method = method;
        this.summary = summary;
        this.notes = notes;
        this.dataType = new DataType(responseClass);
        this.nickname = nickname;
        this.position = position;
        this.produces = produces;
        this.consumes = consumes;
        this.protocol = protocol;
        this.authorizations = this.toAuthorizationsMap(authorizations);
        this.parameters = FluentIterable.from(parameters).toSortedList(this.byName());
        this.responseMessages = ImmutableSortedSet.copyOf(this.responseMessageOrdering(), responseMessages);
        this.deprecated = deprecated;
    }

    private Comparator<ResponseMessage> responseMessageOrdering() {
        return new Comparator<ResponseMessage>(){

            @Override
            public int compare(ResponseMessage first, ResponseMessage second) {
                return Ints.compare((int)first.getCode(), (int)second.getCode());
            }
        };
    }

    private Map<String, List<AuthorizationScope>> toAuthorizationsMap(List<Authorization> authorizations) {
        return Maps.transformEntries((Map)Maps.uniqueIndex(authorizations, this.byType()), this.toScopes());
    }

    private Maps.EntryTransformer<? super String, ? super Authorization, List<AuthorizationScope>> toScopes() {
        return new Maps.EntryTransformer<String, Authorization, List<AuthorizationScope>>(){

            public List<AuthorizationScope> transformEntry(String key, Authorization value) {
                return Lists.newArrayList(value.getScopes());
            }
        };
    }

    private Function<? super Authorization, String> byType() {
        return new Function<Authorization, String>(){

            public String apply(Authorization input) {
                return input.getType();
            }
        };
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public List<String> getProtocol() {
        return this.protocol;
    }

    public void setProtocol(List<String> protocol) {
        this.protocol = protocol;
    }

    public Map<String, List<AuthorizationScope>> getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(Map<String, List<AuthorizationScope>> authorizations) {
        this.authorizations = authorizations;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Set<ResponseMessage> getResponseMessages() {
        return this.responseMessages;
    }

    public void setResponseMessages(Set<ResponseMessage> responseMessages) {
        this.responseMessages = ImmutableSortedSet.copyOf(this.responseMessageOrdering(), responseMessages);
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public void setDataType(SwaggerDataType dataType) {
        this.dataType = dataType;
    }

    private Comparator<Parameter> byName() {
        return new Comparator<Parameter>(){

            @Override
            public int compare(Parameter first, Parameter second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }
}

