/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.mappers;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.util.UriComponents;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger1.mappers.ServiceModelToSwaggerMapper;

public class Mappers {
    public static Maps.EntryTransformer<String, ApiListing, springfox.documentation.swagger1.dto.ApiListing> toApiListingDto(final HttpServletRequest servletRequest, final String host, final ServiceModelToSwaggerMapper mapper) {
        return new Maps.EntryTransformer<String, ApiListing, springfox.documentation.swagger1.dto.ApiListing>(){

            public springfox.documentation.swagger1.dto.ApiListing transformEntry(String key, ApiListing value) {
                springfox.documentation.swagger1.dto.ApiListing apiListing = mapper.toSwaggerApiListing(value);
                UriComponents uriComponents = HostNameProvider.componentsFrom((HttpServletRequest)servletRequest, (String)apiListing.getBasePath());
                apiListing.setBasePath(Mappers.adjustedBasePath(uriComponents, host, apiListing.getBasePath()));
                return apiListing;
            }
        };
    }

    private static String adjustedBasePath(UriComponents uriComponents, String hostNameOverride, String basePath) {
        if (!Strings.isNullOrEmpty((String)hostNameOverride)) {
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s://%s:%d%s", uriComponents.getScheme(), hostNameOverride, port, basePath);
            }
            return String.format("%s://%s%s", uriComponents.getScheme(), hostNameOverride, basePath);
        }
        return basePath;
    }
}

