/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger1.web;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.swagger1.dto.ApiListing;

public class ApiListingMerger {
    private ApiListingMerger() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ApiListing> mergedApiListing(Collection<ApiListing> apiListings) {
        if (BuilderDefaults.nullToEmptyList(apiListings).size() > 1) {
            ApiListing merged = new ApiListing();
            merged.setSwaggerVersion("1.2");
            merged.setPosition(0);
            for (ApiListing each : apiListings) {
                merged.setApiVersion(each.getApiVersion());
                merged.setBasePath(each.getBasePath());
                merged.setResourcePath(each.getResourcePath());
                merged.setDescription(each.getDescription());
                merged.appendAuthorizations(each.getAuthorizations());
                merged.appendApis(each.getApis());
                merged.appendProtocols(new HashSet<String>(each.getProtocols()));
                merged.appendConsumes(new HashSet<String>(each.getConsumes()));
                merged.appendModels(each.getModels());
                merged.appendProduces(new HashSet<String>(each.getProduces()));
            }
            return Optional.of(merged);
        }
        return BuilderDefaults.nullToEmptyList(apiListings).stream().findFirst();
    }
}

