/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.EnumMapper;

class Properties {
    private static final Map<String, Function<String, ? extends Property>> TYPE_FACTORY = java.util.Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Function<String, IntegerProperty>>("int", Properties.newInstanceOf(IntegerProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, LongProperty>>("long", Properties.newInstanceOf(LongProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, FloatProperty>>("float", Properties.newInstanceOf(FloatProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, DoubleProperty>>("double", Properties.newInstanceOf(DoubleProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, StringProperty>>("string", Properties.newInstanceOf(StringProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, BooleanProperty>>("boolean", Properties.newInstanceOf(BooleanProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, DateProperty>>("date", Properties.newInstanceOf(DateProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, DateTimeProperty>>("date-time", Properties.newInstanceOf(DateTimeProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, DecimalProperty>>("bigdecimal", Properties.newInstanceOf(DecimalProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, BaseIntegerProperty>>("biginteger", Properties.newInstanceOf(BaseIntegerProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, UUIDProperty>>("uuid", Properties.newInstanceOf(UUIDProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, ObjectProperty>>("object", Properties.newInstanceOf(ObjectProperty.class)), new AbstractMap.SimpleEntry<String, Function<String, ? extends Property>>("byte", Properties.bytePropertyFactory()), new AbstractMap.SimpleEntry<String, Function<String, ? extends Property>>("__file", Properties.filePropertyFactory())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

    private Properties() {
        throw new UnsupportedOperationException();
    }

    public static Property property(String typeName) {
        String safeTypeName = Optional.ofNullable(typeName).orElse("");
        return TYPE_FACTORY.getOrDefault(safeTypeName.toLowerCase(), Properties.voidOrRef(safeTypeName)).apply(safeTypeName);
    }

    public static Property property(ModelReference modelRef) {
        if (modelRef.isMap()) {
            return new MapProperty(Properties.property((ModelReference)modelRef.itemModel().get()));
        }
        if (modelRef.isCollection()) {
            if ("byte".equals(modelRef.itemModel().map(Properties.toTypeName()).orElse(""))) {
                return new ByteArrayProperty();
            }
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty((ModelReference)modelRef.itemModel().get()), modelRef.getAllowableValues()));
        }
        return Properties.property(modelRef.getType());
    }

    private static Function<? super ModelReference, String> toTypeName() {
        return new Function<ModelReference, String>(){

            @Override
            public String apply(ModelReference input) {
                return input.getType();
            }
        };
    }

    public static Property itemTypeProperty(ModelReference paramModel) {
        if (paramModel.isCollection()) {
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty((ModelReference)paramModel.itemModel().get()), paramModel.getAllowableValues()));
        }
        return Properties.property(paramModel.getType());
    }

    private static <T extends Property> Function<String, T> newInstanceOf(final Class<T> clazz) {
        return new Function<String, T>(){

            @Override
            public T apply(String input) {
                try {
                    return (Property)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    static Comparator<String> defaultOrdering(Map<String, ModelProperty> properties) {
        return Properties.byPosition(properties).thenComparing(Properties.byName());
    }

    private static Function<String, ? extends Property> voidOrRef(final String typeName) {
        return new Function<String, Property>(){

            @Override
            public Property apply(String input) {
                if (typeName.equalsIgnoreCase("void")) {
                    return null;
                }
                return new RefProperty(typeName);
            }
        };
    }

    private static Function<String, ? extends Property> bytePropertyFactory() {
        return new Function<String, Property>(){

            @Override
            public Property apply(String input) {
                IntegerProperty integerProperty = new IntegerProperty();
                integerProperty.setFormat("int32");
                integerProperty.setMaximum(BigDecimal.valueOf(127L));
                integerProperty.setMinimum(BigDecimal.valueOf(-128L));
                return integerProperty;
            }
        };
    }

    private static Function<String, ? extends Property> filePropertyFactory() {
        return new Function<String, Property>(){

            @Override
            public Property apply(String input) {
                return new FileProperty();
            }
        };
    }

    private static Comparator<String> byName() {
        return new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return first.compareTo(second);
            }
        };
    }

    private static Comparator<String> byPosition(final Map<String, ModelProperty> modelProperties) {
        return new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                ModelProperty p1 = (ModelProperty)modelProperties.get(first);
                ModelProperty p2 = (ModelProperty)modelProperties.get(second);
                return Integer.compare(p1.getPosition(), p2.getPosition());
            }
        };
    }

    static Predicate<Map.Entry<String, ModelProperty>> voidProperties() {
        return new Predicate<Map.Entry<String, ModelProperty>>(){

            @Override
            public boolean test(Map.Entry<String, ModelProperty> input) {
                return Types.isVoid((ResolvedType)input.getValue().getType()) || Properties.collectionOfVoid(input.getValue().getType()) || Properties.arrayTypeOfVoid(input.getValue().getType().getArrayElementType());
            }
        };
    }

    private static boolean arrayTypeOfVoid(ResolvedType arrayElementType) {
        return arrayElementType != null && Types.isVoid((ResolvedType)arrayElementType);
    }

    private static boolean collectionOfVoid(ResolvedType type) {
        return Collections.isContainerType((ResolvedType)type) && Types.isVoid((ResolvedType)Collections.collectionElementType((ResolvedType)type));
    }
}

