/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.domain.jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public abstract class SpringletsDataJaxb {
    private SpringletsDataJaxb() {
    }

    public static <T, S> List<S> marshal(Iterable<T> source, XmlAdapter<S, T> adapter) {
        Assert.notNull(adapter, (String)"[Assertion failed] - this argument is required; it must not be null");
        if (source == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (T element : source) {
            try {
                result.add(adapter.marshal(element));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return result;
    }

    @XmlRootElement(name="order")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class OrderDto {
        @XmlAttribute
        String property;
        @XmlAttribute
        Sort.Direction direction;
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PageDto {
        @XmlAnyElement
        @XmlElementWrapper(name="content")
        List<Object> content;
    }

    @XmlRootElement(name="page-request")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class PageRequestDto {
        @XmlAttribute
        int page;
        @XmlAttribute
        int size;
        @XmlElement(name="order")
        List<OrderDto> orders = new ArrayList<OrderDto>();
    }

    @XmlRootElement(name="search-request")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class GlobalSearchDto {
        @XmlAttribute
        String searchText;
        @XmlAttribute
        boolean regexp;
    }
}

