/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import io.springlets.data.web.datatables.DatatablesColumns;
import io.springlets.data.web.datatables.DatatablesData;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Page;

public class ConvertedDatatablesData<T>
extends DatatablesData<Map<String, Object>> {
    private static final TypeDescriptor TYPE_STRING = TypeDescriptor.valueOf(String.class);
    public static final String DEFAULT_PROPERTY_SEPARATOR = "/";

    public ConvertedDatatablesData(Page<T> data, Long recordsTotal, Integer draw, ConversionService conversionService) {
        this(data.getContent(), recordsTotal, data.getTotalElements(), draw, conversionService, null, DEFAULT_PROPERTY_SEPARATOR);
    }

    public ConvertedDatatablesData(Page<T> data, Long recordsTotal, Integer draw, ConversionService conversionService, DatatablesColumns columns) {
        this(data.getContent(), recordsTotal, data.getTotalElements(), draw, conversionService, columns, DEFAULT_PROPERTY_SEPARATOR);
    }

    public ConvertedDatatablesData(List<T> data, Long recordsTotal, Long recordsFiltered, Integer draw, ConversionService conversionService) {
        this(data, recordsTotal, recordsFiltered, draw, conversionService, null, DEFAULT_PROPERTY_SEPARATOR);
    }

    public ConvertedDatatablesData(List<T> data, Long recordsTotal, Long recordsFiltered, Integer draw, ConversionService conversionService, DatatablesColumns columns, String propertySeparator) {
        super(ConvertedDatatablesData.convertAll(data, conversionService, columns, propertySeparator != null ? propertySeparator : DEFAULT_PROPERTY_SEPARATOR), recordsTotal, recordsFiltered, draw, null);
    }

    private static List<Map<String, Object>> convertAll(List<?> data, ConversionService conversionService, DatatablesColumns columns, String propertySeparator) {
        if (data == null) {
            return null;
        }
        ArrayList<Map<String, Object>> converted = new ArrayList<Map<String, Object>>(data.size());
        for (Object value : data) {
            Map<String, Object> convertedValue = columns == null ? ConvertedDatatablesData.convert(value, conversionService) : ConvertedDatatablesData.convert(value, conversionService, columns, propertySeparator);
            converted.add(convertedValue);
        }
        return converted;
    }

    private static Map<String, Object> convert(Object value, ConversionService conversionService) {
        BeanWrapperImpl bean = new BeanWrapperImpl(value);
        PropertyDescriptor[] properties = bean.getPropertyDescriptors();
        HashMap<String, Object> convertedValue = new HashMap<String, Object>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i].getName();
            Object propertyValue = bean.getPropertyValue(name);
            if (propertyValue == null || !conversionService.canConvert(propertyValue.getClass(), String.class)) continue;
            TypeDescriptor source = bean.getPropertyTypeDescriptor(name);
            String convertedPropertyValue = (String)conversionService.convert(propertyValue, source, TYPE_STRING);
            convertedValue.put(name, convertedPropertyValue);
        }
        return convertedValue;
    }

    private static Map<String, Object> convert(Object value, ConversionService conversionService, DatatablesColumns columns, String propertySeparator) {
        BeanWrapperImpl bean = new BeanWrapperImpl(value);
        HashMap<String, Object> convertedValue = new HashMap<String, Object>();
        for (DatatablesColumns.Column column : columns.getColumns()) {
            String property = column.getData();
            convertedValue.put(property, ConvertedDatatablesData.convertProperty((BeanWrapper)bean, property, conversionService, propertySeparator));
        }
        return convertedValue;
    }

    private static Object convertProperty(BeanWrapper parentBean, String property, ConversionService conversionService, String propertySeparator) {
        int dotIndex = property.indexOf(propertySeparator);
        if (dotIndex > 0) {
            String baseProperty = property.substring(0, dotIndex);
            String childProperty = property.substring(dotIndex + propertySeparator.length());
            BeanWrapperImpl childBean = new BeanWrapperImpl(parentBean.getPropertyValue(baseProperty));
            return ConvertedDatatablesData.convertProperty((BeanWrapper)childBean, childProperty, conversionService, propertySeparator);
        }
        TypeDescriptor source = parentBean.getPropertyTypeDescriptor(property);
        Object propertyValue = parentBean.getPropertyValue(property);
        if (source.isAssignableTo(TYPE_STRING)) {
            return (String)propertyValue;
        }
        return (String)conversionService.convert(propertyValue, source, TYPE_STRING);
    }
}

